/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.StringReader;
import java.security.AccessController;
import javax.swing.JComponent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.StyleSheet;
import sun.security.action.GetBooleanAction;
import sun.swing.SwingAccessor;
import sun.swing.SwingUtilities2;

public class BasicHTML {
    public static final String propertyKey = "html";
    public static final String documentBaseKey = "html.base";

    public static View createHTMLView(JComponent jComponent, String string) {
        return null;
    }

    public static boolean isHTMLString(String string) {
        return false;
    }

    public static void updateRenderer(JComponent jComponent, String string) {
    }

    static class BasicDocument
    extends HTMLDocument {
        BasicDocument(StyleSheet s, Font defaultFont, Color foreground) {
            super(s);
            this.setPreservesUnknownTags(false);
            this.setFontAndColor(defaultFont, foreground);
        }

        private void setFontAndColor(Font font, Color fg) {
            this.getStyleSheet().addRule(SwingUtilities2.displayPropertiesToCSS(font, fg));
        }
    }

    static class BasicEditorKit
    extends HTMLEditorKit {
        private static StyleSheet defaultStyles;

        BasicEditorKit() {
        }

        @Override
        public StyleSheet getStyleSheet() {
            if (defaultStyles == null) {
                defaultStyles = new StyleSheet();
                StringReader r = new StringReader("p { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }");
                try {
                    defaultStyles.loadRules(r, null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                r.close();
                defaultStyles.addStyleSheet(super.getStyleSheet());
            }
            return defaultStyles;
        }

        public Document createDefaultDocument(Font defaultFont, Color foreground) {
            StyleSheet styles = this.getStyleSheet();
            StyleSheet ss = new StyleSheet();
            ss.addStyleSheet(styles);
            BasicDocument doc = new BasicDocument(ss, defaultFont, foreground);
            doc.setAsynchronousLoadPriority(Integer.MAX_VALUE);
            doc.setPreservesUnknownTags(false);
            return doc;
        }

        @Override
        public ViewFactory getViewFactory() {
            return basicHTMLViewFactory;
        }
    }

    static class BasicHTMLViewFactory
    extends HTMLEditorKit.HTMLFactory {
        private static Boolean useOV = null;

        BasicHTMLViewFactory() {
        }

        @Override
        public View create(Element elem) {
            View view = null;
            try {
                BasicHTMLViewFactory.setAllowHTMLObject();
                view = super.create(elem);
            }
            finally {
                BasicHTMLViewFactory.clearAllowHTMLObject();
            }
            if (view instanceof ImageView) {
                ((ImageView)view).setLoadsSynchronously(true);
            }
            return view;
        }

        private static void setAllowHTMLObject() {
            if (useOV == null) {
                useOV = AccessController.doPrivileged(new GetBooleanAction("swing.html.object"));
            }
            SwingAccessor.setAllowHTMLObject(useOV);
        }

        private static void clearAllowHTMLObject() {
            SwingAccessor.setAllowHTMLObject(null);
        }
    }

    static class Renderer
    extends View {
        private int width;
        private View view;
        private ViewFactory factory;
        private JComponent host;

        Renderer(JComponent c, ViewFactory f, View v) {
            super(null);
            this.host = c;
            this.factory = f;
            this.view = v;
            this.view.setParent(this);
            this.setSize(this.view.getPreferredSpan(0), this.view.getPreferredSpan(1));
        }

        @Override
        public AttributeSet getAttributes() {
            return null;
        }

        @Override
        public float getPreferredSpan(int axis) {
            if (axis == 0) {
                return this.width;
            }
            return this.view.getPreferredSpan(axis);
        }

        @Override
        public float getMinimumSpan(int axis) {
            return this.view.getMinimumSpan(axis);
        }

        @Override
        public float getMaximumSpan(int axis) {
            return 2.1474836E9f;
        }

        @Override
        public void preferenceChanged(View child, boolean width, boolean height) {
            this.host.revalidate();
            this.host.repaint();
        }

        @Override
        public float getAlignment(int axis) {
            return this.view.getAlignment(axis);
        }

        @Override
        public void paint(Graphics g, Shape allocation) {
            Rectangle alloc = allocation.getBounds();
            this.view.setSize(alloc.width, alloc.height);
            this.view.paint(g, allocation);
        }

        @Override
        public void setParent(View parent) {
            throw new Error("Can't set parent on root view");
        }

        @Override
        public int getViewCount() {
            return 1;
        }

        @Override
        public View getView(int n) {
            return this.view;
        }

        @Override
        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            return this.view.modelToView(pos, a, b);
        }

        @Override
        public Shape modelToView(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
            return this.view.modelToView(p0, b0, p1, b1, a);
        }

        @Override
        public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
            return this.view.viewToModel(x, y, a, bias);
        }

        @Override
        public Document getDocument() {
            return this.view.getDocument();
        }

        @Override
        public int getStartOffset() {
            return this.view.getStartOffset();
        }

        @Override
        public int getEndOffset() {
            return this.view.getEndOffset();
        }

        @Override
        public Element getElement() {
            return this.view.getElement();
        }

        @Override
        public void setSize(float width, float height) {
            this.width = (int)width;
            this.view.setSize(width, height);
        }

        @Override
        public Container getContainer() {
            return this.host;
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.factory;
        }
    }
}

