/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.BasicTransferable;
import javax.swing.plaf.basic.DragRecognitionSupport;
import javax.swing.text.Position;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public class BasicListUI
extends ListUI {
    protected JList list;
    protected CellRendererPane rendererPane;
    protected FocusListener focusListener;
    protected MouseInputListener mouseInputListener;
    protected ListSelectionListener listSelectionListener;
    protected ListDataListener listDataListener;
    protected PropertyChangeListener propertyChangeListener;
    protected int[] cellHeights;
    protected int cellHeight;
    protected int cellWidth;
    protected int updateLayoutStateNeeded;
    protected static final int modelChanged = 1;
    protected static final int selectionModelChanged = 2;
    protected static final int fontChanged = 4;
    protected static final int fixedCellWidthChanged = 8;
    protected static final int fixedCellHeightChanged = 16;
    protected static final int prototypeCellValueChanged = 32;
    protected static final int cellRendererChanged = 64;

    protected void paintCell(Graphics graphics, int n, Rectangle rectangle, ListCellRenderer listCellRenderer, ListModel listModel, ListSelectionModel listSelectionModel, int n2) {
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    protected void selectPreviousIndex() {
    }

    protected void selectNextIndex() {
    }

    protected void installKeyboardActions() {
    }

    protected void uninstallKeyboardActions() {
    }

    protected void installListeners() {
    }

    protected void uninstallListeners() {
    }

    protected void installDefaults() {
    }

    protected void uninstallDefaults() {
    }

    public void installUI(JComponent jComponent) {
    }

    public void uninstallUI(JComponent jComponent) {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return null;
    }

    public int locationToIndex(JList jList, Point point) {
        return 0;
    }

    public Point indexToLocation(JList jList, int n) {
        return null;
    }

    public Rectangle getCellBounds(JList jList, int n, int n2) {
        return null;
    }

    protected int getRowHeight(int n) {
        return 0;
    }

    protected int convertYToRow(int n) {
        return 0;
    }

    protected int convertRowToY(int n) {
        return 0;
    }

    protected void maybeUpdateLayoutState() {
    }

    protected void updateLayoutState() {
    }

    protected MouseInputListener createMouseInputListener() {
        return null;
    }

    protected FocusListener createFocusListener() {
        return null;
    }

    protected ListSelectionListener createListSelectionListener() {
        return null;
    }

    protected ListDataListener createListDataListener() {
        return null;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return null;
    }

    private static class Actions
    extends UIAction {
        private static final String SELECT_PREVIOUS_COLUMN = "selectPreviousColumn";
        private static final String SELECT_PREVIOUS_COLUMN_EXTEND = "selectPreviousColumnExtendSelection";
        private static final String SELECT_PREVIOUS_COLUMN_CHANGE_LEAD = "selectPreviousColumnChangeLead";
        private static final String SELECT_NEXT_COLUMN = "selectNextColumn";
        private static final String SELECT_NEXT_COLUMN_EXTEND = "selectNextColumnExtendSelection";
        private static final String SELECT_NEXT_COLUMN_CHANGE_LEAD = "selectNextColumnChangeLead";
        private static final String SELECT_PREVIOUS_ROW = "selectPreviousRow";
        private static final String SELECT_PREVIOUS_ROW_EXTEND = "selectPreviousRowExtendSelection";
        private static final String SELECT_PREVIOUS_ROW_CHANGE_LEAD = "selectPreviousRowChangeLead";
        private static final String SELECT_NEXT_ROW = "selectNextRow";
        private static final String SELECT_NEXT_ROW_EXTEND = "selectNextRowExtendSelection";
        private static final String SELECT_NEXT_ROW_CHANGE_LEAD = "selectNextRowChangeLead";
        private static final String SELECT_FIRST_ROW = "selectFirstRow";
        private static final String SELECT_FIRST_ROW_EXTEND = "selectFirstRowExtendSelection";
        private static final String SELECT_FIRST_ROW_CHANGE_LEAD = "selectFirstRowChangeLead";
        private static final String SELECT_LAST_ROW = "selectLastRow";
        private static final String SELECT_LAST_ROW_EXTEND = "selectLastRowExtendSelection";
        private static final String SELECT_LAST_ROW_CHANGE_LEAD = "selectLastRowChangeLead";
        private static final String SCROLL_UP = "scrollUp";
        private static final String SCROLL_UP_EXTEND = "scrollUpExtendSelection";
        private static final String SCROLL_UP_CHANGE_LEAD = "scrollUpChangeLead";
        private static final String SCROLL_DOWN = "scrollDown";
        private static final String SCROLL_DOWN_EXTEND = "scrollDownExtendSelection";
        private static final String SCROLL_DOWN_CHANGE_LEAD = "scrollDownChangeLead";
        private static final String SELECT_ALL = "selectAll";
        private static final String CLEAR_SELECTION = "clearSelection";
        private static final String ADD_TO_SELECTION = "addToSelection";
        private static final String TOGGLE_AND_ANCHOR = "toggleAndAnchor";
        private static final String EXTEND_TO = "extendTo";
        private static final String MOVE_SELECTION_TO = "moveSelectionTo";

        Actions(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String name = this.getName();
            JList list = (JList)e.getSource();
            BasicListUI ui = (BasicListUI)BasicLookAndFeel.getUIOfType((ComponentUI)list.getUI(), BasicListUI.class);
            if (name == SELECT_PREVIOUS_COLUMN) {
                this.changeSelection(list, 1, this.getNextColumnIndex(list, ui, -1), -1);
            } else if (name == SELECT_PREVIOUS_COLUMN_EXTEND) {
                this.changeSelection(list, 2, this.getNextColumnIndex(list, ui, -1), -1);
            } else if (name == SELECT_PREVIOUS_COLUMN_CHANGE_LEAD) {
                this.changeSelection(list, 0, this.getNextColumnIndex(list, ui, -1), -1);
            } else if (name == SELECT_NEXT_COLUMN) {
                this.changeSelection(list, 1, this.getNextColumnIndex(list, ui, 1), 1);
            } else if (name == SELECT_NEXT_COLUMN_EXTEND) {
                this.changeSelection(list, 2, this.getNextColumnIndex(list, ui, 1), 1);
            } else if (name == SELECT_NEXT_COLUMN_CHANGE_LEAD) {
                this.changeSelection(list, 0, this.getNextColumnIndex(list, ui, 1), 1);
            } else if (name == SELECT_PREVIOUS_ROW) {
                this.changeSelection(list, 1, this.getNextIndex(list, ui, -1), -1);
            } else if (name == SELECT_PREVIOUS_ROW_EXTEND) {
                this.changeSelection(list, 2, this.getNextIndex(list, ui, -1), -1);
            } else if (name == SELECT_PREVIOUS_ROW_CHANGE_LEAD) {
                this.changeSelection(list, 0, this.getNextIndex(list, ui, -1), -1);
            } else if (name == SELECT_NEXT_ROW) {
                this.changeSelection(list, 1, this.getNextIndex(list, ui, 1), 1);
            } else if (name == SELECT_NEXT_ROW_EXTEND) {
                this.changeSelection(list, 2, this.getNextIndex(list, ui, 1), 1);
            } else if (name == SELECT_NEXT_ROW_CHANGE_LEAD) {
                this.changeSelection(list, 0, this.getNextIndex(list, ui, 1), 1);
            } else if (name == SELECT_FIRST_ROW) {
                this.changeSelection(list, 1, 0, -1);
            } else if (name == SELECT_FIRST_ROW_EXTEND) {
                this.changeSelection(list, 2, 0, -1);
            } else if (name == SELECT_FIRST_ROW_CHANGE_LEAD) {
                this.changeSelection(list, 0, 0, -1);
            } else if (name == SELECT_LAST_ROW) {
                this.changeSelection(list, 1, list.getModel().getSize() - 1, 1);
            } else if (name == SELECT_LAST_ROW_EXTEND) {
                this.changeSelection(list, 2, list.getModel().getSize() - 1, 1);
            } else if (name == SELECT_LAST_ROW_CHANGE_LEAD) {
                this.changeSelection(list, 0, list.getModel().getSize() - 1, 1);
            } else if (name == SCROLL_UP) {
                this.changeSelection(list, 1, this.getNextPageIndex(list, -1), -1);
            } else if (name == SCROLL_UP_EXTEND) {
                this.changeSelection(list, 2, this.getNextPageIndex(list, -1), -1);
            } else if (name == SCROLL_UP_CHANGE_LEAD) {
                this.changeSelection(list, 0, this.getNextPageIndex(list, -1), -1);
            } else if (name == SCROLL_DOWN) {
                this.changeSelection(list, 1, this.getNextPageIndex(list, 1), 1);
            } else if (name == SCROLL_DOWN_EXTEND) {
                this.changeSelection(list, 2, this.getNextPageIndex(list, 1), 1);
            } else if (name == SCROLL_DOWN_CHANGE_LEAD) {
                this.changeSelection(list, 0, this.getNextPageIndex(list, 1), 1);
            } else if (name == SELECT_ALL) {
                this.selectAll(list);
            } else if (name == CLEAR_SELECTION) {
                this.clearSelection(list);
            } else if (name == ADD_TO_SELECTION) {
                int index = BasicListUI.adjustIndex((int)list.getSelectionModel().getLeadSelectionIndex(), (JList)list);
                if (!list.isSelectedIndex(index)) {
                    int oldAnchor = list.getSelectionModel().getAnchorSelectionIndex();
                    list.setValueIsAdjusting(true);
                    list.addSelectionInterval(index, index);
                    list.getSelectionModel().setAnchorSelectionIndex(oldAnchor);
                    list.setValueIsAdjusting(false);
                }
            } else if (name == TOGGLE_AND_ANCHOR) {
                int index = BasicListUI.adjustIndex((int)list.getSelectionModel().getLeadSelectionIndex(), (JList)list);
                if (list.isSelectedIndex(index)) {
                    list.removeSelectionInterval(index, index);
                } else {
                    list.addSelectionInterval(index, index);
                }
            } else if (name == EXTEND_TO) {
                this.changeSelection(list, 2, BasicListUI.adjustIndex((int)list.getSelectionModel().getLeadSelectionIndex(), (JList)list), 0);
            } else if (name == MOVE_SELECTION_TO) {
                this.changeSelection(list, 1, BasicListUI.adjustIndex((int)list.getSelectionModel().getLeadSelectionIndex(), (JList)list), 0);
            }
        }

        @Override
        public boolean accept(Object c) {
            String name = this.getName();
            if (name == SELECT_PREVIOUS_COLUMN_CHANGE_LEAD || name == SELECT_NEXT_COLUMN_CHANGE_LEAD || name == SELECT_PREVIOUS_ROW_CHANGE_LEAD || name == SELECT_NEXT_ROW_CHANGE_LEAD || name == SELECT_FIRST_ROW_CHANGE_LEAD || name == SELECT_LAST_ROW_CHANGE_LEAD || name == SCROLL_UP_CHANGE_LEAD || name == SCROLL_DOWN_CHANGE_LEAD) {
                return c != null && ((JList)c).getSelectionModel() instanceof DefaultListSelectionModel;
            }
            return true;
        }

        private void clearSelection(JList<?> list) {
            list.clearSelection();
        }

        private void selectAll(JList<?> list) {
            int size = list.getModel().getSize();
            if (size > 0) {
                ListSelectionModel lsm = list.getSelectionModel();
                int lead = BasicListUI.adjustIndex((int)lsm.getLeadSelectionIndex(), list);
                if (lsm.getSelectionMode() == 0) {
                    if (lead == -1) {
                        int min = BasicListUI.adjustIndex((int)list.getMinSelectionIndex(), list);
                        lead = min == -1 ? 0 : min;
                    }
                    list.setSelectionInterval(lead, lead);
                    list.ensureIndexIsVisible(lead);
                } else {
                    list.setValueIsAdjusting(true);
                    int anchor = BasicListUI.adjustIndex((int)lsm.getAnchorSelectionIndex(), list);
                    list.setSelectionInterval(0, size - 1);
                    SwingUtilities2.setLeadAnchorWithoutSelection(lsm, anchor, lead);
                    list.setValueIsAdjusting(false);
                }
            }
        }

        private int getNextPageIndex(JList<?> list, int direction) {
            Rectangle leadRect;
            if (list.getModel().getSize() == 0) {
                return -1;
            }
            int index = -1;
            Rectangle visRect = list.getVisibleRect();
            ListSelectionModel lsm = list.getSelectionModel();
            int lead = BasicListUI.adjustIndex((int)lsm.getLeadSelectionIndex(), list);
            Rectangle rectangle = leadRect = lead == -1 ? new Rectangle() : list.getCellBounds(lead, lead);
            if (leadRect == null) {
                return index;
            }
            if (list.getLayoutOrientation() == 1 && list.getVisibleRowCount() <= 0) {
                if (!list.getComponentOrientation().isLeftToRight()) {
                    direction = -direction;
                }
                if (direction < 0) {
                    visRect.x = leadRect.x + leadRect.width - visRect.width;
                    Point p = new Point(visRect.x - 1, leadRect.y);
                    index = list.locationToIndex(p);
                    if (index == -1) {
                        return index;
                    }
                    Rectangle cellBounds = list.getCellBounds(index, index);
                    if (cellBounds != null && visRect.intersects(cellBounds)) {
                        p.x = cellBounds.x - 1;
                        index = list.locationToIndex(p);
                        if (index == -1) {
                            return index;
                        }
                        cellBounds = list.getCellBounds(index, index);
                    }
                    if (cellBounds != null && cellBounds.y != leadRect.y) {
                        p.x = cellBounds.x + cellBounds.width;
                        index = list.locationToIndex(p);
                    }
                } else {
                    visRect.x = leadRect.x;
                    Point p = new Point(visRect.x + visRect.width, leadRect.y);
                    index = list.locationToIndex(p);
                    if (index == -1) {
                        return index;
                    }
                    Rectangle cellBounds = list.getCellBounds(index, index);
                    if (cellBounds != null && visRect.intersects(cellBounds)) {
                        p.x = cellBounds.x + cellBounds.width;
                        index = list.locationToIndex(p);
                        if (index == -1) {
                            return index;
                        }
                        cellBounds = list.getCellBounds(index, index);
                    }
                    if (cellBounds != null && cellBounds.y != leadRect.y) {
                        p.x = cellBounds.x - 1;
                        index = list.locationToIndex(p);
                    }
                }
            } else if (direction < 0) {
                Point p = new Point(leadRect.x, visRect.y);
                index = list.locationToIndex(p);
                if (lead <= index) {
                    p.y = visRect.y = leadRect.y + leadRect.height - visRect.height;
                    index = list.locationToIndex(p);
                    if (index == -1) {
                        return index;
                    }
                    Rectangle cellBounds = list.getCellBounds(index, index);
                    if (cellBounds != null && cellBounds.y < visRect.y) {
                        p.y = cellBounds.y + cellBounds.height;
                        index = list.locationToIndex(p);
                        if (index == -1) {
                            return index;
                        }
                        cellBounds = list.getCellBounds(index, index);
                    }
                    if (cellBounds != null && cellBounds.y >= leadRect.y) {
                        p.y = leadRect.y - 1;
                        index = list.locationToIndex(p);
                    }
                }
            } else {
                Point p = new Point(leadRect.x, visRect.y + visRect.height - 1);
                index = list.locationToIndex(p);
                if (index == -1) {
                    return index;
                }
                Rectangle cellBounds = list.getCellBounds(index, index);
                if (cellBounds != null && cellBounds.y + cellBounds.height > visRect.y + visRect.height) {
                    p.y = cellBounds.y - 1;
                    index = list.locationToIndex(p);
                    if (index == -1) {
                        return index;
                    }
                    cellBounds = list.getCellBounds(index, index);
                    index = Math.max(index, lead);
                }
                if (lead >= index) {
                    visRect.y = leadRect.y;
                    p.y = visRect.y + visRect.height - 1;
                    index = list.locationToIndex(p);
                    if (index == -1) {
                        return index;
                    }
                    cellBounds = list.getCellBounds(index, index);
                    if (cellBounds != null && cellBounds.y + cellBounds.height > visRect.y + visRect.height) {
                        p.y = cellBounds.y - 1;
                        index = list.locationToIndex(p);
                        if (index == -1) {
                            return index;
                        }
                        cellBounds = list.getCellBounds(index, index);
                    }
                    if (cellBounds != null && cellBounds.y <= leadRect.y) {
                        p.y = leadRect.y + leadRect.height;
                        index = list.locationToIndex(p);
                    }
                }
            }
            return index;
        }

        private void changeSelection(JList<?> list, int type, int index, int direction) {
            if (index >= 0 && index < list.getModel().getSize()) {
                ListSelectionModel lsm = list.getSelectionModel();
                if (type == 0 && list.getSelectionMode() != 2) {
                    type = 1;
                }
                this.adjustScrollPositionIfNecessary(list, index, direction);
                if (type == 2) {
                    int anchor = BasicListUI.adjustIndex((int)lsm.getAnchorSelectionIndex(), list);
                    if (anchor == -1) {
                        anchor = 0;
                    }
                    list.setSelectionInterval(anchor, index);
                } else if (type == 1) {
                    list.setSelectedIndex(index);
                } else {
                    ((DefaultListSelectionModel)lsm).moveLeadSelectionIndex(index);
                }
            }
        }

        private void adjustScrollPositionIfNecessary(JList<?> list, int index, int direction) {
            if (direction == 0) {
                return;
            }
            Rectangle cellBounds = list.getCellBounds(index, index);
            Rectangle visRect = list.getVisibleRect();
            if (cellBounds != null && !visRect.contains(cellBounds)) {
                if (list.getLayoutOrientation() == 1 && list.getVisibleRowCount() <= 0) {
                    if (list.getComponentOrientation().isLeftToRight()) {
                        if (direction > 0) {
                            int x = Math.max(0, cellBounds.x + cellBounds.width - visRect.width);
                            int startIndex = list.locationToIndex(new Point(x, cellBounds.y));
                            if (startIndex == -1) {
                                return;
                            }
                            Rectangle startRect = list.getCellBounds(startIndex, startIndex);
                            if (startRect != null && startRect.x < x && startRect.x < cellBounds.x) {
                                startRect.x += startRect.width;
                                startIndex = list.locationToIndex(startRect.getLocation());
                                if (startIndex == -1) {
                                    return;
                                }
                                startRect = list.getCellBounds(startIndex, startIndex);
                            }
                            cellBounds = startRect;
                        }
                        if (cellBounds != null) {
                            cellBounds.width = visRect.width;
                        }
                    } else if (direction > 0) {
                        int x = cellBounds.x + visRect.width;
                        int rightIndex = list.locationToIndex(new Point(x, cellBounds.y));
                        if (rightIndex == -1) {
                            return;
                        }
                        Rectangle rightRect = list.getCellBounds(rightIndex, rightIndex);
                        if (rightRect != null) {
                            if (rightRect.x + rightRect.width > x && rightRect.x > cellBounds.x) {
                                rightRect.width = 0;
                            }
                            cellBounds.x = Math.max(0, rightRect.x + rightRect.width - visRect.width);
                            cellBounds.width = visRect.width;
                        }
                    } else {
                        cellBounds.x += Math.max(0, cellBounds.width - visRect.width);
                        cellBounds.width = Math.min(cellBounds.width, visRect.width);
                    }
                } else if (direction > 0 && (cellBounds.y < visRect.y || cellBounds.y + cellBounds.height > visRect.y + visRect.height)) {
                    int y = Math.max(0, cellBounds.y + cellBounds.height - visRect.height);
                    int startIndex = list.locationToIndex(new Point(cellBounds.x, y));
                    if (startIndex == -1) {
                        return;
                    }
                    Rectangle startRect = list.getCellBounds(startIndex, startIndex);
                    if (startRect != null && startRect.y < y && startRect.y < cellBounds.y) {
                        startRect.y += startRect.height;
                        startIndex = list.locationToIndex(startRect.getLocation());
                        if (startIndex == -1) {
                            return;
                        }
                        startRect = list.getCellBounds(startIndex, startIndex);
                    }
                    if ((cellBounds = startRect) != null) {
                        cellBounds.height = visRect.height;
                    }
                } else {
                    cellBounds.height = Math.min(cellBounds.height, visRect.height);
                }
                if (cellBounds != null) {
                    list.scrollRectToVisible(cellBounds);
                }
            }
        }

        private int getNextColumnIndex(JList<?> list, BasicListUI ui, int amount) {
            if (list.getLayoutOrientation() != 0) {
                int index = BasicListUI.adjustIndex((int)list.getLeadSelectionIndex(), list);
                int size = list.getModel().getSize();
                if (index == -1) {
                    return 0;
                }
                if (size == 1) {
                    return 0;
                }
                if (ui == null || ui.columnCount <= 1) {
                    return -1;
                }
                int column = ui.convertModelToColumn(index);
                int row = ui.convertModelToRow(index);
                if ((column += amount) >= ui.columnCount || column < 0) {
                    return -1;
                }
                int maxRowCount = ui.getRowCount(column);
                if (row >= maxRowCount) {
                    return -1;
                }
                return ui.getModelIndex(column, row);
            }
            return -1;
        }

        private int getNextIndex(JList<?> list, BasicListUI ui, int amount) {
            int index = BasicListUI.adjustIndex((int)list.getLeadSelectionIndex(), list);
            int size = list.getModel().getSize();
            if (index == -1) {
                if (size > 0) {
                    index = amount > 0 ? 0 : size - 1;
                }
            } else if (size == 1) {
                index = 0;
            } else if (list.getLayoutOrientation() == 2) {
                if (ui != null) {
                    index += ui.columnCount * amount;
                }
            } else {
                index += amount;
            }
            return index;
        }
    }

    public class FocusHandler
    implements FocusListener {
        public FocusHandler(BasicListUI basicListUI) {
        }

        protected void repaintCellFocus() {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    private class Handler
    implements FocusListener,
    KeyListener,
    ListDataListener,
    ListSelectionListener,
    MouseInputListener,
    PropertyChangeListener,
    DragRecognitionSupport.BeforeDrag {
        private String prefix = "";
        private String typedString = "";
        private long lastTime = 0L;
        private boolean dragPressDidSelection;

        private Handler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            int index;
            JList src = (JList)e.getSource();
            ListModel model = src.getModel();
            if (model.getSize() == 0 || e.isAltDown() || BasicGraphicsUtils.isMenuShortcutKeyDown((InputEvent)e) || this.isNavigationKey(e)) {
                return;
            }
            boolean startingFromSelection = true;
            char c = e.getKeyChar();
            long time = e.getWhen();
            int startIndex = BasicListUI.adjustIndex((int)src.getLeadSelectionIndex(), (JList)BasicListUI.this.list);
            if (time - this.lastTime < BasicListUI.this.timeFactor) {
                this.typedString = this.typedString + c;
                if (this.prefix.length() == 1 && c == this.prefix.charAt(0)) {
                    ++startIndex;
                } else {
                    this.prefix = this.typedString;
                }
            } else {
                ++startIndex;
                this.typedString = "" + c;
                this.prefix = this.typedString;
            }
            this.lastTime = time;
            if (startIndex < 0 || startIndex >= model.getSize()) {
                startingFromSelection = false;
                startIndex = 0;
            }
            if ((index = src.getNextMatch(this.prefix, startIndex, Position.Bias.Forward)) >= 0) {
                src.setSelectedIndex(index);
                src.ensureIndexIsVisible(index);
            } else if (startingFromSelection && (index = src.getNextMatch(this.prefix, 0, Position.Bias.Forward)) >= 0) {
                src.setSelectedIndex(index);
                src.ensureIndexIsVisible(index);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (this.isNavigationKey(e)) {
                this.prefix = "";
                this.typedString = "";
                this.lastTime = 0L;
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        private boolean isNavigationKey(KeyEvent event) {
            InputMap inputMap = BasicListUI.this.list.getInputMap(1);
            KeyStroke key = KeyStroke.getKeyStrokeForEvent(event);
            return inputMap != null && inputMap.get(key) != null;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName == "model") {
                ListModel oldModel = (ListModel)e.getOldValue();
                ListModel newModel = (ListModel)e.getNewValue();
                if (oldModel != null) {
                    oldModel.removeListDataListener(BasicListUI.this.listDataListener);
                }
                if (newModel != null) {
                    newModel.addListDataListener(BasicListUI.this.listDataListener);
                }
                BasicListUI.this.updateLayoutStateNeeded |= 1;
                BasicListUI.this.redrawList();
            } else if (propertyName == "selectionModel") {
                ListSelectionModel oldModel = (ListSelectionModel)e.getOldValue();
                ListSelectionModel newModel = (ListSelectionModel)e.getNewValue();
                if (oldModel != null) {
                    oldModel.removeListSelectionListener(BasicListUI.this.listSelectionListener);
                }
                if (newModel != null) {
                    newModel.addListSelectionListener(BasicListUI.this.listSelectionListener);
                }
                BasicListUI.this.updateLayoutStateNeeded |= 1;
                BasicListUI.this.redrawList();
            } else if (propertyName == "cellRenderer") {
                BasicListUI.this.updateLayoutStateNeeded |= 0x40;
                BasicListUI.this.redrawList();
            } else if (propertyName == "font" || SwingUtilities2.isScaleChanged(e)) {
                BasicListUI.this.updateLayoutStateNeeded |= 4;
                BasicListUI.this.redrawList();
            } else if (propertyName == "prototypeCellValue") {
                BasicListUI.this.updateLayoutStateNeeded |= 0x20;
                BasicListUI.this.redrawList();
            } else if (propertyName == "fixedCellHeight") {
                BasicListUI.this.updateLayoutStateNeeded |= 0x10;
                BasicListUI.this.redrawList();
            } else if (propertyName == "fixedCellWidth") {
                BasicListUI.this.updateLayoutStateNeeded |= 8;
                BasicListUI.this.redrawList();
            } else if (propertyName == "selectionForeground") {
                BasicListUI.this.list.repaint();
            } else if (propertyName == "selectionBackground") {
                BasicListUI.this.list.repaint();
            } else if ("layoutOrientation" == propertyName) {
                BasicListUI.this.updateLayoutStateNeeded |= 0x80;
                BasicListUI.this.layoutOrientation = BasicListUI.this.list.getLayoutOrientation();
                BasicListUI.this.redrawList();
            } else if ("visibleRowCount" == propertyName) {
                if (BasicListUI.this.layoutOrientation != 0) {
                    BasicListUI.this.updateLayoutStateNeeded |= 0x80;
                    BasicListUI.this.redrawList();
                }
            } else if ("componentOrientation" == propertyName) {
                BasicListUI.this.isLeftToRight = BasicListUI.this.list.getComponentOrientation().isLeftToRight();
                BasicListUI.this.updateLayoutStateNeeded |= 0x400;
                BasicListUI.this.redrawList();
                InputMap inputMap = BasicListUI.this.getInputMap(0);
                SwingUtilities.replaceUIInputMap(BasicListUI.this.list, 0, inputMap);
            } else if ("List.isFileList" == propertyName) {
                BasicListUI.this.updateIsFileList();
                BasicListUI.this.redrawList();
            } else if ("dropLocation" == propertyName) {
                JList.DropLocation oldValue = (JList.DropLocation)e.getOldValue();
                this.repaintDropLocation(oldValue);
                this.repaintDropLocation(BasicListUI.this.list.getDropLocation());
            }
        }

        private void repaintDropLocation(JList.DropLocation loc) {
            if (loc == null) {
                return;
            }
            Rectangle r = loc.isInsert() ? BasicListUI.this.getDropLineRect(loc) : BasicListUI.this.getCellBounds(BasicListUI.this.list, loc.getIndex());
            if (r != null) {
                BasicListUI.this.list.repaint(r);
            }
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            BasicListUI.this.updateLayoutStateNeeded = 1;
            int minIndex = Math.min(e.getIndex0(), e.getIndex1());
            int maxIndex = Math.max(e.getIndex0(), e.getIndex1());
            ListSelectionModel sm = BasicListUI.this.list.getSelectionModel();
            if (sm != null) {
                sm.insertIndexInterval(minIndex, maxIndex - minIndex + 1, true);
            }
            BasicListUI.this.redrawList();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            BasicListUI.this.updateLayoutStateNeeded = 1;
            ListSelectionModel sm = BasicListUI.this.list.getSelectionModel();
            if (sm != null) {
                sm.removeIndexInterval(e.getIndex0(), e.getIndex1());
            }
            BasicListUI.this.redrawList();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            BasicListUI.this.updateLayoutStateNeeded = 1;
            BasicListUI.this.redrawList();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            BasicListUI.this.maybeUpdateLayoutState();
            int size = BasicListUI.this.list.getModel().getSize();
            int firstIndex = Math.min(size - 1, Math.max(e.getFirstIndex(), 0));
            int lastIndex = Math.min(size - 1, Math.max(e.getLastIndex(), 0));
            Rectangle bounds = BasicListUI.this.getCellBounds(BasicListUI.this.list, firstIndex, lastIndex);
            if (bounds != null) {
                BasicListUI.this.list.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities2.shouldIgnore(e, BasicListUI.this.list)) {
                return;
            }
            boolean dragEnabled = BasicListUI.this.list.getDragEnabled();
            boolean grabFocus = true;
            if (dragEnabled) {
                int row = SwingUtilities2.loc2IndexFileList(BasicListUI.this.list, e.getPoint());
                if (row != -1 && DragRecognitionSupport.mousePressed(e)) {
                    this.dragPressDidSelection = false;
                    if (BasicGraphicsUtils.isMenuShortcutKeyDown((InputEvent)e)) {
                        return;
                    }
                    if (!e.isShiftDown() && BasicListUI.this.list.isSelectedIndex(row)) {
                        BasicListUI.this.list.addSelectionInterval(row, row);
                        return;
                    }
                    grabFocus = false;
                    this.dragPressDidSelection = true;
                }
            } else {
                BasicListUI.this.list.setValueIsAdjusting(true);
            }
            if (grabFocus) {
                SwingUtilities2.adjustFocus(BasicListUI.this.list);
            }
            this.adjustSelection(e);
        }

        private void adjustSelection(MouseEvent e) {
            int row = SwingUtilities2.loc2IndexFileList(BasicListUI.this.list, e.getPoint());
            if (row < 0) {
                if (BasicListUI.this.isFileList && e.getID() == 501 && (!e.isShiftDown() || BasicListUI.this.list.getSelectionMode() == 0)) {
                    BasicListUI.this.list.clearSelection();
                }
            } else {
                boolean anchorSelected;
                int anchorIndex = BasicListUI.adjustIndex((int)BasicListUI.this.list.getAnchorSelectionIndex(), (JList)BasicListUI.this.list);
                if (anchorIndex == -1) {
                    anchorIndex = 0;
                    anchorSelected = false;
                } else {
                    anchorSelected = BasicListUI.this.list.isSelectedIndex(anchorIndex);
                }
                if (BasicGraphicsUtils.isMenuShortcutKeyDown((InputEvent)e)) {
                    if (e.isShiftDown()) {
                        if (anchorSelected) {
                            BasicListUI.this.list.addSelectionInterval(anchorIndex, row);
                        } else {
                            BasicListUI.this.list.removeSelectionInterval(anchorIndex, row);
                            if (BasicListUI.this.isFileList) {
                                BasicListUI.this.list.addSelectionInterval(row, row);
                                BasicListUI.this.list.getSelectionModel().setAnchorSelectionIndex(anchorIndex);
                            }
                        }
                    } else if (BasicListUI.this.list.isSelectedIndex(row)) {
                        BasicListUI.this.list.removeSelectionInterval(row, row);
                    } else {
                        BasicListUI.this.list.addSelectionInterval(row, row);
                    }
                } else if (e.isShiftDown()) {
                    BasicListUI.this.list.setSelectionInterval(anchorIndex, row);
                } else {
                    BasicListUI.this.list.setSelectionInterval(row, row);
                }
            }
        }

        @Override
        public void dragStarting(MouseEvent me) {
            if (BasicGraphicsUtils.isMenuShortcutKeyDown((InputEvent)me)) {
                int row = SwingUtilities2.loc2IndexFileList(BasicListUI.this.list, me.getPoint());
                BasicListUI.this.list.addSelectionInterval(row, row);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (SwingUtilities2.shouldIgnore(e, BasicListUI.this.list)) {
                return;
            }
            if (BasicListUI.this.list.getDragEnabled()) {
                DragRecognitionSupport.mouseDragged(e, this);
                return;
            }
            if (e.isShiftDown() || BasicGraphicsUtils.isMenuShortcutKeyDown((InputEvent)e)) {
                return;
            }
            int row = BasicListUI.this.locationToIndex(BasicListUI.this.list, e.getPoint());
            if (row != -1) {
                if (BasicListUI.this.isFileList) {
                    return;
                }
                Rectangle cellBounds = BasicListUI.this.getCellBounds(BasicListUI.this.list, row, row);
                if (cellBounds != null) {
                    BasicListUI.this.list.scrollRectToVisible(cellBounds);
                    BasicListUI.this.list.setSelectionInterval(row, row);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities2.shouldIgnore(e, BasicListUI.this.list)) {
                return;
            }
            if (BasicListUI.this.list.getDragEnabled()) {
                MouseEvent me = DragRecognitionSupport.mouseReleased(e);
                if (me != null) {
                    SwingUtilities2.adjustFocus(BasicListUI.this.list);
                    if (!this.dragPressDidSelection) {
                        this.adjustSelection(me);
                    }
                }
            } else {
                BasicListUI.this.list.setValueIsAdjusting(false);
            }
        }

        protected void repaintCellFocus() {
            Rectangle r;
            int leadIndex = BasicListUI.adjustIndex((int)BasicListUI.this.list.getLeadSelectionIndex(), (JList)BasicListUI.this.list);
            if (leadIndex != -1 && (r = BasicListUI.this.getCellBounds(BasicListUI.this.list, leadIndex, leadIndex)) != null) {
                BasicListUI.this.list.repaint(r.x, r.y, r.width, r.height);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.repaintCellFocus();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.repaintCellFocus();
        }
    }

    public class ListDataHandler
    implements ListDataListener {
        public ListDataHandler(BasicListUI basicListUI) {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
        }
    }

    public class ListSelectionHandler
    implements ListSelectionListener {
        public ListSelectionHandler(BasicListUI basicListUI) {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
        }
    }

    static class ListTransferHandler
    extends TransferHandler
    implements UIResource {
        ListTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (c instanceof JList) {
                JList list = (JList)c;
                Object[] values = list.getSelectedValues();
                if (values == null || values.length == 0) {
                    return null;
                }
                StringBuilder plainStr = new StringBuilder();
                StringBuilder htmlStr = new StringBuilder();
                htmlStr.append("<html>\n<body>\n<ul>\n");
                for (int i = 0; i < values.length; ++i) {
                    Object obj = values[i];
                    String val = obj == null ? "" : obj.toString();
                    plainStr.append(val).append('\n');
                    htmlStr.append("  <li>").append(val).append('\n');
                }
                plainStr.deleteCharAt(plainStr.length() - 1);
                htmlStr.append("</ul>\n</body>\n</html>");
                return new BasicTransferable(plainStr.toString(), htmlStr.toString());
            }
            return null;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        public MouseInputHandler(BasicListUI basicListUI) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public PropertyChangeHandler(BasicListUI basicListUI) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }
    }
}

