/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;

public abstract class BasicLookAndFeel
extends LookAndFeel
implements Serializable {
    public UIDefaults getDefaults() {
        return null;
    }

    public void initialize() {
    }

    public void uninitialize() {
    }

    protected void initClassDefaults(UIDefaults uIDefaults) {
    }

    protected void initSystemColorDefaults(UIDefaults uIDefaults) {
    }

    protected void loadSystemColors(UIDefaults uIDefaults, String[] stringArray, boolean bl) {
    }

    protected void initComponentDefaults(UIDefaults uIDefaults) {
    }

    protected ActionMap getAudioActionMap() {
        return null;
    }

    protected Action createAudioAction(Object object) {
        return null;
    }

    protected void playSound(Action action) {
    }

    private class AudioAction
    extends AbstractAction
    implements LineListener {
        private String audioResource;
        private byte[] audioBuffer;

        public AudioAction(String name, String resource) {
            super(name);
            this.audioResource = resource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.audioBuffer == null) {
                this.audioBuffer = BasicLookAndFeel.this.loadAudioData(this.audioResource);
            }
            if (this.audioBuffer != null) {
                this.cancelCurrentSound(null);
                try {
                    AudioInputStream soundStream = AudioSystem.getAudioInputStream(new ByteArrayInputStream(this.audioBuffer));
                    DataLine.Info info = new DataLine.Info(Clip.class, soundStream.getFormat());
                    Clip clip = (Clip)AudioSystem.getLine(info);
                    clip.open(soundStream);
                    clip.addLineListener(this);
                    Object object = BasicLookAndFeel.this.audioLock;
                    synchronized (object) {
                        BasicLookAndFeel.this.clipPlaying = clip;
                    }
                    clip.start();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void update(LineEvent event) {
            if (event.getType() == LineEvent.Type.STOP) {
                this.cancelCurrentSound((Clip)event.getLine());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancelCurrentSound(Clip clip) {
            Clip lastClip = null;
            Object object = BasicLookAndFeel.this.audioLock;
            synchronized (object) {
                if (clip == null || clip == BasicLookAndFeel.this.clipPlaying) {
                    lastClip = BasicLookAndFeel.this.clipPlaying;
                    BasicLookAndFeel.this.clipPlaying = null;
                }
            }
            if (lastClip != null) {
                lastClip.removeLineListener(this);
                lastClip.close();
            }
        }
    }
}

