/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.basic.BasicHTML;
import sun.swing.MenuItemLayoutHelper;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public class BasicMenuItemUI
extends MenuItemUI {
    protected JMenuItem menuItem;
    protected Color selectionBackground;
    protected Color selectionForeground;
    protected Color disabledForeground;
    protected Color acceleratorForeground;
    protected Color acceleratorSelectionForeground;
    protected int defaultTextIconGap;
    protected Font acceleratorFont;
    protected MouseInputListener mouseInputListener;
    protected MenuDragMouseListener menuDragMouseListener;
    protected MenuKeyListener menuKeyListener;
    protected Icon arrowIcon;
    protected Icon checkIcon;
    protected boolean oldBorderPainted;

    public static ComponentUI createUI(JComponent jComponent) {
        return null;
    }

    public void installUI(JComponent jComponent) {
    }

    protected void installDefaults() {
    }

    protected void installComponents(JMenuItem jMenuItem) {
    }

    protected String getPropertyPrefix() {
        return null;
    }

    protected void installListeners() {
    }

    protected void installKeyboardActions() {
    }

    public void uninstallUI(JComponent jComponent) {
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallComponents(JMenuItem jMenuItem) {
    }

    protected void uninstallListeners() {
    }

    protected void uninstallKeyboardActions() {
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return null;
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return null;
    }

    protected MenuKeyListener createMenuKeyListener(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n) {
        return null;
    }

    public void update(Graphics graphics, JComponent jComponent) {
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    protected void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n) {
    }

    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
    }

    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
    }

    public MenuElement[] getPath() {
        return null;
    }

    protected void doClick(MenuSelectionManager menuSelectionManager) {
    }

    private static class Actions
    extends UIAction {
        private static final String CLICK = "doClick";

        Actions(String key) {
            super(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem mi = (JMenuItem)e.getSource();
            MenuSelectionManager.defaultManager().clearSelectedPath();
            mi.doClick();
        }
    }

    class Handler
    implements MenuDragMouseListener,
    MouseInputListener,
    PropertyChangeListener {
        Handler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!BasicMenuItemUI.this.menuItem.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < BasicMenuItemUI.this.menuItem.getWidth() && p.y >= 0 && p.y < BasicMenuItemUI.this.menuItem.getHeight()) {
                BasicMenuItemUI.this.doClick(manager);
            } else {
                manager.processMouseEvent(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            int modifiers = e.getModifiers();
            if ((modifiers & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(e);
            } else {
                manager.setSelectedPath(BasicMenuItemUI.this.getPath());
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            int modifiers = e.getModifiers();
            if ((modifiers & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(e);
            } else {
                MenuElement[] path = manager.getSelectedPath();
                if (path.length > 1 && path[path.length - 1] == BasicMenuItemUI.this.menuItem) {
                    MenuElement[] newPath = new MenuElement[path.length - 1];
                    int c = path.length - 1;
                    for (int i = 0; i < c; ++i) {
                        newPath[i] = path[i];
                    }
                    manager.setSelectedPath(newPath);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            MenuSelectionManager.defaultManager().processMouseEvent(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void menuDragMouseEntered(MenuDragMouseEvent e) {
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            manager.setSelectedPath(path);
        }

        @Override
        public void menuDragMouseDragged(MenuDragMouseEvent e) {
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            manager.setSelectedPath(path);
        }

        @Override
        public void menuDragMouseExited(MenuDragMouseEvent e) {
        }

        @Override
        public void menuDragMouseReleased(MenuDragMouseEvent e) {
            if (!BasicMenuItemUI.this.menuItem.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < BasicMenuItemUI.this.menuItem.getWidth() && p.y >= 0 && p.y < BasicMenuItemUI.this.menuItem.getHeight()) {
                BasicMenuItemUI.this.doClick(manager);
            } else {
                manager.clearSelectedPath();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name == "labelFor" || name == "displayedMnemonic" || name == "accelerator") {
                BasicMenuItemUI.this.updateAcceleratorBinding();
            } else if (name == "text" || "font" == name || "foreground" == name || SwingUtilities2.isScaleChanged(e)) {
                JMenuItem lbl = (JMenuItem)e.getSource();
                if (SwingUtilities2.isScaleChanged(e)) {
                    MenuItemLayoutHelper.clearUsedParentClientProperties(lbl);
                }
                String text = lbl.getText();
                BasicHTML.updateRenderer(lbl, text);
            } else if (name == "iconTextGap") {
                BasicMenuItemUI.this.defaultTextIconGap = ((Number)e.getNewValue()).intValue();
            }
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler(BasicMenuItemUI basicMenuItemUI) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

