/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ProgressBarUI;

public class BasicProgressBarUI
extends ProgressBarUI {
    protected JProgressBar progressBar;
    protected ChangeListener changeListener;
    protected Rectangle boxRect;

    public static ComponentUI createUI(JComponent jComponent) {
        return null;
    }

    public void installUI(JComponent jComponent) {
    }

    public void uninstallUI(JComponent jComponent) {
    }

    protected void installDefaults() {
    }

    protected void uninstallDefaults() {
    }

    protected void installListeners() {
    }

    protected void startAnimationTimer() {
    }

    protected void stopAnimationTimer() {
    }

    protected void uninstallListeners() {
    }

    protected Dimension getPreferredInnerHorizontal() {
        return null;
    }

    protected Dimension getPreferredInnerVertical() {
        return null;
    }

    protected Color getSelectionForeground() {
        return null;
    }

    protected Color getSelectionBackground() {
        return null;
    }

    protected int getCellLength() {
        return 0;
    }

    protected void setCellLength(int n) {
    }

    protected int getCellSpacing() {
        return 0;
    }

    protected void setCellSpacing(int n) {
    }

    protected int getAmountFull(Insets insets, int n, int n2) {
        return 0;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    protected Rectangle getBox(Rectangle rectangle) {
        return null;
    }

    protected int getBoxLength(int n, int n2) {
        return 0;
    }

    protected void paintIndeterminate(Graphics graphics, JComponent jComponent) {
    }

    protected void paintDeterminate(Graphics graphics, JComponent jComponent) {
    }

    protected void paintString(Graphics graphics, int n, int n2, int n3, int n4, int n5, Insets insets) {
    }

    protected Point getStringPlacement(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        return null;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    protected int getAnimationIndex() {
        return 0;
    }

    protected void setAnimationIndex(int n) {
    }

    protected void incrementAnimationIndex() {
    }

    private class Animator
    implements ActionListener {
        private Timer timer;
        private long previousDelay;
        private int interval;
        private long lastCall;
        private int MINIMUM_DELAY = 5;

        private Animator() {
        }

        private void start(int interval) {
            this.previousDelay = interval;
            this.lastCall = 0L;
            if (this.timer == null) {
                this.timer = new Timer(interval, this);
            } else {
                this.timer.setDelay(interval);
            }
            if (ADJUSTTIMER) {
                this.timer.setRepeats(false);
                this.timer.setCoalesce(false);
            }
            this.timer.start();
        }

        private void stop() {
            this.timer.stop();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ADJUSTTIMER) {
                long time = System.currentTimeMillis();
                if (this.lastCall > 0L) {
                    int nextDelay = (int)(this.previousDelay - time + this.lastCall + (long)BasicProgressBarUI.this.getRepaintInterval());
                    if (nextDelay < this.MINIMUM_DELAY) {
                        nextDelay = this.MINIMUM_DELAY;
                    }
                    this.timer.setInitialDelay(nextDelay);
                    this.previousDelay = nextDelay;
                }
                this.timer.start();
                this.lastCall = time;
            }
            BasicProgressBarUI.this.incrementAnimationIndex();
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        public ChangeHandler(BasicProgressBarUI basicProgressBarUI) {
        }

        public void stateChanged(ChangeEvent changeEvent) {
        }
    }

    private class Handler
    implements ChangeListener,
    PropertyChangeListener,
    HierarchyListener {
        private Handler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int oldPercent;
            BoundedRangeModel model = BasicProgressBarUI.this.progressBar.getModel();
            int newRange = model.getMaximum() - model.getMinimum();
            int newPercent = newRange > 0 ? (int)(100L * (long)model.getValue() / (long)newRange) : 0;
            if (newPercent != (oldPercent = BasicProgressBarUI.this.getCachedPercent())) {
                BasicProgressBarUI.this.setCachedPercent(newPercent);
                BasicProgressBarUI.this.progressBar.repaint();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if ("indeterminate" == prop) {
                if (BasicProgressBarUI.this.progressBar.isIndeterminate()) {
                    BasicProgressBarUI.this.initIndeterminateValues();
                } else {
                    BasicProgressBarUI.this.cleanUpIndeterminateValues();
                }
                BasicProgressBarUI.this.progressBar.repaint();
            }
        }

        @Override
        public void hierarchyChanged(HierarchyEvent he) {
            if ((he.getChangeFlags() & 2L) != 0L && BasicProgressBarUI.this.progressBar.isIndeterminate()) {
                if (BasicProgressBarUI.this.progressBar.isDisplayable()) {
                    BasicProgressBarUI.this.startAnimationTimer();
                } else {
                    BasicProgressBarUI.this.stopAnimationTimer();
                }
            }
        }
    }
}

