/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneConstants;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import sun.swing.UIAction;

public class BasicScrollPaneUI
extends ScrollPaneUI
implements ScrollPaneConstants {
    protected JScrollPane scrollpane;
    protected ChangeListener vsbChangeListener;
    protected ChangeListener hsbChangeListener;
    protected ChangeListener viewportChangeListener;
    protected PropertyChangeListener spPropertyChangeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return null;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    protected void installDefaults(JScrollPane jScrollPane) {
    }

    protected void installListeners(JScrollPane jScrollPane) {
    }

    protected void installKeyboardActions(JScrollPane jScrollPane) {
    }

    public void installUI(JComponent jComponent) {
    }

    protected void uninstallDefaults(JScrollPane jScrollPane) {
    }

    protected void uninstallListeners(JComponent jComponent) {
    }

    protected void uninstallKeyboardActions(JScrollPane jScrollPane) {
    }

    public void uninstallUI(JComponent jComponent) {
    }

    protected void syncScrollPaneWithViewport() {
    }

    protected ChangeListener createViewportChangeListener() {
        return null;
    }

    protected ChangeListener createHSBChangeListener() {
        return null;
    }

    protected ChangeListener createVSBChangeListener() {
        return null;
    }

    protected MouseWheelListener createMouseWheelListener() {
        return null;
    }

    protected void updateScrollBarDisplayPolicy(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void updateViewport(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void updateRowHeader(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void updateColumnHeader(PropertyChangeEvent propertyChangeEvent) {
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return null;
    }

    private static class Actions
    extends UIAction {
        private static final String SCROLL_UP = "scrollUp";
        private static final String SCROLL_DOWN = "scrollDown";
        private static final String SCROLL_HOME = "scrollHome";
        private static final String SCROLL_END = "scrollEnd";
        private static final String UNIT_SCROLL_UP = "unitScrollUp";
        private static final String UNIT_SCROLL_DOWN = "unitScrollDown";
        private static final String SCROLL_LEFT = "scrollLeft";
        private static final String SCROLL_RIGHT = "scrollRight";
        private static final String UNIT_SCROLL_LEFT = "unitScrollLeft";
        private static final String UNIT_SCROLL_RIGHT = "unitScrollRight";

        Actions(String key) {
            super(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JScrollPane scrollPane = (JScrollPane)e.getSource();
            boolean ltr = scrollPane.getComponentOrientation().isLeftToRight();
            String key = this.getName();
            if (key == SCROLL_UP) {
                this.scroll(scrollPane, 1, -1, true);
            } else if (key == SCROLL_DOWN) {
                this.scroll(scrollPane, 1, 1, true);
            } else if (key == SCROLL_HOME) {
                this.scrollHome(scrollPane);
            } else if (key == SCROLL_END) {
                this.scrollEnd(scrollPane);
            } else if (key == UNIT_SCROLL_UP) {
                this.scroll(scrollPane, 1, -1, false);
            } else if (key == UNIT_SCROLL_DOWN) {
                this.scroll(scrollPane, 1, 1, false);
            } else if (key == SCROLL_LEFT) {
                this.scroll(scrollPane, 0, ltr ? -1 : 1, true);
            } else if (key == SCROLL_RIGHT) {
                this.scroll(scrollPane, 0, ltr ? 1 : -1, true);
            } else if (key == UNIT_SCROLL_LEFT) {
                this.scroll(scrollPane, 0, ltr ? -1 : 1, false);
            } else if (key == UNIT_SCROLL_RIGHT) {
                this.scroll(scrollPane, 0, ltr ? 1 : -1, false);
            }
        }

        private void scrollEnd(JScrollPane scrollpane) {
            Component view;
            JViewport vp = scrollpane.getViewport();
            if (vp != null && (view = vp.getView()) != null) {
                Rectangle visRect = vp.getViewRect();
                Rectangle bounds = view.getBounds();
                if (scrollpane.getComponentOrientation().isLeftToRight()) {
                    vp.setViewPosition(new Point(bounds.width - visRect.width, bounds.height - visRect.height));
                } else {
                    vp.setViewPosition(new Point(0, bounds.height - visRect.height));
                }
            }
        }

        private void scrollHome(JScrollPane scrollpane) {
            Component view;
            JViewport vp = scrollpane.getViewport();
            if (vp != null && (view = vp.getView()) != null) {
                if (scrollpane.getComponentOrientation().isLeftToRight()) {
                    vp.setViewPosition(new Point(0, 0));
                } else {
                    Rectangle visRect = vp.getViewRect();
                    Rectangle bounds = view.getBounds();
                    vp.setViewPosition(new Point(bounds.width - visRect.width, 0));
                }
            }
        }

        private void scroll(JScrollPane scrollpane, int orientation, int direction, boolean block) {
            Component view;
            JViewport vp = scrollpane.getViewport();
            if (vp != null && (view = vp.getView()) != null) {
                Rectangle visRect = vp.getViewRect();
                Dimension vSize = view.getSize();
                int amount = view instanceof Scrollable ? (block ? ((Scrollable)((Object)view)).getScrollableBlockIncrement(visRect, orientation, direction) : ((Scrollable)((Object)view)).getScrollableUnitIncrement(visRect, orientation, direction)) : (block ? (orientation == 1 ? visRect.height : visRect.width) : 10);
                if (orientation == 1) {
                    visRect.y += amount * direction;
                    if (visRect.y + visRect.height > vSize.height) {
                        visRect.y = Math.max(0, vSize.height - visRect.height);
                    } else if (visRect.y < 0) {
                        visRect.y = 0;
                    }
                } else if (scrollpane.getComponentOrientation().isLeftToRight()) {
                    visRect.x += amount * direction;
                    if (visRect.x + visRect.width > vSize.width) {
                        visRect.x = Math.max(0, vSize.width - visRect.width);
                    } else if (visRect.x < 0) {
                        visRect.x = 0;
                    }
                } else {
                    visRect.x -= amount * direction;
                    visRect.x = visRect.width > vSize.width ? vSize.width - visRect.width : Math.max(0, Math.min(vSize.width - visRect.width, visRect.x));
                }
                vp.setViewPosition(visRect.getLocation());
            }
        }
    }

    public class HSBChangeListener
    implements ChangeListener {
        public HSBChangeListener(BasicScrollPaneUI basicScrollPaneUI) {
        }

        public void stateChanged(ChangeEvent changeEvent) {
        }
    }

    class Handler
    implements ChangeListener,
    PropertyChangeListener,
    MouseWheelListener {
        Handler() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (BasicScrollPaneUI.this.scrollpane.isWheelScrollingEnabled() && e.getWheelRotation() != 0) {
                JScrollBar toScroll = BasicScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                int direction = e.getWheelRotation() < 0 ? -1 : 1;
                int orientation = 1;
                if (toScroll == null || !toScroll.isVisible() || e.isShiftDown()) {
                    JScrollBar hScroll = BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                    if (hScroll == null) {
                        return;
                    }
                    if (hScroll.isVisible()) {
                        toScroll = hScroll;
                        orientation = 0;
                    } else if (!hScroll.isVisible()) {
                        if (e.isShiftDown()) {
                            return;
                        }
                        orientation = 1;
                    }
                }
                e.consume();
                if (e.getScrollType() == 0) {
                    JViewport vp = BasicScrollPaneUI.this.scrollpane.getViewport();
                    if (vp == null) {
                        return;
                    }
                    Component comp = vp.getView();
                    int units = Math.abs(e.getUnitsToScroll());
                    boolean limitScroll = Math.abs(e.getWheelRotation()) == 1;
                    Object fastWheelScroll = toScroll.getClientProperty("JScrollBar.fastWheelScrolling");
                    if (Boolean.TRUE == fastWheelScroll && comp instanceof Scrollable) {
                        Scrollable scrollComp = (Scrollable)((Object)comp);
                        Rectangle viewRect = vp.getViewRect();
                        int startingX = viewRect.x;
                        boolean leftToRight = comp.getComponentOrientation().isLeftToRight();
                        int scrollMin = toScroll.getMinimum();
                        int scrollMax = toScroll.getMaximum() - toScroll.getModel().getExtent();
                        if (limitScroll) {
                            int blockIncr = scrollComp.getScrollableBlockIncrement(viewRect, orientation, direction);
                            if (direction < 0) {
                                scrollMin = Math.max(scrollMin, toScroll.getValue() - blockIncr);
                            } else {
                                scrollMax = Math.min(scrollMax, toScroll.getValue() + blockIncr);
                            }
                        }
                        for (int i = 0; i < units; ++i) {
                            int unitIncr = scrollComp.getScrollableUnitIncrement(viewRect, orientation, direction);
                            if (orientation == 1) {
                                if (direction < 0) {
                                    viewRect.y -= unitIncr;
                                    if (viewRect.y > scrollMin) continue;
                                    viewRect.y = scrollMin;
                                    break;
                                }
                                viewRect.y += unitIncr;
                                if (viewRect.y < scrollMax) continue;
                                viewRect.y = scrollMax;
                                break;
                            }
                            if (leftToRight && direction < 0 || !leftToRight && direction > 0) {
                                viewRect.x -= unitIncr;
                                if (!leftToRight || viewRect.x >= scrollMin) continue;
                                viewRect.x = scrollMin;
                                break;
                            }
                            if (leftToRight && direction > 0 || !leftToRight && direction < 0) {
                                viewRect.x += unitIncr;
                                if (!leftToRight || viewRect.x <= scrollMax) continue;
                                viewRect.x = scrollMax;
                                break;
                            }
                            assert (false) : "Non-sensical ComponentOrientation / scroll direction";
                        }
                        if (orientation == 1) {
                            toScroll.setValue(viewRect.y);
                        } else if (leftToRight) {
                            toScroll.setValue(viewRect.x);
                        } else {
                            int newPos = toScroll.getValue() - (viewRect.x - startingX);
                            if (newPos < scrollMin) {
                                newPos = scrollMin;
                            } else if (newPos > scrollMax) {
                                newPos = scrollMax;
                            }
                            toScroll.setValue(newPos);
                        }
                    } else {
                        BasicScrollBarUI.scrollByUnits((JScrollBar)toScroll, (int)direction, (int)units, (boolean)limitScroll);
                    }
                } else if (e.getScrollType() == 1) {
                    BasicScrollBarUI.scrollByBlock((JScrollBar)toScroll, (int)direction);
                }
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JViewport viewport = BasicScrollPaneUI.this.scrollpane.getViewport();
            if (viewport != null) {
                if (e.getSource() == viewport) {
                    BasicScrollPaneUI.this.syncScrollPaneWithViewport();
                } else {
                    JScrollBar hsb = BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                    if (hsb != null && e.getSource() == hsb.getModel()) {
                        this.hsbStateChanged(viewport, e);
                    } else {
                        JScrollBar vsb = BasicScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                        if (vsb != null && e.getSource() == vsb.getModel()) {
                            this.vsbStateChanged(viewport, e);
                        }
                    }
                }
            }
        }

        private void vsbStateChanged(JViewport viewport, ChangeEvent e) {
            BoundedRangeModel model = (BoundedRangeModel)e.getSource();
            Point p = viewport.getViewPosition();
            p.y = model.getValue();
            viewport.setViewPosition(p);
        }

        private void hsbStateChanged(JViewport viewport, ChangeEvent e) {
            BoundedRangeModel model = (BoundedRangeModel)e.getSource();
            Point p = viewport.getViewPosition();
            int value = model.getValue();
            if (BasicScrollPaneUI.this.scrollpane.getComponentOrientation().isLeftToRight()) {
                p.x = value;
            } else {
                int max = viewport.getViewSize().width;
                int extent = viewport.getExtentSize().width;
                int oldX = p.x;
                p.x = max - extent - value;
                if (extent == 0 && value != 0 && oldX == max) {
                    BasicScrollPaneUI.this.setValueCalled = true;
                } else if (extent != 0 && oldX < 0 && p.x == 0) {
                    p.x += value;
                }
            }
            viewport.setViewPosition(p);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getSource() == BasicScrollPaneUI.this.scrollpane) {
                this.scrollPanePropertyChange(e);
            } else {
                this.sbPropertyChange(e);
            }
        }

        private void scrollPanePropertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName == "verticalScrollBarDisplayPolicy") {
                BasicScrollPaneUI.this.updateScrollBarDisplayPolicy(e);
            } else if (propertyName == "horizontalScrollBarDisplayPolicy") {
                BasicScrollPaneUI.this.updateScrollBarDisplayPolicy(e);
            } else if (propertyName == "viewport") {
                BasicScrollPaneUI.this.updateViewport(e);
            } else if (propertyName == "rowHeader") {
                BasicScrollPaneUI.this.updateRowHeader(e);
            } else if (propertyName == "columnHeader") {
                BasicScrollPaneUI.this.updateColumnHeader(e);
            } else if (propertyName == "verticalScrollBar") {
                BasicScrollPaneUI.this.updateVerticalScrollBar(e);
            } else if (propertyName == "horizontalScrollBar") {
                BasicScrollPaneUI.this.updateHorizontalScrollBar(e);
            } else if (propertyName == "componentOrientation") {
                BasicScrollPaneUI.this.scrollpane.revalidate();
                BasicScrollPaneUI.this.scrollpane.repaint();
            }
        }

        private void sbPropertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            Object source = e.getSource();
            if ("model" == propertyName) {
                JScrollBar sb = BasicScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                BoundedRangeModel oldModel = (BoundedRangeModel)e.getOldValue();
                ChangeListener cl = null;
                if (source == sb) {
                    cl = BasicScrollPaneUI.this.vsbChangeListener;
                } else if (source == BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) {
                    sb = BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                    cl = BasicScrollPaneUI.this.hsbChangeListener;
                }
                if (cl != null) {
                    if (oldModel != null) {
                        oldModel.removeChangeListener(cl);
                    }
                    if (sb.getModel() != null) {
                        sb.getModel().addChangeListener(cl);
                    }
                }
            } else if ("componentOrientation" == propertyName && source == BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) {
                JScrollBar hsb = BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                JViewport viewport = BasicScrollPaneUI.this.scrollpane.getViewport();
                Point p = viewport.getViewPosition();
                p.x = BasicScrollPaneUI.this.scrollpane.getComponentOrientation().isLeftToRight() ? hsb.getValue() : viewport.getViewSize().width - viewport.getExtentSize().width - hsb.getValue();
                viewport.setViewPosition(p);
            }
        }
    }

    protected class MouseWheelHandler
    implements MouseWheelListener {
        protected MouseWheelHandler(BasicScrollPaneUI basicScrollPaneUI) {
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public PropertyChangeHandler(BasicScrollPaneUI basicScrollPaneUI) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }
    }

    public class VSBChangeListener
    implements ChangeListener {
        public VSBChangeListener(BasicScrollPaneUI basicScrollPaneUI) {
        }

        public void stateChanged(ChangeEvent changeEvent) {
        }
    }

    public class ViewportChangeHandler
    implements ChangeListener {
        public ViewportChangeHandler(BasicScrollPaneUI basicScrollPaneUI) {
        }

        public void stateChanged(ChangeEvent changeEvent) {
        }
    }
}

