/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.SpinnerUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.InternationalFormatter;
import sun.swing.DefaultLookup;

public class BasicSpinnerUI
extends SpinnerUI {
    protected JSpinner spinner;

    public static ComponentUI createUI(JComponent jComponent) {
        return null;
    }

    public void installUI(JComponent jComponent) {
    }

    public void uninstallUI(JComponent jComponent) {
    }

    protected void installListeners() {
    }

    protected void uninstallListeners() {
    }

    protected void installDefaults() {
    }

    protected void uninstallDefaults() {
    }

    protected void installNextButtonListeners(Component component) {
    }

    protected void installPreviousButtonListeners(Component component) {
    }

    protected LayoutManager createLayout() {
        return null;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return null;
    }

    protected Component createPreviousButton() {
        return null;
    }

    protected Component createNextButton() {
        return null;
    }

    protected JComponent createEditor() {
        return null;
    }

    protected void replaceEditor(JComponent jComponent, JComponent jComponent2) {
    }

    protected void installKeyboardActions() {
    }

    private static class ArrowButtonHandler
    extends AbstractAction
    implements FocusListener,
    MouseListener,
    UIResource {
        final Timer autoRepeatTimer;
        final boolean isNext;
        JSpinner spinner = null;
        JButton arrowButton = null;

        ArrowButtonHandler(String name, boolean isNext) {
            super(name);
            this.isNext = isNext;
            this.autoRepeatTimer = new Timer(60, this);
            this.autoRepeatTimer.setInitialDelay(300);
        }

        private JSpinner eventToSpinner(AWTEvent e) {
            Object src = e.getSource();
            while (src instanceof Component && !(src instanceof JSpinner)) {
                src = ((Component)src).getParent();
            }
            return src instanceof JSpinner ? (JSpinner)src : null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JSpinner spinner = this.spinner;
            if (!(e.getSource() instanceof Timer)) {
                spinner = this.eventToSpinner(e);
                if (e.getSource() instanceof JButton) {
                    this.arrowButton = (JButton)e.getSource();
                }
            } else if (this.arrowButton != null && !this.arrowButton.getModel().isPressed() && this.autoRepeatTimer.isRunning()) {
                this.autoRepeatTimer.stop();
                spinner = null;
                this.arrowButton = null;
            }
            if (spinner != null) {
                try {
                    Object value;
                    int calendarField = this.getCalendarField(spinner);
                    spinner.commitEdit();
                    if (calendarField != -1) {
                        ((SpinnerDateModel)spinner.getModel()).setCalendarField(calendarField);
                    }
                    Object object = value = this.isNext ? spinner.getNextValue() : spinner.getPreviousValue();
                    if (value != null) {
                        spinner.setValue(value);
                        this.select(spinner);
                    }
                }
                catch (IllegalArgumentException | ParseException ex) {
                    UIManager.getLookAndFeel().provideErrorFeedback(spinner);
                }
            }
        }

        private void select(JSpinner spinner) {
            JComponent editor = spinner.getEditor();
            if (editor instanceof JSpinner.DateEditor) {
                SpinnerDateModel model;
                DateFormat.Field field;
                Object value;
                JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)editor;
                JFormattedTextField ftf = dateEditor.getTextField();
                SimpleDateFormat format = dateEditor.getFormat();
                if (format != null && (value = spinner.getValue()) != null && (field = DateFormat.Field.ofCalendarField((model = dateEditor.getModel()).getCalendarField())) != null) {
                    try {
                        AttributedCharacterIterator iterator = ((Format)format).formatToCharacterIterator(value);
                        if (!this.select(ftf, iterator, field) && field == DateFormat.Field.HOUR0) {
                            this.select(ftf, iterator, DateFormat.Field.HOUR1);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }

        private boolean select(JFormattedTextField ftf, AttributedCharacterIterator iterator, DateFormat.Field field) {
            int max = ftf.getDocument().getLength();
            iterator.first();
            do {
                Map<AttributedCharacterIterator.Attribute, Object> attrs;
                if ((attrs = iterator.getAttributes()) == null || !attrs.containsKey(field)) continue;
                int start = iterator.getRunStart(field);
                int end = iterator.getRunLimit(field);
                if (start != -1 && end != -1 && start <= max && end <= max) {
                    ftf.select(start, end);
                }
                return true;
            } while (iterator.next() != '\uffff');
            return false;
        }

        private int getCalendarField(JSpinner spinner) {
            JComponent editor = spinner.getEditor();
            if (editor instanceof JSpinner.DateEditor) {
                JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)editor;
                JFormattedTextField ftf = dateEditor.getTextField();
                int start = ftf.getSelectionStart();
                JFormattedTextField.AbstractFormatter formatter = ftf.getFormatter();
                if (formatter instanceof InternationalFormatter) {
                    Format.Field[] fields = ((InternationalFormatter)formatter).getFields(start);
                    for (int counter = 0; counter < fields.length; ++counter) {
                        int calendarField;
                        if (!(fields[counter] instanceof DateFormat.Field) || (calendarField = fields[counter] == DateFormat.Field.HOUR1 ? 10 : ((DateFormat.Field)fields[counter]).getCalendarField()) == -1) continue;
                        return calendarField;
                    }
                }
            }
            return -1;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && e.getComponent().isEnabled()) {
                this.spinner = this.eventToSpinner(e);
                this.autoRepeatTimer.start();
                this.focusSpinnerIfNecessary();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.autoRepeatTimer.stop();
            this.arrowButton = null;
            this.spinner = null;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (this.spinner != null && !this.autoRepeatTimer.isRunning() && this.spinner == this.eventToSpinner(e)) {
                this.autoRepeatTimer.start();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this.autoRepeatTimer.isRunning()) {
                this.autoRepeatTimer.stop();
            }
        }

        private void focusSpinnerIfNecessary() {
            Component fo = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (this.spinner.isRequestFocusEnabled() && (fo == null || !SwingUtilities.isDescendingFrom(fo, this.spinner))) {
                FocusTraversalPolicy ftp;
                Component child;
                Container root = this.spinner;
                if (!root.isFocusCycleRoot()) {
                    root = root.getFocusCycleRootAncestor();
                }
                if (root != null && (child = (ftp = root.getFocusTraversalPolicy()).getComponentAfter(root, this.spinner)) != null && SwingUtilities.isDescendingFrom(child, this.spinner)) {
                    child.requestFocus(FocusEvent.Cause.MOUSE_EVENT);
                }
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (this.spinner == this.eventToSpinner(e)) {
                if (this.autoRepeatTimer.isRunning()) {
                    this.autoRepeatTimer.stop();
                }
                this.spinner = null;
                if (this.arrowButton != null) {
                    ButtonModel model = this.arrowButton.getModel();
                    model.setPressed(false);
                    model.setArmed(false);
                    this.arrowButton = null;
                }
            }
        }
    }

    private static class Handler
    implements LayoutManager,
    PropertyChangeListener,
    ChangeListener {
        private Component nextButton = null;
        private Component previousButton = null;
        private Component editor = null;

        private Handler() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
            if ("Next".equals(name)) {
                this.nextButton = c;
            } else if ("Previous".equals(name)) {
                this.previousButton = c;
            } else if ("Editor".equals(name)) {
                this.editor = c;
            }
        }

        @Override
        public void removeLayoutComponent(Component c) {
            if (c == this.nextButton) {
                this.nextButton = null;
            } else if (c == this.previousButton) {
                this.previousButton = null;
            } else if (c == this.editor) {
                this.editor = null;
            }
        }

        private Dimension preferredSize(Component c) {
            return c == null ? zeroSize : c.getPreferredSize();
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension nextD = this.preferredSize(this.nextButton);
            Dimension previousD = this.preferredSize(this.previousButton);
            Dimension editorD = this.preferredSize(this.editor);
            editorD.height = (editorD.height + 1) / 2 * 2;
            Dimension size = new Dimension(editorD.width, editorD.height);
            size.width += Math.max(nextD.width, previousD.width);
            Insets insets = parent.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
            return size;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        private void setBounds(Component c, int x, int y, int width, int height) {
            if (c != null) {
                c.setBounds(x, y, width, height);
            }
        }

        @Override
        public void layoutContainer(Container parent) {
            int buttonsX;
            int editorWidth;
            int editorX;
            int width = parent.getWidth();
            int height = parent.getHeight();
            Insets insets = parent.getInsets();
            if (this.nextButton == null && this.previousButton == null) {
                this.setBounds(this.editor, insets.left, insets.top, width - insets.left - insets.right, height - insets.top - insets.bottom);
                return;
            }
            Dimension nextD = this.preferredSize(this.nextButton);
            Dimension previousD = this.preferredSize(this.previousButton);
            int buttonsWidth = Math.max(nextD.width, previousD.width);
            int editorHeight = height - (insets.top + insets.bottom);
            Insets buttonInsets = UIManager.getInsets("Spinner.arrowButtonInsets");
            if (buttonInsets == null) {
                buttonInsets = insets;
            }
            if (parent.getComponentOrientation().isLeftToRight()) {
                editorX = insets.left;
                editorWidth = width - insets.left - buttonsWidth - buttonInsets.right;
                buttonsX = width - buttonsWidth - buttonInsets.right;
            } else {
                buttonsX = buttonInsets.left;
                editorX = buttonsX + buttonsWidth;
                editorWidth = width - buttonInsets.left - buttonsWidth - insets.right;
            }
            int nextY = buttonInsets.top;
            int nextHeight = height / 2 + height % 2 - nextY;
            int previousY = buttonInsets.top + nextHeight;
            int previousHeight = height - previousY - buttonInsets.bottom;
            this.setBounds(this.editor, editorX, insets.top, editorWidth, editorHeight);
            this.setBounds(this.nextButton, buttonsX, nextY, buttonsWidth, nextHeight);
            this.setBounds(this.previousButton, buttonsX, previousY, buttonsWidth, previousHeight);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            JSpinner spinner;
            SpinnerUI spinnerUI;
            JComponent c;
            String propertyName = e.getPropertyName();
            if (e.getSource() instanceof JSpinner) {
                JSpinner spinner2 = (JSpinner)e.getSource();
                SpinnerUI spinnerUI2 = spinner2.getUI();
                if (spinnerUI2 instanceof BasicSpinnerUI) {
                    ComponentOrientation o;
                    BasicSpinnerUI ui = (BasicSpinnerUI)spinnerUI2;
                    if ("editor".equals(propertyName)) {
                        JFormattedTextField tf;
                        JComponent oldEditor = (JComponent)e.getOldValue();
                        JComponent newEditor = (JComponent)e.getNewValue();
                        ui.replaceEditor(oldEditor, newEditor);
                        ui.updateEnabledState();
                        if (oldEditor instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)oldEditor).getTextField()) != null) {
                            tf.removeFocusListener(nextButtonHandler);
                            tf.removeFocusListener(previousButtonHandler);
                        }
                        if (newEditor instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)newEditor).getTextField()) != null) {
                            if (tf.getFont() instanceof UIResource) {
                                Font font = spinner2.getFont();
                                tf.setFont(font == null ? null : new FontUIResource(font));
                            }
                            tf.addFocusListener(nextButtonHandler);
                            tf.addFocusListener(previousButtonHandler);
                        }
                    } else if ("enabled".equals(propertyName) || "model".equals(propertyName)) {
                        ui.updateEnabledState();
                    } else if ("font".equals(propertyName)) {
                        JFormattedTextField tf;
                        JComponent editor = spinner2.getEditor();
                        if (editor instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)editor).getTextField()) != null && tf.getFont() instanceof UIResource) {
                            Font font = spinner2.getFont();
                            tf.setFont(font == null ? null : new FontUIResource(font));
                        }
                    } else if ("ToolTipText".equals(propertyName)) {
                        this.updateToolTipTextForChildren(spinner2);
                    } else if ("componentOrientation".equals(propertyName) && (o = (ComponentOrientation)e.getNewValue()) != (ComponentOrientation)e.getOldValue()) {
                        JComponent editor = spinner2.getEditor();
                        if (editor != null) {
                            editor.applyComponentOrientation(o);
                        }
                        spinner2.revalidate();
                        spinner2.repaint();
                    }
                }
            } else if (e.getSource() instanceof JComponent && (c = (JComponent)e.getSource()).getParent() instanceof JPanel && c.getParent().getParent() instanceof JSpinner && "border".equals(propertyName) && (spinnerUI = (spinner = (JSpinner)c.getParent().getParent()).getUI()) instanceof BasicSpinnerUI) {
                BasicSpinnerUI ui = (BasicSpinnerUI)spinnerUI;
                ui.maybeRemoveEditorBorder(c);
            }
        }

        private void updateToolTipTextForChildren(JComponent spinner) {
            String toolTipText = spinner.getToolTipText();
            Component[] children = spinner.getComponents();
            for (int i = 0; i < children.length; ++i) {
                if (children[i] instanceof JSpinner.DefaultEditor) {
                    JFormattedTextField tf = ((JSpinner.DefaultEditor)children[i]).getTextField();
                    if (tf == null) continue;
                    tf.setToolTipText(toolTipText);
                    continue;
                }
                if (!(children[i] instanceof JComponent)) continue;
                ((JComponent)children[i]).setToolTipText(spinner.getToolTipText());
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SpinnerUI spinnerUI;
            JSpinner spinner;
            if (e.getSource() instanceof JSpinner && DefaultLookup.getBoolean(spinner = (JSpinner)e.getSource(), spinnerUI = spinner.getUI(), "Spinner.disableOnBoundaryValues", false) && spinnerUI instanceof BasicSpinnerUI) {
                BasicSpinnerUI ui = (BasicSpinnerUI)spinnerUI;
                ui.updateEnabledState();
            }
        }
    }
}

