/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.BasicTransferable;
import javax.swing.plaf.basic.DragRecognitionSupport;
import javax.swing.text.Position;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public class BasicTreeUI
extends TreeUI {
    protected transient Icon collapsedIcon;
    protected transient Icon expandedIcon;
    protected int leftChildIndent;
    protected int rightChildIndent;
    protected int totalChildIndent;
    protected Dimension preferredMinSize;
    protected int lastSelectedRow;
    protected JTree tree;
    protected transient TreeCellRenderer currentCellRenderer;
    protected boolean createdRenderer;
    protected transient TreeCellEditor cellEditor;
    protected boolean createdCellEditor;
    protected boolean stopEditingInCompleteEditing;
    protected CellRendererPane rendererPane;
    protected Dimension preferredSize;
    protected boolean validCachedPreferredSize;
    protected AbstractLayoutCache treeState;
    protected Hashtable<TreePath, Boolean> drawingCache;
    protected boolean largeModel;
    protected AbstractLayoutCache.NodeDimensions nodeDimensions;
    protected TreeModel treeModel;
    protected TreeSelectionModel treeSelectionModel;
    protected int depthOffset;
    protected Component editingComponent;
    protected TreePath editingPath;
    protected int editingRow;
    protected boolean editorHasDifferentSize;

    public static ComponentUI createUI(JComponent jComponent) {
        return null;
    }

    protected Color getHashColor() {
        return null;
    }

    protected void setHashColor(Color color) {
    }

    public void setLeftChildIndent(int n) {
    }

    public int getLeftChildIndent() {
        return 0;
    }

    public void setRightChildIndent(int n) {
    }

    public int getRightChildIndent() {
        return 0;
    }

    public void setExpandedIcon(Icon icon) {
    }

    public Icon getExpandedIcon() {
        return null;
    }

    public void setCollapsedIcon(Icon icon) {
    }

    public Icon getCollapsedIcon() {
        return null;
    }

    protected void setLargeModel(boolean bl) {
    }

    protected boolean isLargeModel() {
        return false;
    }

    protected void setRowHeight(int n) {
    }

    protected int getRowHeight() {
        return 0;
    }

    protected void setCellRenderer(TreeCellRenderer treeCellRenderer) {
    }

    protected TreeCellRenderer getCellRenderer() {
        return null;
    }

    protected void setModel(TreeModel treeModel) {
    }

    protected TreeModel getModel() {
        return null;
    }

    protected void setRootVisible(boolean bl) {
    }

    protected boolean isRootVisible() {
        return false;
    }

    protected void setShowsRootHandles(boolean bl) {
    }

    protected boolean getShowsRootHandles() {
        return false;
    }

    protected void setCellEditor(TreeCellEditor treeCellEditor) {
    }

    protected TreeCellEditor getCellEditor() {
        return null;
    }

    protected void setEditable(boolean bl) {
    }

    protected boolean isEditable() {
        return false;
    }

    protected void setSelectionModel(TreeSelectionModel treeSelectionModel) {
    }

    protected TreeSelectionModel getSelectionModel() {
        return null;
    }

    public Rectangle getPathBounds(JTree jTree, TreePath treePath) {
        return null;
    }

    public TreePath getPathForRow(JTree jTree, int n) {
        return null;
    }

    public int getRowForPath(JTree jTree, TreePath treePath) {
        return 0;
    }

    public int getRowCount(JTree jTree) {
        return 0;
    }

    public TreePath getClosestPathForLocation(JTree jTree, int n, int n2) {
        return null;
    }

    public boolean isEditing(JTree jTree) {
        return false;
    }

    public boolean stopEditing(JTree jTree) {
        return false;
    }

    public void cancelEditing(JTree jTree) {
    }

    public void startEditingAtPath(JTree jTree, TreePath treePath) {
    }

    public TreePath getEditingPath(JTree jTree) {
        return null;
    }

    public void installUI(JComponent jComponent) {
    }

    protected void prepareForUIInstall() {
    }

    protected void completeUIInstall() {
    }

    protected void installDefaults() {
    }

    protected void installListeners() {
    }

    protected void installKeyboardActions() {
    }

    protected void installComponents() {
    }

    protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
        return null;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return null;
    }

    protected MouseListener createMouseListener() {
        return null;
    }

    protected FocusListener createFocusListener() {
        return null;
    }

    protected KeyListener createKeyListener() {
        return null;
    }

    protected PropertyChangeListener createSelectionModelPropertyChangeListener() {
        return null;
    }

    protected TreeSelectionListener createTreeSelectionListener() {
        return null;
    }

    protected CellEditorListener createCellEditorListener() {
        return null;
    }

    protected ComponentListener createComponentListener() {
        return null;
    }

    protected TreeExpansionListener createTreeExpansionListener() {
        return null;
    }

    protected AbstractLayoutCache createLayoutCache() {
        return null;
    }

    protected CellRendererPane createCellRendererPane() {
        return null;
    }

    protected TreeCellEditor createDefaultCellEditor() {
        return null;
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        return null;
    }

    protected TreeModelListener createTreeModelListener() {
        return null;
    }

    public void uninstallUI(JComponent jComponent) {
    }

    protected void prepareForUIUninstall() {
    }

    protected void completeUIUninstall() {
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallComponents() {
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    protected void paintHorizontalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
    }

    protected void paintVerticalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, TreePath treePath) {
    }

    protected void paintExpandControl(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
    }

    protected void paintRow(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
    }

    protected boolean shouldPaintExpandControl(TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        return false;
    }

    protected void paintVerticalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
    }

    protected void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
    }

    protected int getVerticalLegBuffer() {
        return 0;
    }

    protected int getHorizontalLegBuffer() {
        return 0;
    }

    protected void drawCentered(Component component, Graphics graphics, Icon icon, int n, int n2) {
    }

    protected void drawDashedHorizontalLine(Graphics graphics, int n, int n2, int n3) {
    }

    protected void drawDashedVerticalLine(Graphics graphics, int n, int n2, int n3) {
    }

    protected int getRowX(int n, int n2) {
        return 0;
    }

    protected void updateLayoutCacheExpandedNodes() {
    }

    protected void updateExpandedDescendants(TreePath treePath) {
    }

    protected TreePath getLastChildPath(TreePath treePath) {
        return null;
    }

    protected void updateDepthOffset() {
    }

    protected void updateCellEditor() {
    }

    protected void updateRenderer() {
    }

    protected void configureLayoutCache() {
    }

    protected void updateSize() {
    }

    protected void updateCachedPreferredSize() {
    }

    protected void pathWasExpanded(TreePath treePath) {
    }

    protected void pathWasCollapsed(TreePath treePath) {
    }

    protected void ensureRowsAreVisible(int n, int n2) {
    }

    public void setPreferredMinSize(Dimension dimension) {
    }

    public Dimension getPreferredMinSize() {
        return null;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getPreferredSize(JComponent jComponent, boolean bl) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    protected void completeEditing() {
    }

    protected void completeEditing(boolean bl, boolean bl2, boolean bl3) {
    }

    protected boolean startEditing(TreePath treePath, MouseEvent mouseEvent) {
        return false;
    }

    protected void checkForClickInExpandControl(TreePath treePath, int n, int n2) {
    }

    protected boolean isLocationInExpandControl(TreePath treePath, int n, int n2) {
        return false;
    }

    protected void handleExpandControlClick(TreePath treePath, int n, int n2) {
    }

    protected void toggleExpandState(TreePath treePath) {
    }

    protected boolean isToggleSelectionEvent(MouseEvent mouseEvent) {
        return false;
    }

    protected boolean isMultiSelectEvent(MouseEvent mouseEvent) {
        return false;
    }

    protected boolean isToggleEvent(MouseEvent mouseEvent) {
        return false;
    }

    protected void selectPathForEvent(TreePath treePath, MouseEvent mouseEvent) {
    }

    protected boolean isLeaf(int n) {
        return false;
    }

    private static class Actions
    extends UIAction {
        private static final String SELECT_PREVIOUS = "selectPrevious";
        private static final String SELECT_PREVIOUS_CHANGE_LEAD = "selectPreviousChangeLead";
        private static final String SELECT_PREVIOUS_EXTEND_SELECTION = "selectPreviousExtendSelection";
        private static final String SELECT_NEXT = "selectNext";
        private static final String SELECT_NEXT_CHANGE_LEAD = "selectNextChangeLead";
        private static final String SELECT_NEXT_EXTEND_SELECTION = "selectNextExtendSelection";
        private static final String SELECT_CHILD = "selectChild";
        private static final String SELECT_CHILD_CHANGE_LEAD = "selectChildChangeLead";
        private static final String SELECT_PARENT = "selectParent";
        private static final String SELECT_PARENT_CHANGE_LEAD = "selectParentChangeLead";
        private static final String SCROLL_UP_CHANGE_SELECTION = "scrollUpChangeSelection";
        private static final String SCROLL_UP_CHANGE_LEAD = "scrollUpChangeLead";
        private static final String SCROLL_UP_EXTEND_SELECTION = "scrollUpExtendSelection";
        private static final String SCROLL_DOWN_CHANGE_SELECTION = "scrollDownChangeSelection";
        private static final String SCROLL_DOWN_EXTEND_SELECTION = "scrollDownExtendSelection";
        private static final String SCROLL_DOWN_CHANGE_LEAD = "scrollDownChangeLead";
        private static final String SELECT_FIRST = "selectFirst";
        private static final String SELECT_FIRST_CHANGE_LEAD = "selectFirstChangeLead";
        private static final String SELECT_FIRST_EXTEND_SELECTION = "selectFirstExtendSelection";
        private static final String SELECT_LAST = "selectLast";
        private static final String SELECT_LAST_CHANGE_LEAD = "selectLastChangeLead";
        private static final String SELECT_LAST_EXTEND_SELECTION = "selectLastExtendSelection";
        private static final String TOGGLE = "toggle";
        private static final String CANCEL_EDITING = "cancel";
        private static final String START_EDITING = "startEditing";
        private static final String SELECT_ALL = "selectAll";
        private static final String CLEAR_SELECTION = "clearSelection";
        private static final String SCROLL_LEFT = "scrollLeft";
        private static final String SCROLL_RIGHT = "scrollRight";
        private static final String SCROLL_LEFT_EXTEND_SELECTION = "scrollLeftExtendSelection";
        private static final String SCROLL_RIGHT_EXTEND_SELECTION = "scrollRightExtendSelection";
        private static final String SCROLL_RIGHT_CHANGE_LEAD = "scrollRightChangeLead";
        private static final String SCROLL_LEFT_CHANGE_LEAD = "scrollLeftChangeLead";
        private static final String EXPAND = "expand";
        private static final String COLLAPSE = "collapse";
        private static final String MOVE_SELECTION_TO_PARENT = "moveSelectionToParent";
        private static final String ADD_TO_SELECTION = "addToSelection";
        private static final String TOGGLE_AND_ANCHOR = "toggleAndAnchor";
        private static final String EXTEND_TO = "extendTo";
        private static final String MOVE_SELECTION_TO = "moveSelectionTo";

        Actions() {
            super(null);
        }

        Actions(String key) {
            super(key);
        }

        @Override
        public boolean accept(Object o) {
            if (o instanceof JTree && this.getName() == CANCEL_EDITING) {
                return ((JTree)o).isEditing();
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTree tree = (JTree)e.getSource();
            BasicTreeUI ui = (BasicTreeUI)BasicLookAndFeel.getUIOfType((ComponentUI)tree.getUI(), BasicTreeUI.class);
            if (ui == null) {
                return;
            }
            String key = this.getName();
            if (key == SELECT_PREVIOUS) {
                this.increment(tree, ui, -1, false, true);
            } else if (key == SELECT_PREVIOUS_CHANGE_LEAD) {
                this.increment(tree, ui, -1, false, false);
            } else if (key == SELECT_PREVIOUS_EXTEND_SELECTION) {
                this.increment(tree, ui, -1, true, true);
            } else if (key == SELECT_NEXT) {
                this.increment(tree, ui, 1, false, true);
            } else if (key == SELECT_NEXT_CHANGE_LEAD) {
                this.increment(tree, ui, 1, false, false);
            } else if (key == SELECT_NEXT_EXTEND_SELECTION) {
                this.increment(tree, ui, 1, true, true);
            } else if (key == SELECT_CHILD) {
                this.traverse(tree, ui, 1, true);
            } else if (key == SELECT_CHILD_CHANGE_LEAD) {
                this.traverse(tree, ui, 1, false);
            } else if (key == SELECT_PARENT) {
                this.traverse(tree, ui, -1, true);
            } else if (key == SELECT_PARENT_CHANGE_LEAD) {
                this.traverse(tree, ui, -1, false);
            } else if (key == SCROLL_UP_CHANGE_SELECTION) {
                this.page(tree, ui, -1, false, true);
            } else if (key == SCROLL_UP_CHANGE_LEAD) {
                this.page(tree, ui, -1, false, false);
            } else if (key == SCROLL_UP_EXTEND_SELECTION) {
                this.page(tree, ui, -1, true, true);
            } else if (key == SCROLL_DOWN_CHANGE_SELECTION) {
                this.page(tree, ui, 1, false, true);
            } else if (key == SCROLL_DOWN_EXTEND_SELECTION) {
                this.page(tree, ui, 1, true, true);
            } else if (key == SCROLL_DOWN_CHANGE_LEAD) {
                this.page(tree, ui, 1, false, false);
            } else if (key == SELECT_FIRST) {
                this.home(tree, ui, -1, false, true);
            } else if (key == SELECT_FIRST_CHANGE_LEAD) {
                this.home(tree, ui, -1, false, false);
            } else if (key == SELECT_FIRST_EXTEND_SELECTION) {
                this.home(tree, ui, -1, true, true);
            } else if (key == SELECT_LAST) {
                this.home(tree, ui, 1, false, true);
            } else if (key == SELECT_LAST_CHANGE_LEAD) {
                this.home(tree, ui, 1, false, false);
            } else if (key == SELECT_LAST_EXTEND_SELECTION) {
                this.home(tree, ui, 1, true, true);
            } else if (key == TOGGLE) {
                this.toggle(tree, ui);
            } else if (key == CANCEL_EDITING) {
                this.cancelEditing(tree, ui);
            } else if (key == START_EDITING) {
                this.startEditing(tree, ui);
            } else if (key == SELECT_ALL) {
                this.selectAll(tree, ui, true);
            } else if (key == CLEAR_SELECTION) {
                this.selectAll(tree, ui, false);
            } else if (key == ADD_TO_SELECTION) {
                int lead;
                if (ui.getRowCount(tree) > 0 && !tree.isRowSelected(lead = ui.getLeadSelectionRow())) {
                    TreePath aPath = ui.getAnchorSelectionPath();
                    tree.addSelectionRow(lead);
                    ui.setAnchorSelectionPath(aPath);
                }
            } else if (key == TOGGLE_AND_ANCHOR) {
                if (ui.getRowCount(tree) > 0) {
                    int lead = ui.getLeadSelectionRow();
                    TreePath lPath = ui.getLeadSelectionPath();
                    if (!tree.isRowSelected(lead)) {
                        tree.addSelectionRow(lead);
                    } else {
                        tree.removeSelectionRow(lead);
                        ui.setLeadSelectionPath(lPath);
                    }
                    ui.setAnchorSelectionPath(lPath);
                }
            } else if (key == EXTEND_TO) {
                this.extendSelection(tree, ui);
            } else if (key == MOVE_SELECTION_TO) {
                if (ui.getRowCount(tree) > 0) {
                    int lead = ui.getLeadSelectionRow();
                    tree.setSelectionInterval(lead, lead);
                }
            } else if (key == SCROLL_LEFT) {
                this.scroll(tree, ui, 0, -10);
            } else if (key == SCROLL_RIGHT) {
                this.scroll(tree, ui, 0, 10);
            } else if (key == SCROLL_LEFT_EXTEND_SELECTION) {
                this.scrollChangeSelection(tree, ui, -1, true, true);
            } else if (key == SCROLL_RIGHT_EXTEND_SELECTION) {
                this.scrollChangeSelection(tree, ui, 1, true, true);
            } else if (key == SCROLL_RIGHT_CHANGE_LEAD) {
                this.scrollChangeSelection(tree, ui, 1, false, false);
            } else if (key == SCROLL_LEFT_CHANGE_LEAD) {
                this.scrollChangeSelection(tree, ui, -1, false, false);
            } else if (key == EXPAND) {
                this.expand(tree, ui);
            } else if (key == COLLAPSE) {
                this.collapse(tree, ui);
            } else if (key == MOVE_SELECTION_TO_PARENT) {
                this.moveSelectionToParent(tree, ui);
            }
        }

        private void scrollChangeSelection(JTree tree, BasicTreeUI ui, int direction, boolean addToSelection, boolean changeSelection) {
            int rowCount = ui.getRowCount(tree);
            if (rowCount > 0 && ui.treeSelectionModel != null) {
                TreePath newPath;
                Rectangle visRect = tree.getVisibleRect();
                if (direction == -1) {
                    newPath = ui.getClosestPathForLocation(tree, visRect.x, visRect.y);
                    visRect.x = Math.max(0, visRect.x - visRect.width);
                } else {
                    visRect.x = Math.min(Math.max(0, tree.getWidth() - visRect.width), visRect.x + visRect.width);
                    newPath = ui.getClosestPathForLocation(tree, visRect.x, visRect.y + visRect.height);
                }
                tree.scrollRectToVisible(visRect);
                if (addToSelection) {
                    ui.extendSelection(newPath);
                } else if (changeSelection) {
                    tree.setSelectionPath(newPath);
                } else {
                    ui.setLeadSelectionPath(newPath, true);
                }
            }
        }

        private void scroll(JTree component, BasicTreeUI ui, int direction, int amount) {
            Rectangle visRect = component.getVisibleRect();
            Dimension size = component.getSize();
            if (direction == 0) {
                visRect.x += amount;
                visRect.x = Math.max(0, visRect.x);
                visRect.x = Math.min(Math.max(0, size.width - visRect.width), visRect.x);
            } else {
                visRect.y += amount;
                visRect.y = Math.max(0, visRect.y);
                visRect.y = Math.min(Math.max(0, size.width - visRect.height), visRect.y);
            }
            component.scrollRectToVisible(visRect);
        }

        private void extendSelection(JTree tree, BasicTreeUI ui) {
            int lead;
            if (ui.getRowCount(tree) > 0 && (lead = ui.getLeadSelectionRow()) != -1) {
                TreePath leadP = ui.getLeadSelectionPath();
                TreePath aPath = ui.getAnchorSelectionPath();
                int aRow = ui.getRowForPath(tree, aPath);
                if (aRow == -1) {
                    aRow = 0;
                }
                tree.setSelectionInterval(aRow, lead);
                ui.setLeadSelectionPath(leadP);
                ui.setAnchorSelectionPath(aPath);
            }
        }

        private void selectAll(JTree tree, BasicTreeUI ui, boolean selectAll) {
            int rowCount = ui.getRowCount(tree);
            if (rowCount > 0) {
                if (selectAll) {
                    if (tree.getSelectionModel().getSelectionMode() == 1) {
                        int lead = ui.getLeadSelectionRow();
                        if (lead != -1) {
                            tree.setSelectionRow(lead);
                        } else if (tree.getMinSelectionRow() == -1) {
                            tree.setSelectionRow(0);
                            ui.ensureRowsAreVisible(0, 0);
                        }
                        return;
                    }
                    TreePath lastPath = ui.getLeadSelectionPath();
                    TreePath aPath = ui.getAnchorSelectionPath();
                    if (lastPath != null && !tree.isVisible(lastPath)) {
                        lastPath = null;
                    }
                    tree.setSelectionInterval(0, rowCount - 1);
                    if (lastPath != null) {
                        ui.setLeadSelectionPath(lastPath);
                    }
                    if (aPath != null && tree.isVisible(aPath)) {
                        ui.setAnchorSelectionPath(aPath);
                    }
                } else {
                    TreePath lastPath = ui.getLeadSelectionPath();
                    TreePath aPath = ui.getAnchorSelectionPath();
                    tree.clearSelection();
                    ui.setAnchorSelectionPath(aPath);
                    ui.setLeadSelectionPath(lastPath);
                }
            }
        }

        private void startEditing(JTree tree, BasicTreeUI ui) {
            int editRow;
            TreePath lead = ui.getLeadSelectionPath();
            int n = editRow = lead != null ? ui.getRowForPath(tree, lead) : -1;
            if (editRow != -1) {
                tree.startEditingAtPath(lead);
            }
        }

        private void cancelEditing(JTree tree, BasicTreeUI ui) {
            tree.cancelEditing();
        }

        private void toggle(JTree tree, BasicTreeUI ui) {
            int selRow = ui.getLeadSelectionRow();
            if (selRow != -1 && !ui.isLeaf(selRow)) {
                TreePath aPath = ui.getAnchorSelectionPath();
                TreePath lPath = ui.getLeadSelectionPath();
                ui.toggleExpandState(ui.getPathForRow(tree, selRow));
                ui.setAnchorSelectionPath(aPath);
                ui.setLeadSelectionPath(lPath);
            }
        }

        private void expand(JTree tree, BasicTreeUI ui) {
            int selRow = ui.getLeadSelectionRow();
            tree.expandRow(selRow);
        }

        private void collapse(JTree tree, BasicTreeUI ui) {
            int selRow = ui.getLeadSelectionRow();
            tree.collapseRow(selRow);
        }

        private void increment(JTree tree, BasicTreeUI ui, int direction, boolean addToSelection, boolean changeSelection) {
            int rowCount;
            if (!addToSelection && !changeSelection && tree.getSelectionModel().getSelectionMode() != 4) {
                changeSelection = true;
            }
            if (ui.treeSelectionModel != null && (rowCount = tree.getRowCount()) > 0) {
                int selIndex = ui.getLeadSelectionRow();
                int newIndex = selIndex == -1 ? (direction == 1 ? 0 : rowCount - 1) : Math.min(rowCount - 1, Math.max(0, selIndex + direction));
                if (addToSelection && ui.treeSelectionModel.getSelectionMode() != 1) {
                    ui.extendSelection(tree.getPathForRow(newIndex));
                } else if (changeSelection) {
                    tree.setSelectionInterval(newIndex, newIndex);
                } else {
                    ui.setLeadSelectionPath(tree.getPathForRow(newIndex), true);
                }
                ui.ensureRowsAreVisible(newIndex, newIndex);
                ui.lastSelectedRow = newIndex;
            }
        }

        private void traverse(JTree tree, BasicTreeUI ui, int direction, boolean changeSelection) {
            int rowCount;
            if (!changeSelection && tree.getSelectionModel().getSelectionMode() != 4) {
                changeSelection = true;
            }
            if ((rowCount = tree.getRowCount()) > 0) {
                int newIndex;
                int minSelIndex = ui.getLeadSelectionRow();
                if (minSelIndex == -1) {
                    newIndex = 0;
                } else if (direction == 1) {
                    TreePath minSelPath = ui.getPathForRow(tree, minSelIndex);
                    int childCount = tree.getModel().getChildCount(minSelPath.getLastPathComponent());
                    newIndex = -1;
                    if (!ui.isLeaf(minSelIndex)) {
                        if (!tree.isExpanded(minSelIndex)) {
                            ui.toggleExpandState(minSelPath);
                        } else if (childCount > 0) {
                            newIndex = Math.min(minSelIndex + 1, rowCount - 1);
                        }
                    }
                } else if (!ui.isLeaf(minSelIndex) && tree.isExpanded(minSelIndex)) {
                    ui.toggleExpandState(ui.getPathForRow(tree, minSelIndex));
                    newIndex = -1;
                } else {
                    TreePath path = ui.getPathForRow(tree, minSelIndex);
                    newIndex = path != null && path.getPathCount() > 1 ? ui.getRowForPath(tree, path.getParentPath()) : -1;
                }
                if (newIndex != -1) {
                    if (changeSelection) {
                        tree.setSelectionInterval(newIndex, newIndex);
                    } else {
                        ui.setLeadSelectionPath(ui.getPathForRow(tree, newIndex), true);
                    }
                    ui.ensureRowsAreVisible(newIndex, newIndex);
                }
            }
        }

        private void moveSelectionToParent(JTree tree, BasicTreeUI ui) {
            int newIndex;
            int selRow = ui.getLeadSelectionRow();
            TreePath path = ui.getPathForRow(tree, selRow);
            if (path != null && path.getPathCount() > 1 && (newIndex = ui.getRowForPath(tree, path.getParentPath())) != -1) {
                tree.setSelectionInterval(newIndex, newIndex);
                ui.ensureRowsAreVisible(newIndex, newIndex);
            }
        }

        private void page(JTree tree, BasicTreeUI ui, int direction, boolean addToSelection, boolean changeSelection) {
            int rowCount;
            if (!addToSelection && !changeSelection && tree.getSelectionModel().getSelectionMode() != 4) {
                changeSelection = true;
            }
            if ((rowCount = ui.getRowCount(tree)) > 0 && ui.treeSelectionModel != null) {
                Rectangle newRect;
                TreePath newPath;
                Dimension maxSize = tree.getSize();
                TreePath lead = ui.getLeadSelectionPath();
                Rectangle visRect = tree.getVisibleRect();
                if (direction == -1) {
                    newPath = ui.getClosestPathForLocation(tree, visRect.x, visRect.y);
                    if (newPath.equals(lead)) {
                        visRect.y = Math.max(0, visRect.y - visRect.height);
                        newPath = tree.getClosestPathForLocation(visRect.x, visRect.y);
                    }
                } else {
                    visRect.y = Math.min(maxSize.height, visRect.y + visRect.height - 1);
                    newPath = tree.getClosestPathForLocation(visRect.x, visRect.y);
                    if (newPath.equals(lead)) {
                        visRect.y = Math.min(maxSize.height, visRect.y + visRect.height - 1);
                        newPath = tree.getClosestPathForLocation(visRect.x, visRect.y);
                    }
                }
                if ((newRect = ui.getPathBounds(tree, newPath)) != null) {
                    newRect.x = visRect.x;
                    newRect.width = visRect.width;
                    if (direction == -1) {
                        newRect.height = visRect.height;
                    } else {
                        newRect.y -= visRect.height - newRect.height;
                        newRect.height = visRect.height;
                    }
                    if (addToSelection) {
                        ui.extendSelection(newPath);
                    } else if (changeSelection) {
                        tree.setSelectionPath(newPath);
                    } else {
                        ui.setLeadSelectionPath(newPath, true);
                    }
                    tree.scrollRectToVisible(newRect);
                }
            }
        }

        private void home(JTree tree, final BasicTreeUI ui, int direction, boolean addToSelection, boolean changeSelection) {
            int rowCount;
            if (!addToSelection && !changeSelection && tree.getSelectionModel().getSelectionMode() != 4) {
                changeSelection = true;
            }
            if ((rowCount = ui.getRowCount(tree)) > 0) {
                if (direction == -1) {
                    ui.ensureRowsAreVisible(0, 0);
                    if (addToSelection) {
                        int aRow;
                        TreePath aPath = ui.getAnchorSelectionPath();
                        int n = aRow = aPath == null ? -1 : ui.getRowForPath(tree, aPath);
                        if (aRow == -1) {
                            tree.setSelectionInterval(0, 0);
                        } else {
                            tree.setSelectionInterval(0, aRow);
                            ui.setAnchorSelectionPath(aPath);
                            ui.setLeadSelectionPath(ui.getPathForRow(tree, 0));
                        }
                    } else if (changeSelection) {
                        tree.setSelectionInterval(0, 0);
                    } else {
                        ui.setLeadSelectionPath(ui.getPathForRow(tree, 0), true);
                    }
                } else {
                    ui.ensureRowsAreVisible(rowCount - 1, rowCount - 1);
                    if (addToSelection) {
                        int aRow;
                        TreePath aPath = ui.getAnchorSelectionPath();
                        int n = aRow = aPath == null ? -1 : ui.getRowForPath(tree, aPath);
                        if (aRow == -1) {
                            tree.setSelectionInterval(rowCount - 1, rowCount - 1);
                        } else {
                            tree.setSelectionInterval(aRow, rowCount - 1);
                            ui.setAnchorSelectionPath(aPath);
                            ui.setLeadSelectionPath(ui.getPathForRow(tree, rowCount - 1));
                        }
                    } else if (changeSelection) {
                        tree.setSelectionInterval(rowCount - 1, rowCount - 1);
                    } else {
                        ui.setLeadSelectionPath(ui.getPathForRow(tree, rowCount - 1), true);
                    }
                    if (ui.isLargeModel()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ui.ensureRowsAreVisible(rowCount - 1, rowCount - 1);
                            }
                        });
                    }
                }
            }
        }
    }

    public class CellEditorHandler
    implements CellEditorListener {
        public CellEditorHandler(BasicTreeUI basicTreeUI) {
        }

        public void editingStopped(ChangeEvent changeEvent) {
        }

        public void editingCanceled(ChangeEvent changeEvent) {
        }
    }

    public class ComponentHandler
    extends ComponentAdapter
    implements ActionListener {
        protected Timer timer;
        protected JScrollBar scrollBar;

        public ComponentHandler(BasicTreeUI basicTreeUI) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        protected void startTimer() {
        }

        protected JScrollPane getScrollPane() {
            return null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public class FocusHandler
    implements FocusListener {
        public FocusHandler(BasicTreeUI basicTreeUI) {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    private class Handler
    implements CellEditorListener,
    FocusListener,
    KeyListener,
    MouseListener,
    MouseMotionListener,
    PropertyChangeListener,
    TreeExpansionListener,
    TreeModelListener,
    TreeSelectionListener,
    DragRecognitionSupport.BeforeDrag {
        private String prefix = "";
        private String typedString = "";
        private long lastTime = 0L;
        private boolean dragPressDidSelection;
        private boolean dragStarted;
        private TreePath pressedPath;
        private MouseEvent pressedEvent;
        private boolean valueChangedOnPress;

        private Handler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.getRowCount() > 0 && BasicTreeUI.this.tree.hasFocus() && BasicTreeUI.this.tree.isEnabled()) {
                TreePath path;
                if (e.isAltDown() || BasicGraphicsUtils.isMenuShortcutKeyDown((InputEvent)e) || this.isNavigationKey(e)) {
                    return;
                }
                boolean startingFromSelection = true;
                char c = e.getKeyChar();
                long time = e.getWhen();
                int startingRow = BasicTreeUI.this.tree.getLeadSelectionRow();
                if (time - this.lastTime < BasicTreeUI.this.timeFactor) {
                    this.typedString = this.typedString + c;
                    if (this.prefix.length() == 1 && c == this.prefix.charAt(0)) {
                        ++startingRow;
                    } else {
                        this.prefix = this.typedString;
                    }
                } else {
                    ++startingRow;
                    this.typedString = "" + c;
                    this.prefix = this.typedString;
                }
                this.lastTime = time;
                if (startingRow < 0 || startingRow >= BasicTreeUI.this.tree.getRowCount()) {
                    startingFromSelection = false;
                    startingRow = 0;
                }
                if ((path = BasicTreeUI.this.tree.getNextMatch(this.prefix, startingRow, Position.Bias.Forward)) != null) {
                    BasicTreeUI.this.tree.setSelectionPath(path);
                    int row = BasicTreeUI.this.getRowForPath(BasicTreeUI.this.tree, path);
                    BasicTreeUI.this.ensureRowsAreVisible(row, row);
                } else if (startingFromSelection && (path = BasicTreeUI.this.tree.getNextMatch(this.prefix, 0, Position.Bias.Forward)) != null) {
                    BasicTreeUI.this.tree.setSelectionPath(path);
                    int row = BasicTreeUI.this.getRowForPath(BasicTreeUI.this.tree, path);
                    BasicTreeUI.this.ensureRowsAreVisible(row, row);
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (BasicTreeUI.this.tree != null && this.isNavigationKey(e)) {
                this.prefix = "";
                this.typedString = "";
                this.lastTime = 0L;
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        private boolean isNavigationKey(KeyEvent event) {
            InputMap inputMap = BasicTreeUI.this.tree.getInputMap(1);
            KeyStroke key = KeyStroke.getKeyStrokeForEvent(event);
            return inputMap != null && inputMap.get(key) != null;
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getSource() == BasicTreeUI.this.treeSelectionModel) {
                BasicTreeUI.this.treeSelectionModel.resetRowSelection();
            } else if (event.getSource() == BasicTreeUI.this.tree) {
                String changeName = event.getPropertyName();
                if (changeName == "leadSelectionPath") {
                    if (!BasicTreeUI.this.ignoreLAChange) {
                        BasicTreeUI.this.updateLeadSelectionRow();
                        BasicTreeUI.this.repaintPath((TreePath)event.getOldValue());
                        BasicTreeUI.this.repaintPath((TreePath)event.getNewValue());
                    }
                } else if (changeName == "anchorSelectionPath" && !BasicTreeUI.this.ignoreLAChange) {
                    BasicTreeUI.this.repaintPath((TreePath)event.getOldValue());
                    BasicTreeUI.this.repaintPath((TreePath)event.getNewValue());
                }
                if (changeName == "cellRenderer") {
                    BasicTreeUI.this.setCellRenderer((TreeCellRenderer)event.getNewValue());
                    BasicTreeUI.this.redoTheLayout();
                } else if (changeName == "model") {
                    BasicTreeUI.this.setModel((TreeModel)event.getNewValue());
                } else if (changeName == "rootVisible") {
                    BasicTreeUI.this.setRootVisible((Boolean)event.getNewValue());
                } else if (changeName == "showsRootHandles") {
                    BasicTreeUI.this.setShowsRootHandles((Boolean)event.getNewValue());
                } else if (changeName == "rowHeight") {
                    BasicTreeUI.this.setRowHeight((Integer)event.getNewValue());
                } else if (changeName == "cellEditor") {
                    BasicTreeUI.this.setCellEditor((TreeCellEditor)event.getNewValue());
                } else if (changeName == "editable") {
                    BasicTreeUI.this.setEditable((Boolean)event.getNewValue());
                } else if (changeName == "largeModel") {
                    BasicTreeUI.this.setLargeModel(BasicTreeUI.this.tree.isLargeModel());
                } else if (changeName == "selectionModel") {
                    BasicTreeUI.this.setSelectionModel(BasicTreeUI.this.tree.getSelectionModel());
                } else if (changeName == "font" || SwingUtilities2.isScaleChanged(event)) {
                    BasicTreeUI.this.completeEditing();
                    if (BasicTreeUI.this.treeState != null) {
                        BasicTreeUI.this.treeState.invalidateSizes();
                    }
                    BasicTreeUI.this.updateSize();
                } else if (changeName == "componentOrientation") {
                    if (BasicTreeUI.this.tree != null) {
                        BasicTreeUI.this.leftToRight = BasicGraphicsUtils.isLeftToRight((Component)BasicTreeUI.this.tree);
                        BasicTreeUI.this.redoTheLayout();
                        BasicTreeUI.this.tree.treeDidChange();
                        InputMap km = BasicTreeUI.this.getInputMap(0);
                        SwingUtilities.replaceUIInputMap(BasicTreeUI.this.tree, 0, km);
                    }
                } else if ("dropLocation" == changeName) {
                    JTree.DropLocation oldValue = (JTree.DropLocation)event.getOldValue();
                    this.repaintDropLocation(oldValue);
                    this.repaintDropLocation(BasicTreeUI.this.tree.getDropLocation());
                }
            }
        }

        private void repaintDropLocation(JTree.DropLocation loc) {
            if (loc == null) {
                return;
            }
            Rectangle r = BasicTreeUI.this.isDropLine(loc) ? BasicTreeUI.this.getDropLineRect(loc) : BasicTreeUI.this.tree.getPathBounds(loc.getPath());
            if (r != null) {
                BasicTreeUI.this.tree.repaint(r);
            }
        }

        private boolean isActualPath(TreePath path, int x, int y) {
            if (path == null) {
                return false;
            }
            Rectangle bounds = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, path);
            if (bounds == null || y > bounds.y + bounds.height) {
                return false;
            }
            return x >= bounds.x && x <= bounds.x + bounds.width;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities2.shouldIgnore(e, BasicTreeUI.this.tree)) {
                return;
            }
            if (BasicTreeUI.this.isEditing(BasicTreeUI.this.tree) && BasicTreeUI.this.tree.getInvokesStopCellEditing() && !BasicTreeUI.this.stopEditing(BasicTreeUI.this.tree)) {
                return;
            }
            BasicTreeUI.this.completeEditing();
            this.pressedPath = BasicTreeUI.this.getClosestPathForLocation(BasicTreeUI.this.tree, e.getX(), e.getY());
            if (BasicTreeUI.this.tree.getDragEnabled()) {
                this.mousePressedDND(e);
            } else {
                SwingUtilities2.adjustFocus(BasicTreeUI.this.tree);
                this.handleSelection(e);
            }
        }

        private void mousePressedDND(MouseEvent e) {
            this.pressedEvent = e;
            boolean grabFocus = true;
            this.dragStarted = false;
            this.valueChangedOnPress = false;
            if (this.isActualPath(this.pressedPath, e.getX(), e.getY()) && DragRecognitionSupport.mousePressed(e)) {
                this.dragPressDidSelection = false;
                if (BasicGraphicsUtils.isMenuShortcutKeyDown((InputEvent)e)) {
                    return;
                }
                if (!e.isShiftDown() && BasicTreeUI.this.tree.isPathSelected(this.pressedPath)) {
                    BasicTreeUI.this.setAnchorSelectionPath(this.pressedPath);
                    BasicTreeUI.this.setLeadSelectionPath(this.pressedPath, true);
                    return;
                }
                this.dragPressDidSelection = true;
                grabFocus = false;
            }
            if (grabFocus) {
                SwingUtilities2.adjustFocus(BasicTreeUI.this.tree);
            }
            this.handleSelection(e);
        }

        void handleSelection(MouseEvent e) {
            if (this.pressedPath != null) {
                int x;
                Rectangle bounds = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, this.pressedPath);
                if (bounds == null || e.getY() >= bounds.y + bounds.height) {
                    return;
                }
                if (SwingUtilities.isLeftMouseButton(e)) {
                    BasicTreeUI.this.checkForClickInExpandControl(this.pressedPath, e.getX(), e.getY());
                }
                if ((x = e.getX()) >= bounds.x && x < bounds.x + bounds.width && (BasicTreeUI.this.tree.getDragEnabled() || !BasicTreeUI.this.startEditing(this.pressedPath, e))) {
                    BasicTreeUI.this.selectPathForEvent(this.pressedPath, e);
                }
            }
        }

        @Override
        public void dragStarting(MouseEvent me) {
            this.dragStarted = true;
            if (BasicGraphicsUtils.isMenuShortcutKeyDown((InputEvent)me)) {
                BasicTreeUI.this.tree.addSelectionPath(this.pressedPath);
                BasicTreeUI.this.setAnchorSelectionPath(this.pressedPath);
                BasicTreeUI.this.setLeadSelectionPath(this.pressedPath, true);
            }
            this.pressedEvent = null;
            this.pressedPath = null;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (SwingUtilities2.shouldIgnore(e, BasicTreeUI.this.tree)) {
                return;
            }
            if (BasicTreeUI.this.tree.getDragEnabled()) {
                DragRecognitionSupport.mouseDragged(e, this);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities2.shouldIgnore(e, BasicTreeUI.this.tree)) {
                return;
            }
            if (BasicTreeUI.this.tree.getDragEnabled()) {
                this.mouseReleasedDND(e);
            }
            this.pressedEvent = null;
            this.pressedPath = null;
        }

        private void mouseReleasedDND(MouseEvent e) {
            MouseEvent me = DragRecognitionSupport.mouseReleased(e);
            if (me != null) {
                SwingUtilities2.adjustFocus(BasicTreeUI.this.tree);
                if (!this.dragPressDidSelection) {
                    this.handleSelection(me);
                }
            }
            if (!this.dragStarted && this.pressedPath != null && !this.valueChangedOnPress && this.isActualPath(this.pressedPath, this.pressedEvent.getX(), this.pressedEvent.getY())) {
                BasicTreeUI.this.startEditingOnRelease(this.pressedPath, this.pressedEvent, e);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (BasicTreeUI.this.tree != null) {
                Rectangle pBounds = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, BasicTreeUI.this.tree.getLeadSelectionPath());
                if (pBounds != null) {
                    BasicTreeUI.this.tree.repaint(BasicTreeUI.this.getRepaintPathBounds(pBounds));
                }
                if ((pBounds = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, BasicTreeUI.this.getLeadSelectionPath())) != null) {
                    BasicTreeUI.this.tree.repaint(BasicTreeUI.this.getRepaintPathBounds(pBounds));
                }
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.focusGained(e);
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            BasicTreeUI.this.completeEditing(false, false, true);
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
            BasicTreeUI.this.completeEditing(false, false, false);
        }

        @Override
        public void valueChanged(TreeSelectionEvent event) {
            TreePath[] paths;
            this.valueChangedOnPress = true;
            BasicTreeUI.this.completeEditing();
            if (BasicTreeUI.this.tree.getExpandsSelectedPaths() && BasicTreeUI.this.treeSelectionModel != null && (paths = BasicTreeUI.this.treeSelectionModel.getSelectionPaths()) != null) {
                for (int counter = paths.length - 1; counter >= 0; --counter) {
                    TreePath path = paths[counter].getParentPath();
                    boolean expand = true;
                    while (path != null) {
                        if (BasicTreeUI.this.treeModel.isLeaf(path.getLastPathComponent())) {
                            expand = false;
                            path = null;
                            continue;
                        }
                        path = path.getParentPath();
                    }
                    if (!expand) continue;
                    BasicTreeUI.this.tree.makeVisible(paths[counter]);
                }
            }
            TreePath oldLead = BasicTreeUI.this.getLeadSelectionPath();
            BasicTreeUI.this.lastSelectedRow = BasicTreeUI.this.tree.getMinSelectionRow();
            TreePath lead = BasicTreeUI.this.tree.getSelectionModel().getLeadSelectionPath();
            BasicTreeUI.this.setAnchorSelectionPath(lead);
            BasicTreeUI.this.setLeadSelectionPath(lead);
            TreePath[] changedPaths = event.getPaths();
            Rectangle visRect = BasicTreeUI.this.tree.getVisibleRect();
            boolean paintPaths = true;
            int nWidth = BasicTreeUI.this.tree.getWidth();
            if (changedPaths != null) {
                int maxCounter = changedPaths.length;
                if (maxCounter > 4) {
                    BasicTreeUI.this.tree.repaint();
                    paintPaths = false;
                } else {
                    for (int counter = 0; counter < maxCounter; ++counter) {
                        Rectangle nodeBounds = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, changedPaths[counter]);
                        if (nodeBounds == null || !visRect.intersects(nodeBounds)) continue;
                        BasicTreeUI.this.tree.repaint(0, nodeBounds.y, nWidth, nodeBounds.height);
                    }
                }
            }
            if (paintPaths) {
                Rectangle nodeBounds = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, oldLead);
                if (nodeBounds != null && visRect.intersects(nodeBounds)) {
                    BasicTreeUI.this.tree.repaint(0, nodeBounds.y, nWidth, nodeBounds.height);
                }
                if ((nodeBounds = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, lead)) != null && visRect.intersects(nodeBounds)) {
                    BasicTreeUI.this.tree.repaint(0, nodeBounds.y, nWidth, nodeBounds.height);
                }
            }
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            if (event != null && BasicTreeUI.this.tree != null) {
                TreePath path = event.getPath();
                BasicTreeUI.this.updateExpandedDescendants(path);
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            if (event != null && BasicTreeUI.this.tree != null) {
                TreePath path = event.getPath();
                BasicTreeUI.this.completeEditing();
                if (path != null && BasicTreeUI.this.tree.isVisible(path)) {
                    BasicTreeUI.this.treeState.setExpandedState(path, false);
                    BasicTreeUI.this.updateLeadSelectionRow();
                    BasicTreeUI.this.updateSize();
                }
            }
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            if (BasicTreeUI.this.treeState != null && e != null) {
                TreePath parentPath = SwingUtilities2.getTreePath(e, BasicTreeUI.this.getModel());
                int[] indices = e.getChildIndices();
                if (indices == null || indices.length == 0) {
                    BasicTreeUI.this.treeState.treeNodesChanged(e);
                    BasicTreeUI.this.updateSize();
                } else if (BasicTreeUI.this.treeState.isExpanded(parentPath)) {
                    int minIndex = indices[0];
                    for (int i = indices.length - 1; i > 0; --i) {
                        minIndex = Math.min(indices[i], minIndex);
                    }
                    Object minChild = BasicTreeUI.this.treeModel.getChild(parentPath.getLastPathComponent(), minIndex);
                    TreePath minPath = parentPath.pathByAddingChild(minChild);
                    Rectangle minBounds = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, minPath);
                    BasicTreeUI.this.treeState.treeNodesChanged(e);
                    BasicTreeUI.this.updateSize0();
                    Rectangle newMinBounds = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, minPath);
                    if (minBounds == null || newMinBounds == null) {
                        return;
                    }
                    if (indices.length == 1 && newMinBounds.height == minBounds.height) {
                        BasicTreeUI.this.tree.repaint(0, minBounds.y, BasicTreeUI.this.tree.getWidth(), minBounds.height);
                    } else {
                        BasicTreeUI.this.tree.repaint(0, minBounds.y, BasicTreeUI.this.tree.getWidth(), BasicTreeUI.this.tree.getHeight() - minBounds.y);
                    }
                } else {
                    BasicTreeUI.this.treeState.treeNodesChanged(e);
                }
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            if (BasicTreeUI.this.treeState != null && e != null) {
                BasicTreeUI.this.treeState.treeNodesInserted(e);
                BasicTreeUI.this.updateLeadSelectionRow();
                TreePath path = SwingUtilities2.getTreePath(e, BasicTreeUI.this.getModel());
                if (BasicTreeUI.this.treeState.isExpanded(path)) {
                    BasicTreeUI.this.updateSize();
                } else {
                    int[] indices = e.getChildIndices();
                    int childCount = BasicTreeUI.this.treeModel.getChildCount(path.getLastPathComponent());
                    if (indices != null && childCount - indices.length == 0) {
                        BasicTreeUI.this.updateSize();
                    }
                }
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            if (BasicTreeUI.this.treeState != null && e != null) {
                BasicTreeUI.this.treeState.treeNodesRemoved(e);
                BasicTreeUI.this.updateLeadSelectionRow();
                TreePath path = SwingUtilities2.getTreePath(e, BasicTreeUI.this.getModel());
                if (BasicTreeUI.this.treeState.isExpanded(path) || BasicTreeUI.this.treeModel.getChildCount(path.getLastPathComponent()) == 0) {
                    BasicTreeUI.this.updateSize();
                }
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            if (BasicTreeUI.this.treeState != null && e != null) {
                BasicTreeUI.this.treeState.treeStructureChanged(e);
                BasicTreeUI.this.updateLeadSelectionRow();
                TreePath pPath = SwingUtilities2.getTreePath(e, BasicTreeUI.this.getModel());
                if (pPath != null) {
                    pPath = pPath.getParentPath();
                }
                if (pPath == null || BasicTreeUI.this.treeState.isExpanded(pPath)) {
                    BasicTreeUI.this.updateSize();
                }
            }
        }
    }

    public class KeyHandler
    extends KeyAdapter {
        protected Action repeatKeyAction;
        protected boolean isKeyDown;

        public KeyHandler(BasicTreeUI basicTreeUI) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    public class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        public MouseHandler(BasicTreeUI basicTreeUI) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        protected Component source;
        protected Component destination;

        public MouseInputHandler(BasicTreeUI basicTreeUI, Component component, Component component2, MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        protected void removeFromSource() {
        }
    }

    public class NodeDimensionsHandler
    extends AbstractLayoutCache.NodeDimensions {
        public NodeDimensionsHandler(BasicTreeUI basicTreeUI) {
        }

        public Rectangle getNodeDimensions(Object object, int n, int n2, boolean bl, Rectangle rectangle) {
            return null;
        }

        protected int getRowX(int n, int n2) {
            return 0;
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public PropertyChangeHandler(BasicTreeUI basicTreeUI) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }
    }

    public class SelectionModelPropertyChangeHandler
    implements PropertyChangeListener {
        public SelectionModelPropertyChangeHandler(BasicTreeUI basicTreeUI) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }
    }

    public class TreeCancelEditingAction
    extends AbstractAction {
        public TreeCancelEditingAction(BasicTreeUI basicTreeUI, String string) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public boolean isEnabled() {
            return false;
        }
    }

    public class TreeExpansionHandler
    implements TreeExpansionListener {
        public TreeExpansionHandler(BasicTreeUI basicTreeUI) {
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        }
    }

    public class TreeHomeAction
    extends AbstractAction {
        protected int direction;

        public TreeHomeAction(BasicTreeUI basicTreeUI, int n, String string) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public boolean isEnabled() {
            return false;
        }
    }

    public class TreeIncrementAction
    extends AbstractAction {
        protected int direction;

        public TreeIncrementAction(BasicTreeUI basicTreeUI, int n, String string) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public boolean isEnabled() {
            return false;
        }
    }

    public class TreeModelHandler
    implements TreeModelListener {
        public TreeModelHandler(BasicTreeUI basicTreeUI) {
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }
    }

    public class TreePageAction
    extends AbstractAction {
        protected int direction;

        public TreePageAction(BasicTreeUI basicTreeUI, int n, String string) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public boolean isEnabled() {
            return false;
        }
    }

    public class TreeSelectionHandler
    implements TreeSelectionListener {
        public TreeSelectionHandler(BasicTreeUI basicTreeUI) {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        }
    }

    public class TreeToggleAction
    extends AbstractAction {
        public TreeToggleAction(BasicTreeUI basicTreeUI, String string) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public boolean isEnabled() {
            return false;
        }
    }

    static class TreeTransferHandler
    extends TransferHandler
    implements UIResource,
    Comparator<TreePath> {
        private JTree tree;

        TreeTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (c instanceof JTree) {
                TreePath[] displayPaths;
                this.tree = (JTree)c;
                TreePath[] paths = this.tree.getSelectionPaths();
                if (paths == null || paths.length == 0) {
                    return null;
                }
                StringBuilder plainStr = new StringBuilder();
                StringBuilder htmlStr = new StringBuilder();
                htmlStr.append("<html>\n<body>\n<ul>\n");
                TreeModel model = this.tree.getModel();
                Object lastPath = null;
                for (TreePath path : displayPaths = this.getDisplayOrderPaths(paths)) {
                    Object node = path.getLastPathComponent();
                    boolean leaf = model.isLeaf(node);
                    String label = this.getDisplayString(path, true, leaf);
                    plainStr.append(label).append('\n');
                    htmlStr.append("  <li>").append(label).append('\n');
                }
                plainStr.deleteCharAt(plainStr.length() - 1);
                htmlStr.append("</ul>\n</body>\n</html>");
                this.tree = null;
                return new BasicTransferable(plainStr.toString(), htmlStr.toString());
            }
            return null;
        }

        @Override
        public int compare(TreePath o1, TreePath o2) {
            int row1 = this.tree.getRowForPath(o1);
            int row2 = this.tree.getRowForPath(o2);
            return row1 - row2;
        }

        String getDisplayString(TreePath path, boolean selected, boolean leaf) {
            int row = this.tree.getRowForPath(path);
            boolean hasFocus = this.tree.getLeadSelectionRow() == row;
            Object node = path.getLastPathComponent();
            return this.tree.convertValueToText(node, selected, this.tree.isExpanded(row), leaf, row, hasFocus);
        }

        TreePath[] getDisplayOrderPaths(TreePath[] paths) {
            ArrayList<TreePath> selOrder = new ArrayList<TreePath>();
            for (TreePath path : paths) {
                selOrder.add(path);
            }
            selOrder.sort(this);
            int n = selOrder.size();
            TreePath[] displayPaths = new TreePath[n];
            for (int i = 0; i < n; ++i) {
                displayPaths[i] = (TreePath)selOrder.get(i);
            }
            return displayPaths;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }
    }

    public class TreeTraverseAction
    extends AbstractAction {
        protected int direction;

        public TreeTraverseAction(BasicTreeUI basicTreeUI, int n, String string) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public boolean isEnabled() {
            return false;
        }
    }
}

