/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.CompositeView;
import javax.swing.text.Element;
import javax.swing.text.LabelView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class FlowView
extends BoxView {
    protected int layoutSpan;
    protected View layoutPool;
    protected FlowStrategy strategy;

    public FlowView(Element element, int n) {
    }

    public int getFlowAxis() {
        return 0;
    }

    public int getFlowSpan(int n) {
        return 0;
    }

    public int getFlowStart(int n) {
        return 0;
    }

    protected abstract View createRow();

    protected void loadChildren(ViewFactory viewFactory) {
    }

    protected int getViewIndexAtPosition(int n) {
        return 0;
    }

    protected void layout(int n, int n2) {
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        return null;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
    }

    public void setParent(View view) {
    }

    public static class FlowStrategy {
        public void insertUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
        }

        public void removeUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
        }

        public void changedUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
        }

        protected View getLogicalView(FlowView flowView) {
            return null;
        }

        public void layout(FlowView flowView) {
        }

        protected int layoutRow(FlowView flowView, int n, int n2) {
            return 0;
        }

        protected void adjustRow(FlowView flowView, int n, int n2, int n3) {
        }

        protected View createView(FlowView flowView, int n, int n2, int n3) {
            return null;
        }
    }

    static class LogicalView
    extends CompositeView {
        LogicalView(Element elem) {
            super(elem);
        }

        @Override
        protected int getViewIndexAtPosition(int pos) {
            Element elem = this.getElement();
            if (elem.isLeaf()) {
                return 0;
            }
            return super.getViewIndexAtPosition(pos);
        }

        @Override
        protected void loadChildren(ViewFactory f) {
            Element elem = this.getElement();
            if (elem.isLeaf()) {
                LabelView v = new LabelView(elem);
                this.append(v);
            } else {
                super.loadChildren(f);
            }
        }

        @Override
        public AttributeSet getAttributes() {
            View p = this.getParent();
            return p != null ? p.getAttributes() : null;
        }

        @Override
        public float getPreferredSpan(int axis) {
            float maxpref = 0.0f;
            float pref = 0.0f;
            int n = this.getViewCount();
            for (int i = 0; i < n; ++i) {
                View v = this.getView(i);
                pref += v.getPreferredSpan(axis);
                if (v.getBreakWeight(axis, 0.0f, 2.1474836E9f) < 3000) continue;
                maxpref = Math.max(maxpref, pref);
                pref = 0.0f;
            }
            maxpref = Math.max(maxpref, pref);
            return maxpref;
        }

        @Override
        public float getMinimumSpan(int axis) {
            float maxmin = 0.0f;
            float min = 0.0f;
            boolean nowrap = false;
            int n = this.getViewCount();
            for (int i = 0; i < n; ++i) {
                View v = this.getView(i);
                if (v.getBreakWeight(axis, 0.0f, 2.1474836E9f) == 0) {
                    min += v.getPreferredSpan(axis);
                    nowrap = true;
                } else if (nowrap) {
                    maxmin = Math.max(min, maxmin);
                    nowrap = false;
                    min = 0.0f;
                }
                if (!(v instanceof ComponentView)) continue;
                maxmin = Math.max(maxmin, v.getMinimumSpan(axis));
            }
            maxmin = Math.max(maxmin, min);
            return maxmin;
        }

        @Override
        protected void forwardUpdateToView(View v, DocumentEvent e, Shape a, ViewFactory f) {
            View parent = v.getParent();
            v.setParent(this);
            super.forwardUpdateToView(v, e, a, f);
            v.setParent(parent);
        }

        @Override
        protected void forwardUpdate(DocumentEvent.ElementChange ec, DocumentEvent e, Shape a, ViewFactory f) {
            super.forwardUpdate(ec, e, a, f);
            DocumentEvent.EventType type = e.getType();
            if (type == DocumentEvent.EventType.INSERT || type == DocumentEvent.EventType.REMOVE) {
                this.firstUpdateIndex = Math.min(this.lastUpdateIndex + 1, this.getViewCount() - 1);
                this.lastUpdateIndex = Math.max(this.getViewCount() - 1, 0);
                for (int i = this.firstUpdateIndex; i <= this.lastUpdateIndex; ++i) {
                    View v = this.getView(i);
                    if (v == null) continue;
                    v.updateAfterChange();
                }
            }
        }

        @Override
        public void paint(Graphics g, Shape allocation) {
        }

        @Override
        protected boolean isBefore(int x, int y, Rectangle alloc) {
            return false;
        }

        @Override
        protected boolean isAfter(int x, int y, Rectangle alloc) {
            return false;
        }

        @Override
        protected View getViewAtPoint(int x, int y, Rectangle alloc) {
            return null;
        }

        @Override
        protected void childAllocation(int index, Rectangle a) {
        }
    }
}

