/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Vector;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.GapVector;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class GapContent
extends GapVector
implements AbstractDocument.Content,
Serializable {
    public GapContent() {
    }

    public GapContent(int n) {
    }

    protected Object allocateArray(int n) {
        return null;
    }

    protected int getArrayLength() {
        return 0;
    }

    public int length() {
        return 0;
    }

    public UndoableEdit insertString(int n, String string) throws BadLocationException {
        return null;
    }

    public UndoableEdit remove(int n, int n2) throws BadLocationException {
        return null;
    }

    public String getString(int n, int n2) throws BadLocationException {
        return null;
    }

    public void getChars(int n, int n2, Segment segment) throws BadLocationException {
    }

    public Position createPosition(int n) throws BadLocationException {
        return null;
    }

    protected void shiftEnd(int n) {
    }

    protected void shiftGap(int n) {
    }

    protected void resetMarksAtZero() {
    }

    protected void shiftGapStartDown(int n) {
    }

    protected void shiftGapEndUp(int n) {
    }

    protected Vector getPositionsInRange(Vector vector, int n, int n2) {
        return null;
    }

    protected void updateUndoPositions(Vector vector, int n, int n2) {
    }

    class InsertUndo
    extends AbstractUndoableEdit {
        protected int offset;
        protected int length;
        protected String string;
        protected Vector posRefs;

        protected InsertUndo(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            try {
                this.posRefs = GapContent.this.getPositionsInRange(null, this.offset, this.length);
                this.string = GapContent.this.getString(this.offset, this.length);
                GapContent.this.remove(this.offset, this.length);
            }
            catch (BadLocationException bl) {
                throw new CannotUndoException();
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            try {
                GapContent.this.insertString(this.offset, this.string);
                this.string = null;
                if (this.posRefs != null) {
                    GapContent.this.updateUndoPositions(this.posRefs, this.offset, this.length);
                    this.posRefs = null;
                }
            }
            catch (BadLocationException bl) {
                throw new CannotRedoException();
            }
        }
    }

    final class MarkData
    extends WeakReference<StickyPosition> {
        int index;

        MarkData(int index) {
            super(null);
            this.index = index;
        }

        MarkData(int index, StickyPosition position, ReferenceQueue<? super StickyPosition> queue) {
            super(position, queue);
            this.index = index;
        }

        public int getOffset() {
            int g0 = GapContent.this.getGapStart();
            int g1 = GapContent.this.getGapEnd();
            int offs = this.index < g0 ? this.index : this.index - (g1 - g0);
            return Math.max(offs, 0);
        }

        StickyPosition getPosition() {
            return (StickyPosition)this.get();
        }
    }

    static class MarkVector
    extends GapVector {
        MarkData[] oneMark = new MarkData[1];

        MarkVector() {
        }

        MarkVector(int size) {
            super(size);
        }

        @Override
        protected Object allocateArray(int len) {
            return new MarkData[len];
        }

        @Override
        protected int getArrayLength() {
            MarkData[] marks = (MarkData[])this.getArray();
            return marks.length;
        }

        public int size() {
            int len = this.getArrayLength() - (this.getGapEnd() - this.getGapStart());
            return len;
        }

        public void insertElementAt(MarkData m, int index) {
            this.oneMark[0] = m;
            this.replace(index, 0, this.oneMark, 1);
        }

        public void addElement(MarkData m) {
            this.insertElementAt(m, this.size());
        }

        public MarkData elementAt(int index) {
            int g0 = this.getGapStart();
            int g1 = this.getGapEnd();
            MarkData[] array = (MarkData[])this.getArray();
            if (index < g0) {
                return array[index];
            }
            return array[index += g1 - g0];
        }

        protected void replaceRange(int start, int end, Object[] marks) {
            int g0 = this.getGapStart();
            int g1 = this.getGapEnd();
            int index = start;
            int newIndex = 0;
            Object[] array = (Object[])this.getArray();
            if (start >= g0) {
                index += g1 - g0;
                end += g1 - g0;
            } else if (end >= g0) {
                end += g1 - g0;
                while (index < g0) {
                    array[index++] = marks[newIndex++];
                }
                index = g1;
            } else {
                while (index < end) {
                    array[index++] = marks[newIndex++];
                }
            }
            while (index < end) {
                array[index++] = marks[newIndex++];
            }
        }
    }

    class RemoveUndo
    extends AbstractUndoableEdit {
        protected int offset;
        protected int length;
        protected String string;
        protected Vector<UndoPosRef> posRefs;

        protected RemoveUndo(int offset, String string) {
            this.offset = offset;
            this.string = string;
            this.length = string.length();
            this.posRefs = GapContent.this.getPositionsInRange(null, offset, this.length);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            try {
                GapContent.this.insertString(this.offset, this.string);
                if (this.posRefs != null) {
                    GapContent.this.updateUndoPositions(this.posRefs, this.offset, this.length);
                    this.posRefs = null;
                }
                this.string = null;
            }
            catch (BadLocationException bl) {
                throw new CannotUndoException();
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            try {
                this.string = GapContent.this.getString(this.offset, this.length);
                this.posRefs = GapContent.this.getPositionsInRange(null, this.offset, this.length);
                GapContent.this.remove(this.offset, this.length);
            }
            catch (BadLocationException bl) {
                throw new CannotRedoException();
            }
        }
    }

    final class StickyPosition
    implements Position {
        MarkData mark;

        StickyPosition(GapContent this$0) {
        }

        void setMark(MarkData mark) {
            this.mark = mark;
        }

        @Override
        public int getOffset() {
            return this.mark.getOffset();
        }

        public String toString() {
            return Integer.toString(this.getOffset());
        }
    }

    final class UndoPosRef {
        protected int undoLocation;
        protected MarkData rec;

        UndoPosRef(GapContent this$0, MarkData rec) {
            this.rec = rec;
            this.undoLocation = rec.getOffset();
        }

        protected void resetLocation(int endOffset, int g1) {
            this.rec.index = this.undoLocation != endOffset ? this.undoLocation : g1;
        }
    }
}

