/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextHitInfo;
import java.awt.im.InputContext;
import java.awt.im.InputMethodRequests;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.TransferHandler;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.Keymap;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyledDocument;
import sun.awt.AppContext;

public abstract class JTextComponent
extends JComponent
implements Scrollable,
Accessible {
    public static final String FOCUS_ACCELERATOR_KEY = "focusAcceleratorKey";
    public static final String DEFAULT_KEYMAP = "default";

    public TextUI getUI() {
        return null;
    }

    public void setUI(TextUI textUI) {
    }

    public void updateUI() {
    }

    public void addCaretListener(CaretListener caretListener) {
    }

    public void removeCaretListener(CaretListener caretListener) {
    }

    public CaretListener[] getCaretListeners() {
        return null;
    }

    protected void fireCaretUpdate(CaretEvent caretEvent) {
    }

    public void setDocument(Document document) {
    }

    public Document getDocument() {
        return null;
    }

    public void setComponentOrientation(ComponentOrientation componentOrientation) {
    }

    public Action[] getActions() {
        return null;
    }

    public void setMargin(Insets insets) {
    }

    public Insets getMargin() {
        return null;
    }

    public void setNavigationFilter(NavigationFilter navigationFilter) {
    }

    public NavigationFilter getNavigationFilter() {
        return null;
    }

    public Caret getCaret() {
        return null;
    }

    public void setCaret(Caret caret) {
    }

    public Highlighter getHighlighter() {
        return null;
    }

    public void setHighlighter(Highlighter highlighter) {
    }

    public void setKeymap(Keymap keymap) {
    }

    public void setDragEnabled(boolean bl) {
    }

    public boolean getDragEnabled() {
        return false;
    }

    public Keymap getKeymap() {
        return null;
    }

    public static Keymap addKeymap(String string, Keymap keymap) {
        return null;
    }

    public static Keymap removeKeymap(String string) {
        return null;
    }

    public static Keymap getKeymap(String string) {
        return null;
    }

    public static void loadKeymap(Keymap keymap, KeyBinding[] keyBindingArray, Action[] actionArray) {
    }

    public Color getCaretColor() {
        return null;
    }

    public void setCaretColor(Color color) {
    }

    public Color getSelectionColor() {
        return null;
    }

    public void setSelectionColor(Color color) {
    }

    public Color getSelectedTextColor() {
        return null;
    }

    public void setSelectedTextColor(Color color) {
    }

    public Color getDisabledTextColor() {
        return null;
    }

    public void setDisabledTextColor(Color color) {
    }

    public void replaceSelection(String string) {
    }

    public String getText(int n, int n2) throws BadLocationException {
        return null;
    }

    public Rectangle modelToView(int n) throws BadLocationException {
        return null;
    }

    public int viewToModel(Point point) {
        return 0;
    }

    public void cut() {
    }

    public void copy() {
    }

    public void paste() {
    }

    public void moveCaretPosition(int n) {
    }

    public void setFocusAccelerator(char c) {
    }

    public char getFocusAccelerator() {
        return '\u0000';
    }

    public void read(Reader reader, Object object) throws IOException {
    }

    public void write(Writer writer) throws IOException {
    }

    public void removeNotify() {
    }

    public void setCaretPosition(int n) {
    }

    public int getCaretPosition() {
        return 0;
    }

    public void setText(String string) {
    }

    public String getText() {
        return null;
    }

    public String getSelectedText() {
        return null;
    }

    public boolean isEditable() {
        return false;
    }

    public void setEditable(boolean bl) {
    }

    public int getSelectionStart() {
        return 0;
    }

    public void setSelectionStart(int n) {
    }

    public int getSelectionEnd() {
        return 0;
    }

    public void setSelectionEnd(int n) {
    }

    public void select(int n, int n2) {
    }

    public void selectAll() {
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return null;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return null;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 0;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 0;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    protected String paramString() {
        return null;
    }

    protected void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
    }

    public InputMethodRequests getInputMethodRequests() {
        return null;
    }

    public void addInputMethodListener(InputMethodListener inputMethodListener) {
    }

    public class AccessibleJTextComponent
    extends JComponent.AccessibleJComponent
    implements AccessibleText,
    CaretListener,
    DocumentListener,
    AccessibleAction,
    AccessibleEditableText {
        public AccessibleJTextComponent(JTextComponent jTextComponent) {
        }

        public void caretUpdate(CaretEvent caretEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
        }

        public void removeUpdate(DocumentEvent documentEvent) {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return null;
        }

        public AccessibleText getAccessibleText() {
            return null;
        }

        public int getIndexAtPoint(Point point) {
            return 0;
        }

        public Rectangle getCharacterBounds(int n) {
            return null;
        }

        public int getCharCount() {
            return 0;
        }

        public int getCaretPosition() {
            return 0;
        }

        public AttributeSet getCharacterAttribute(int n) {
            return null;
        }

        public int getSelectionStart() {
            return 0;
        }

        public int getSelectionEnd() {
            return 0;
        }

        public String getSelectedText() {
            return null;
        }

        public String getAtIndex(int n, int n2) {
            return null;
        }

        public String getAfterIndex(int n, int n2) {
            return null;
        }

        public String getBeforeIndex(int n, int n2) {
            return null;
        }

        public AccessibleEditableText getAccessibleEditableText() {
            return null;
        }

        public void setTextContents(String string) {
        }

        public void insertTextAtIndex(int n, String string) {
        }

        public String getTextRange(int n, int n2) {
            return null;
        }

        public void delete(int n, int n2) {
        }

        public void cut(int n, int n2) {
        }

        public void paste(int n) {
        }

        public void replaceText(int n, int n2, String string) {
        }

        public void selectText(int n, int n2) {
        }

        public void setAttributes(int n, int n2, AttributeSet attributeSet) {
        }

        public AccessibleAction getAccessibleAction() {
            return null;
        }

        public int getAccessibleActionCount() {
            return 0;
        }

        public String getAccessibleActionDescription(int n) {
            return null;
        }

        public boolean doAccessibleAction(int n) {
            return false;
        }

        private class IndexedSegment
        extends Segment {
            public int modelOffset;

            private IndexedSegment(AccessibleJTextComponent accessibleJTextComponent) {
            }
        }
    }

    class ComposedTextCaret
    extends DefaultCaret
    implements Serializable {
        Color bg;

        ComposedTextCaret() {
        }

        @Override
        public void install(JTextComponent c) {
            super.install(c);
            Document doc = c.getDocument();
            if (doc instanceof StyledDocument) {
                StyledDocument sDoc = (StyledDocument)doc;
                Element elem = sDoc.getCharacterElement(c.composedTextStart.getOffset());
                AttributeSet attr = elem.getAttributes();
                this.bg = sDoc.getBackground(attr);
            }
            if (this.bg == null) {
                this.bg = c.getBackground();
            }
        }

        @Override
        public void paint(Graphics g) {
            if (this.isVisible()) {
                try {
                    Rectangle r = this.component.modelToView(this.getDot());
                    g.setXORMode(this.bg);
                    g.drawLine(r.x, r.y, r.x, r.y + r.height - 1);
                    g.setPaintMode();
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        @Override
        protected void positionCaret(MouseEvent me) {
            int composedStartIndex;
            JTextComponent host = this.component;
            Point pt = new Point(me.getX(), me.getY());
            int offset = host.viewToModel(pt);
            if (offset < (composedStartIndex = host.composedTextStart.getOffset()) || offset > JTextComponent.this.composedTextEnd.getOffset()) {
                try {
                    Position newPos = host.getDocument().createPosition(offset);
                    host.getInputContext().endComposition();
                    EventQueue.invokeLater(new DoSetCaretPosition(host, newPos));
                }
                catch (BadLocationException ble) {
                    System.err.println(ble);
                }
            } else {
                super.positionCaret(me);
            }
        }
    }

    static class DefaultKeymap
    implements Keymap {
        String nm;
        Keymap parent;
        Hashtable<KeyStroke, Action> bindings;
        Action defaultAction;

        DefaultKeymap(String nm, Keymap parent) {
            this.nm = nm;
            this.parent = parent;
            this.bindings = new Hashtable();
        }

        @Override
        public Action getDefaultAction() {
            if (this.defaultAction != null) {
                return this.defaultAction;
            }
            return this.parent != null ? this.parent.getDefaultAction() : null;
        }

        @Override
        public void setDefaultAction(Action a) {
            this.defaultAction = a;
        }

        @Override
        public String getName() {
            return this.nm;
        }

        @Override
        public Action getAction(KeyStroke key) {
            Action a = this.bindings.get(key);
            if (a == null && this.parent != null) {
                a = this.parent.getAction(key);
            }
            return a;
        }

        @Override
        public KeyStroke[] getBoundKeyStrokes() {
            KeyStroke[] keys = new KeyStroke[this.bindings.size()];
            int i = 0;
            Enumeration<KeyStroke> e = this.bindings.keys();
            while (e.hasMoreElements()) {
                keys[i++] = e.nextElement();
            }
            return keys;
        }

        @Override
        public Action[] getBoundActions() {
            Action[] actions = new Action[this.bindings.size()];
            int i = 0;
            Enumeration<Action> e = this.bindings.elements();
            while (e.hasMoreElements()) {
                actions[i++] = e.nextElement();
            }
            return actions;
        }

        @Override
        public KeyStroke[] getKeyStrokesForAction(Action a) {
            KeyStroke[] pStrokes;
            if (a == null) {
                return null;
            }
            KeyStroke[] retValue = null;
            ArrayList<KeyStroke> keyStrokes = null;
            Enumeration<KeyStroke> keys = this.bindings.keys();
            while (keys.hasMoreElements()) {
                KeyStroke key = keys.nextElement();
                if (this.bindings.get(key) != a) continue;
                if (keyStrokes == null) {
                    keyStrokes = new ArrayList<KeyStroke>();
                }
                keyStrokes.add(key);
            }
            if (this.parent != null && (pStrokes = this.parent.getKeyStrokesForAction(a)) != null) {
                int counter;
                int rCount = 0;
                for (counter = pStrokes.length - 1; counter >= 0; --counter) {
                    if (!this.isLocallyDefined(pStrokes[counter])) continue;
                    pStrokes[counter] = null;
                    ++rCount;
                }
                if (rCount > 0 && rCount < pStrokes.length) {
                    if (keyStrokes == null) {
                        keyStrokes = new ArrayList();
                    }
                    for (counter = pStrokes.length - 1; counter >= 0; --counter) {
                        if (pStrokes[counter] == null) continue;
                        keyStrokes.add(pStrokes[counter]);
                    }
                } else if (rCount == 0) {
                    if (keyStrokes == null) {
                        retValue = pStrokes;
                    } else {
                        retValue = new KeyStroke[keyStrokes.size() + pStrokes.length];
                        keyStrokes.toArray(retValue);
                        System.arraycopy(pStrokes, 0, retValue, keyStrokes.size(), pStrokes.length);
                        keyStrokes = null;
                    }
                }
            }
            if (keyStrokes != null) {
                retValue = keyStrokes.toArray(new KeyStroke[0]);
            }
            return retValue;
        }

        @Override
        public boolean isLocallyDefined(KeyStroke key) {
            return this.bindings.containsKey(key);
        }

        @Override
        public void addActionForKeyStroke(KeyStroke key, Action a) {
            this.bindings.put(key, a);
        }

        @Override
        public void removeKeyStrokeBinding(KeyStroke key) {
            this.bindings.remove(key);
        }

        @Override
        public void removeBindings() {
            this.bindings.clear();
        }

        @Override
        public Keymap getResolveParent() {
            return this.parent;
        }

        @Override
        public void setResolveParent(Keymap parent) {
            this.parent = parent;
        }

        public String toString() {
            return "Keymap[" + this.nm + "]" + String.valueOf(this.bindings);
        }
    }

    static class DefaultTransferHandler
    extends TransferHandler
    implements UIResource {
        DefaultTransferHandler() {
        }

        @Override
        public void exportToClipboard(JComponent comp, Clipboard clipboard, int action) throws IllegalStateException {
            int p1;
            JTextComponent text;
            int p0;
            if (comp instanceof JTextComponent && (p0 = (text = (JTextComponent)comp).getSelectionStart()) != (p1 = text.getSelectionEnd())) {
                try {
                    Document doc = text.getDocument();
                    String srcData = doc.getText(p0, p1 - p0);
                    StringSelection contents = new StringSelection(srcData);
                    clipboard.setContents(contents, null);
                    if (action == 2) {
                        doc.remove(p0, p1 - p0);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean importData(JComponent comp, Transferable t) {
            DataFlavor flavor;
            if (comp instanceof JTextComponent && (flavor = this.getFlavor(t.getTransferDataFlavors())) != null) {
                InputContext ic = comp.getInputContext();
                if (ic != null) {
                    ic.endComposition();
                }
                try {
                    String data = (String)t.getTransferData(flavor);
                    ((JTextComponent)comp).replaceSelection(data);
                    return true;
                }
                catch (UnsupportedFlavorException | IOException exception) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            JTextComponent c = (JTextComponent)comp;
            if (!c.isEditable() || !c.isEnabled()) {
                return false;
            }
            return this.getFlavor(transferFlavors) != null;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 0;
        }

        private DataFlavor getFlavor(DataFlavor[] flavors) {
            if (flavors != null) {
                for (DataFlavor flavor : flavors) {
                    if (!flavor.equals(DataFlavor.stringFlavor)) continue;
                    return flavor;
                }
            }
            return null;
        }
    }

    private static class DoSetCaretPosition
    implements Runnable {
        JTextComponent host;
        Position newPos;

        DoSetCaretPosition(JTextComponent host, Position newPos) {
            this.host = host;
            this.newPos = newPos;
        }

        @Override
        public void run() {
            this.host.setCaretPosition(this.newPos.getOffset());
        }
    }

    class InputMethodRequestsHandler
    implements InputMethodRequests,
    DocumentListener {
        InputMethodRequestsHandler() {
        }

        @Override
        public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
            Document doc = JTextComponent.this.getDocument();
            if (doc != null && JTextComponent.this.latestCommittedTextStart != null && !JTextComponent.this.latestCommittedTextStart.equals(JTextComponent.this.latestCommittedTextEnd)) {
                try {
                    int startIndex = JTextComponent.this.latestCommittedTextStart.getOffset();
                    int endIndex = JTextComponent.this.latestCommittedTextEnd.getOffset();
                    String latestCommittedText = doc.getText(startIndex, endIndex - startIndex);
                    doc.remove(startIndex, endIndex - startIndex);
                    return new AttributedString(latestCommittedText).getIterator();
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
            Object committed;
            int composedStartIndex = 0;
            int composedEndIndex = 0;
            if (JTextComponent.this.composedTextExists()) {
                composedStartIndex = JTextComponent.this.composedTextStart.getOffset();
                composedEndIndex = JTextComponent.this.composedTextEnd.getOffset();
            }
            try {
                if (beginIndex < composedStartIndex) {
                    if (endIndex <= composedStartIndex) {
                        committed = JTextComponent.this.getText(beginIndex, endIndex - beginIndex);
                    } else {
                        int firstPartLength = composedStartIndex - beginIndex;
                        committed = JTextComponent.this.getText(beginIndex, firstPartLength) + JTextComponent.this.getText(composedEndIndex, endIndex - beginIndex - firstPartLength);
                    }
                } else {
                    committed = JTextComponent.this.getText(beginIndex + (composedEndIndex - composedStartIndex), endIndex - beginIndex);
                }
            }
            catch (BadLocationException ble) {
                throw new IllegalArgumentException("Invalid range");
            }
            return new AttributedString((String)committed).getIterator();
        }

        @Override
        public int getCommittedTextLength() {
            Document doc = JTextComponent.this.getDocument();
            int length = 0;
            if (doc != null) {
                length = doc.getLength();
                if (JTextComponent.this.composedTextContent != null) {
                    length = JTextComponent.this.composedTextEnd == null || JTextComponent.this.composedTextStart == null ? (length -= JTextComponent.this.composedTextContent.length()) : (length -= JTextComponent.this.composedTextEnd.getOffset() - JTextComponent.this.composedTextStart.getOffset());
                }
            }
            return length;
        }

        @Override
        public int getInsertPositionOffset() {
            int caretIndex;
            int composedStartIndex = 0;
            int composedEndIndex = 0;
            if (JTextComponent.this.composedTextExists()) {
                composedStartIndex = JTextComponent.this.composedTextStart.getOffset();
                composedEndIndex = JTextComponent.this.composedTextEnd.getOffset();
            }
            if ((caretIndex = JTextComponent.this.getCaretPosition()) < composedStartIndex) {
                return caretIndex;
            }
            if (caretIndex < composedEndIndex) {
                return composedStartIndex;
            }
            return caretIndex - (composedEndIndex - composedStartIndex);
        }

        @Override
        public TextHitInfo getLocationOffset(int x, int y) {
            if (JTextComponent.this.composedTextAttribute == null) {
                return null;
            }
            Point p = JTextComponent.this.getLocationOnScreen();
            p.x = x - p.x;
            p.y = y - p.y;
            int pos = JTextComponent.this.viewToModel(p);
            if (pos >= JTextComponent.this.composedTextStart.getOffset() && pos <= JTextComponent.this.composedTextEnd.getOffset()) {
                return TextHitInfo.leading(pos - JTextComponent.this.composedTextStart.getOffset());
            }
            return null;
        }

        @Override
        public Rectangle getTextLocation(TextHitInfo offset) {
            Rectangle r;
            try {
                r = JTextComponent.this.modelToView(JTextComponent.this.getCaretPosition());
                if (r != null) {
                    Point p = JTextComponent.this.getLocationOnScreen();
                    r.translate(p.x, p.y);
                }
            }
            catch (BadLocationException ble) {
                r = null;
            }
            if (r == null) {
                r = new Rectangle();
            }
            return r;
        }

        @Override
        public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
            String selection = JTextComponent.this.getSelectedText();
            if (selection != null) {
                return new AttributedString(selection).getIterator();
            }
            return null;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            JTextComponent.this.latestCommittedTextEnd = null;
            JTextComponent.this.latestCommittedTextStart = null;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            JTextComponent.this.latestCommittedTextEnd = null;
            JTextComponent.this.latestCommittedTextStart = null;
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            JTextComponent.this.latestCommittedTextEnd = null;
            JTextComponent.this.latestCommittedTextStart = null;
        }
    }

    public static class KeyBinding {
        public KeyStroke key;
        public String actionName;

        public KeyBinding(KeyStroke keyStroke, String string) {
        }
    }

    static class KeymapActionMap
    extends ActionMap {
        private Keymap keymap;

        KeymapActionMap(Keymap keymap) {
            this.keymap = keymap;
        }

        @Override
        public Object[] keys() {
            boolean hasDefault;
            Object[] sKeys = super.keys();
            Object[] keymapKeys = this.keymap.getBoundActions();
            int sCount = sKeys == null ? 0 : sKeys.length;
            int keymapCount = keymapKeys == null ? 0 : keymapKeys.length;
            boolean bl = hasDefault = this.keymap.getDefaultAction() != null;
            if (hasDefault) {
                ++keymapCount;
            }
            if (sCount == 0) {
                if (hasDefault) {
                    Object[] retValue = new Object[keymapCount];
                    if (keymapCount > 1) {
                        System.arraycopy(keymapKeys, 0, retValue, 0, keymapCount - 1);
                    }
                    retValue[keymapCount - 1] = KeymapWrapper.DefaultActionKey;
                    return retValue;
                }
                return keymapKeys;
            }
            if (keymapCount == 0) {
                return sKeys;
            }
            Object[] retValue = new Object[sCount + keymapCount];
            System.arraycopy(sKeys, 0, retValue, 0, sCount);
            if (hasDefault) {
                if (keymapCount > 1) {
                    System.arraycopy(keymapKeys, 0, retValue, sCount, keymapCount - 1);
                }
                retValue[sCount + keymapCount - 1] = KeymapWrapper.DefaultActionKey;
            } else {
                System.arraycopy(keymapKeys, 0, retValue, sCount, keymapCount);
            }
            return retValue;
        }

        @Override
        public int size() {
            int keymapCount;
            Action[] actions = this.keymap.getBoundActions();
            int n = keymapCount = actions == null ? 0 : actions.length;
            if (this.keymap.getDefaultAction() != null) {
                ++keymapCount;
            }
            return super.size() + keymapCount;
        }

        @Override
        public Action get(Object key) {
            Action retValue = super.get(key);
            if (retValue == null) {
                if (key == KeymapWrapper.DefaultActionKey) {
                    retValue = this.keymap.getDefaultAction();
                } else if (key instanceof Action) {
                    retValue = (Action)key;
                }
            }
            return retValue;
        }
    }

    static class KeymapWrapper
    extends InputMap {
        static final Object DefaultActionKey = new Object();
        private Keymap keymap;

        KeymapWrapper(Keymap keymap) {
            this.keymap = keymap;
        }

        @Override
        public KeyStroke[] keys() {
            int keymapCount;
            KeyStroke[] sKeys = super.keys();
            KeyStroke[] keymapKeys = this.keymap.getBoundKeyStrokes();
            int sCount = sKeys == null ? 0 : sKeys.length;
            int n = keymapCount = keymapKeys == null ? 0 : keymapKeys.length;
            if (sCount == 0) {
                return keymapKeys;
            }
            if (keymapCount == 0) {
                return sKeys;
            }
            KeyStroke[] retValue = new KeyStroke[sCount + keymapCount];
            System.arraycopy(sKeys, 0, retValue, 0, sCount);
            System.arraycopy(keymapKeys, 0, retValue, sCount, keymapCount);
            return retValue;
        }

        @Override
        public int size() {
            KeyStroke[] keymapStrokes = this.keymap.getBoundKeyStrokes();
            int keymapCount = keymapStrokes == null ? 0 : keymapStrokes.length;
            return super.size() + keymapCount;
        }

        @Override
        public Object get(KeyStroke keyStroke) {
            Object retValue = this.keymap.getAction(keyStroke);
            if (retValue == null && (retValue = super.get(keyStroke)) == null && keyStroke.getKeyChar() != '\uffff' && this.keymap.getDefaultAction() != null) {
                retValue = DefaultActionKey;
            }
            return retValue;
        }
    }

    static class MutableCaretEvent
    extends CaretEvent
    implements ChangeListener,
    FocusListener,
    MouseListener {
        private boolean dragActive;
        private int dot;
        private int mark;

        MutableCaretEvent(JTextComponent c) {
            super(c);
        }

        final void fire() {
            JTextComponent c = (JTextComponent)this.getSource();
            if (c != null) {
                Caret caret = c.getCaret();
                this.dot = caret.getDot();
                this.mark = caret.getMark();
                c.fireCaretUpdate(this);
            }
        }

        @Override
        public final String toString() {
            return "dot=" + this.dot + ",mark=" + this.mark;
        }

        @Override
        public final int getDot() {
            return this.dot;
        }

        @Override
        public final int getMark() {
            return this.mark;
        }

        @Override
        public final void stateChanged(ChangeEvent e) {
            if (!this.dragActive) {
                this.fire();
            }
        }

        @Override
        public void focusGained(FocusEvent fe) {
            AppContext.getAppContext().put(FOCUSED_COMPONENT, fe.getSource());
        }

        @Override
        public void focusLost(FocusEvent fe) {
        }

        @Override
        public final void mousePressed(MouseEvent e) {
            this.dragActive = true;
        }

        @Override
        public final void mouseReleased(MouseEvent e) {
            this.dragActive = false;
            this.fire();
        }

        @Override
        public final void mouseClicked(MouseEvent e) {
        }

        @Override
        public final void mouseEntered(MouseEvent e) {
        }

        @Override
        public final void mouseExited(MouseEvent e) {
        }
    }
}

