/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.Map;
import javax.swing.text.html.StyleSheet;

public class HTMLDocument
extends DefaultStyledDocument {
    public static final String AdditionalComments = "AdditionalComments";

    public HTMLDocument() {
    }

    public HTMLDocument(StyleSheet styleSheet) {
    }

    public HTMLDocument(AbstractDocument.Content content, StyleSheet styleSheet) {
    }

    public HTMLEditorKit.ParserCallback getReader(int n) {
        return null;
    }

    public HTMLEditorKit.ParserCallback getReader(int n, int n2, int n3, HTML.Tag tag) {
        return null;
    }

    public URL getBase() {
        return null;
    }

    public void setBase(URL uRL) {
    }

    protected void insert(int n, DefaultStyledDocument.ElementSpec[] elementSpecArray) throws BadLocationException {
    }

    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
    }

    protected void create(DefaultStyledDocument.ElementSpec[] elementSpecArray) {
    }

    public void setParagraphAttributes(int n, int n2, AttributeSet attributeSet, boolean bl) {
    }

    public StyleSheet getStyleSheet() {
        return null;
    }

    public Iterator getIterator(HTML.Tag tag) {
        return null;
    }

    protected Element createLeafElement(Element element, AttributeSet attributeSet, int n, int n2) {
        return null;
    }

    protected Element createBranchElement(Element element, AttributeSet attributeSet) {
        return null;
    }

    protected AbstractDocument.AbstractElement createDefaultRoot() {
        return null;
    }

    public void setTokenThreshold(int n) {
    }

    public int getTokenThreshold() {
        return 0;
    }

    public void setPreservesUnknownTags(boolean bl) {
    }

    public boolean getPreservesUnknownTags() {
        return false;
    }

    public void processHTMLFrameHyperlinkEvent(HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent) {
    }

    public void setParser(HTMLEditorKit.Parser parser) {
    }

    public HTMLEditorKit.Parser getParser() {
        return null;
    }

    public void setInnerHTML(Element element, String string) throws BadLocationException, IOException {
    }

    public void setOuterHTML(Element element, String string) throws BadLocationException, IOException {
    }

    public void insertAfterStart(Element element, String string) throws BadLocationException, IOException {
    }

    public void insertBeforeEnd(Element element, String string) throws BadLocationException, IOException {
    }

    public void insertBeforeStart(Element element, String string) throws BadLocationException, IOException {
    }

    public void insertAfterEnd(Element element, String string) throws BadLocationException, IOException {
    }

    public Element getElement(String string) {
        return null;
    }

    public Element getElement(Element element, Object object, Object object2) {
        return null;
    }

    protected void fireChangedUpdate(DocumentEvent documentEvent) {
    }

    protected void fireUndoableEditUpdate(UndoableEditEvent undoableEditEvent) {
    }

    public class BlockElement
    extends AbstractDocument.BranchElement {
        public BlockElement(HTMLDocument hTMLDocument, Element element, AttributeSet attributeSet) {
        }

        public String getName() {
            return null;
        }

        public AttributeSet getResolveParent() {
            return null;
        }
    }

    private static class FixedLengthDocument
    extends PlainDocument {
        private int maxLength;

        public FixedLengthDocument(int maxLength) {
            this.maxLength = maxLength;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            if (str != null && str.length() + this.getLength() <= this.maxLength) {
                super.insertString(offset, str, a);
            }
        }
    }

    public class HTMLReader
    extends HTMLEditorKit.ParserCallback {
        protected Vector<DefaultStyledDocument.ElementSpec> parseBuffer;
        protected MutableAttributeSet charAttr;

        public HTMLReader(HTMLDocument hTMLDocument, int n) {
        }

        public HTMLReader(HTMLDocument hTMLDocument, int n, int n2, int n3, HTML.Tag tag) {
        }

        public void flush() throws BadLocationException {
        }

        public void handleText(char[] cArray, int n) {
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
        }

        public void handleComment(char[] cArray, int n) {
        }

        public void handleEndTag(HTML.Tag tag, int n) {
        }

        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
        }

        public void handleEndOfLineString(String string) {
        }

        protected void registerTag(HTML.Tag tag, TagAction tagAction) {
        }

        protected void pushCharacterStyle() {
        }

        protected void popCharacterStyle() {
        }

        protected void textAreaContent(char[] cArray) {
        }

        protected void preContent(char[] cArray) {
        }

        protected void blockOpen(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
        }

        protected void blockClose(HTML.Tag tag) {
        }

        protected void addContent(char[] cArray, int n, int n2) {
        }

        protected void addContent(char[] cArray, int n, int n2, boolean bl) {
        }

        protected void addSpecialElement(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
        }

        class AnchorAction
        extends CharacterAction {
            AnchorAction() {
                super(HTMLReader.this);
            }

            @Override
            public void start(HTML.Tag t, MutableAttributeSet attr) {
                HTMLReader.this.emptyAnchor = true;
                super.start(t, attr);
            }

            @Override
            public void end(HTML.Tag t) {
                if (HTMLReader.this.emptyAnchor) {
                    char[] one = new char[]{'\n'};
                    HTMLReader.this.addContent(one, 0, 1);
                }
                super.end(t);
            }
        }

        class AreaAction
        extends TagAction {
            AreaAction() {
                super(HTMLReader.this);
            }

            @Override
            public void start(HTML.Tag t, MutableAttributeSet a) {
                if (HTMLReader.this.lastMap != null) {
                    HTMLReader.this.lastMap.addArea(a.copyAttributes());
                }
            }

            @Override
            public void end(HTML.Tag t) {
            }
        }

        class BaseAction
        extends TagAction {
            BaseAction() {
                super(HTMLReader.this);
            }

            @Override
            public void start(HTML.Tag t, MutableAttributeSet attr) {
                String href = (String)attr.getAttribute(HTML.Attribute.HREF);
                if (href != null) {
                    try {
                        URL newBase = new URL(HTMLReader.this.this$0.base, href);
                        HTMLReader.this.this$0.setBase(newBase);
                        HTMLReader.this.this$0.hasBaseTag = true;
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                HTMLReader.this.this$0.baseTarget = (String)attr.getAttribute(HTML.Attribute.TARGET);
            }
        }

        public class BlockAction
        extends TagAction {
            public BlockAction(HTMLReader hTMLReader) {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            }

            public void end(HTML.Tag tag) {
            }
        }

        public class CharacterAction
        extends TagAction {
            public CharacterAction(HTMLReader hTMLReader) {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            }

            public void end(HTML.Tag tag) {
            }
        }

        final class ConvertAction
        extends CharacterAction {
            ConvertAction() {
                super(HTMLReader.this);
            }

            void convertAttributes(HTML.Tag t, MutableAttributeSet attr) {
                StyleSheet sheet = HTMLReader.this.this$0.getStyleSheet();
                if (t == HTML.Tag.B) {
                    sheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.FONT_WEIGHT, "bold");
                } else if (t == HTML.Tag.I) {
                    sheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.FONT_STYLE, "italic");
                } else if (t == HTML.Tag.U) {
                    Object v = HTMLReader.this.charAttr.getAttribute(CSS.Attribute.TEXT_DECORATION);
                    String value = "underline";
                    value = v != null ? value + "," + v.toString() : value;
                    sheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.TEXT_DECORATION, value);
                } else if (t == HTML.Tag.STRIKE || t == HTML.Tag.S) {
                    Object v = HTMLReader.this.charAttr.getAttribute(CSS.Attribute.TEXT_DECORATION);
                    String value = "line-through";
                    value = v != null ? value + "," + v.toString() : value;
                    sheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.TEXT_DECORATION, value);
                } else if (t == HTML.Tag.SUP) {
                    Object v = HTMLReader.this.charAttr.getAttribute(CSS.Attribute.VERTICAL_ALIGN);
                    String value = "sup";
                    value = v != null ? value + "," + v.toString() : value;
                    sheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.VERTICAL_ALIGN, value);
                } else if (t == HTML.Tag.SUB) {
                    Object v = HTMLReader.this.charAttr.getAttribute(CSS.Attribute.VERTICAL_ALIGN);
                    String value = "sub";
                    value = v != null ? value + "," + v.toString() : value;
                    sheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.VERTICAL_ALIGN, value);
                } else if (t == HTML.Tag.FONT) {
                    String size;
                    String face;
                    String color = (String)attr.getAttribute(HTML.Attribute.COLOR);
                    if (color != null) {
                        sheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.COLOR, color);
                    }
                    if ((face = (String)attr.getAttribute(HTML.Attribute.FACE)) != null) {
                        sheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.FONT_FAMILY, face);
                    }
                    if ((size = (String)attr.getAttribute(HTML.Attribute.SIZE)) != null) {
                        sheet.addCSSAttributeFromHTML(HTMLReader.this.charAttr, CSS.Attribute.FONT_SIZE, size);
                    }
                }
            }
        }

        public class FormAction
        extends SpecialAction {
            public FormAction(HTMLReader hTMLReader) {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            }

            public void end(HTML.Tag tag) {
            }
        }

        private class FormTagAction
        extends BlockAction {
            private FormTagAction() {
                super(HTMLReader.this);
            }

            @Override
            public void start(HTML.Tag t, MutableAttributeSet attr) {
                super.start(t, attr);
                HTMLReader.this.this$0.radioButtonGroupsMap = new HashMap();
            }

            @Override
            public void end(HTML.Tag t) {
                super.end(t);
                HTMLReader.this.this$0.radioButtonGroupsMap = null;
            }
        }

        class HeadAction
        extends BlockAction {
            HeadAction() {
                super(HTMLReader.this);
            }

            @Override
            public void start(HTML.Tag t, MutableAttributeSet a) {
                HTMLReader.this.inHead = true;
                if (HTMLReader.this.insertTag == null && !HTMLReader.this.insertAfterImplied || HTMLReader.this.insertTag == HTML.Tag.HEAD || HTMLReader.this.insertAfterImplied && (HTMLReader.this.foundInsertTag || !a.isDefined(HTMLEditorKit.ParserCallback.IMPLIED))) {
                    super.start(t, a);
                }
            }

            @Override
            public void end(HTML.Tag t) {
                HTMLReader.this.inStyle = false;
                HTMLReader.this.inHead = false;
                if (HTMLReader.this.styles != null) {
                    boolean isDefaultCSS = HTMLReader.this.isStyleCSS;
                    int counter = 0;
                    int maxCounter = HTMLReader.this.styles.size();
                    while (counter < maxCounter) {
                        String type;
                        boolean isCSS;
                        Object value = HTMLReader.this.styles.elementAt(counter);
                        if (value == HTML.Tag.LINK) {
                            this.handleLink((AttributeSet)HTMLReader.this.styles.elementAt(++counter));
                            ++counter;
                            continue;
                        }
                        boolean bl = isCSS = (type = (String)HTMLReader.this.styles.elementAt(++counter)) == null ? isDefaultCSS : type.equals("text/css");
                        while (++counter < maxCounter && HTMLReader.this.styles.elementAt(counter) instanceof String) {
                            if (!isCSS) continue;
                            HTMLReader.this.addCSSRules((String)HTMLReader.this.styles.elementAt(counter));
                        }
                    }
                }
                if (HTMLReader.this.insertTag == null && !HTMLReader.this.insertAfterImplied || HTMLReader.this.insertTag == HTML.Tag.HEAD || HTMLReader.this.insertAfterImplied && HTMLReader.this.foundInsertTag) {
                    super.end(t);
                }
            }

            boolean isEmpty(HTML.Tag t) {
                return false;
            }

            private void handleLink(AttributeSet attr) {
                String type = (String)attr.getAttribute(HTML.Attribute.TYPE);
                if (type == null) {
                    type = HTMLReader.this.this$0.getDefaultStyleSheetType();
                }
                if (type.equals("text/css")) {
                    String rel = (String)attr.getAttribute(HTML.Attribute.REL);
                    String title = (String)attr.getAttribute(HTML.Attribute.TITLE);
                    String media = (String)attr.getAttribute(HTML.Attribute.MEDIA);
                    media = media == null ? "all" : media.toLowerCase();
                    if (rel != null) {
                        rel = rel.toLowerCase();
                        if ((media.contains("all") || media.contains("screen")) && (rel.equals("stylesheet") || rel.equals("alternate stylesheet") && title.equals(HTMLReader.this.defaultStyle))) {
                            HTMLReader.this.linkCSSStyleSheet((String)attr.getAttribute(HTML.Attribute.HREF));
                        }
                    }
                }
            }
        }

        public class HiddenAction
        extends TagAction {
            public HiddenAction(HTMLReader hTMLReader) {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            }

            public void end(HTML.Tag tag) {
            }
        }

        public class IsindexAction
        extends TagAction {
            public IsindexAction(HTMLReader hTMLReader) {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            }
        }

        class LinkAction
        extends HiddenAction {
            LinkAction() {
                super(HTMLReader.this);
            }

            @Override
            public void start(HTML.Tag t, MutableAttributeSet a) {
                String rel = (String)a.getAttribute(HTML.Attribute.REL);
                if (rel != null && ((rel = rel.toLowerCase()).equals("stylesheet") || rel.equals("alternate stylesheet"))) {
                    if (HTMLReader.this.styles == null) {
                        HTMLReader.this.styles = new Vector(3);
                    }
                    HTMLReader.this.styles.addElement(t);
                    HTMLReader.this.styles.addElement(a.copyAttributes());
                }
                super.start(t, a);
            }
        }

        class MapAction
        extends TagAction {
            MapAction() {
                super(HTMLReader.this);
            }

            @Override
            public void start(HTML.Tag t, MutableAttributeSet a) {
                HTMLReader.this.lastMap = new Map((String)a.getAttribute(HTML.Attribute.NAME));
                HTMLReader.this.this$0.addMap(HTMLReader.this.lastMap);
            }

            @Override
            public void end(HTML.Tag t) {
            }
        }

        class MetaAction
        extends HiddenAction {
            MetaAction() {
                super(HTMLReader.this);
            }

            @Override
            public void start(HTML.Tag t, MutableAttributeSet a) {
                Object equiv = a.getAttribute(HTML.Attribute.HTTPEQUIV);
                if (equiv != null) {
                    if ((equiv = ((String)equiv).toLowerCase()).equals("content-style-type")) {
                        String value = (String)a.getAttribute(HTML.Attribute.CONTENT);
                        HTMLReader.this.this$0.setDefaultStyleSheetType(value);
                        HTMLReader.this.isStyleCSS = "text/css".equals(HTMLReader.this.this$0.getDefaultStyleSheetType());
                    } else if (equiv.equals("default-style")) {
                        HTMLReader.this.defaultStyle = (String)a.getAttribute(HTML.Attribute.CONTENT);
                    }
                }
                super.start(t, a);
            }

            boolean isEmpty(HTML.Tag t) {
                return true;
            }
        }

        class ObjectAction
        extends SpecialAction {
            ObjectAction() {
                super(HTMLReader.this);
            }

            @Override
            public void start(HTML.Tag t, MutableAttributeSet a) {
                if (t == HTML.Tag.PARAM) {
                    this.addParameter(a);
                } else {
                    super.start(t, a);
                }
            }

            @Override
            public void end(HTML.Tag t) {
                if (t != HTML.Tag.PARAM) {
                    super.end(t);
                }
            }

            void addParameter(AttributeSet a) {
                String name = (String)a.getAttribute(HTML.Attribute.NAME);
                String value = (String)a.getAttribute(HTML.Attribute.VALUE);
                if (name != null && value != null) {
                    DefaultStyledDocument.ElementSpec objSpec = HTMLReader.this.parseBuffer.lastElement();
                    MutableAttributeSet objAttr = (MutableAttributeSet)objSpec.getAttributes();
                    objAttr.addAttribute(name, value);
                }
            }
        }

        public class ParagraphAction
        extends BlockAction {
            public ParagraphAction(HTMLReader hTMLReader) {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            }

            public void end(HTML.Tag tag) {
            }
        }

        public class PreAction
        extends BlockAction {
            public PreAction(HTMLReader hTMLReader) {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            }

            public void end(HTML.Tag tag) {
            }
        }

        public class SpecialAction
        extends TagAction {
            public SpecialAction(HTMLReader hTMLReader) {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            }
        }

        class StyleAction
        extends TagAction {
            StyleAction() {
                super(HTMLReader.this);
            }

            @Override
            public void start(HTML.Tag t, MutableAttributeSet a) {
                if (HTMLReader.this.inHead) {
                    if (HTMLReader.this.styles == null) {
                        HTMLReader.this.styles = new Vector(3);
                    }
                    HTMLReader.this.styles.addElement(t);
                    HTMLReader.this.styles.addElement(a.getAttribute(HTML.Attribute.TYPE));
                    HTMLReader.this.inStyle = true;
                }
            }

            @Override
            public void end(HTML.Tag t) {
                HTMLReader.this.inStyle = false;
            }

            boolean isEmpty(HTML.Tag t) {
                return false;
            }
        }

        public class TagAction {
            public TagAction(HTMLReader hTMLReader) {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            }

            public void end(HTML.Tag tag) {
            }
        }

        class TitleAction
        extends HiddenAction {
            TitleAction() {
                super(HTMLReader.this);
            }

            @Override
            public void start(HTML.Tag t, MutableAttributeSet attr) {
                HTMLReader.this.inTitle = true;
                super.start(t, attr);
            }

            @Override
            public void end(HTML.Tag t) {
                HTMLReader.this.inTitle = false;
                super.end(t);
            }

            boolean isEmpty(HTML.Tag t) {
                return false;
            }
        }
    }

    public static abstract class Iterator {
        public abstract AttributeSet getAttributes();

        public abstract int getStartOffset();

        public abstract int getEndOffset();

        public abstract void next();

        public abstract boolean isValid();

        public abstract HTML.Tag getTag();
    }

    static class LeafIterator
    extends Iterator {
        private int endOffset;
        private HTML.Tag tag;
        private ElementIterator pos;

        LeafIterator(HTML.Tag t, Document doc) {
            this.tag = t;
            this.pos = new ElementIterator(doc);
            this.endOffset = 0;
            this.next();
        }

        @Override
        public AttributeSet getAttributes() {
            Element elem = this.pos.current();
            if (elem != null) {
                AttributeSet a = (AttributeSet)elem.getAttributes().getAttribute(this.tag);
                if (a == null) {
                    a = elem.getAttributes();
                }
                return a;
            }
            return null;
        }

        @Override
        public int getStartOffset() {
            Element elem = this.pos.current();
            if (elem != null) {
                return elem.getStartOffset();
            }
            return -1;
        }

        @Override
        public int getEndOffset() {
            return this.endOffset;
        }

        @Override
        public void next() {
            this.nextLeaf(this.pos);
            while (this.isValid()) {
                AttributeSet a;
                Element elem = this.pos.current();
                if (elem.getStartOffset() >= this.endOffset && ((a = this.pos.current().getAttributes()).isDefined(this.tag) || a.getAttribute(StyleConstants.NameAttribute) == this.tag)) {
                    this.setEndOffset();
                    break;
                }
                this.nextLeaf(this.pos);
            }
        }

        @Override
        public HTML.Tag getTag() {
            return this.tag;
        }

        @Override
        public boolean isValid() {
            return this.pos.current() != null;
        }

        void nextLeaf(ElementIterator iter) {
            Element e;
            iter.next();
            while (iter.current() != null && !(e = iter.current()).isLeaf()) {
                iter.next();
            }
        }

        void setEndOffset() {
            Element e;
            AttributeSet a1;
            AttributeSet a0 = this.getAttributes();
            this.endOffset = this.pos.current().getEndOffset();
            ElementIterator fwd = (ElementIterator)this.pos.clone();
            this.nextLeaf(fwd);
            while (fwd.current() != null && (a1 = (AttributeSet)(e = fwd.current()).getAttributes().getAttribute(this.tag)) != null && a1.equals(a0)) {
                this.endOffset = e.getEndOffset();
                this.nextLeaf(fwd);
            }
        }
    }

    public class RunElement
    extends AbstractDocument.LeafElement {
        public RunElement(HTMLDocument hTMLDocument, Element element, AttributeSet attributeSet, int n, int n2) {
        }

        public String getName() {
            return null;
        }

        public AttributeSet getResolveParent() {
            return null;
        }
    }

    static class TaggedAttributeSet
    extends SimpleAttributeSet {
        TaggedAttributeSet() {
        }
    }
}

