/*
 * Decompiled with CFR 0.152.
 */
package org.xml.sax.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NamespaceSupport {
    public static final String XMLNS = "http://www.w3.org/XML/1998/namespace";
    public static final String NSDECL = "http://www.w3.org/xmlns/2000/";

    public void reset() {
    }

    public void pushContext() {
    }

    public void popContext() {
    }

    public boolean declarePrefix(String string, String string2) {
        return false;
    }

    public String[] processName(String string, String[] stringArray, boolean bl) {
        return null;
    }

    public String getURI(String string) {
        return null;
    }

    public Enumeration getPrefixes() {
        return null;
    }

    public String getPrefix(String string) {
        return null;
    }

    public Enumeration getPrefixes(String string) {
        return null;
    }

    public Enumeration getDeclaredPrefixes() {
        return null;
    }

    public void setNamespaceDeclUris(boolean bl) {
    }

    public boolean isNamespaceDeclUris() {
        return false;
    }

    final class Context {
        Map<String, String> prefixTable;
        Map<String, String> uriTable;
        Map<String, String[]> elementNameTable;
        Map<String, String[]> attributeNameTable;
        String defaultNS = null;
        private List<String> declarations = null;
        private boolean declSeen = false;
        private Context parent = null;

        Context() {
            this.copyTables();
        }

        void setParent(Context parent) {
            this.parent = parent;
            this.declarations = null;
            this.prefixTable = parent.prefixTable;
            this.uriTable = parent.uriTable;
            this.elementNameTable = parent.elementNameTable;
            this.attributeNameTable = parent.attributeNameTable;
            this.defaultNS = parent.defaultNS;
            this.declSeen = false;
        }

        void clear() {
            this.parent = null;
            this.prefixTable = null;
            this.uriTable = null;
            this.elementNameTable = null;
            this.attributeNameTable = null;
            this.defaultNS = null;
        }

        void declarePrefix(String prefix, String uri) {
            if (!this.declSeen) {
                this.copyTables();
            }
            if (this.declarations == null) {
                this.declarations = new ArrayList<String>();
            }
            prefix = prefix.intern();
            uri = uri.intern();
            if ("".equals(prefix)) {
                this.defaultNS = "".equals(uri) ? null : uri;
            } else {
                this.prefixTable.put(prefix, uri);
                this.uriTable.put(uri, prefix);
            }
            this.declarations.add(prefix);
        }

        String[] processName(String qName, boolean isAttribute) {
            Map<String, String[]> table = isAttribute ? this.attributeNameTable : this.elementNameTable;
            String[] name = table.get(qName);
            if (name != null) {
                return name;
            }
            name = new String[3];
            name[2] = qName.intern();
            int index = qName.indexOf(58);
            if (index == -1) {
                name[0] = isAttribute ? (qName == "xmlns" && NamespaceSupport.this.namespaceDeclUris ? NamespaceSupport.NSDECL : "") : (this.defaultNS == null ? "" : this.defaultNS);
                name[1] = name[2];
            } else {
                String prefix = qName.substring(0, index);
                String local = qName.substring(index + 1);
                String uri = "".equals(prefix) ? this.defaultNS : this.prefixTable.get(prefix);
                if (uri == null || !isAttribute && "xmlns".equals(prefix)) {
                    return null;
                }
                name[0] = uri;
                name[1] = local.intern();
            }
            table.put(name[2], name);
            return name;
        }

        String getURI(String prefix) {
            if ("".equals(prefix)) {
                return this.defaultNS;
            }
            if (this.prefixTable == null) {
                return null;
            }
            return this.prefixTable.get(prefix);
        }

        String getPrefix(String uri) {
            if (this.uriTable == null) {
                return null;
            }
            return this.uriTable.get(uri);
        }

        Enumeration<String> getDeclaredPrefixes() {
            if (this.declarations == null) {
                return EMPTY_ENUMERATION;
            }
            return Collections.enumeration(this.declarations);
        }

        Enumeration<String> getPrefixes() {
            if (this.prefixTable == null) {
                return EMPTY_ENUMERATION;
            }
            return Collections.enumeration(this.prefixTable.keySet());
        }

        private void copyTables() {
            this.prefixTable = this.prefixTable != null ? new HashMap<String, String>(this.prefixTable) : new HashMap<String, String>();
            this.uriTable = this.uriTable != null ? new HashMap<String, String>(this.uriTable) : new HashMap<String, String>();
            this.elementNameTable = new HashMap<String, String[]>();
            this.attributeNameTable = new HashMap<String, String[]>();
            this.declSeen = true;
        }
    }
}

