/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.IPrimitives;
import alice.tuprolog.Library;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PrimitiveInfo {
    public static final int DIRECTIVE = 0;
    public static final int PREDICATE = 1;
    public static final int FUNCTOR = 2;
    private int type;
    private Method method;
    private IPrimitives source;
    private Term[] primitive_args;
    private String primitive_key;

    public PrimitiveInfo(int n, String string, Library library, Method method, int n2) throws NoSuchMethodException {
        if (method == null) {
            throw new NoSuchMethodException();
        }
        this.type = n;
        this.primitive_key = string;
        this.source = library;
        this.method = method;
        this.primitive_args = new Term[n2];
    }

    public String invalidate() {
        String string = this.primitive_key;
        this.primitive_key = null;
        return string;
    }

    public String getKey() {
        return this.primitive_key;
    }

    public boolean isDirective() {
        return this.type == 0;
    }

    public boolean isFunctor() {
        return this.type == 2;
    }

    public boolean isPredicate() {
        return this.type == 1;
    }

    public int getType() {
        return this.type;
    }

    public IPrimitives getSource() {
        return this.source;
    }

    public void evalAsDirective(Struct struct) throws IllegalAccessException, InvocationTargetException {
        for (int i = 0; i < this.primitive_args.length; ++i) {
            this.primitive_args[i] = struct.getTerm(i);
        }
        this.method.invoke((Object)this.source, (Object[])this.primitive_args);
    }

    public boolean evalAsPredicate(Struct struct) throws Throwable {
        for (int i = 0; i < this.primitive_args.length; ++i) {
            this.primitive_args[i] = struct.getArg(i);
        }
        try {
            return (Boolean)this.method.invoke((Object)this.source, (Object[])this.primitive_args);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
    }

    public Term evalAsFunctor(Struct struct) {
        try {
            for (int i = 0; i < this.primitive_args.length; ++i) {
                this.primitive_args[i] = struct.getTerm(i);
            }
            return (Term)this.method.invoke((Object)this.source, (Object[])this.primitive_args);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString() {
        return "[ primitive: method " + this.method.getName() + " - " + this.primitive_args + " - N args: " + this.primitive_args.length + " - " + this.source.getClass().getName() + " ]\n";
    }
}

