/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Iterator;
import sun.security.jca.GetInstance;

public abstract class KeyPairGenerator
extends KeyPairGeneratorSpi {
    protected KeyPairGenerator(String string) {
    }

    public String getAlgorithm() {
        return null;
    }

    public static KeyPairGenerator getInstance(String string) throws NoSuchAlgorithmException {
        return null;
    }

    public static KeyPairGenerator getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        return null;
    }

    public static KeyPairGenerator getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        return null;
    }

    public final Provider getProvider() {
        return null;
    }

    public void initialize(int n) {
    }

    public void initialize(int n, SecureRandom secureRandom) {
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
    }

    public final KeyPair genKeyPair() {
        return null;
    }

    public KeyPair generateKeyPair() {
        return null;
    }

    private static final class Delegate
    extends KeyPairGenerator {
        private volatile KeyPairGeneratorSpi spi;
        private final Object lock = new Object();
        private Iterator<Provider.Service> serviceIterator;
        private static final int I_NONE = 1;
        private static final int I_SIZE = 2;
        private static final int I_PARAMS = 3;
        private int initType;
        private int initKeySize;
        private AlgorithmParameterSpec initParams;
        private SecureRandom initRandom;

        Delegate(KeyPairGeneratorSpi spi, String algorithm) {
            super(algorithm);
            this.spi = spi;
        }

        Delegate(GetInstance.Instance instance, Iterator<Provider.Service> serviceIterator, String algorithm) {
            super(algorithm);
            this.spi = (KeyPairGeneratorSpi)instance.impl;
            this.provider = instance.provider;
            this.serviceIterator = serviceIterator;
            this.initType = 1;
            if (!skipDebug && pdebug != null) {
                pdebug.println("KeyPairGenerator." + algorithm + " algorithm from: " + this.provider.getName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private KeyPairGeneratorSpi nextSpi(KeyPairGeneratorSpi oldSpi, boolean reinit) {
            Object object = this.lock;
            synchronized (object) {
                if (oldSpi != null && oldSpi != this.spi) {
                    return this.spi;
                }
                if (this.serviceIterator == null) {
                    return null;
                }
                while (this.serviceIterator.hasNext()) {
                    Provider.Service s = this.serviceIterator.next();
                    try {
                        Object inst = s.newInstance(null);
                        if (!(inst instanceof KeyPairGeneratorSpi)) continue;
                        KeyPairGeneratorSpi spi = (KeyPairGeneratorSpi)inst;
                        if (inst instanceof KeyPairGenerator) continue;
                        if (reinit) {
                            if (this.initType == 2) {
                                spi.initialize(this.initKeySize, this.initRandom);
                            } else if (this.initType == 3) {
                                spi.initialize(this.initParams, this.initRandom);
                            } else if (this.initType != 1) {
                                throw new AssertionError((Object)("KeyPairGenerator initType: " + this.initType));
                            }
                        }
                        this.provider = s.getProvider();
                        this.spi = spi;
                        return spi;
                    }
                    catch (Exception exception) {
                    }
                }
                this.disableFailover();
                return null;
            }
        }

        void disableFailover() {
            this.serviceIterator = null;
            this.initType = 0;
            this.initParams = null;
            this.initRandom = null;
        }

        @Override
        public void initialize(int keysize, SecureRandom random) {
            if (this.serviceIterator == null) {
                this.spi.initialize(keysize, random);
                return;
            }
            RuntimeException failure = null;
            KeyPairGeneratorSpi mySpi = this.spi;
            while (true) {
                try {
                    mySpi.initialize(keysize, random);
                    this.initType = 2;
                    this.initKeySize = keysize;
                    this.initParams = null;
                    this.initRandom = random;
                    return;
                }
                catch (RuntimeException e) {
                    if (failure != null) continue;
                    failure = e;
                    if ((mySpi = this.nextSpi(mySpi, false)) != null) continue;
                    throw failure;
                }
                break;
            }
        }

        @Override
        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (this.serviceIterator == null) {
                this.spi.initialize(params, random);
                return;
            }
            Exception failure = null;
            KeyPairGeneratorSpi mySpi = this.spi;
            while (true) {
                try {
                    mySpi.initialize(params, random);
                    this.initType = 3;
                    this.initKeySize = 0;
                    this.initParams = params;
                    this.initRandom = random;
                    return;
                }
                catch (Exception e) {
                    if (failure != null) continue;
                    failure = e;
                    if ((mySpi = this.nextSpi(mySpi, false)) != null) continue;
                    if (failure instanceof RuntimeException) {
                        throw (RuntimeException)failure;
                    }
                    throw (InvalidAlgorithmParameterException)failure;
                }
                break;
            }
        }

        @Override
        public KeyPair generateKeyPair() {
            if (this.serviceIterator == null) {
                return this.spi.generateKeyPair();
            }
            RuntimeException failure = null;
            KeyPairGeneratorSpi mySpi = this.spi;
            while (true) {
                try {
                    return mySpi.generateKeyPair();
                }
                catch (RuntimeException e) {
                    if (failure != null) continue;
                    failure = e;
                    if ((mySpi = this.nextSpi(mySpi, true)) != null) continue;
                    throw failure;
                }
                break;
            }
        }
    }
}

