/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    public ArrayBlockingQueue(int n) {
    }

    public ArrayBlockingQueue(int n, boolean bl) {
    }

    public ArrayBlockingQueue(int n, boolean bl, Collection<? extends E> collection) {
    }

    @Override
    public boolean offer(E e) {
        return false;
    }

    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) throws InterruptedException {
        return false;
    }

    @Override
    public E poll() {
        return null;
    }

    @Override
    public E poll(long l, TimeUnit timeUnit) throws InterruptedException {
        return null;
    }

    @Override
    public boolean remove(Object object) {
        return false;
    }

    @Override
    public E peek() {
        return null;
    }

    @Override
    public E take() throws InterruptedException {
        return null;
    }

    @Override
    public void put(E e) throws InterruptedException {
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public int remainingCapacity() {
        return 0;
    }

    @Override
    public boolean contains(Object object) {
        return false;
    }

    @Override
    public Object[] toArray() {
        return null;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return null;
    }

    @Override
    public String toString() {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        return 0;
    }

    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        return 0;
    }

    @Override
    public Iterator<E> iterator() {
        return null;
    }

    private class Itr
    implements Iterator<E> {
        private int cursor;
        private E nextItem;
        private int nextIndex;
        private E lastItem;
        private int lastRet = -1;
        private int prevTakeIndex;
        private int prevCycles;
        private static final int NONE = -1;
        private static final int REMOVED = -2;
        private static final int DETACHED = -3;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Itr() {
            ReentrantLock lock = ArrayBlockingQueue.this.lock;
            lock.lock();
            try {
                if (ArrayBlockingQueue.this.count == 0) {
                    this.cursor = -1;
                    this.nextIndex = -1;
                    this.prevTakeIndex = -3;
                } else {
                    int takeIndex;
                    this.prevTakeIndex = takeIndex = ArrayBlockingQueue.this.takeIndex;
                    this.nextIndex = takeIndex;
                    this.nextItem = ArrayBlockingQueue.this.itemAt(this.nextIndex);
                    this.cursor = this.incCursor(takeIndex);
                    if (ArrayBlockingQueue.this.itrs == null) {
                        ArrayBlockingQueue.this.itrs = new Itrs(ArrayBlockingQueue.this, this);
                    } else {
                        ArrayBlockingQueue.this.itrs.register(this);
                        ArrayBlockingQueue.this.itrs.doSomeSweeping(false);
                    }
                    this.prevCycles = ArrayBlockingQueue.this.itrs.cycles;
                }
            }
            finally {
                lock.unlock();
            }
        }

        boolean isDetached() {
            return this.prevTakeIndex < 0;
        }

        private int incCursor(int index) {
            if (++index == ArrayBlockingQueue.this.items.length) {
                index = 0;
            }
            if (index == ArrayBlockingQueue.this.putIndex) {
                index = -1;
            }
            return index;
        }

        private boolean invalidated(int index, int prevTakeIndex, long dequeues, int length) {
            if (index < 0) {
                return false;
            }
            int distance = index - prevTakeIndex;
            if (distance < 0) {
                distance += length;
            }
            return dequeues > (long)distance;
        }

        private void incorporateDequeues() {
            int cycles = ArrayBlockingQueue.this.itrs.cycles;
            int takeIndex = ArrayBlockingQueue.this.takeIndex;
            int prevCycles = this.prevCycles;
            int prevTakeIndex = this.prevTakeIndex;
            if (cycles != prevCycles || takeIndex != prevTakeIndex) {
                int len = ArrayBlockingQueue.this.items.length;
                long dequeues = (long)(cycles - prevCycles) * (long)len + (long)(takeIndex - prevTakeIndex);
                if (this.invalidated(this.lastRet, prevTakeIndex, dequeues, len)) {
                    this.lastRet = -2;
                }
                if (this.invalidated(this.nextIndex, prevTakeIndex, dequeues, len)) {
                    this.nextIndex = -2;
                }
                if (this.invalidated(this.cursor, prevTakeIndex, dequeues, len)) {
                    this.cursor = takeIndex;
                }
                if (this.cursor < 0 && this.nextIndex < 0 && this.lastRet < 0) {
                    this.detach();
                } else {
                    this.prevCycles = cycles;
                    this.prevTakeIndex = takeIndex;
                }
            }
        }

        private void detach() {
            if (this.prevTakeIndex >= 0) {
                this.prevTakeIndex = -3;
                ArrayBlockingQueue.this.itrs.doSomeSweeping(true);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.nextItem != null) {
                return true;
            }
            this.noNext();
            return false;
        }

        private void noNext() {
            ReentrantLock lock = ArrayBlockingQueue.this.lock;
            lock.lock();
            try {
                if (!this.isDetached()) {
                    this.incorporateDequeues();
                    if (this.lastRet >= 0) {
                        this.lastItem = ArrayBlockingQueue.this.itemAt(this.lastRet);
                        this.detach();
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            Object e = this.nextItem;
            if (e == null) {
                throw new NoSuchElementException();
            }
            ReentrantLock lock = ArrayBlockingQueue.this.lock;
            lock.lock();
            try {
                if (!this.isDetached()) {
                    this.incorporateDequeues();
                }
                this.lastRet = this.nextIndex;
                int cursor = this.cursor;
                if (cursor >= 0) {
                    this.nextIndex = cursor;
                    this.nextItem = ArrayBlockingQueue.this.itemAt(this.nextIndex);
                    this.cursor = this.incCursor(cursor);
                } else {
                    this.nextIndex = -1;
                    this.nextItem = null;
                    if (this.lastRet == -2) {
                        this.detach();
                    }
                }
            }
            finally {
                lock.unlock();
            }
            return e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            ReentrantLock lock = ArrayBlockingQueue.this.lock;
            lock.lock();
            try {
                int to;
                Object e = this.nextItem;
                if (e == null) {
                    return;
                }
                if (!this.isDetached()) {
                    this.incorporateDequeues();
                }
                action.accept(e);
                if (this.isDetached() || this.cursor < 0) {
                    return;
                }
                Object[] items = ArrayBlockingQueue.this.items;
                int i = this.cursor;
                int end = ArrayBlockingQueue.this.putIndex;
                int n = to = i < end ? end : items.length;
                while (true) {
                    if (i < to) {
                        action.accept(ArrayBlockingQueue.itemAt((Object[])items, (int)i));
                        ++i;
                        continue;
                    }
                    if (to == end) {
                        break;
                    }
                    i = 0;
                    to = end;
                }
            }
            finally {
                this.lastRet = -1;
                this.nextIndex = -1;
                this.cursor = -1;
                this.lastItem = null;
                this.nextItem = null;
                this.detach();
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            ReentrantLock lock = ArrayBlockingQueue.this.lock;
            lock.lock();
            try {
                if (!this.isDetached()) {
                    this.incorporateDequeues();
                }
                int lastRet = this.lastRet;
                this.lastRet = -1;
                if (lastRet >= 0) {
                    if (!this.isDetached()) {
                        ArrayBlockingQueue.this.removeAt(lastRet);
                    } else {
                        Object lastItem = this.lastItem;
                        this.lastItem = null;
                        if (ArrayBlockingQueue.this.itemAt(lastRet) == lastItem) {
                            ArrayBlockingQueue.this.removeAt(lastRet);
                        }
                    }
                } else if (lastRet == -1) {
                    throw new IllegalStateException();
                }
                if (this.cursor < 0 && this.nextIndex < 0) {
                    this.detach();
                }
            }
            finally {
                lock.unlock();
            }
        }

        void shutdown() {
            this.cursor = -1;
            if (this.nextIndex >= 0) {
                this.nextIndex = -2;
            }
            if (this.lastRet >= 0) {
                this.lastRet = -2;
                this.lastItem = null;
            }
            this.prevTakeIndex = -3;
        }

        private int distance(int index, int prevTakeIndex, int length) {
            int distance = index - prevTakeIndex;
            if (distance < 0) {
                distance += length;
            }
            return distance;
        }

        boolean removedAt(int removedIndex) {
            int nextIndex;
            int lastRet;
            if (this.isDetached()) {
                return true;
            }
            int takeIndex = ArrayBlockingQueue.this.takeIndex;
            int prevTakeIndex = this.prevTakeIndex;
            int len = ArrayBlockingQueue.this.items.length;
            int removedDistance = len * (ArrayBlockingQueue.this.itrs.cycles - this.prevCycles + (removedIndex < takeIndex ? 1 : 0)) + (removedIndex - prevTakeIndex);
            int cursor = this.cursor;
            if (cursor >= 0) {
                int x = this.distance(cursor, prevTakeIndex, len);
                if (x == removedDistance) {
                    if (cursor == ArrayBlockingQueue.this.putIndex) {
                        cursor = -1;
                        this.cursor = -1;
                    }
                } else if (x > removedDistance) {
                    this.cursor = cursor = ArrayBlockingQueue.dec((int)cursor, (int)len);
                }
            }
            if ((lastRet = this.lastRet) >= 0) {
                int x = this.distance(lastRet, prevTakeIndex, len);
                if (x == removedDistance) {
                    lastRet = -2;
                    this.lastRet = -2;
                } else if (x > removedDistance) {
                    this.lastRet = lastRet = ArrayBlockingQueue.dec((int)lastRet, (int)len);
                }
            }
            if ((nextIndex = this.nextIndex) >= 0) {
                int x = this.distance(nextIndex, prevTakeIndex, len);
                if (x == removedDistance) {
                    nextIndex = -2;
                    this.nextIndex = -2;
                } else if (x > removedDistance) {
                    this.nextIndex = nextIndex = ArrayBlockingQueue.dec((int)nextIndex, (int)len);
                }
            }
            if (cursor < 0 && nextIndex < 0 && lastRet < 0) {
                this.prevTakeIndex = -3;
                return true;
            }
            return false;
        }

        boolean takeIndexWrapped() {
            if (this.isDetached()) {
                return true;
            }
            if (ArrayBlockingQueue.this.itrs.cycles - this.prevCycles > 1) {
                this.shutdown();
                return true;
            }
            return false;
        }
    }
}

