/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyOnWriteArrayList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    public CopyOnWriteArrayList() {
    }

    public CopyOnWriteArrayList(Collection<? extends E> collection) {
    }

    public CopyOnWriteArrayList(E[] EArray) {
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object object) {
        return false;
    }

    @Override
    public int indexOf(Object object) {
        return 0;
    }

    public int indexOf(E e, int n) {
        return 0;
    }

    @Override
    public int lastIndexOf(Object object) {
        return 0;
    }

    public int lastIndexOf(E e, int n) {
        return 0;
    }

    public Object clone() {
        return null;
    }

    @Override
    public Object[] toArray() {
        return null;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return null;
    }

    @Override
    public E get(int n) {
        return null;
    }

    @Override
    public synchronized E set(int n, E e) {
        return null;
    }

    @Override
    public synchronized boolean add(E e) {
        return false;
    }

    @Override
    public synchronized void add(int n, E e) {
    }

    @Override
    public synchronized E remove(int n) {
        return null;
    }

    @Override
    public synchronized boolean remove(Object object) {
        return false;
    }

    public synchronized boolean addIfAbsent(E e) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return false;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> collection) {
        return false;
    }

    @Override
    public synchronized boolean retainAll(Collection<?> collection) {
        return false;
    }

    public synchronized int addAllAbsent(Collection<? extends E> collection) {
        return 0;
    }

    @Override
    public synchronized void clear() {
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> collection) {
        return false;
    }

    @Override
    public synchronized boolean addAll(int n, Collection<? extends E> collection) {
        return false;
    }

    public String toString() {
        return null;
    }

    @Override
    public boolean equals(Object object) {
        return false;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public Iterator<E> iterator() {
        return null;
    }

    @Override
    public ListIterator<E> listIterator() {
        return null;
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        return null;
    }

    @Override
    public synchronized List<E> subList(int n, int n2) {
        return null;
    }

    static final class COWIterator<E>
    implements ListIterator<E> {
        private final Object[] snapshot;
        private int cursor;

        COWIterator(Object[] es, int initialCursor) {
            this.cursor = initialCursor;
            this.snapshot = es;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.snapshot.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (E)this.snapshot[this.cursor++];
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return (E)this.snapshot[--this.cursor];
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            int size = this.snapshot.length;
            this.cursor = size;
            for (int i = this.cursor; i < size; ++i) {
                action.accept(CopyOnWriteArrayList.elementAt((Object[])this.snapshot, (int)i));
            }
        }
    }

    private class COWSubList
    implements List<E>,
    RandomAccess {
        private final int offset;
        private int size;
        private Object[] expectedArray;

        COWSubList(Object[] es, int offset, int size) {
            this.expectedArray = es;
            this.offset = offset;
            this.size = size;
        }

        private void checkForComodification() {
            if (CopyOnWriteArrayList.this.getArray() != this.expectedArray) {
                throw new ConcurrentModificationException();
            }
        }

        private Object[] getArrayChecked() {
            Object[] a = CopyOnWriteArrayList.this.getArray();
            if (a != this.expectedArray) {
                throw new ConcurrentModificationException();
            }
            return a;
        }

        private void rangeCheck(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException(CopyOnWriteArrayList.outOfBounds((int)index, (int)this.size));
            }
        }

        private void rangeCheckForAdd(int index) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException(CopyOnWriteArrayList.outOfBounds((int)index, (int)this.size));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            int size;
            int offset;
            Object[] es;
            Object object = CopyOnWriteArrayList.this.lock;
            synchronized (object) {
                es = this.getArrayChecked();
                offset = this.offset;
                size = this.size;
            }
            return Arrays.copyOfRange(es, offset, offset + size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            int size;
            int offset;
            Object[] es;
            Object object = CopyOnWriteArrayList.this.lock;
            synchronized (object) {
                es = this.getArrayChecked();
                offset = this.offset;
                size = this.size;
            }
            if (a.length < size) {
                return Arrays.copyOfRange(es, offset, offset + size, a.getClass());
            }
            System.arraycopy(es, offset, a, 0, size);
            if (a.length > size) {
                a[size] = null;
            }
            return a;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object o) {
            int size;
            int offset;
            Object[] es;
            Object object = CopyOnWriteArrayList.this.lock;
            synchronized (object) {
                es = this.getArrayChecked();
                offset = this.offset;
                size = this.size;
            }
            int i = CopyOnWriteArrayList.indexOfRange((Object)o, (Object[])es, (int)offset, (int)(offset + size));
            return i == -1 ? -1 : i - offset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object o) {
            int size;
            int offset;
            Object[] es;
            Object object = CopyOnWriteArrayList.this.lock;
            synchronized (object) {
                es = this.getArrayChecked();
                offset = this.offset;
                size = this.size;
            }
            int i = CopyOnWriteArrayList.lastIndexOfRange((Object)o, (Object[])es, (int)offset, (int)(offset + size));
            return i == -1 ? -1 : i - offset;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) >= 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> c) {
            int size;
            int offset;
            Object[] es;
            Iterator<?> iterator = CopyOnWriteArrayList.this.lock;
            synchronized (iterator) {
                es = this.getArrayChecked();
                offset = this.offset;
                size = this.size;
            }
            for (Object o : c) {
                if (CopyOnWriteArrayList.indexOfRange(o, (Object[])es, (int)offset, (int)(offset + size)) >= 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        public String toString() {
            return Arrays.toString(this.toArray());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            int size;
            int offset;
            Object[] es;
            Object object = CopyOnWriteArrayList.this.lock;
            synchronized (object) {
                es = this.getArrayChecked();
                offset = this.offset;
                size = this.size;
            }
            return CopyOnWriteArrayList.hashCodeOfRange((Object[])es, (int)offset, (int)(offset + size));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            int size;
            int offset;
            Object[] es;
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            Iterator it = ((List)o).iterator();
            Object object = CopyOnWriteArrayList.this.lock;
            synchronized (object) {
                es = this.getArrayChecked();
                offset = this.offset;
                size = this.size;
            }
            int end = offset + size;
            for (int i = offset; i < end; ++i) {
                if (it.hasNext() && Objects.equals(es[i], it.next())) continue;
                return false;
            }
            return !it.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E set(int index, E element) {
            Object object = CopyOnWriteArrayList.this.lock;
            synchronized (object) {
                this.rangeCheck(index);
                this.checkForComodification();
                Object x = CopyOnWriteArrayList.this.set(this.offset + index, element);
                this.expectedArray = CopyOnWriteArrayList.this.getArray();
                return x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E get(int index) {
            Object object = CopyOnWriteArrayList.this.lock;
            synchronized (object) {
                this.rangeCheck(index);
                this.checkForComodification();
                return CopyOnWriteArrayList.this.get(this.offset + index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E getFirst() {
            Object object = CopyOnWriteArrayList.this.lock;
            synchronized (object) {
                if (this.size == 0) {
                    throw new NoSuchElementException();
                }
                return this.get(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E getLast() {
            Object object = CopyOnWriteArrayList.this.lock;
            synchronized (object) {
                if (this.size == 0) {
                    throw new NoSuchElementException();
                }
                return this.get(this.size - 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = CopyOnWriteArrayList.this.lock;
            synchronized (object) {
                this.checkForComodification();
                return this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(E element) {
            Object object = CopyOnWriteArrayList.this.lock;
            synchronized (object) {
                this.checkForComodification();
                CopyOnWriteArrayList.this.add(this.offset + this.size, element);
                this.expectedArray = CopyOnWriteArrayList.this.getArray();
                ++this.size;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int index, E element) {
            Object object = CopyOnWriteArrayList.this.lock;
            synchronized (object) {
                this.checkForComodification();
                this.rangeCheckForAdd(index);
                CopyOnWriteArrayList.this.add(this.offset + index, element);
                this.expectedArray = CopyOnWriteArrayList.this.getArray();
                ++this.size;
            }
        }

        @Override
        public void addFirst(E e) {
            this.add(0, e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addLast(E e) {
            Object object = CopyOnWriteArrayList.this.lock;
            synchronized (object) {
                this.add(this.size, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends E> c) {
            Object object = CopyOnWriteArrayList.this.lock;
            synchronized (object) {
                Object[] oldArray = this.getArrayChecked();
                boolean modified = CopyOnWriteArrayList.this.addAll(this.offset + this.size, c);
                this.expectedArray = CopyOnWriteArrayList.this.getArray();
                this.size += this.expectedArray.length - oldArray.length;
                return modified;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            Object object = CopyOnWriteArrayList.this.lock;
            synchronized (object) {
                this.rangeCheckForAdd(index);
                Object[] oldArray = this.getArrayChecked();
                boolean modified = CopyOnWriteArrayList.this.addAll(this.offset + index, c);
                this.expectedArray = CopyOnWriteArrayList.this.getArray();
                this.size += this.expectedArray.length - oldArray.length;
                return modified;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = CopyOnWriteArrayList.this.lock;
            synchronized (object) {
                this.checkForComodification();
                CopyOnWriteArrayList.this.removeRange(this.offset, this.offset + this.size);
                this.expectedArray = CopyOnWriteArrayList.this.getArray();
                this.size = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E remove(int index) {
            Object object = CopyOnWriteArrayList.this.lock;
            synchronized (object) {
                this.rangeCheck(index);
                this.checkForComodification();
                Object result = CopyOnWriteArrayList.this.remove(this.offset + index);
                this.expectedArray = CopyOnWriteArrayList.this.getArray();
                --this.size;
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E removeFirst() {
            Object object = CopyOnWriteArrayList.this.lock;
            synchronized (object) {
                if (this.size == 0) {
                    throw new NoSuchElementException();
                }
                return this.remove(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E removeLast() {
            Object object = CopyOnWriteArrayList.this.lock;
            synchronized (object) {
                if (this.size == 0) {
                    throw new NoSuchElementException();
                }
                return this.remove(this.size - 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            Object object = CopyOnWriteArrayList.this.lock;
            synchronized (object) {
                this.checkForComodification();
                int index = this.indexOf(o);
                if (index == -1) {
                    return false;
                }
                this.remove(index);
                return true;
            }
        }

        @Override
        public Iterator<E> iterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListIterator<E> listIterator(int index) {
            Object object = CopyOnWriteArrayList.this.lock;
            synchronized (object) {
                this.checkForComodification();
                this.rangeCheckForAdd(index);
                return new COWSubListIterator(CopyOnWriteArrayList.this, index, this.offset, this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            Object object = CopyOnWriteArrayList.this.lock;
            synchronized (object) {
                this.checkForComodification();
                if (fromIndex < 0 || toIndex > this.size || fromIndex > toIndex) {
                    throw new IndexOutOfBoundsException();
                }
                return new COWSubList(this.expectedArray, fromIndex + this.offset, toIndex - fromIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEach(Consumer<? super E> action) {
            int end;
            int i;
            Object[] es;
            Objects.requireNonNull(action);
            Object object = CopyOnWriteArrayList.this.lock;
            synchronized (object) {
                es = this.getArrayChecked();
                end = i + this.size;
            }
            for (i = this.offset; i < end; ++i) {
                action.accept(CopyOnWriteArrayList.elementAt((Object[])es, (int)i));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            Object object = CopyOnWriteArrayList.this.lock;
            synchronized (object) {
                this.checkForComodification();
                CopyOnWriteArrayList.this.replaceAllRange(operator, this.offset, this.offset + this.size);
                this.expectedArray = CopyOnWriteArrayList.this.getArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(Comparator<? super E> c) {
            Object object = CopyOnWriteArrayList.this.lock;
            synchronized (object) {
                this.checkForComodification();
                CopyOnWriteArrayList.this.sortRange(c, this.offset, this.offset + this.size);
                this.expectedArray = CopyOnWriteArrayList.this.getArray();
            }
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            Objects.requireNonNull(c);
            return this.bulkRemove(e -> c.contains(e));
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            Objects.requireNonNull(c);
            return this.bulkRemove(e -> !c.contains(e));
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            Objects.requireNonNull(filter);
            return this.bulkRemove(filter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean bulkRemove(Predicate<? super E> filter) {
            Object object = CopyOnWriteArrayList.this.lock;
            synchronized (object) {
                Object[] oldArray = this.getArrayChecked();
                boolean modified = CopyOnWriteArrayList.this.bulkRemove(filter, this.offset, this.offset + this.size);
                this.expectedArray = CopyOnWriteArrayList.this.getArray();
                this.size += this.expectedArray.length - oldArray.length;
                return modified;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Spliterator<E> spliterator() {
            Object object = CopyOnWriteArrayList.this.lock;
            synchronized (object) {
                return Spliterators.spliterator(this.getArrayChecked(), this.offset, this.offset + this.size, 1040);
            }
        }

        @Override
        public List<E> reversed() {
            return new Reversed(this, CopyOnWriteArrayList.this.lock);
        }
    }

    private static class COWSubListIterator<E>
    implements ListIterator<E> {
        private final ListIterator<E> it;
        private final int offset;
        private final int size;

        COWSubListIterator(List<E> l, int index, int offset, int size) {
            this.offset = offset;
            this.size = size;
            this.it = l.listIterator(index + offset);
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex() < this.size;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                return this.it.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return this.previousIndex() >= 0;
        }

        @Override
        public E previous() {
            if (this.hasPrevious()) {
                return this.it.previous();
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return this.it.nextIndex() - this.offset;
        }

        @Override
        public int previousIndex() {
            return this.it.previousIndex() - this.offset;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            while (this.hasNext()) {
                action.accept(this.it.next());
            }
        }
    }
}

