/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.lang.ref.Reference;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import sun.security.util.SecurityConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Executors {
    public static ExecutorService newFixedThreadPool(int n) {
        return null;
    }

    public static ExecutorService newFixedThreadPool(int n, ThreadFactory threadFactory) {
        return null;
    }

    public static ExecutorService newSingleThreadExecutor() {
        return null;
    }

    public static ExecutorService newSingleThreadExecutor(ThreadFactory threadFactory) {
        return null;
    }

    public static ExecutorService newCachedThreadPool() {
        return null;
    }

    public static ExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
        return null;
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor() {
        return null;
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory threadFactory) {
        return null;
    }

    public static ScheduledExecutorService newScheduledThreadPool(int n) {
        return null;
    }

    public static ScheduledExecutorService newScheduledThreadPool(int n, ThreadFactory threadFactory) {
        return null;
    }

    public static ExecutorService unconfigurableExecutorService(ExecutorService executorService) {
        return null;
    }

    public static ScheduledExecutorService unconfigurableScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        return null;
    }

    public static ThreadFactory defaultThreadFactory() {
        return null;
    }

    public static ThreadFactory privilegedThreadFactory() {
        return null;
    }

    public static <T> Callable<T> callable(Runnable runnable, T t) {
        return null;
    }

    public static Callable<Object> callable(Runnable runnable) {
        return null;
    }

    public static Callable<Object> callable(PrivilegedAction privilegedAction) {
        return null;
    }

    public static Callable<Object> callable(PrivilegedExceptionAction privilegedExceptionAction) {
        return null;
    }

    public static <T> Callable<T> privilegedCallable(Callable<T> callable) {
        return null;
    }

    public static <T> Callable<T> privilegedCallableUsingCurrentClassLoader(Callable<T> callable) {
        return null;
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        DefaultThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "pool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    private static class DelegatedExecutorService
    implements ExecutorService {
        private final ExecutorService e;

        DelegatedExecutorService(ExecutorService executor) {
            this.e = executor;
        }

        @Override
        public void execute(Runnable command) {
            try {
                this.e.execute(command);
            }
            finally {
                Reference.reachabilityFence(this);
            }
        }

        @Override
        public void shutdown() {
            try {
                this.e.shutdown();
            }
            finally {
                Reference.reachabilityFence(this);
            }
        }

        @Override
        public List<Runnable> shutdownNow() {
            try {
                List<Runnable> list = this.e.shutdownNow();
                return list;
            }
            finally {
                Reference.reachabilityFence(this);
            }
        }

        @Override
        public boolean isShutdown() {
            try {
                boolean bl = this.e.isShutdown();
                return bl;
            }
            finally {
                Reference.reachabilityFence(this);
            }
        }

        @Override
        public boolean isTerminated() {
            try {
                boolean bl = this.e.isTerminated();
                return bl;
            }
            finally {
                Reference.reachabilityFence(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            try {
                boolean bl = this.e.awaitTermination(timeout, unit);
                return bl;
            }
            finally {
                Reference.reachabilityFence(this);
            }
        }

        @Override
        public Future<?> submit(Runnable task) {
            try {
                Future<?> future = this.e.submit(task);
                return future;
            }
            finally {
                Reference.reachabilityFence(this);
            }
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            try {
                Future<T> future = this.e.submit(task);
                return future;
            }
            finally {
                Reference.reachabilityFence(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            try {
                Future<T> future = this.e.submit(task, result);
                return future;
            }
            finally {
                Reference.reachabilityFence(this);
            }
        }

        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            try {
                List list = this.e.invokeAll(tasks);
                return list;
            }
            finally {
                Reference.reachabilityFence(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            try {
                List list = this.e.invokeAll(tasks, timeout, unit);
                return list;
            }
            finally {
                Reference.reachabilityFence(this);
            }
        }

        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            try {
                Object t = this.e.invokeAny(tasks);
                return t;
            }
            finally {
                Reference.reachabilityFence(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                Object t = this.e.invokeAny(tasks, timeout, unit);
                return t;
            }
            finally {
                Reference.reachabilityFence(this);
            }
        }
    }

    private static class DelegatedScheduledExecutorService
    extends DelegatedExecutorService
    implements ScheduledExecutorService {
        private final ScheduledExecutorService e;

        DelegatedScheduledExecutorService(ScheduledExecutorService executor) {
            super(executor);
            this.e = executor;
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return this.e.schedule(command, delay, unit);
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            return this.e.schedule(callable, delay, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return this.e.scheduleAtFixedRate(command, initialDelay, period, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this.e.scheduleWithFixedDelay(command, initialDelay, delay, unit);
        }
    }

    private static final class PrivilegedCallable<T>
    implements Callable<T> {
        final Callable<T> task;
        final AccessControlContext acc;

        PrivilegedCallable(Callable<T> task) {
            this.task = task;
            this.acc = AccessController.getContext();
        }

        @Override
        public T call() throws Exception {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<T>(){

                    @Override
                    public T run() throws Exception {
                        return task.call();
                    }
                }, this.acc);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }

        public String toString() {
            return super.toString() + "[Wrapped task = " + this.task + "]";
        }
    }

    private static final class PrivilegedCallableUsingCurrentClassLoader<T>
    implements Callable<T> {
        final Callable<T> task;
        final AccessControlContext acc;
        final ClassLoader ccl;

        PrivilegedCallableUsingCurrentClassLoader(Callable<T> task) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
                sm.checkPermission(new RuntimePermission("setContextClassLoader"));
            }
            this.task = task;
            this.acc = AccessController.getContext();
            this.ccl = Thread.currentThread().getContextClassLoader();
        }

        @Override
        public T call() throws Exception {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<T>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public T run() throws Exception {
                        Thread t = Thread.currentThread();
                        ClassLoader cl = t.getContextClassLoader();
                        if (ccl == cl) {
                            return task.call();
                        }
                        t.setContextClassLoader(ccl);
                        try {
                            Object t2 = task.call();
                            return t2;
                        }
                        finally {
                            t.setContextClassLoader(cl);
                        }
                    }
                }, this.acc);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }

        public String toString() {
            return super.toString() + "[Wrapped task = " + this.task + "]";
        }
    }

    private static class PrivilegedThreadFactory
    extends DefaultThreadFactory {
        final AccessControlContext acc;
        final ClassLoader ccl;

        PrivilegedThreadFactory() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
                sm.checkPermission(new RuntimePermission("setContextClassLoader"));
            }
            this.acc = AccessController.getContext();
            this.ccl = Thread.currentThread().getContextClassLoader();
        }

        @Override
        public Thread newThread(final Runnable r) {
            return super.newThread(new Runnable(){

                @Override
                public void run() {
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Void run() {
                            Thread.currentThread().setContextClassLoader(ccl);
                            r.run();
                            return null;
                        }
                    }, acc);
                }
            });
        }
    }

    private static final class RunnableAdapter<T>
    implements Callable<T> {
        private final Runnable task;
        private final T result;

        RunnableAdapter(Runnable task, T result) {
            this.task = task;
            this.result = result;
        }

        @Override
        public T call() {
            this.task.run();
            return this.result;
        }

        public String toString() {
            return super.toString() + "[Wrapped task = " + this.task + "]";
        }
    }
}

