/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.locks;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReadWriteLock;
import jdk.internal.vm.annotation.ReservedStackAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReentrantReadWriteLock
implements ReadWriteLock,
Serializable {
    public ReentrantReadWriteLock() {
    }

    public ReentrantReadWriteLock(boolean bl) {
    }

    @Override
    public WriteLock writeLock() {
        return null;
    }

    @Override
    public ReadLock readLock() {
        return null;
    }

    public final boolean isFair() {
        return false;
    }

    protected Thread getOwner() {
        return null;
    }

    public int getReadLockCount() {
        return 0;
    }

    public boolean isWriteLocked() {
        return false;
    }

    public boolean isWriteLockedByCurrentThread() {
        return false;
    }

    public int getWriteHoldCount() {
        return 0;
    }

    protected Collection<Thread> getQueuedWriterThreads() {
        return null;
    }

    protected Collection<Thread> getQueuedReaderThreads() {
        return null;
    }

    public final boolean hasQueuedThreads() {
        return false;
    }

    public final boolean hasQueuedThread(Thread thread) {
        return false;
    }

    public final int getQueueLength() {
        return 0;
    }

    protected Collection<Thread> getQueuedThreads() {
        return null;
    }

    public boolean hasWaiters(Condition condition) {
        return false;
    }

    public int getWaitQueueLength(Condition condition) {
        return 0;
    }

    protected Collection<Thread> getWaitingThreads(Condition condition) {
        return null;
    }

    public String toString() {
        return null;
    }

    static final class FairSync
    extends Sync {
        private static final long serialVersionUID = -2274990926593161451L;

        FairSync() {
        }

        @Override
        final boolean writerShouldBlock() {
            return this.hasQueuedPredecessors();
        }

        @Override
        final boolean readerShouldBlock() {
            return this.hasQueuedPredecessors();
        }
    }

    static final class NonfairSync
    extends Sync {
        private static final long serialVersionUID = -8159625535654395037L;

        NonfairSync() {
        }

        @Override
        final boolean writerShouldBlock() {
            return false;
        }

        @Override
        final boolean readerShouldBlock() {
            return this.apparentlyFirstQueuedIsExclusive();
        }
    }

    public static class ReadLock
    implements Lock,
    Serializable {
        protected ReadLock(ReentrantReadWriteLock reentrantReadWriteLock) {
        }

        public void lock() {
        }

        public void lockInterruptibly() throws InterruptedException {
        }

        public boolean tryLock() {
            return false;
        }

        public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
            return false;
        }

        public void unlock() {
        }

        public Condition newCondition() {
            return null;
        }

        public String toString() {
            return null;
        }
    }

    static abstract class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 6317671515068378041L;
        static final int SHARED_SHIFT = 16;
        static final int SHARED_UNIT = 65536;
        static final int MAX_COUNT = 65535;
        static final int EXCLUSIVE_MASK = 65535;
        private transient ThreadLocalHoldCounter readHolds = new ThreadLocalHoldCounter();
        private transient HoldCounter cachedHoldCounter;
        private transient Thread firstReader;
        private transient int firstReaderHoldCount;

        static int sharedCount(int c) {
            return c >>> 16;
        }

        static int exclusiveCount(int c) {
            return c & 0xFFFF;
        }

        Sync() {
            this.setState(this.getState());
        }

        abstract boolean readerShouldBlock();

        abstract boolean writerShouldBlock();

        @Override
        @ReservedStackAccess
        protected final boolean tryRelease(int releases) {
            boolean free;
            if (!this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            int nextc = this.getState() - releases;
            boolean bl = free = Sync.exclusiveCount(nextc) == 0;
            if (free) {
                this.setExclusiveOwnerThread(null);
            }
            this.setState(nextc);
            return free;
        }

        @Override
        @ReservedStackAccess
        protected final boolean tryAcquire(int acquires) {
            Thread current = Thread.currentThread();
            int c = this.getState();
            int w = Sync.exclusiveCount(c);
            if (c != 0) {
                if (w == 0 || current != this.getExclusiveOwnerThread()) {
                    return false;
                }
                if (w + Sync.exclusiveCount(acquires) > 65535) {
                    throw new Error("Maximum lock count exceeded");
                }
                this.setState(c + acquires);
                return true;
            }
            if (this.writerShouldBlock() || !this.compareAndSetState(c, c + acquires)) {
                return false;
            }
            this.setExclusiveOwnerThread(current);
            return true;
        }

        @Override
        @ReservedStackAccess
        protected final boolean tryReleaseShared(int unused) {
            int nextc;
            int c;
            Thread current = Thread.currentThread();
            if (this.firstReader == current) {
                if (this.firstReaderHoldCount == 1) {
                    this.firstReader = null;
                } else {
                    --this.firstReaderHoldCount;
                }
            } else {
                int count;
                HoldCounter rh = this.cachedHoldCounter;
                if (rh == null || rh.tid != LockSupport.getThreadId((Thread)current)) {
                    rh = (HoldCounter)this.readHolds.get();
                }
                if ((count = rh.count) <= 1) {
                    this.readHolds.remove();
                    if (count <= 0) {
                        throw Sync.unmatchedUnlockException();
                    }
                }
                --rh.count;
            }
            while (!this.compareAndSetState(c = this.getState(), nextc = c - 65536)) {
            }
            return nextc == 0;
        }

        private static IllegalMonitorStateException unmatchedUnlockException() {
            return new IllegalMonitorStateException("attempt to unlock read lock, not locked by current thread");
        }

        @Override
        @ReservedStackAccess
        protected final int tryAcquireShared(int unused) {
            Thread current = Thread.currentThread();
            int c = this.getState();
            if (Sync.exclusiveCount(c) != 0 && this.getExclusiveOwnerThread() != current) {
                return -1;
            }
            int r = Sync.sharedCount(c);
            if (!this.readerShouldBlock() && r < 65535 && this.compareAndSetState(c, c + 65536)) {
                if (r == 0) {
                    this.firstReader = current;
                    this.firstReaderHoldCount = 1;
                } else if (this.firstReader == current) {
                    ++this.firstReaderHoldCount;
                } else {
                    HoldCounter rh = this.cachedHoldCounter;
                    if (rh == null || rh.tid != LockSupport.getThreadId((Thread)current)) {
                        this.cachedHoldCounter = rh = (HoldCounter)this.readHolds.get();
                    } else if (rh.count == 0) {
                        this.readHolds.set(rh);
                    }
                    ++rh.count;
                }
                return 1;
            }
            return this.fullTryAcquireShared(current);
        }

        final int fullTryAcquireShared(Thread current) {
            int c;
            HoldCounter rh = null;
            do {
                if (Sync.exclusiveCount(c = this.getState()) != 0) {
                    if (this.getExclusiveOwnerThread() != current) {
                        return -1;
                    }
                } else if (this.readerShouldBlock() && this.firstReader != current) {
                    if (rh == null && ((rh = this.cachedHoldCounter) == null || rh.tid != LockSupport.getThreadId((Thread)current))) {
                        rh = (HoldCounter)this.readHolds.get();
                        if (rh.count == 0) {
                            this.readHolds.remove();
                        }
                    }
                    if (rh.count == 0) {
                        return -1;
                    }
                }
                if (Sync.sharedCount(c) != 65535) continue;
                throw new Error("Maximum lock count exceeded");
            } while (!this.compareAndSetState(c, c + 65536));
            if (Sync.sharedCount(c) == 0) {
                this.firstReader = current;
                this.firstReaderHoldCount = 1;
            } else if (this.firstReader == current) {
                ++this.firstReaderHoldCount;
            } else {
                if (rh == null) {
                    rh = this.cachedHoldCounter;
                }
                if (rh == null || rh.tid != LockSupport.getThreadId((Thread)current)) {
                    rh = (HoldCounter)this.readHolds.get();
                } else if (rh.count == 0) {
                    this.readHolds.set(rh);
                }
                ++rh.count;
                this.cachedHoldCounter = rh;
            }
            return 1;
        }

        @ReservedStackAccess
        final boolean tryWriteLock() {
            Thread current = Thread.currentThread();
            int c = this.getState();
            if (c != 0) {
                int w = Sync.exclusiveCount(c);
                if (w == 0 || current != this.getExclusiveOwnerThread()) {
                    return false;
                }
                if (w == 65535) {
                    throw new Error("Maximum lock count exceeded");
                }
            }
            if (!this.compareAndSetState(c, c + 1)) {
                return false;
            }
            this.setExclusiveOwnerThread(current);
            return true;
        }

        @ReservedStackAccess
        final boolean tryReadLock() {
            int r;
            int c;
            Thread current = Thread.currentThread();
            do {
                if (Sync.exclusiveCount(c = this.getState()) != 0 && this.getExclusiveOwnerThread() != current) {
                    return false;
                }
                r = Sync.sharedCount(c);
                if (r != 65535) continue;
                throw new Error("Maximum lock count exceeded");
            } while (!this.compareAndSetState(c, c + 65536));
            if (r == 0) {
                this.firstReader = current;
                this.firstReaderHoldCount = 1;
            } else if (this.firstReader == current) {
                ++this.firstReaderHoldCount;
            } else {
                HoldCounter rh = this.cachedHoldCounter;
                if (rh == null || rh.tid != LockSupport.getThreadId((Thread)current)) {
                    this.cachedHoldCounter = rh = (HoldCounter)this.readHolds.get();
                } else if (rh.count == 0) {
                    this.readHolds.set(rh);
                }
                ++rh.count;
            }
            return true;
        }

        @Override
        protected final boolean isHeldExclusively() {
            return this.getExclusiveOwnerThread() == Thread.currentThread();
        }

        final AbstractQueuedSynchronizer.ConditionObject newCondition() {
            return new AbstractQueuedSynchronizer.ConditionObject(this);
        }

        final Thread getOwner() {
            return Sync.exclusiveCount(this.getState()) == 0 ? null : this.getExclusiveOwnerThread();
        }

        final int getReadLockCount() {
            return Sync.sharedCount(this.getState());
        }

        final boolean isWriteLocked() {
            return Sync.exclusiveCount(this.getState()) != 0;
        }

        final int getWriteHoldCount() {
            return this.isHeldExclusively() ? Sync.exclusiveCount(this.getState()) : 0;
        }

        final int getReadHoldCount() {
            if (this.getReadLockCount() == 0) {
                return 0;
            }
            Thread current = Thread.currentThread();
            if (this.firstReader == current) {
                return this.firstReaderHoldCount;
            }
            HoldCounter rh = this.cachedHoldCounter;
            if (rh != null && rh.tid == LockSupport.getThreadId((Thread)current)) {
                return rh.count;
            }
            int count = ((HoldCounter)this.readHolds.get()).count;
            if (count == 0) {
                this.readHolds.remove();
            }
            return count;
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this.readHolds = new ThreadLocalHoldCounter();
            this.setState(0);
        }

        final int getCount() {
            return this.getState();
        }

        static final class ThreadLocalHoldCounter
        extends ThreadLocal<HoldCounter> {
            ThreadLocalHoldCounter() {
            }

            @Override
            public HoldCounter initialValue() {
                return new HoldCounter();
            }
        }

        static final class HoldCounter {
            int count;
            final long tid = LockSupport.getThreadId((Thread)Thread.currentThread());

            HoldCounter() {
            }
        }
    }

    public static class WriteLock
    implements Lock,
    Serializable {
        protected WriteLock(ReentrantReadWriteLock reentrantReadWriteLock) {
        }

        public void lock() {
        }

        public void lockInterruptibly() throws InterruptedException {
        }

        public boolean tryLock() {
            return false;
        }

        public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
            return false;
        }

        public void unlock() {
        }

        public Condition newCondition() {
            return null;
        }

        public String toString() {
            return null;
        }
    }
}

