/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import com.sun.jmx.remote.internal.ClientCommunicatorAdmin;
import com.sun.jmx.remote.internal.ClientListenerInfo;
import com.sun.jmx.remote.internal.ClientNotifForwarder;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.ServerException;
import java.rmi.UnmarshalException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerDelegate;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.NotificationResult;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIServer;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import sun.reflect.misc.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMIConnector
implements JMXConnector,
Serializable {
    public RMIConnector(JMXServiceURL jMXServiceURL, Map<String, ?> map) {
    }

    public RMIConnector(RMIServer rMIServer, Map<String, ?> map) {
    }

    public String toString() {
        return null;
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public synchronized void connect(Map<String, ?> map) throws IOException {
    }

    @Override
    public synchronized String getConnectionId() throws IOException {
        return null;
    }

    @Override
    public synchronized MBeanServerConnection getMBeanServerConnection() throws IOException {
        return null;
    }

    @Override
    public synchronized MBeanServerConnection getMBeanServerConnection(Subject subject) throws IOException {
        return null;
    }

    @Override
    public void addConnectionNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
    }

    @Override
    public synchronized void close() throws IOException {
    }

    private static final class ObjectInputStreamWithLoader
    extends ObjectInputStream {
        private final ClassLoader loader;

        ObjectInputStreamWithLoader(InputStream in, ClassLoader cl) throws IOException, IllegalArgumentException {
            super(in);
            if (cl == null) {
                throw new IllegalArgumentException("class loader is null");
            }
            this.loader = cl;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
            String name = classDesc.getName();
            ReflectUtil.checkPackageAccess(name);
            return Class.forName(name, false, Objects.requireNonNull(this.loader));
        }
    }

    private class RMIClientCommunicatorAdmin
    extends ClientCommunicatorAdmin {
        public RMIClientCommunicatorAdmin(long period) {
            super(period);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void gotIOException(IOException ioe) throws IOException {
            block12: {
                if (ioe instanceof NoSuchObjectException) {
                    super.gotIOException(ioe);
                    return;
                }
                try {
                    RMIConnector.this.connection.getDefaultDomain(null);
                }
                catch (IOException ioexc) {
                    boolean toClose = false;
                    RMIClientCommunicatorAdmin rMIClientCommunicatorAdmin = this;
                    synchronized (rMIClientCommunicatorAdmin) {
                        if (!RMIConnector.this.terminated) {
                            RMIConnector.this.terminated = true;
                            toClose = true;
                        }
                    }
                    if (!toClose) break block12;
                    JMXConnectionNotification failedNotif = new JMXConnectionNotification("jmx.remote.connection.failed", this, RMIConnector.this.connectionId, RMIConnector.this.clientNotifSeqNo++, "Failed to communicate with the server: " + ioe.toString(), ioe);
                    RMIConnector.this.sendNotification(failedNotif);
                    try {
                        RMIConnector.this.close(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (ioe instanceof ServerException) {
                Throwable tt = ((ServerException)ioe).detail;
                if (tt instanceof IOException) {
                    throw (IOException)tt;
                }
                if (tt instanceof RuntimeException) {
                    throw (RuntimeException)tt;
                }
            }
            throw ioe;
        }

        public void reconnectNotificationListeners(ClientListenerInfo[] old) throws IOException {
            int i;
            int len = old.length;
            ClientListenerInfo[] clis = new ClientListenerInfo[len];
            Subject[] subjects = new Subject[len];
            ObjectName[] names = new ObjectName[len];
            NotificationListener[] listeners = new NotificationListener[len];
            NotificationFilter[] filters = new NotificationFilter[len];
            MarshalledObject[] mFilters = (MarshalledObject[])Util.cast(new MarshalledObject[len]);
            Object[] handbacks = new Object[len];
            for (i = 0; i < len; ++i) {
                subjects[i] = old[i].getDelegationSubject();
                names[i] = old[i].getObjectName();
                listeners[i] = old[i].getListener();
                filters[i] = old[i].getNotificationFilter();
                mFilters[i] = new MarshalledObject(filters[i]);
                handbacks[i] = old[i].getHandback();
            }
            try {
                Integer[] ids = RMIConnector.this.addListenersWithSubjects(names, mFilters, subjects, false);
                for (i = 0; i < len; ++i) {
                    clis[i] = new ClientListenerInfo(ids[i], names[i], listeners[i], filters[i], handbacks[i], subjects[i]);
                }
                RMIConnector.this.rmiNotifClient.postReconnection(clis);
                return;
            }
            catch (InstanceNotFoundException ids) {
                int j = 0;
                for (i = 0; i < len; ++i) {
                    try {
                        Integer id = RMIConnector.this.addListenerWithSubject(names[i], new MarshalledObject(filters[i]), subjects[i], false);
                        clis[j++] = new ClientListenerInfo(id, names[i], listeners[i], filters[i], handbacks[i], subjects[i]);
                        continue;
                    }
                    catch (InstanceNotFoundException infe) {
                        logger.warning("reconnectNotificationListeners", "Can't reconnect listener for " + String.valueOf(names[i]));
                    }
                }
                if (j != len) {
                    ClientListenerInfo[] tmp = clis;
                    clis = new ClientListenerInfo[j];
                    System.arraycopy(tmp, 0, clis, 0, j);
                }
                RMIConnector.this.rmiNotifClient.postReconnection(clis);
                return;
            }
        }

        @Override
        protected void checkConnection() throws IOException {
            if (logger.debugOn()) {
                logger.debug("RMIClientCommunicatorAdmin-checkConnection", "Calling the method getDefaultDomain.");
            }
            RMIConnector.this.connection.getDefaultDomain(null);
        }

        @Override
        protected void doStart() throws IOException {
            RMIServer stub;
            try {
                stub = RMIConnector.this.rmiServer != null ? RMIConnector.this.rmiServer : RMIConnector.this.findRMIServer(RMIConnector.this.jmxServiceURL, RMIConnector.this.env);
            }
            catch (NamingException ne) {
                throw new IOException("Failed to get a RMI stub: " + String.valueOf(ne));
            }
            Object credentials = RMIConnector.this.env.get("jmx.remote.credentials");
            RMIConnector.this.connection = stub.newClient(credentials);
            ClientListenerInfo[] old = RMIConnector.this.rmiNotifClient.preReconnection();
            this.reconnectNotificationListeners(old);
            RMIConnector.this.connectionId = RMIConnector.this.getConnectionId();
            JMXConnectionNotification reconnectedNotif = new JMXConnectionNotification("jmx.remote.connection.opened", this, RMIConnector.this.connectionId, RMIConnector.this.clientNotifSeqNo++, "Reconnected to server", null);
            RMIConnector.this.sendNotification(reconnectedNotif);
        }

        @Override
        protected void doStop() {
            try {
                RMIConnector.this.close();
            }
            catch (IOException ioe) {
                logger.warning("RMIClientCommunicatorAdmin-doStop", "Failed to call the method close():" + String.valueOf(ioe));
                logger.debug("RMIClientCommunicatorAdmin-doStop", ioe);
            }
        }
    }

    private class RMINotifClient
    extends ClientNotifForwarder {
        public RMINotifClient(ClassLoader cl, Map<String, ?> env) {
            super(cl, env);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected NotificationResult fetchNotifs(long clientSequenceNumber, int maxNotifications, long timeout) throws IOException, ClassNotFoundException {
            boolean retried = false;
            while (true) {
                try {
                    return RMIConnector.this.connection.fetchNotifications(clientSequenceNumber, maxNotifications, timeout);
                }
                catch (IOException ioe) {
                    this.rethrowDeserializationException(ioe);
                    try {
                        RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                        continue;
                    }
                    catch (IOException ee) {
                        boolean toClose = false;
                        RMINotifClient rMINotifClient = this;
                        synchronized (rMINotifClient) {
                            if (RMIConnector.this.terminated) {
                                throw ioe;
                            }
                            if (retried) {
                                toClose = true;
                            }
                        }
                        if (toClose) {
                            JMXConnectionNotification failedNotif = new JMXConnectionNotification("jmx.remote.connection.failed", this, RMIConnector.this.connectionId, RMIConnector.this.clientNotifSeqNo++, "Failed to communicate with the server: " + ioe.toString(), ioe);
                            RMIConnector.this.sendNotification(failedNotif);
                            try {
                                RMIConnector.this.close(true);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw ioe;
                        }
                        retried = true;
                        continue;
                    }
                }
                break;
            }
        }

        private void rethrowDeserializationException(IOException ioe) throws ClassNotFoundException, IOException {
            if (ioe instanceof UnmarshalException) {
                NotSerializableException nse = new NotSerializableException();
                nse.initCause(ioe);
                throw nse;
            }
        }

        @Override
        protected Integer addListenerForMBeanRemovedNotif() throws IOException, InstanceNotFoundException {
            Integer[] listenerIDs;
            NotificationFilterSupport clientFilter = new NotificationFilterSupport();
            clientFilter.enableType("JMX.mbean.unregistered");
            MarshalledObject sFilter = new MarshalledObject(clientFilter);
            ObjectName[] names = new ObjectName[]{MBeanServerDelegate.DELEGATE_NAME};
            MarshalledObject[] filters = (MarshalledObject[])Util.cast(new MarshalledObject[]{sFilter});
            Subject[] subjects = new Subject[]{null};
            try {
                listenerIDs = RMIConnector.this.connection.addNotificationListeners(names, filters, subjects);
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                listenerIDs = RMIConnector.this.connection.addNotificationListeners(names, filters, subjects);
            }
            return listenerIDs[0];
        }

        @Override
        protected void removeListenerForMBeanRemovedNotif(Integer id) throws IOException, InstanceNotFoundException, ListenerNotFoundException {
            try {
                RMIConnector.this.connection.removeNotificationListeners(MBeanServerDelegate.DELEGATE_NAME, new Integer[]{id}, null);
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                RMIConnector.this.connection.removeNotificationListeners(MBeanServerDelegate.DELEGATE_NAME, new Integer[]{id}, null);
            }
        }

        @Override
        protected void lostNotifs(String message, long number) {
            String notifType = "jmx.remote.connection.notifs.lost";
            JMXConnectionNotification n = new JMXConnectionNotification("jmx.remote.connection.notifs.lost", RMIConnector.this, RMIConnector.this.connectionId, RMIConnector.this.clientNotifCounter++, message, number);
            RMIConnector.this.sendNotification(n);
        }
    }

    private class RemoteMBeanServerConnection
    implements MBeanServerConnection {
        private Subject delegationSubject;

        public RemoteMBeanServerConnection() {
            this(null);
        }

        public RemoteMBeanServerConnection(Subject delegationSubject) {
            this.delegationSubject = delegationSubject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
            if (logger.debugOn()) {
                logger.debug("createMBean(String,ObjectName)", "className=" + className + ", name=" + String.valueOf(name));
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(className, name, this.delegationSubject);
                return objectInstance;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(className, name, this.delegationSubject);
                return objectInstance;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
            if (logger.debugOn()) {
                logger.debug("createMBean(String,ObjectName,ObjectName)", "className=" + className + ", name=" + String.valueOf(name) + ", loaderName=" + String.valueOf(loaderName) + ")");
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(className, name, loaderName, this.delegationSubject);
                return objectInstance;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(className, name, loaderName, this.delegationSubject);
                return objectInstance;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
            if (logger.debugOn()) {
                logger.debug("createMBean(String,ObjectName,Object[],String[])", "className=" + className + ", name=" + String.valueOf(name) + ", signature=" + RMIConnector.strings((String[])signature));
            }
            MarshalledObject sParams = new MarshalledObject(params);
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(className, name, sParams, signature, this.delegationSubject);
                return objectInstance;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(className, name, sParams, signature, this.delegationSubject);
                return objectInstance;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
            if (logger.debugOn()) {
                logger.debug("createMBean(String,ObjectName,ObjectName,Object[],String[])", "className=" + className + ", name=" + String.valueOf(name) + ", loaderName=" + String.valueOf(loaderName) + ", signature=" + RMIConnector.strings((String[])signature));
            }
            MarshalledObject sParams = new MarshalledObject(params);
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(className, name, loaderName, sParams, signature, this.delegationSubject);
                return objectInstance;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                ObjectInstance objectInstance = RMIConnector.this.connection.createMBean(className, name, loaderName, sParams, signature, this.delegationSubject);
                return objectInstance;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
            if (logger.debugOn()) {
                logger.debug("unregisterMBean", "name=" + String.valueOf(name));
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                RMIConnector.this.connection.unregisterMBean(name, this.delegationSubject);
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                RMIConnector.this.connection.unregisterMBean(name, this.delegationSubject);
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, IOException {
            if (logger.debugOn()) {
                logger.debug("getObjectInstance", "name=" + String.valueOf(name));
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                ObjectInstance objectInstance = RMIConnector.this.connection.getObjectInstance(name, this.delegationSubject);
                return objectInstance;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                ObjectInstance objectInstance = RMIConnector.this.connection.getObjectInstance(name, this.delegationSubject);
                return objectInstance;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) throws IOException {
            if (logger.debugOn()) {
                logger.debug("queryMBeans", "name=" + String.valueOf(name) + ", query=" + String.valueOf(query));
            }
            MarshalledObject sQuery = new MarshalledObject(query);
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                Set<ObjectInstance> set = RMIConnector.this.connection.queryMBeans(name, sQuery, this.delegationSubject);
                return set;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                Set<ObjectInstance> set = RMIConnector.this.connection.queryMBeans(name, sQuery, this.delegationSubject);
                return set;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<ObjectName> queryNames(ObjectName name, QueryExp query) throws IOException {
            if (logger.debugOn()) {
                logger.debug("queryNames", "name=" + String.valueOf(name) + ", query=" + String.valueOf(query));
            }
            MarshalledObject sQuery = new MarshalledObject(query);
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                Set<ObjectName> set = RMIConnector.this.connection.queryNames(name, sQuery, this.delegationSubject);
                return set;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                Set<ObjectName> set = RMIConnector.this.connection.queryNames(name, sQuery, this.delegationSubject);
                return set;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isRegistered(ObjectName name) throws IOException {
            if (logger.debugOn()) {
                logger.debug("isRegistered", "name=" + String.valueOf(name));
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                boolean bl = RMIConnector.this.connection.isRegistered(name, this.delegationSubject);
                return bl;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                boolean bl = RMIConnector.this.connection.isRegistered(name, this.delegationSubject);
                return bl;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer getMBeanCount() throws IOException {
            if (logger.debugOn()) {
                logger.debug("getMBeanCount", "");
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                Integer n = RMIConnector.this.connection.getMBeanCount(this.delegationSubject);
                return n;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                Integer n = RMIConnector.this.connection.getMBeanCount(this.delegationSubject);
                return n;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
            if (logger.debugOn()) {
                logger.debug("getAttribute", "name=" + String.valueOf(name) + ", attribute=" + attribute);
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                Object object = RMIConnector.this.connection.getAttribute(name, attribute, this.delegationSubject);
                return object;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                Object object = RMIConnector.this.connection.getAttribute(name, attribute, this.delegationSubject);
                return object;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
            if (logger.debugOn()) {
                logger.debug("getAttributes", "name=" + String.valueOf(name) + ", attributes=" + RMIConnector.strings((String[])attributes));
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                AttributeList attributeList = RMIConnector.this.connection.getAttributes(name, attributes, this.delegationSubject);
                return attributeList;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                AttributeList attributeList = RMIConnector.this.connection.getAttributes(name, attributes, this.delegationSubject);
                return attributeList;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
            if (logger.debugOn()) {
                logger.debug("setAttribute", "name=" + String.valueOf(name) + ", attribute name=" + attribute.getName());
            }
            MarshalledObject sAttribute = new MarshalledObject(attribute);
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                RMIConnector.this.connection.setAttribute(name, sAttribute, this.delegationSubject);
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                RMIConnector.this.connection.setAttribute(name, sAttribute, this.delegationSubject);
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
            if (logger.debugOn()) {
                logger.debug("setAttributes", "name=" + String.valueOf(name) + ", attribute names=" + RMIConnector.getAttributesNames((AttributeList)attributes));
            }
            MarshalledObject sAttributes = new MarshalledObject(attributes);
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                AttributeList attributeList = RMIConnector.this.connection.setAttributes(name, sAttributes, this.delegationSubject);
                return attributeList;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                AttributeList attributeList = RMIConnector.this.connection.setAttributes(name, sAttributes, this.delegationSubject);
                return attributeList;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
            if (logger.debugOn()) {
                logger.debug("invoke", "name=" + String.valueOf(name) + ", operationName=" + operationName + ", signature=" + RMIConnector.strings((String[])signature));
            }
            MarshalledObject sParams = new MarshalledObject(params);
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                Object object = RMIConnector.this.connection.invoke(name, operationName, sParams, signature, this.delegationSubject);
                return object;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                Object object = RMIConnector.this.connection.invoke(name, operationName, sParams, signature, this.delegationSubject);
                return object;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getDefaultDomain() throws IOException {
            if (logger.debugOn()) {
                logger.debug("getDefaultDomain", "");
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                String string = RMIConnector.this.connection.getDefaultDomain(this.delegationSubject);
                return string;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                String string = RMIConnector.this.connection.getDefaultDomain(this.delegationSubject);
                return string;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String[] getDomains() throws IOException {
            if (logger.debugOn()) {
                logger.debug("getDomains", "");
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                String[] stringArray = RMIConnector.this.connection.getDomains(this.delegationSubject);
                return stringArray;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                String[] stringArray = RMIConnector.this.connection.getDomains(this.delegationSubject);
                return stringArray;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
            if (logger.debugOn()) {
                logger.debug("getMBeanInfo", "name=" + String.valueOf(name));
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                MBeanInfo mBeanInfo = RMIConnector.this.connection.getMBeanInfo(name, this.delegationSubject);
                return mBeanInfo;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                MBeanInfo mBeanInfo = RMIConnector.this.connection.getMBeanInfo(name, this.delegationSubject);
                return mBeanInfo;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, IOException {
            if (logger.debugOn()) {
                logger.debug("isInstanceOf", "name=" + String.valueOf(name) + ", className=" + className);
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                boolean bl = RMIConnector.this.connection.isInstanceOf(name, className, this.delegationSubject);
                return bl;
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                boolean bl = RMIConnector.this.connection.isInstanceOf(name, className, this.delegationSubject);
                return bl;
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
            if (logger.debugOn()) {
                logger.debug("addNotificationListener(ObjectName,ObjectName,NotificationFilter,Object)", "name=" + String.valueOf(name) + ", listener=" + String.valueOf(listener) + ", filter=" + String.valueOf(filter) + ", handback=" + String.valueOf(handback));
            }
            MarshalledObject sFilter = new MarshalledObject(filter);
            MarshalledObject sHandback = new MarshalledObject(handback);
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                RMIConnector.this.connection.addNotificationListener(name, listener, sFilter, sHandback, this.delegationSubject);
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                RMIConnector.this.connection.addNotificationListener(name, listener, sFilter, sHandback, this.delegationSubject);
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            if (logger.debugOn()) {
                logger.debug("removeNotificationListener(ObjectName,ObjectName)", "name=" + String.valueOf(name) + ", listener=" + String.valueOf(listener));
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                RMIConnector.this.connection.removeNotificationListener(name, listener, this.delegationSubject);
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                RMIConnector.this.connection.removeNotificationListener(name, listener, this.delegationSubject);
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            if (logger.debugOn()) {
                logger.debug("removeNotificationListener(ObjectName,ObjectName,NotificationFilter,Object)", "name=" + String.valueOf(name) + ", listener=" + String.valueOf(listener) + ", filter=" + String.valueOf(filter) + ", handback=" + String.valueOf(handback));
            }
            MarshalledObject sFilter = new MarshalledObject(filter);
            MarshalledObject sHandback = new MarshalledObject(handback);
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                RMIConnector.this.connection.removeNotificationListener(name, listener, sFilter, sHandback, this.delegationSubject);
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                RMIConnector.this.connection.removeNotificationListener(name, listener, sFilter, sHandback, this.delegationSubject);
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
        }

        @Override
        public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
            boolean debug = logger.debugOn();
            if (debug) {
                logger.debug("addNotificationListener(ObjectName,NotificationListener,NotificationFilter,Object)", "name=" + String.valueOf(name) + ", listener=" + String.valueOf(listener) + ", filter=" + String.valueOf(filter) + ", handback=" + String.valueOf(handback));
            }
            Integer listenerID = RMIConnector.this.addListenerWithSubject(name, new MarshalledObject(filter), this.delegationSubject, true);
            RMIConnector.this.rmiNotifClient.addNotificationListener(listenerID, name, listener, filter, handback, this.delegationSubject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            boolean debug = logger.debugOn();
            if (debug) {
                logger.debug("removeNotificationListener(ObjectName,NotificationListener)", "name=" + String.valueOf(name) + ", listener=" + String.valueOf(listener));
            }
            Object[] ret = RMIConnector.this.rmiNotifClient.getListenerIds(name, listener);
            if (debug) {
                logger.debug("removeNotificationListener", "listenerIDs=" + RMIConnector.objects((Object[])ret));
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                RMIConnector.this.connection.removeNotificationListeners(name, (Integer[])ret, this.delegationSubject);
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                RMIConnector.this.connection.removeNotificationListeners(name, (Integer[])ret, this.delegationSubject);
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
            RMIConnector.this.rmiNotifClient.removeNotificationListener(name, listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            boolean debug = logger.debugOn();
            if (debug) {
                logger.debug("removeNotificationListener(ObjectName,NotificationListener,NotificationFilter,Object)", "name=" + String.valueOf(name) + ", listener=" + String.valueOf(listener) + ", filter=" + String.valueOf(filter) + ", handback=" + String.valueOf(handback));
            }
            Integer ret = RMIConnector.this.rmiNotifClient.getListenerId(name, listener, filter, handback);
            if (debug) {
                logger.debug("removeNotificationListener", "listenerID=" + ret);
            }
            ClassLoader old = RMIConnector.this.pushDefaultClassLoader();
            try {
                RMIConnector.this.connection.removeNotificationListeners(name, new Integer[]{ret}, this.delegationSubject);
            }
            catch (IOException ioe) {
                RMIConnector.this.communicatorAdmin.gotIOException(ioe);
                RMIConnector.this.connection.removeNotificationListeners(name, new Integer[]{ret}, this.delegationSubject);
            }
            finally {
                RMIConnector.this.popDefaultClassLoader(old);
            }
            RMIConnector.this.rmiNotifClient.removeNotificationListener(name, listener, filter, handback);
        }
    }
}

