/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import sun.swing.SwingUtilities2;

public class BasicInternalFrameTitlePane
extends JComponent {
    protected JMenuBar menuBar;
    protected JButton iconButton;
    protected JButton maxButton;
    protected JButton closeButton;
    protected JMenu windowMenu;
    protected JInternalFrame frame;
    protected Color selectedTitleColor;
    protected Color selectedTextColor;
    protected Color notSelectedTitleColor;
    protected Color notSelectedTextColor;
    protected Icon maxIcon;
    protected Icon minIcon;
    protected Icon iconIcon;
    protected Icon closeIcon;
    protected PropertyChangeListener propertyChangeListener;
    protected Action closeAction;
    protected Action maximizeAction;
    protected Action iconifyAction;
    protected Action restoreAction;
    protected Action moveAction;
    protected Action sizeAction;
    protected static final String CLOSE_CMD;
    protected static final String ICONIFY_CMD;
    protected static final String RESTORE_CMD;
    protected static final String MAXIMIZE_CMD;
    protected static final String MOVE_CMD;
    protected static final String SIZE_CMD;

    public BasicInternalFrameTitlePane(JInternalFrame jInternalFrame) {
    }

    protected void installTitlePane() {
    }

    protected void addSubComponents() {
    }

    protected void createActions() {
    }

    protected void installListeners() {
    }

    protected void uninstallListeners() {
    }

    protected void installDefaults() {
    }

    protected void uninstallDefaults() {
    }

    protected void createButtons() {
    }

    protected void setButtonIcons() {
    }

    protected void assembleSystemMenu() {
    }

    protected void addSystemMenuItems(JMenu jMenu) {
    }

    protected JMenu createSystemMenu() {
        return null;
    }

    protected JMenuBar createSystemMenuBar() {
        return null;
    }

    protected void showSystemMenu() {
    }

    public void paintComponent(Graphics graphics) {
    }

    protected void paintTitleBackground(Graphics graphics) {
    }

    protected String getTitle(String string, FontMetrics fontMetrics, int n) {
        return null;
    }

    protected void postClosingEvent(JInternalFrame jInternalFrame) {
    }

    protected void enableActions() {
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return null;
    }

    protected LayoutManager createLayout() {
        return null;
    }

    public class CloseAction
    extends AbstractAction {
        public CloseAction(BasicInternalFrameTitlePane basicInternalFrameTitlePane) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private class Handler
    implements LayoutManager,
    PropertyChangeListener {
        private Handler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            if (prop == "selected") {
                BasicInternalFrameTitlePane.this.repaint();
                return;
            }
            if (prop == "icon" || prop == "maximum") {
                BasicInternalFrameTitlePane.this.setButtonIcons();
                BasicInternalFrameTitlePane.this.enableActions();
                return;
            }
            if ("closable" == prop) {
                if (evt.getNewValue() == Boolean.TRUE) {
                    BasicInternalFrameTitlePane.this.add(BasicInternalFrameTitlePane.this.closeButton);
                } else {
                    BasicInternalFrameTitlePane.this.remove(BasicInternalFrameTitlePane.this.closeButton);
                }
            } else if ("maximizable" == prop) {
                if (evt.getNewValue() == Boolean.TRUE) {
                    BasicInternalFrameTitlePane.this.add(BasicInternalFrameTitlePane.this.maxButton);
                } else {
                    BasicInternalFrameTitlePane.this.remove(BasicInternalFrameTitlePane.this.maxButton);
                }
            } else if ("iconable" == prop) {
                if (evt.getNewValue() == Boolean.TRUE) {
                    BasicInternalFrameTitlePane.this.add(BasicInternalFrameTitlePane.this.iconButton);
                } else {
                    BasicInternalFrameTitlePane.this.remove(BasicInternalFrameTitlePane.this.iconButton);
                }
            }
            BasicInternalFrameTitlePane.this.enableActions();
            BasicInternalFrameTitlePane.this.revalidate();
            BasicInternalFrameTitlePane.this.repaint();
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int subtitle_w;
            int title_length;
            int width = 22;
            if (BasicInternalFrameTitlePane.this.frame.isClosable()) {
                width += 19;
            }
            if (BasicInternalFrameTitlePane.this.frame.isMaximizable()) {
                width += 19;
            }
            if (BasicInternalFrameTitlePane.this.frame.isIconifiable()) {
                width += 19;
            }
            FontMetrics fm = BasicInternalFrameTitlePane.this.frame.getFontMetrics(BasicInternalFrameTitlePane.this.getFont());
            String frameTitle = BasicInternalFrameTitlePane.this.frame.getTitle();
            int title_w = frameTitle != null ? SwingUtilities2.stringWidth(BasicInternalFrameTitlePane.this.frame, fm, frameTitle) : 0;
            int n = title_length = frameTitle != null ? frameTitle.length() : 0;
            width = title_length > 3 ? (width += title_w < (subtitle_w = SwingUtilities2.stringWidth(BasicInternalFrameTitlePane.this.frame, fm, frameTitle.substring(0, 3) + "...")) ? title_w : subtitle_w) : (width += title_w);
            Icon icon = BasicInternalFrameTitlePane.this.frame.getFrameIcon();
            int fontHeight = fm.getHeight();
            fontHeight += 2;
            int iconHeight = 0;
            if (icon != null) {
                iconHeight = Math.min(icon.getIconHeight(), 16);
            }
            int height = Math.max(fontHeight, iconHeight += 2);
            Dimension dim = new Dimension(width, height);
            if (BasicInternalFrameTitlePane.this.getBorder() != null) {
                Insets insets = BasicInternalFrameTitlePane.this.getBorder().getBorderInsets(c);
                dim.height += insets.top + insets.bottom;
                dim.width += insets.left + insets.right;
            }
            return dim;
        }

        @Override
        public void layoutContainer(Container c) {
            boolean leftToRight = BasicGraphicsUtils.isLeftToRight(BasicInternalFrameTitlePane.this.frame);
            int w = BasicInternalFrameTitlePane.this.getWidth();
            int h = BasicInternalFrameTitlePane.this.getHeight();
            int buttonHeight = BasicInternalFrameTitlePane.this.closeButton.getIcon().getIconHeight();
            Icon icon = BasicInternalFrameTitlePane.this.frame.getFrameIcon();
            int iconHeight = 0;
            if (icon != null) {
                iconHeight = icon.getIconHeight();
            }
            int x = leftToRight ? 2 : w - 16 - 2;
            BasicInternalFrameTitlePane.this.menuBar.setBounds(x, (h - iconHeight) / 2, 16, 16);
            int n = x = leftToRight ? w - 16 - 2 : 2;
            if (BasicInternalFrameTitlePane.this.frame.isClosable()) {
                BasicInternalFrameTitlePane.this.closeButton.setBounds(x, (h - buttonHeight) / 2, 16, 14);
                x += leftToRight ? -18 : 18;
            }
            if (BasicInternalFrameTitlePane.this.frame.isMaximizable()) {
                BasicInternalFrameTitlePane.this.maxButton.setBounds(x, (h - buttonHeight) / 2, 16, 14);
                x += leftToRight ? -18 : 18;
            }
            if (BasicInternalFrameTitlePane.this.frame.isIconifiable()) {
                BasicInternalFrameTitlePane.this.iconButton.setBounds(x, (h - buttonHeight) / 2, 16, 14);
            }
        }
    }

    public class IconifyAction
    extends AbstractAction {
        public IconifyAction(BasicInternalFrameTitlePane basicInternalFrameTitlePane) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public class MaximizeAction
    extends AbstractAction {
        public MaximizeAction(BasicInternalFrameTitlePane basicInternalFrameTitlePane) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public class MoveAction
    extends AbstractAction {
        public MoveAction(BasicInternalFrameTitlePane basicInternalFrameTitlePane) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private static class NoFocusButton
    extends JButton {
        private String uiKey;

        public NoFocusButton(String uiKey, String opacityKey) {
            this.setFocusPainted(false);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.uiKey = uiKey;
            Object opacity = UIManager.get(opacityKey);
            if (opacity instanceof Boolean) {
                this.setOpaque((Boolean)opacity);
            }
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        @Override
        public void requestFocus() {
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            AccessibleContext ac = super.getAccessibleContext();
            if (this.uiKey != null) {
                ac.setAccessibleName(UIManager.getString(this.uiKey));
                this.uiKey = null;
            }
            return ac;
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public PropertyChangeHandler(BasicInternalFrameTitlePane basicInternalFrameTitlePane) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }
    }

    public class RestoreAction
    extends AbstractAction {
        public RestoreAction(BasicInternalFrameTitlePane basicInternalFrameTitlePane) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private class ShowSystemMenuAction
    extends AbstractAction {
        private boolean show;

        public ShowSystemMenuAction(boolean show) {
            this.show = show;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.show) {
                BasicInternalFrameTitlePane.this.windowMenu.doClick();
            } else {
                BasicInternalFrameTitlePane.this.windowMenu.setVisible(false);
            }
        }
    }

    public class SizeAction
    extends AbstractAction {
        public SizeAction(BasicInternalFrameTitlePane basicInternalFrameTitlePane) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public class SystemMenuBar
    extends JMenuBar {
        public SystemMenuBar(BasicInternalFrameTitlePane basicInternalFrameTitlePane) {
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void requestFocus() {
        }

        public void paint(Graphics graphics) {
        }

        public boolean isOpaque() {
            return false;
        }
    }

    public class TitlePaneLayout
    implements LayoutManager {
        public TitlePaneLayout(BasicInternalFrameTitlePane basicInternalFrameTitlePane) {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return null;
        }

        public Dimension minimumLayoutSize(Container container) {
            return null;
        }

        public void layoutContainer(Container container) {
        }
    }
}

