/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;

public class MaskFormatter
extends DefaultFormatter {
    public MaskFormatter() {
    }

    public MaskFormatter(String string) throws ParseException {
    }

    public void setMask(String string) throws ParseException {
    }

    public String getMask() {
        return null;
    }

    public void setValidCharacters(String string) {
    }

    public String getValidCharacters() {
        return null;
    }

    public void setInvalidCharacters(String string) {
    }

    public String getInvalidCharacters() {
        return null;
    }

    public void setPlaceholder(String string) {
    }

    public String getPlaceholder() {
        return null;
    }

    public void setPlaceholderCharacter(char c) {
    }

    public char getPlaceholderCharacter() {
        return '\u0000';
    }

    public void setValueContainsLiteralCharacters(boolean bl) {
    }

    public boolean getValueContainsLiteralCharacters() {
        return false;
    }

    public Object stringToValue(String string) throws ParseException {
        return null;
    }

    public String valueToString(Object object) throws ParseException {
        return null;
    }

    public void install(JFormattedTextField jFormattedTextField) {
    }

    private class AlphaNumericCharacter
    extends MaskCharacter {
        private AlphaNumericCharacter(MaskFormatter maskFormatter) {
        }

        @Override
        public boolean isValidCharacter(char aChar) {
            return Character.isLetterOrDigit(aChar) && super.isValidCharacter(aChar);
        }
    }

    private class CharCharacter
    extends MaskCharacter {
        private CharCharacter(MaskFormatter maskFormatter) {
        }

        @Override
        public boolean isValidCharacter(char aChar) {
            return Character.isLetter(aChar) && super.isValidCharacter(aChar);
        }
    }

    private class DigitMaskCharacter
    extends MaskCharacter {
        private DigitMaskCharacter(MaskFormatter maskFormatter) {
        }

        @Override
        public boolean isValidCharacter(char aChar) {
            return Character.isDigit(aChar) && super.isValidCharacter(aChar);
        }
    }

    private class HexCharacter
    extends MaskCharacter {
        private HexCharacter(MaskFormatter maskFormatter) {
        }

        @Override
        public boolean isValidCharacter(char aChar) {
            return (aChar == '0' || aChar == '1' || aChar == '2' || aChar == '3' || aChar == '4' || aChar == '5' || aChar == '6' || aChar == '7' || aChar == '8' || aChar == '9' || aChar == 'a' || aChar == 'A' || aChar == 'b' || aChar == 'B' || aChar == 'c' || aChar == 'C' || aChar == 'd' || aChar == 'D' || aChar == 'e' || aChar == 'E' || aChar == 'f' || aChar == 'F') && super.isValidCharacter(aChar);
        }

        @Override
        public char getChar(char aChar) {
            if (Character.isDigit(aChar)) {
                return aChar;
            }
            return Character.toUpperCase(aChar);
        }
    }

    private class LiteralCharacter
    extends MaskCharacter {
        private char fixedChar;

        public LiteralCharacter(MaskFormatter maskFormatter, char fixedChar) {
            this.fixedChar = fixedChar;
        }

        @Override
        public boolean isLiteral() {
            return true;
        }

        @Override
        public char getChar(char aChar) {
            return this.fixedChar;
        }
    }

    private class LowerCaseCharacter
    extends MaskCharacter {
        private LowerCaseCharacter(MaskFormatter maskFormatter) {
        }

        @Override
        public boolean isValidCharacter(char aChar) {
            return Character.isLetter(aChar) && super.isValidCharacter(aChar);
        }

        @Override
        public char getChar(char aChar) {
            return Character.toLowerCase(aChar);
        }
    }

    private class MaskCharacter {
        private MaskCharacter() {
        }

        public boolean isLiteral() {
            return false;
        }

        public boolean isValidCharacter(char aChar) {
            if (this.isLiteral()) {
                return this.getChar(aChar) == aChar;
            }
            aChar = this.getChar(aChar);
            String filter = MaskFormatter.this.getValidCharacters();
            if (filter != null && filter.indexOf(aChar) == -1) {
                return false;
            }
            filter = MaskFormatter.this.getInvalidCharacters();
            return filter == null || filter.indexOf(aChar) == -1;
        }

        public char getChar(char aChar) {
            return aChar;
        }

        public void append(StringBuilder buff, String formatting, int[] index, String placeholder) throws ParseException {
            char aChar;
            boolean inString = index[0] < formatting.length();
            char c = aChar = inString ? formatting.charAt(index[0]) : (char)'\u0000';
            if (this.isLiteral()) {
                buff.append(this.getChar(aChar));
                if (MaskFormatter.this.getValueContainsLiteralCharacters()) {
                    if (inString && aChar != this.getChar(aChar)) {
                        throw new ParseException("Invalid character: " + aChar, index[0]);
                    }
                    index[0] = index[0] + 1;
                }
            } else if (index[0] >= formatting.length()) {
                if (placeholder != null && index[0] < placeholder.length()) {
                    buff.append(placeholder.charAt(index[0]));
                } else {
                    buff.append(MaskFormatter.this.getPlaceholderCharacter());
                }
                index[0] = index[0] + 1;
            } else if (this.isValidCharacter(aChar)) {
                buff.append(this.getChar(aChar));
                index[0] = index[0] + 1;
            } else {
                throw new ParseException("Invalid character: " + aChar, index[0]);
            }
        }
    }

    private class UpperCaseCharacter
    extends MaskCharacter {
        private UpperCaseCharacter(MaskFormatter maskFormatter) {
        }

        @Override
        public boolean isValidCharacter(char aChar) {
            return Character.isLetter(aChar) && super.isValidCharacter(aChar);
        }

        @Override
        public char getChar(char aChar) {
            return Character.toUpperCase(aChar);
        }
    }
}

