/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.JTextComponent;
import javax.swing.text.LabelView;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.ParagraphView;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class StyledEditorKit
extends DefaultEditorKit {
    public MutableAttributeSet getInputAttributes() {
        return null;
    }

    public Element getCharacterAttributeRun() {
        return null;
    }

    public Action[] getActions() {
        return null;
    }

    public Document createDefaultDocument() {
        return null;
    }

    public void install(JEditorPane jEditorPane) {
    }

    public void deinstall(JEditorPane jEditorPane) {
    }

    public ViewFactory getViewFactory() {
        return null;
    }

    public Object clone() {
        return null;
    }

    protected void createInputAttributes(Element element, MutableAttributeSet mutableAttributeSet) {
    }

    public static class AlignmentAction
    extends StyledTextAction {
        public AlignmentAction(String string, int n) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class AttributeTracker
    implements CaretListener,
    PropertyChangeListener,
    Serializable {
        AttributeTracker() {
        }

        void updateInputAttributes(int dot, int mark, JTextComponent c) {
            Document aDoc = c.getDocument();
            if (!(aDoc instanceof StyledDocument)) {
                return;
            }
            int start = Math.min(dot, mark);
            StyledDocument doc = (StyledDocument)aDoc;
            StyledEditorKit.this.currentParagraph = doc.getParagraphElement(start);
            Element run = StyledEditorKit.this.currentParagraph.getStartOffset() == start || dot != mark ? doc.getCharacterElement(start) : doc.getCharacterElement(Math.max(start - 1, 0));
            if (run != StyledEditorKit.this.currentRun) {
                StyledEditorKit.this.currentRun = run;
                StyledEditorKit.this.createInputAttributes(StyledEditorKit.this.currentRun, StyledEditorKit.this.getInputAttributes());
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object newValue = evt.getNewValue();
            Object source = evt.getSource();
            if (source instanceof JTextComponent && newValue instanceof Document) {
                this.updateInputAttributes(0, 0, (JTextComponent)source);
            }
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            this.updateInputAttributes(e.getDot(), e.getMark(), (JTextComponent)e.getSource());
        }
    }

    public static class BoldAction
    extends StyledTextAction {
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public static class FontFamilyAction
    extends StyledTextAction {
        public FontFamilyAction(String string, String string2) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public static class FontSizeAction
    extends StyledTextAction {
        public FontSizeAction(String string, int n) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public static class ForegroundAction
    extends StyledTextAction {
        public ForegroundAction(String string, Color color) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public static class ItalicAction
    extends StyledTextAction {
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    static class StyledInsertBreakAction
    extends StyledTextAction {
        private SimpleAttributeSet tempSet;

        StyledInsertBreakAction() {
            super("insert-break");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JEditorPane target = this.getEditor(e);
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    UIManager.getLookAndFeel().provideErrorFeedback(target);
                    return;
                }
                StyledEditorKit sek = this.getStyledEditorKit(target);
                if (this.tempSet != null) {
                    this.tempSet.removeAttributes(this.tempSet);
                } else {
                    this.tempSet = new SimpleAttributeSet();
                }
                this.tempSet.addAttributes(sek.getInputAttributes());
                target.replaceSelection("\n");
                MutableAttributeSet ia = sek.getInputAttributes();
                ia.removeAttributes(ia);
                ia.addAttributes(this.tempSet);
                this.tempSet.removeAttributes(this.tempSet);
            } else {
                JTextComponent text = this.getTextComponent(e);
                if (text != null) {
                    if (!text.isEditable() || !text.isEnabled()) {
                        UIManager.getLookAndFeel().provideErrorFeedback(target);
                        return;
                    }
                    text.replaceSelection("\n");
                }
            }
        }
    }

    public static abstract class StyledTextAction
    extends TextAction {
        public StyledTextAction(String string) {
        }

        protected final JEditorPane getEditor(ActionEvent actionEvent) {
            return null;
        }

        protected final StyledDocument getStyledDocument(JEditorPane jEditorPane) {
            return null;
        }

        protected final StyledEditorKit getStyledEditorKit(JEditorPane jEditorPane) {
            return null;
        }

        protected final void setCharacterAttributes(JEditorPane jEditorPane, AttributeSet attributeSet, boolean bl) {
        }

        protected final void setParagraphAttributes(JEditorPane jEditorPane, AttributeSet attributeSet, boolean bl) {
        }
    }

    static class StyledViewFactory
    implements ViewFactory {
        StyledViewFactory() {
        }

        @Override
        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new LabelView(elem);
                }
                if (kind.equals("paragraph")) {
                    return new ParagraphView(elem);
                }
                if (kind.equals("section")) {
                    return new BoxView(elem, 1);
                }
                if (kind.equals("component")) {
                    return new ComponentView(elem);
                }
                if (kind.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new LabelView(elem);
        }
    }

    public static class UnderlineAction
    extends StyledTextAction {
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }
}

