/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.lang.ref.SoftReference;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SegmentCache;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class WrappedPlainView
extends BoxView
implements TabExpander {
    public WrappedPlainView(Element element) {
    }

    public WrappedPlainView(Element element, boolean bl) {
    }

    protected int getTabSize() {
        return 0;
    }

    protected void drawLine(int n, int n2, Graphics graphics, int n3, int n4) {
    }

    protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        return 0;
    }

    protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        return 0;
    }

    protected final Segment getLineBuffer() {
        return null;
    }

    protected int calculateBreakPosition(int n, int n2) {
        return 0;
    }

    protected void loadChildren(ViewFactory viewFactory) {
    }

    public float nextTabStop(float f, int n) {
        return 0.0f;
    }

    public void paint(Graphics graphics, Shape shape) {
    }

    public void setSize(float f, float f2) {
    }

    public float getPreferredSpan(int n) {
        return 0.0f;
    }

    public float getMinimumSpan(int n) {
        return 0.0f;
    }

    public float getMaximumSpan(int n) {
        return 0.0f;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
    }

    class WrappedLine
    extends View {
        int lineCount;
        SoftReference<int[]> lineCache;

        WrappedLine(Element elem) {
            super(elem);
            this.lineCache = null;
            this.lineCount = -1;
        }

        @Override
        public float getPreferredSpan(int axis) {
            switch (axis) {
                case 0: {
                    float width = WrappedPlainView.this.getWidth();
                    if (width == 2.1474836E9f) {
                        return 100.0f;
                    }
                    return width;
                }
                case 1: {
                    if (this.lineCount < 0 || WrappedPlainView.this.widthChanging) {
                        this.breakLines(this.getStartOffset());
                    }
                    return this.lineCount * WrappedPlainView.this.metrics.getHeight();
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + axis);
        }

        @Override
        public void paint(Graphics g, Shape a) {
            Rectangle alloc = (Rectangle)a;
            int y = alloc.y + WrappedPlainView.this.metrics.getAscent();
            int x = alloc.x;
            JTextComponent host = (JTextComponent)this.getContainer();
            Highlighter h = host.getHighlighter();
            LayeredHighlighter dh = h instanceof LayeredHighlighter ? (LayeredHighlighter)h : null;
            int start = this.getStartOffset();
            int end = this.getEndOffset();
            int p0 = start;
            int[] lineEnds = this.getLineEnds();
            boolean useDrawLineFP = WrappedPlainView.this.drawLineOverridden && g instanceof Graphics2D;
            for (int i = 0; i < this.lineCount; ++i) {
                int p1;
                int n = p1 = lineEnds == null ? end : start + lineEnds[i];
                if (dh != null) {
                    int hOffset = p1 == end ? p1 - 1 : p1;
                    dh.paintLayeredHighlights(g, p0, hOffset, a, host, this);
                }
                if (useDrawLineFP) {
                    WrappedPlainView.this.drawLine(p0, p1, (Graphics2D)g, x, y);
                } else {
                    WrappedPlainView.this.drawLine(p0, p1, g, x, y);
                }
                p0 = p1;
                y += WrappedPlainView.this.metrics.getHeight();
            }
        }

        @Override
        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            Rectangle alloc = a.getBounds();
            alloc.height = WrappedPlainView.this.metrics.getHeight();
            alloc.width = 1;
            int p0 = this.getStartOffset();
            if (pos < p0 || pos > this.getEndOffset()) {
                throw new BadLocationException("Position out of range", pos);
            }
            int testP = b == Position.Bias.Forward ? pos : Math.max(p0, pos - 1);
            int line = 0;
            int[] lineEnds = this.getLineEnds();
            if (lineEnds != null) {
                line = this.findLine(testP - p0);
                if (line > 0) {
                    p0 += lineEnds[line - 1];
                }
                alloc.y += alloc.height * line;
            }
            if (pos > p0) {
                Segment segment = SegmentCache.getSharedSegment();
                WrappedPlainView.this.loadText(segment, p0, pos);
                float x = alloc.x;
                x += Utilities.getTabbedTextWidth(segment, WrappedPlainView.this.metrics, x, (TabExpander)WrappedPlainView.this, p0);
                SegmentCache.releaseSharedSegment(segment);
                return new Rectangle2D.Float(x, alloc.y, alloc.width, alloc.height);
            }
            return alloc;
        }

        @Override
        public int viewToModel(float fx, float fy, Shape a, Position.Bias[] bias) {
            int p1;
            int line;
            bias[0] = Position.Bias.Forward;
            Rectangle alloc = (Rectangle)a;
            int x = (int)fx;
            int y = (int)fy;
            if (y < alloc.y) {
                return this.getStartOffset();
            }
            if (y > alloc.y + alloc.height) {
                return this.getEndOffset() - 1;
            }
            alloc.height = WrappedPlainView.this.metrics.getHeight();
            int n = line = alloc.height > 0 ? (y - alloc.y) / alloc.height : this.lineCount - 1;
            if (line >= this.lineCount) {
                return this.getEndOffset() - 1;
            }
            int p0 = this.getStartOffset();
            if (this.lineCount == 1) {
                p1 = this.getEndOffset();
            } else {
                int[] lineEnds = this.getLineEnds();
                p1 = p0 + lineEnds[line];
                if (line > 0) {
                    p0 += lineEnds[line - 1];
                }
            }
            if (x < alloc.x) {
                return p0;
            }
            if (x > alloc.x + alloc.width) {
                return p1 - 1;
            }
            Segment segment = SegmentCache.getSharedSegment();
            WrappedPlainView.this.loadText(segment, p0, p1);
            int n2 = Utilities.getTabbedTextOffset(segment, WrappedPlainView.this.metrics, (float)alloc.x, (float)x, (TabExpander)WrappedPlainView.this, p0, false);
            SegmentCache.releaseSharedSegment(segment);
            return Math.min(p0 + n2, p1 - 1);
        }

        @Override
        public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            this.update(e, a);
        }

        @Override
        public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            this.update(e, a);
        }

        private void update(DocumentEvent ev, Shape a) {
            int oldCount = this.lineCount;
            this.breakLines(ev.getOffset());
            if (oldCount != this.lineCount) {
                WrappedPlainView.this.preferenceChanged(this, false, true);
                this.getContainer().repaint();
            } else if (a != null) {
                Container c = this.getContainer();
                Rectangle alloc = (Rectangle)a;
                c.repaint(alloc.x, alloc.y, alloc.width, alloc.height);
            }
        }

        final int[] getLineEnds() {
            if (this.lineCache == null) {
                return null;
            }
            int[] lineEnds = this.lineCache.get();
            if (lineEnds == null) {
                return this.breakLines(this.getStartOffset());
            }
            return lineEnds;
        }

        final int[] breakLines(int startPos) {
            int maxCapacity;
            int[] lineEnds;
            int[] oldLineEnds = lineEnds = this.lineCache == null ? null : this.lineCache.get();
            int start = this.getStartOffset();
            int lineIndex = 0;
            if (lineEnds != null && (lineIndex = this.findLine(startPos - start)) > 0) {
                --lineIndex;
            }
            int p0 = lineIndex == 0 ? start : start + lineEnds[lineIndex - 1];
            int p1 = this.getEndOffset();
            while (p0 < p1) {
                int p = WrappedPlainView.this.calculateBreakPosition(p0, p1);
                int n = p0 = p == p0 ? ++p : p;
                if (lineIndex == 0 && p0 >= p1) {
                    this.lineCache = null;
                    lineEnds = null;
                    lineIndex = 1;
                    break;
                }
                if (lineEnds == null || lineIndex >= lineEnds.length) {
                    double growFactor = (double)(p1 - start) / (double)(p0 - start);
                    int newSize = (int)Math.ceil((double)(lineIndex + 1) * growFactor);
                    newSize = Math.max(newSize, lineIndex + 2);
                    int[] tmp = new int[newSize];
                    if (lineEnds != null) {
                        System.arraycopy(lineEnds, 0, tmp, 0, lineIndex);
                    }
                    lineEnds = tmp;
                }
                lineEnds[lineIndex++] = p0 - start;
            }
            this.lineCount = lineIndex;
            if (this.lineCount > 1 && lineEnds.length > (maxCapacity = this.lineCount + this.lineCount / 3)) {
                int[] tmp = new int[maxCapacity];
                System.arraycopy(lineEnds, 0, tmp, 0, this.lineCount);
                lineEnds = tmp;
            }
            if (lineEnds != null && lineEnds != oldLineEnds) {
                this.lineCache = new SoftReference<int[]>(lineEnds);
            }
            return lineEnds;
        }

        private int findLine(int offset) {
            int[] lineEnds = this.lineCache.get();
            if (offset < lineEnds[0]) {
                return 0;
            }
            if (offset > lineEnds[this.lineCount - 1]) {
                return this.lineCount;
            }
            return this.findLine(lineEnds, offset, 0, this.lineCount - 1);
        }

        private int findLine(int[] array, int offset, int min, int max) {
            if (max - min <= 1) {
                return max;
            }
            int mid = (max + min) / 2;
            return offset < array[mid] ? this.findLine(array, offset, min, mid) : this.findLine(array, offset, mid, max);
        }
    }
}

