/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AsyncBoxView;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class ZoneView
extends BoxView {
    public ZoneView(Element element, int n) {
    }

    public int getMaximumZoneSize() {
        return 0;
    }

    public void setMaximumZoneSize(int n) {
    }

    public int getMaxZonesLoaded() {
        return 0;
    }

    public void setMaxZonesLoaded(int n) {
    }

    protected void zoneWasLoaded(View view) {
    }

    protected void unloadZone(View view) {
    }

    protected boolean isZoneLoaded(View view) {
        return false;
    }

    protected View createZone(int n, int n2) {
        return null;
    }

    protected void loadChildren(ViewFactory viewFactory) {
    }

    protected int getViewIndexAtPosition(int n) {
        return 0;
    }

    protected boolean updateChildren(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, ViewFactory viewFactory) {
        return false;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
    }

    class Zone
    extends AsyncBoxView {
        private Position start;
        private Position end;

        public Zone(Element elem, Position start, Position end) {
            super(elem, ZoneView.this.getAxis());
            this.start = start;
            this.end = end;
        }

        public void load() {
            if (!this.isLoaded()) {
                this.setEstimatedMajorSpan(true);
                Element e = this.getElement();
                ViewFactory f = this.getViewFactory();
                int index0 = e.getElementIndex(this.getStartOffset());
                int index1 = e.getElementIndex(this.getEndOffset());
                View[] added = new View[index1 - index0 + 1];
                for (int i = index0; i <= index1; ++i) {
                    added[i - index0] = f.create(e.getElement(i));
                }
                this.replace(0, 0, added);
                ZoneView.this.zoneWasLoaded(this);
            }
        }

        public void unload() {
            this.setEstimatedMajorSpan(true);
            this.removeAll();
        }

        public boolean isLoaded() {
            return this.getViewCount() != 0;
        }

        @Override
        protected void loadChildren(ViewFactory f) {
            this.setEstimatedMajorSpan(true);
            Element elem = this.getElement();
            int index0 = elem.getElementIndex(this.getStartOffset());
            int index1 = elem.getElementIndex(this.getEndOffset());
            int nChildren = index1 - index0;
            View first = f.create(elem.getElement(index0));
            first.setParent(this);
            float w = first.getPreferredSpan(0);
            float h = first.getPreferredSpan(1);
            if (this.getMajorAxis() == 0) {
                w *= (float)nChildren;
            } else {
                h += (float)nChildren;
            }
            this.setSize(w, h);
        }

        @Override
        protected void flushRequirementChanges() {
            if (this.isLoaded()) {
                super.flushRequirementChanges();
            }
        }

        @Override
        public int getViewIndex(int pos, Position.Bias b) {
            boolean isBackward = b == Position.Bias.Backward;
            pos = isBackward ? Math.max(0, pos - 1) : pos;
            Element elem = this.getElement();
            int index1 = elem.getElementIndex(pos);
            int index0 = elem.getElementIndex(this.getStartOffset());
            return index1 - index0;
        }

        @Override
        protected boolean updateChildren(DocumentEvent.ElementChange ec, DocumentEvent e, ViewFactory f) {
            Element[] removedElems = ec.getChildrenRemoved();
            Element[] addedElems = ec.getChildrenAdded();
            Element elem = this.getElement();
            int index0 = elem.getElementIndex(this.getStartOffset());
            int index1 = elem.getElementIndex(this.getEndOffset() - 1);
            int index = ec.getIndex();
            if (index >= index0 && index <= index1) {
                int replaceIndex = index - index0;
                int nadd = Math.min(index1 - index0 + 1, addedElems.length);
                int nremove = Math.min(index1 - index0 + 1, removedElems.length);
                View[] added = new View[nadd];
                for (int i = 0; i < nadd; ++i) {
                    added[i] = f.create(addedElems[i]);
                }
                this.replace(replaceIndex, nremove, added);
            }
            return true;
        }

        @Override
        public AttributeSet getAttributes() {
            return ZoneView.this.getAttributes();
        }

        @Override
        public void paint(Graphics g, Shape a) {
            this.load();
            super.paint(g, a);
        }

        @Override
        public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
            this.load();
            return super.viewToModel(x, y, a, bias);
        }

        @Override
        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            this.load();
            return super.modelToView(pos, a, b);
        }

        @Override
        public int getStartOffset() {
            return this.start.getOffset();
        }

        @Override
        public int getEndOffset() {
            return this.end.getOffset();
        }

        @Override
        public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            if (this.isLoaded()) {
                super.insertUpdate(e, a, f);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            if (this.isLoaded()) {
                super.removeUpdate(e, a, f);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            if (this.isLoaded()) {
                super.changedUpdate(e, a, f);
            }
        }
    }
}

