/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.CSSParser;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.MuxingAttributeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleSheet
extends StyleContext {
    public Style getRule(HTML.Tag tag, Element element) {
        return null;
    }

    public Style getRule(String string) {
        return null;
    }

    public void addRule(String string) {
    }

    public AttributeSet getDeclaration(String string) {
        return null;
    }

    public void loadRules(Reader reader, URL uRL) throws IOException {
    }

    public AttributeSet getViewAttributes(View view) {
        return null;
    }

    @Override
    public void removeStyle(String string) {
    }

    public void addStyleSheet(StyleSheet styleSheet) {
    }

    public void removeStyleSheet(StyleSheet styleSheet) {
    }

    public StyleSheet[] getStyleSheets() {
        return null;
    }

    public void importStyleSheet(URL uRL) {
    }

    public void setBase(URL uRL) {
    }

    public URL getBase() {
        return null;
    }

    public void addCSSAttribute(MutableAttributeSet mutableAttributeSet, CSS.Attribute attribute, String string) {
    }

    public boolean addCSSAttributeFromHTML(MutableAttributeSet mutableAttributeSet, CSS.Attribute attribute, String string) {
        return false;
    }

    public AttributeSet translateHTMLToCSS(AttributeSet attributeSet) {
        return null;
    }

    @Override
    public AttributeSet addAttribute(AttributeSet attributeSet, Object object, Object object2) {
        return null;
    }

    @Override
    public AttributeSet addAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        return null;
    }

    @Override
    public AttributeSet removeAttribute(AttributeSet attributeSet, Object object) {
        return null;
    }

    @Override
    public AttributeSet removeAttributes(AttributeSet attributeSet, Enumeration<?> enumeration) {
        return null;
    }

    @Override
    public AttributeSet removeAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        return null;
    }

    @Override
    protected StyleContext.SmallAttributeSet createSmallAttributeSet(AttributeSet attributeSet) {
        return null;
    }

    @Override
    protected MutableAttributeSet createLargeAttributeSet(AttributeSet attributeSet) {
        return null;
    }

    @Override
    public Font getFont(AttributeSet attributeSet) {
        return null;
    }

    @Override
    public Color getForeground(AttributeSet attributeSet) {
        return null;
    }

    @Override
    public Color getBackground(AttributeSet attributeSet) {
        return null;
    }

    public BoxPainter getBoxPainter(AttributeSet attributeSet) {
        return null;
    }

    public ListPainter getListPainter(AttributeSet attributeSet) {
        return null;
    }

    public void setBaseFontSize(int n) {
    }

    public void setBaseFontSize(String string) {
    }

    public static int getIndexOfSize(float f) {
        return 0;
    }

    public float getPointSize(int n) {
        return 0.0f;
    }

    public float getPointSize(String string) {
        return 0.0f;
    }

    public Color stringToColor(String string) {
        return null;
    }

    static class BackgroundImagePainter
    implements Serializable {
        ImageIcon backgroundImage;
        float hPosition;
        float vPosition;
        short flags;
        private int paintX;
        private int paintY;
        private int paintMaxX;
        private int paintMaxY;

        BackgroundImagePainter(AttributeSet a, CSS css, StyleSheet ss) {
            CSS.Value repeats;
            this.backgroundImage = ss.getBackgroundImage(a);
            CSS.BackgroundPosition pos = (CSS.BackgroundPosition)a.getAttribute(CSS.Attribute.BACKGROUND_POSITION);
            if (pos != null) {
                this.hPosition = pos.getHorizontalPosition();
                this.vPosition = pos.getVerticalPosition();
                if (pos.isHorizontalPositionRelativeToSize()) {
                    this.flags = (short)(this.flags | 4);
                } else if (pos.isHorizontalPositionRelativeToFontSize()) {
                    this.hPosition *= (float)CSS.getFontSize(a, 12, ss);
                }
                if (pos.isVerticalPositionRelativeToSize()) {
                    this.flags = (short)(this.flags | 8);
                } else if (pos.isVerticalPositionRelativeToFontSize()) {
                    this.vPosition *= (float)CSS.getFontSize(a, 12, ss);
                }
            }
            if ((repeats = (CSS.Value)a.getAttribute(CSS.Attribute.BACKGROUND_REPEAT)) == null || repeats == CSS.Value.BACKGROUND_REPEAT) {
                this.flags = (short)(this.flags | 3);
            } else if (repeats == CSS.Value.BACKGROUND_REPEAT_X) {
                this.flags = (short)(this.flags | 1);
            } else if (repeats == CSS.Value.BACKGROUND_REPEAT_Y) {
                this.flags = (short)(this.flags | 2);
            }
        }

        void paint(Graphics g, float x, float y, float w, float h, View v) {
            Rectangle clip = g.getClipRect();
            if (clip != null) {
                g.clipRect((int)x, (int)y, (int)w, (int)h);
            }
            if ((this.flags & 3) == 0) {
                int width = this.backgroundImage.getIconWidth();
                int height = this.backgroundImage.getIconWidth();
                this.paintX = (this.flags & 4) == 4 ? (int)(x + w * this.hPosition - (float)width * this.hPosition) : (int)x + (int)this.hPosition;
                this.paintY = (this.flags & 8) == 8 ? (int)(y + h * this.vPosition - (float)height * this.vPosition) : (int)y + (int)this.vPosition;
                if (clip == null || this.paintX + width > clip.x && this.paintY + height > clip.y && this.paintX < clip.x + clip.width && this.paintY < clip.y + clip.height) {
                    this.backgroundImage.paintIcon(null, g, this.paintX, this.paintY);
                }
            } else {
                int width = this.backgroundImage.getIconWidth();
                int height = this.backgroundImage.getIconHeight();
                if (width > 0 && height > 0) {
                    this.paintX = (int)x;
                    this.paintY = (int)y;
                    this.paintMaxX = (int)(x + w);
                    this.paintMaxY = (int)(y + h);
                    if (this.updatePaintCoordinates(clip, width, height)) {
                        while (this.paintX < this.paintMaxX) {
                            for (int ySpot = this.paintY; ySpot < this.paintMaxY; ySpot += height) {
                                this.backgroundImage.paintIcon(null, g, this.paintX, ySpot);
                            }
                            this.paintX += width;
                        }
                    }
                }
            }
            if (clip != null) {
                g.setClip(clip.x, clip.y, clip.width, clip.height);
            }
        }

        private boolean updatePaintCoordinates(Rectangle clip, int width, int height) {
            if ((this.flags & 3) == 1) {
                this.paintMaxY = this.paintY + 1;
            } else if ((this.flags & 3) == 2) {
                this.paintMaxX = this.paintX + 1;
            }
            if (clip != null) {
                if ((this.flags & 3) == 1 && (this.paintY + height <= clip.y || this.paintY > clip.y + clip.height)) {
                    return false;
                }
                if ((this.flags & 3) == 2 && (this.paintX + width <= clip.x || this.paintX > clip.x + clip.width)) {
                    return false;
                }
                if ((this.flags & 1) == 1) {
                    if (clip.x + clip.width < this.paintMaxX) {
                        this.paintMaxX = (clip.x + clip.width - this.paintX) % width == 0 ? clip.x + clip.width : ((clip.x + clip.width - this.paintX) / width + 1) * width + this.paintX;
                    }
                    if (clip.x > this.paintX) {
                        this.paintX = (clip.x - this.paintX) / width * width + this.paintX;
                    }
                }
                if ((this.flags & 2) == 2) {
                    if (clip.y + clip.height < this.paintMaxY) {
                        this.paintMaxY = (clip.y + clip.height - this.paintY) % height == 0 ? clip.y + clip.height : ((clip.y + clip.height - this.paintY) / height + 1) * height + this.paintY;
                    }
                    if (clip.y > this.paintY) {
                        this.paintY = (clip.y - this.paintY) / height * height + this.paintY;
                    }
                }
            }
            return true;
        }
    }

    public static class BoxPainter
    implements Serializable {
        public float getInset(int n, View view) {
            return 0.0f;
        }

        public void paint(Graphics graphics, float f, float f2, float f3, float f4, View view) {
        }

        static enum HorizontalMargin {
            LEFT,
            RIGHT;

        }
    }

    class CssParser
    implements CSSParser.CSSParserCallback {
        Vector<String[]> selectors = new Vector();
        Vector<String> selectorTokens = new Vector();
        String propertyName;
        MutableAttributeSet declaration = new SimpleAttributeSet();
        boolean parsingDeclaration;
        boolean isLink;
        URL base;
        CSSParser parser = new CSSParser();

        CssParser() {
        }

        public AttributeSet parseDeclaration(String string) {
            try {
                return this.parseDeclaration(new StringReader(string));
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public AttributeSet parseDeclaration(Reader r) throws IOException {
            this.parse(this.base, r, true, false);
            return this.declaration.copyAttributes();
        }

        public void parse(URL base, Reader r, boolean parseDeclaration, boolean isLink) throws IOException {
            this.base = base;
            this.isLink = isLink;
            this.parsingDeclaration = parseDeclaration;
            this.declaration.removeAttributes(this.declaration);
            this.selectorTokens.removeAllElements();
            this.selectors.removeAllElements();
            this.propertyName = null;
            this.parser.parse(r, this, parseDeclaration);
        }

        @Override
        public void handleImport(String importString) {
            URL url = CSS.getURL(this.base, importString);
            if (url != null) {
                StyleSheet.this.importStyleSheet(url);
            }
        }

        @Override
        public void handleSelector(String selector) {
            if (!selector.startsWith(".") && !selector.startsWith("#")) {
                selector = selector.toLowerCase();
            }
            int length = selector.length();
            if (selector.endsWith(",")) {
                if (length > 1) {
                    selector = selector.substring(0, length - 1);
                    this.selectorTokens.addElement(selector);
                }
                this.addSelector();
            } else if (length > 0) {
                this.selectorTokens.addElement(selector);
            }
        }

        @Override
        public void startRule() {
            if (this.selectorTokens.size() > 0) {
                this.addSelector();
            }
            this.propertyName = null;
        }

        @Override
        public void handleProperty(String property) {
            this.propertyName = property;
        }

        @Override
        public void handleValue(String value) {
            if (this.propertyName != null && value != null && value.length() > 0) {
                CSS.Attribute cssKey = CSS.getAttribute(this.propertyName);
                if (cssKey != null) {
                    URL url;
                    if (cssKey == CSS.Attribute.LIST_STYLE_IMAGE && value != null && !value.equals("none") && (url = CSS.getURL(this.base, value)) != null) {
                        value = url.toString();
                    }
                    StyleSheet.this.addCSSAttribute(this.declaration, cssKey, value);
                }
                this.propertyName = null;
            }
        }

        @Override
        public void endRule() {
            int n = this.selectors.size();
            for (int i = 0; i < n; ++i) {
                String[] selector = this.selectors.elementAt(i);
                if (selector.length <= 0) continue;
                StyleSheet.this.addRule(selector, this.declaration, this.isLink);
            }
            this.declaration.removeAttributes(this.declaration);
            this.selectors.removeAllElements();
        }

        private void addSelector() {
            Object[] selector = new String[this.selectorTokens.size()];
            this.selectorTokens.copyInto(selector);
            this.selectors.addElement((String[])selector);
            this.selectorTokens.removeAllElements();
        }
    }

    class LargeConversionSet
    extends SimpleAttributeSet {
        public LargeConversionSet(AttributeSet source) {
            super(source);
        }

        public LargeConversionSet() {
        }

        @Override
        public boolean isDefined(Object key) {
            CSS.Attribute cssKey;
            if (key instanceof StyleConstants && (cssKey = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)key)) != null) {
                return super.isDefined(cssKey);
            }
            return super.isDefined(key);
        }

        @Override
        public Object getAttribute(Object key) {
            Object value;
            CSS.Attribute cssKey;
            if (key instanceof StyleConstants && (cssKey = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)key)) != null && (value = super.getAttribute(cssKey)) != null) {
                return StyleSheet.this.css.cssValueToStyleConstantsValue((StyleConstants)key, value);
            }
            return super.getAttribute(key);
        }
    }

    public static class ListPainter
    implements Serializable {
        public void paint(Graphics graphics, float f, float f2, float f3, float f4, View view, int n) {
        }
    }

    static class ResolvedStyle
    extends MuxingAttributeSet
    implements Serializable,
    Style {
        String name;
        private int extendedIndex;

        ResolvedStyle(String name, AttributeSet[] attrs, int extendedIndex) {
            super(attrs);
            this.name = name;
            this.extendedIndex = extendedIndex;
        }

        synchronized void insertStyle(Style style, int specificity) {
            int counter;
            AttributeSet[] attrs = this.getAttributes();
            int maxCounter = attrs.length;
            for (counter = 0; counter < this.extendedIndex && specificity <= StyleSheet.getSpecificity((String)((Style)attrs[counter]).getName()); ++counter) {
            }
            this.insertAttributeSetAt(style, counter);
            ++this.extendedIndex;
        }

        synchronized void removeStyle(Style style) {
            AttributeSet[] attrs = this.getAttributes();
            for (int counter = attrs.length - 1; counter >= 0; --counter) {
                if (attrs[counter] != style) continue;
                this.removeAttributeSetAt(counter);
                if (counter >= this.extendedIndex) break;
                --this.extendedIndex;
                break;
            }
        }

        synchronized void insertExtendedStyleAt(Style attr, int index) {
            this.insertAttributeSetAt(attr, this.extendedIndex + index);
        }

        synchronized void addExtendedStyle(Style attr) {
            this.insertAttributeSetAt(attr, this.getAttributes().length);
        }

        synchronized void removeExtendedStyleAt(int index) {
            this.removeAttributeSetAt(this.extendedIndex + index);
        }

        protected boolean matches(String selector) {
            int sLast = selector.length();
            if (sLast == 0) {
                return false;
            }
            int thisLast = this.name.length();
            int sCurrent = selector.lastIndexOf(32);
            int thisCurrent = this.name.lastIndexOf(32);
            if (sCurrent >= 0) {
                ++sCurrent;
            }
            if (thisCurrent >= 0) {
                ++thisCurrent;
            }
            if (!this.matches(selector, sCurrent, sLast, thisCurrent, thisLast)) {
                return false;
            }
            while (sCurrent != -1) {
                sLast = sCurrent - 1;
                if ((sCurrent = selector.lastIndexOf(32, sLast - 1)) >= 0) {
                    ++sCurrent;
                }
                boolean match = false;
                while (!match && thisCurrent != -1) {
                    thisLast = thisCurrent - 1;
                    if ((thisCurrent = this.name.lastIndexOf(32, thisLast - 1)) >= 0) {
                        ++thisCurrent;
                    }
                    match = this.matches(selector, sCurrent, sLast, thisCurrent, thisLast);
                }
                if (match) continue;
                return false;
            }
            return true;
        }

        boolean matches(String selector, int sCurrent, int sLast, int thisCurrent, int thisLast) {
            sCurrent = Math.max(sCurrent, 0);
            thisCurrent = Math.max(thisCurrent, 0);
            int thisDotIndex = this.boundedIndexOf(this.name, '.', thisCurrent, thisLast);
            int thisPoundIndex = this.boundedIndexOf(this.name, '#', thisCurrent, thisLast);
            int sDotIndex = this.boundedIndexOf(selector, '.', sCurrent, sLast);
            int sPoundIndex = this.boundedIndexOf(selector, '#', sCurrent, sLast);
            if (sDotIndex != -1) {
                if (thisDotIndex == -1) {
                    return false;
                }
                return !(sCurrent == sDotIndex ? thisLast - thisDotIndex != sLast - sDotIndex || !selector.regionMatches(sCurrent, this.name, thisDotIndex, thisLast - thisDotIndex) : sLast - sCurrent != thisLast - thisCurrent || !selector.regionMatches(sCurrent, this.name, thisCurrent, thisLast - thisCurrent));
            }
            if (sPoundIndex != -1) {
                if (thisPoundIndex == -1) {
                    return false;
                }
                return !(sCurrent == sPoundIndex ? thisLast - thisPoundIndex != sLast - sPoundIndex || !selector.regionMatches(sCurrent, this.name, thisPoundIndex, thisLast - thisPoundIndex) : sLast - sCurrent != thisLast - thisCurrent || !selector.regionMatches(sCurrent, this.name, thisCurrent, thisLast - thisCurrent));
            }
            if (thisDotIndex != -1) {
                return thisDotIndex - thisCurrent == sLast - sCurrent && selector.regionMatches(sCurrent, this.name, thisCurrent, thisDotIndex - thisCurrent);
            }
            if (thisPoundIndex != -1) {
                return thisPoundIndex - thisCurrent == sLast - sCurrent && selector.regionMatches(sCurrent, this.name, thisCurrent, thisPoundIndex - thisCurrent);
            }
            return thisLast - thisCurrent == sLast - sCurrent && selector.regionMatches(sCurrent, this.name, thisCurrent, thisLast - thisCurrent);
        }

        int boundedIndexOf(String string, char search, int start, int end) {
            int retValue = string.indexOf(search, start);
            if (retValue >= end) {
                return -1;
            }
            return retValue;
        }

        @Override
        public void addAttribute(Object name, Object value) {
        }

        @Override
        public void addAttributes(AttributeSet attributes) {
        }

        @Override
        public void removeAttribute(Object name) {
        }

        @Override
        public void removeAttributes(Enumeration<?> names) {
        }

        @Override
        public void removeAttributes(AttributeSet attributes) {
        }

        @Override
        public void setResolveParent(AttributeSet parent) {
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void addChangeListener(ChangeListener l) {
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
        }

        public ChangeListener[] getChangeListeners() {
            return new ChangeListener[0];
        }
    }

    private static class SearchBuffer {
        static Stack<SearchBuffer> searchBuffers = new Stack();
        Vector vector = null;
        StringBuffer stringBuffer = null;
        HashSet<SelectorMapping> hashSet = null;

        private SearchBuffer() {
        }

        static SearchBuffer obtainSearchBuffer() {
            SearchBuffer sb;
            try {
                sb = !searchBuffers.empty() ? searchBuffers.pop() : new SearchBuffer();
            }
            catch (EmptyStackException ese) {
                sb = new SearchBuffer();
            }
            return sb;
        }

        static void releaseSearchBuffer(SearchBuffer sb) {
            sb.empty();
            searchBuffers.push(sb);
        }

        StringBuffer getStringBuffer() {
            if (this.stringBuffer == null) {
                this.stringBuffer = new StringBuffer();
            }
            return this.stringBuffer;
        }

        Vector getVector() {
            if (this.vector == null) {
                this.vector = new Vector();
            }
            return this.vector;
        }

        HashSet<SelectorMapping> getHashSet() {
            if (this.hashSet == null) {
                this.hashSet = new HashSet();
            }
            return this.hashSet;
        }

        void empty() {
            if (this.stringBuffer != null) {
                this.stringBuffer.setLength(0);
            }
            if (this.vector != null) {
                this.vector.removeAllElements();
            }
            if (this.hashSet != null) {
                this.hashSet.clear();
            }
        }
    }

    static class SelectorMapping
    implements Serializable {
        private int specificity;
        private Style style;
        private HashMap<String, SelectorMapping> children;

        public SelectorMapping(int specificity) {
            this.specificity = specificity;
        }

        public int getSpecificity() {
            return this.specificity;
        }

        public void setStyle(Style style) {
            this.style = style;
        }

        public Style getStyle() {
            return this.style;
        }

        public SelectorMapping getChildSelectorMapping(String selector, boolean create) {
            SelectorMapping retValue = null;
            if (this.children != null) {
                retValue = this.children.get(selector);
            } else if (create) {
                this.children = new HashMap(7);
            }
            if (retValue == null && create) {
                int specificity = this.getChildSpecificity(selector);
                retValue = this.createChildSelectorMapping(specificity);
                this.children.put(selector, retValue);
            }
            return retValue;
        }

        protected SelectorMapping createChildSelectorMapping(int specificity) {
            return new SelectorMapping(specificity);
        }

        protected int getChildSpecificity(String selector) {
            char firstChar = selector.charAt(0);
            int specificity = this.getSpecificity();
            if (firstChar == '.') {
                specificity += 100;
            } else if (firstChar == '#') {
                specificity += 10000;
            } else {
                ++specificity;
                if (selector.indexOf(46) != -1) {
                    specificity += 100;
                }
                if (selector.indexOf(35) != -1) {
                    specificity += 10000;
                }
            }
            return specificity;
        }
    }

    class SmallConversionSet
    extends StyleContext.SmallAttributeSet {
        public SmallConversionSet(AttributeSet attrs) {
            super((StyleContext)StyleSheet.this, attrs);
        }

        @Override
        public boolean isDefined(Object key) {
            CSS.Attribute cssKey;
            if (key instanceof StyleConstants && (cssKey = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)key)) != null) {
                return super.isDefined(cssKey);
            }
            return super.isDefined(key);
        }

        @Override
        public Object getAttribute(Object key) {
            Object value;
            CSS.Attribute cssKey;
            if (key instanceof StyleConstants && (cssKey = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)key)) != null && (value = super.getAttribute(cssKey)) != null) {
                return StyleSheet.this.css.cssValueToStyleConstantsValue((StyleConstants)key, value);
            }
            return super.getAttribute(key);
        }
    }

    class ViewAttributeSet
    extends MuxingAttributeSet {
        View host;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ViewAttributeSet(View v) {
            this.host = v;
            Document doc = v.getDocument();
            SearchBuffer sb = SearchBuffer.obtainSearchBuffer();
            Vector muxList = sb.getVector();
            try {
                if (doc instanceof HTMLDocument) {
                    StyleSheet styles = StyleSheet.this;
                    Element elem = v.getElement();
                    AttributeSet a = elem.getAttributes();
                    AttributeSet htmlAttr = styles.translateHTMLToCSS(a);
                    if (htmlAttr.getAttributeCount() != 0) {
                        muxList.addElement(htmlAttr);
                    }
                    if (elem.isLeaf()) {
                        Enumeration<?> keys = a.getAttributeNames();
                        while (keys.hasMoreElements()) {
                            Style cssRule;
                            AttributeSet attr;
                            Object o;
                            Object key = keys.nextElement();
                            if (!(key instanceof HTML.Tag) || key == HTML.Tag.A && (o = a.getAttribute(key)) instanceof AttributeSet && (attr = (AttributeSet)o).getAttribute(HTML.Attribute.HREF) == null || (cssRule = styles.getRule((HTML.Tag)key, elem)) == null) continue;
                            muxList.addElement(cssRule);
                        }
                    } else {
                        HTML.Tag t = (HTML.Tag)a.getAttribute(StyleConstants.NameAttribute);
                        Style cssRule = styles.getRule(t, elem);
                        if (cssRule != null) {
                            muxList.addElement(cssRule);
                        }
                    }
                }
                Object[] attrs = new AttributeSet[muxList.size()];
                muxList.copyInto(attrs);
                this.setAttributes((AttributeSet[])attrs);
            }
            finally {
                SearchBuffer.releaseSearchBuffer(sb);
            }
        }

        @Override
        public boolean isDefined(Object key) {
            CSS.Attribute cssKey;
            if (key instanceof StyleConstants && (cssKey = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)key)) != null) {
                key = cssKey;
            }
            return super.isDefined(key);
        }

        @Override
        public Object getAttribute(Object key) {
            CSS.Attribute cssKey;
            if (key instanceof StyleConstants && (cssKey = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)key)) != null) {
                Object value = this.doGetAttribute(cssKey);
                if (value instanceof CSS.FontSize) {
                    return ((CSS.FontSize)value).getValue(this, StyleSheet.this);
                }
                if (value instanceof CSS.CssValue) {
                    return ((CSS.CssValue)value).toStyleConstants((StyleConstants)key, this.host);
                }
            }
            return this.doGetAttribute(key);
        }

        private Object getTextDecoration(Object value) {
            AttributeSet parent = this.getResolveParent();
            if (parent == null) {
                return value;
            }
            Object parentValue = parent.getAttribute(CSS.Attribute.TEXT_DECORATION);
            return parentValue == null ? value : CSS.mergeTextDecoration(String.valueOf(value) + "," + String.valueOf(parentValue));
        }

        Object doGetAttribute(Object key) {
            AttributeSet parent;
            CSS.Attribute css;
            Object retValue = super.getAttribute(key);
            if (retValue != null) {
                if (key != CSS.Attribute.TEXT_DECORATION) {
                    return retValue;
                }
                return this.getTextDecoration(retValue);
            }
            if (key == CSS.Attribute.FONT_SIZE) {
                return StyleSheet.this.fontSizeInherit();
            }
            if (key instanceof CSS.Attribute && (css = (CSS.Attribute)key).isInherited() && (parent = this.getResolveParent()) != null) {
                return parent.getAttribute(key);
            }
            return null;
        }

        @Override
        public AttributeSet getResolveParent() {
            if (this.host == null) {
                return null;
            }
            View parent = this.host.getParent();
            return parent != null ? parent.getAttributes() : null;
        }
    }
}

