/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedHeightLayoutCache
extends AbstractLayoutCache {
    @Override
    public void setModel(TreeModel treeModel) {
    }

    @Override
    public void setRootVisible(boolean bl) {
    }

    @Override
    public void setRowHeight(int n) {
    }

    @Override
    public int getRowCount() {
        return 0;
    }

    @Override
    public void invalidatePathBounds(TreePath treePath) {
    }

    @Override
    public void invalidateSizes() {
    }

    @Override
    public boolean isExpanded(TreePath treePath) {
        return false;
    }

    @Override
    public Rectangle getBounds(TreePath treePath, Rectangle rectangle) {
        return null;
    }

    @Override
    public TreePath getPathForRow(int n) {
        return null;
    }

    @Override
    public int getRowForPath(TreePath treePath) {
        return 0;
    }

    @Override
    public TreePath getPathClosestTo(int n, int n2) {
        return null;
    }

    @Override
    public int getVisibleChildCount(TreePath treePath) {
        return 0;
    }

    @Override
    public Enumeration<TreePath> getVisiblePathsFrom(TreePath treePath) {
        return null;
    }

    @Override
    public void setExpandedState(TreePath treePath, boolean bl) {
    }

    @Override
    public boolean getExpandedState(TreePath treePath) {
        return false;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
    }

    private class FHTreeStateNode
    extends DefaultMutableTreeNode {
        protected boolean isExpanded;
        protected int childIndex;
        protected int childCount;
        protected int row;
        protected TreePath path;

        public FHTreeStateNode(Object userObject, int childIndex, int row) {
            super(userObject);
            this.childIndex = childIndex;
            this.row = row;
        }

        @Override
        public void setParent(MutableTreeNode parent) {
            super.setParent(parent);
            if (parent != null) {
                this.path = ((FHTreeStateNode)parent).getTreePath().pathByAddingChild(this.getUserObject());
                FixedHeightLayoutCache.this.addMapping(this);
            }
        }

        @Override
        public void remove(int childIndex) {
            FHTreeStateNode node = (FHTreeStateNode)this.getChildAt(childIndex);
            node.removeFromMapping();
            super.remove(childIndex);
        }

        @Override
        public void setUserObject(Object o) {
            super.setUserObject(o);
            if (this.path != null) {
                FHTreeStateNode parent = (FHTreeStateNode)this.getParent();
                if (parent != null) {
                    this.resetChildrenPaths(parent.getTreePath());
                } else {
                    this.resetChildrenPaths(null);
                }
            }
        }

        public int getChildIndex() {
            return this.childIndex;
        }

        public TreePath getTreePath() {
            return this.path;
        }

        public FHTreeStateNode getChildAtModelIndex(int index) {
            for (int counter = this.getChildCount() - 1; counter >= 0; --counter) {
                if (((FHTreeStateNode)this.getChildAt((int)counter)).childIndex != index) continue;
                return (FHTreeStateNode)this.getChildAt(counter);
            }
            return null;
        }

        public boolean isVisible() {
            FHTreeStateNode parent = (FHTreeStateNode)this.getParent();
            if (parent == null) {
                return true;
            }
            return parent.isExpanded() && parent.isVisible();
        }

        public int getRow() {
            return this.row;
        }

        public int getRowToModelIndex(int index) {
            int lastRow;
            int retValue = lastRow = this.getRow() + 1;
            int maxCounter = this.getChildCount();
            for (int counter = 0; counter < maxCounter; ++counter) {
                FHTreeStateNode child = (FHTreeStateNode)this.getChildAt(counter);
                if (child.childIndex < index) continue;
                if (child.childIndex == index) {
                    return child.row;
                }
                if (counter == 0) {
                    return this.getRow() + 1 + index;
                }
                return child.row - (child.childIndex - index);
            }
            return this.getRow() + 1 + this.getTotalChildCount() - (this.childCount - index);
        }

        public int getTotalChildCount() {
            if (this.isExpanded()) {
                int pIndex;
                FHTreeStateNode parent = (FHTreeStateNode)this.getParent();
                if (parent != null && (pIndex = parent.getIndex(this)) + 1 < parent.getChildCount()) {
                    FHTreeStateNode nextSibling = (FHTreeStateNode)parent.getChildAt(pIndex + 1);
                    return nextSibling.row - this.row - (nextSibling.childIndex - this.childIndex);
                }
                int retCount = this.childCount;
                for (int counter = this.getChildCount() - 1; counter >= 0; --counter) {
                    retCount += ((FHTreeStateNode)this.getChildAt(counter)).getTotalChildCount();
                }
                return retCount;
            }
            return 0;
        }

        public boolean isExpanded() {
            return this.isExpanded;
        }

        public int getVisibleLevel() {
            if (FixedHeightLayoutCache.this.isRootVisible()) {
                return this.getLevel();
            }
            return this.getLevel() - 1;
        }

        protected void resetChildrenPaths(TreePath parentPath) {
            FixedHeightLayoutCache.this.removeMapping(this);
            this.path = parentPath == null ? new TreePath(this.getUserObject()) : parentPath.pathByAddingChild(this.getUserObject());
            FixedHeightLayoutCache.this.addMapping(this);
            for (int counter = this.getChildCount() - 1; counter >= 0; --counter) {
                ((FHTreeStateNode)this.getChildAt(counter)).resetChildrenPaths(this.path);
            }
        }

        protected void removeFromMapping() {
            if (this.path != null) {
                FixedHeightLayoutCache.this.removeMapping(this);
                for (int counter = this.getChildCount() - 1; counter >= 0; --counter) {
                    ((FHTreeStateNode)this.getChildAt(counter)).removeFromMapping();
                }
            }
        }

        protected FHTreeStateNode createChildFor(Object userObject) {
            int newChildIndex = FixedHeightLayoutCache.this.treeModel.getIndexOfChild(this.getUserObject(), userObject);
            if (newChildIndex < 0) {
                return null;
            }
            FHTreeStateNode child = FixedHeightLayoutCache.this.createNodeForValue(userObject, newChildIndex);
            int childRow = this.isVisible() ? this.getRowToModelIndex(newChildIndex) : -1;
            child.row = childRow;
            int maxCounter = this.getChildCount();
            for (int counter = 0; counter < maxCounter; ++counter) {
                FHTreeStateNode aNode = (FHTreeStateNode)this.getChildAt(counter);
                if (aNode.childIndex <= newChildIndex) continue;
                this.insert(child, counter);
                return child;
            }
            this.add(child);
            return child;
        }

        protected void adjustRowBy(int amount) {
            this.row += amount;
            if (this.isExpanded) {
                for (int counter = this.getChildCount() - 1; counter >= 0; --counter) {
                    ((FHTreeStateNode)this.getChildAt(counter)).adjustRowBy(amount);
                }
            }
        }

        protected void adjustRowBy(int amount, int startIndex) {
            FHTreeStateNode parent;
            if (this.isExpanded) {
                for (int counter = this.getChildCount() - 1; counter >= startIndex; --counter) {
                    ((FHTreeStateNode)this.getChildAt(counter)).adjustRowBy(amount);
                }
            }
            if ((parent = (FHTreeStateNode)this.getParent()) != null) {
                parent.adjustRowBy(amount, parent.getIndex(this) + 1);
            }
        }

        protected void didExpand() {
            int nextRow = this.setRowAndChildren(this.row);
            FHTreeStateNode parent = (FHTreeStateNode)this.getParent();
            int childRowCount = nextRow - this.row - 1;
            if (parent != null) {
                parent.adjustRowBy(childRowCount, parent.getIndex(this) + 1);
            }
            FixedHeightLayoutCache.this.adjustRowCountBy(childRowCount);
        }

        protected int setRowAndChildren(int nextRow) {
            this.row = nextRow;
            if (!this.isExpanded()) {
                return this.row + 1;
            }
            int lastRow = this.row + 1;
            int lastModelIndex = 0;
            int maxCounter = this.getChildCount();
            for (int counter = 0; counter < maxCounter; ++counter) {
                FHTreeStateNode child = (FHTreeStateNode)this.getChildAt(counter);
                lastRow += child.childIndex - lastModelIndex;
                lastModelIndex = child.childIndex + 1;
                if (child.isExpanded) {
                    lastRow = child.setRowAndChildren(lastRow);
                    continue;
                }
                child.row = lastRow++;
            }
            return lastRow + this.childCount - lastModelIndex;
        }

        protected void resetChildrenRowsFrom(int newRow, int childIndex, int modelIndex) {
            FHTreeStateNode node;
            int lastRow = newRow;
            int lastModelIndex = modelIndex;
            int maxCounter = this.getChildCount();
            for (int counter = childIndex; counter < maxCounter; ++counter) {
                node = (FHTreeStateNode)this.getChildAt(counter);
                lastRow += node.childIndex - lastModelIndex;
                lastModelIndex = node.childIndex + 1;
                if (node.isExpanded) {
                    lastRow = node.setRowAndChildren(lastRow);
                    continue;
                }
                node.row = lastRow++;
            }
            lastRow += this.childCount - lastModelIndex;
            node = (FHTreeStateNode)this.getParent();
            if (node != null) {
                node.resetChildrenRowsFrom(lastRow, node.getIndex(this) + 1, this.childIndex + 1);
            } else {
                FixedHeightLayoutCache.this.rowCount = lastRow;
            }
        }

        protected void makeVisible() {
            FHTreeStateNode parent = (FHTreeStateNode)this.getParent();
            if (parent != null) {
                parent.expandParentAndReceiver();
            }
        }

        protected void expandParentAndReceiver() {
            FHTreeStateNode parent = (FHTreeStateNode)this.getParent();
            if (parent != null) {
                parent.expandParentAndReceiver();
            }
            this.expand();
        }

        protected void expand() {
            if (!this.isExpanded && !this.isLeaf()) {
                boolean visible = this.isVisible();
                this.isExpanded = true;
                this.childCount = FixedHeightLayoutCache.this.treeModel.getChildCount(this.getUserObject());
                if (visible) {
                    this.didExpand();
                }
                if (visible && FixedHeightLayoutCache.this.treeSelectionModel != null) {
                    FixedHeightLayoutCache.this.treeSelectionModel.resetRowSelection();
                }
            }
        }

        protected void collapse(boolean adjustRows) {
            if (this.isExpanded) {
                if (this.isVisible() && adjustRows) {
                    int childCount = this.getTotalChildCount();
                    this.isExpanded = false;
                    FixedHeightLayoutCache.this.adjustRowCountBy(-childCount);
                    this.adjustRowBy(-childCount, 0);
                } else {
                    this.isExpanded = false;
                }
                if (adjustRows && this.isVisible() && FixedHeightLayoutCache.this.treeSelectionModel != null) {
                    FixedHeightLayoutCache.this.treeSelectionModel.resetRowSelection();
                }
            }
        }

        @Override
        public boolean isLeaf() {
            TreeModel model = FixedHeightLayoutCache.this.getModel();
            return model != null ? model.isLeaf(this.getUserObject()) : true;
        }

        protected void addNode(FHTreeStateNode newChild) {
            boolean added = false;
            int childIndex = newChild.getChildIndex();
            int maxCounter = this.getChildCount();
            for (int counter = 0; counter < maxCounter; ++counter) {
                if (((FHTreeStateNode)this.getChildAt(counter)).getChildIndex() <= childIndex) continue;
                added = true;
                this.insert(newChild, counter);
                counter = maxCounter;
            }
            if (!added) {
                this.add(newChild);
            }
        }

        protected void removeChildAtModelIndex(int modelIndex, boolean isChildVisible) {
            FHTreeStateNode childNode = this.getChildAtModelIndex(modelIndex);
            if (childNode != null) {
                int row = childNode.getRow();
                int index = this.getIndex(childNode);
                childNode.collapse(false);
                this.remove(index);
                this.adjustChildIndexs(index, -1);
                --this.childCount;
                if (isChildVisible) {
                    this.resetChildrenRowsFrom(row, index, modelIndex);
                }
            } else {
                int maxCounter = this.getChildCount();
                for (int counter = 0; counter < maxCounter; ++counter) {
                    FHTreeStateNode aChild = (FHTreeStateNode)this.getChildAt(counter);
                    if (aChild.childIndex < modelIndex) continue;
                    if (isChildVisible) {
                        this.adjustRowBy(-1, counter);
                        FixedHeightLayoutCache.this.adjustRowCountBy(-1);
                    }
                    while (counter < maxCounter) {
                        --((FHTreeStateNode)this.getChildAt((int)counter)).childIndex;
                        ++counter;
                    }
                    --this.childCount;
                    return;
                }
                if (isChildVisible) {
                    this.adjustRowBy(-1, maxCounter);
                    FixedHeightLayoutCache.this.adjustRowCountBy(-1);
                }
                --this.childCount;
            }
        }

        protected void adjustChildIndexs(int index, int amount) {
            int maxCounter = this.getChildCount();
            for (int counter = index; counter < maxCounter; ++counter) {
                ((FHTreeStateNode)this.getChildAt((int)counter)).childIndex += amount;
            }
        }

        protected void childInsertedAtModelIndex(int index, boolean isExpandedAndVisible) {
            int maxCounter = this.getChildCount();
            for (int counter = 0; counter < maxCounter; ++counter) {
                FHTreeStateNode aChild = (FHTreeStateNode)this.getChildAt(counter);
                if (aChild.childIndex < index) continue;
                if (isExpandedAndVisible) {
                    this.adjustRowBy(1, counter);
                    FixedHeightLayoutCache.this.adjustRowCountBy(1);
                }
                while (counter < maxCounter) {
                    ++((FHTreeStateNode)this.getChildAt((int)counter)).childIndex;
                    ++counter;
                }
                ++this.childCount;
                return;
            }
            if (isExpandedAndVisible) {
                this.adjustRowBy(1, maxCounter);
                FixedHeightLayoutCache.this.adjustRowCountBy(1);
            }
            ++this.childCount;
        }

        protected boolean getPathForRow(int row, int nextRow, SearchInfo info) {
            if (this.row == row) {
                info.node = this;
                info.isNodeParentNode = false;
                info.childIndex = this.childIndex;
                return true;
            }
            FHTreeStateNode lastChild = null;
            int maxCounter = this.getChildCount();
            for (int counter = 0; counter < maxCounter; ++counter) {
                FHTreeStateNode child = (FHTreeStateNode)this.getChildAt(counter);
                if (child.row > row) {
                    if (counter == 0) {
                        info.node = this;
                        info.isNodeParentNode = true;
                        info.childIndex = row - this.row - 1;
                        return true;
                    }
                    int lastChildEndRow = 1 + child.row - (child.childIndex - lastChild.childIndex);
                    if (row < lastChildEndRow) {
                        return lastChild.getPathForRow(row, lastChildEndRow, info);
                    }
                    info.node = this;
                    info.isNodeParentNode = true;
                    info.childIndex = row - lastChildEndRow + lastChild.childIndex + 1;
                    return true;
                }
                lastChild = child;
            }
            if (lastChild != null) {
                int lastChildEndRow = nextRow - (this.childCount - lastChild.childIndex) + 1;
                if (row < lastChildEndRow) {
                    return lastChild.getPathForRow(row, lastChildEndRow, info);
                }
                info.node = this;
                info.isNodeParentNode = true;
                info.childIndex = row - lastChildEndRow + lastChild.childIndex + 1;
                return true;
            }
            int retChildIndex = row - this.row - 1;
            if (retChildIndex >= this.childCount) {
                return false;
            }
            info.node = this;
            info.isNodeParentNode = true;
            info.childIndex = retChildIndex;
            return true;
        }

        protected int getCountTo(int stopIndex) {
            int retCount = stopIndex + 1;
            int maxCounter = this.getChildCount();
            for (int counter = 0; counter < maxCounter; ++counter) {
                FHTreeStateNode aChild = (FHTreeStateNode)this.getChildAt(counter);
                if (aChild.childIndex >= stopIndex) {
                    counter = maxCounter;
                    continue;
                }
                retCount += aChild.getTotalChildCount();
            }
            if (this.parent != null) {
                return retCount + ((FHTreeStateNode)this.getParent()).getCountTo(this.childIndex);
            }
            if (!FixedHeightLayoutCache.this.isRootVisible()) {
                return retCount - 1;
            }
            return retCount;
        }

        protected int getNumExpandedChildrenTo(int stopIndex) {
            int retCount = stopIndex;
            int maxCounter = this.getChildCount();
            for (int counter = 0; counter < maxCounter; ++counter) {
                FHTreeStateNode aChild = (FHTreeStateNode)this.getChildAt(counter);
                if (aChild.childIndex >= stopIndex) {
                    return retCount;
                }
                retCount += aChild.getTotalChildCount();
            }
            return retCount;
        }

        protected void didAdjustTree() {
        }
    }

    private class SearchInfo {
        protected FHTreeStateNode node;
        protected boolean isNodeParentNode;
        protected int childIndex;

        private SearchInfo() {
        }

        protected TreePath getPath() {
            if (this.node == null) {
                return null;
            }
            if (this.isNodeParentNode) {
                return this.node.getTreePath().pathByAddingChild(FixedHeightLayoutCache.this.treeModel.getChild(this.node.getUserObject(), this.childIndex));
            }
            return this.node.path;
        }
    }

    private class VisibleFHTreeStateNodeEnumeration
    implements Enumeration<TreePath> {
        protected FHTreeStateNode parent;
        protected int nextIndex;
        protected int childCount;

        protected VisibleFHTreeStateNodeEnumeration(FHTreeStateNode node) {
            this(node, -1);
        }

        protected VisibleFHTreeStateNodeEnumeration(FHTreeStateNode parent, int startIndex) {
            this.parent = parent;
            this.nextIndex = startIndex;
            this.childCount = FixedHeightLayoutCache.this.treeModel.getChildCount(this.parent.getUserObject());
        }

        @Override
        public boolean hasMoreElements() {
            return this.parent != null;
        }

        @Override
        public TreePath nextElement() {
            FHTreeStateNode node;
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("No more visible paths");
            }
            TreePath retObject = this.nextIndex == -1 ? this.parent.getTreePath() : ((node = this.parent.getChildAtModelIndex(this.nextIndex)) == null ? this.parent.getTreePath().pathByAddingChild(FixedHeightLayoutCache.this.treeModel.getChild(this.parent.getUserObject(), this.nextIndex)) : node.getTreePath());
            this.updateNextObject();
            return retObject;
        }

        protected void updateNextObject() {
            if (!this.updateNextIndex()) {
                this.findNextValidParent();
            }
        }

        protected boolean findNextValidParent() {
            if (this.parent == FixedHeightLayoutCache.this.root) {
                this.parent = null;
                return false;
            }
            while (this.parent != null) {
                FHTreeStateNode newParent = (FHTreeStateNode)this.parent.getParent();
                if (newParent != null) {
                    this.nextIndex = this.parent.childIndex;
                    this.parent = newParent;
                    this.childCount = FixedHeightLayoutCache.this.treeModel.getChildCount(this.parent.getUserObject());
                    if (!this.updateNextIndex()) continue;
                    return true;
                }
                this.parent = null;
            }
            return false;
        }

        protected boolean updateNextIndex() {
            if (this.nextIndex == -1 && !this.parent.isExpanded()) {
                return false;
            }
            if (this.childCount == 0) {
                return false;
            }
            if (++this.nextIndex >= this.childCount) {
                return false;
            }
            FHTreeStateNode child = this.parent.getChildAtModelIndex(this.nextIndex);
            if (child != null && child.isExpanded()) {
                this.parent = child;
                this.nextIndex = -1;
                this.childCount = FixedHeightLayoutCache.this.treeModel.getChildCount(child.getUserObject());
            }
            return true;
        }
    }
}

