/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

public class OSInfo {
    public static void main(String[] args) {
        System.out.print(OSInfo.getNativeLibFolderPathForCurrentOS());
    }

    public static String getNativeLibFolderPathForCurrentOS() {
        return OSInfo.getOSName() + "/" + OSInfo.getArchName();
    }

    public static String getOSName() {
        return OSInfo.translateOSNameToFolderName(System.getProperty("os.name"));
    }

    public static String getArchName() {
        return OSInfo.translateArchNameToFolderName(System.getProperty("os.arch"));
    }

    public static String translateOSNameToFolderName(String osName) {
        if (osName.contains("Windows")) {
            return "Windows";
        }
        if (osName.contains("Mac")) {
            return "Mac";
        }
        if (osName.contains("Linux")) {
            return "Linux";
        }
        return osName.replaceAll("\\W", "");
    }

    public static String translateArchNameToFolderName(String archName) {
        return archName.replaceAll("\\W", "");
    }
}

