/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import com.dropbox.client2.android.AuthActivity;
import com.dropbox.client2.session.AbstractSession;
import com.dropbox.client2.session.AccessTokenPair;
import com.dropbox.client2.session.AppKeyPair;
import com.dropbox.client2.session.Session;
import java.util.List;

public class AndroidAuthSession
extends AbstractSession {
    public AndroidAuthSession(AppKeyPair appKeyPair, Session.AccessType type) {
        super(appKeyPair, type);
    }

    public AndroidAuthSession(AppKeyPair appKeyPair, Session.AccessType type, AccessTokenPair accessTokenPair) {
        super(appKeyPair, type, accessTokenPair);
    }

    public void startAuthentication(Context context) {
        AppKeyPair appKeyPair = this.getAppKeyPair();
        Intent testIntent = new Intent("android.intent.action.VIEW");
        String scheme = "db-" + appKeyPair.key;
        String uri = scheme + "://" + 1 + "/test";
        testIntent.setData(Uri.parse((String)uri));
        PackageManager pm = context.getPackageManager();
        List activities = pm.queryIntentActivities(testIntent, 0);
        if (0 == activities.size()) {
            throw new IllegalStateException("URI scheme in your app's manifest is not set up correctly. You should have a com.dropbox.client2.android.AuthActivity with the scheme: " + scheme);
        }
        if (activities.size() > 1) {
            AlertDialog.Builder builder = new AlertDialog.Builder(context);
            builder.setTitle((CharSequence)"Security alert");
            builder.setMessage((CharSequence)"Another app on your phone may be trying to pose as the app you are currently using. The malicious app cannot access your account, but linking to Dropbox has been disabled as a precaution. Please contact support@dropbox.com.");
            builder.setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            });
            builder.show();
            return;
        }
        String authPackage = ((ResolveInfo)activities.get((int)0)).activityInfo.packageName;
        if (!context.getPackageName().equals(authPackage)) {
            throw new IllegalStateException("There must be an AuthActivity within your app's package registered for your URI scheme (" + scheme + "). However, it " + "appears that an activity in a different package is " + "registered for that scheme instead. If you have " + "multiple apps that all want to use the same access" + "token pair, designate one of them to do " + "authentication and have the other apps launch it " + "and then retrieve the token pair from it.");
        }
        Intent intent = new Intent(context, AuthActivity.class);
        intent.putExtra("EXTRA_INTERNAL_CONSUMER_KEY", appKeyPair.key);
        intent.putExtra("EXTRA_INTERNAL_CONSUMER_SECRET", appKeyPair.secret);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        context.startActivity(intent);
    }

    public boolean authenticationSuccessful() {
        Intent data = AuthActivity.lastResult;
        if (data == null) {
            return false;
        }
        String token = data.getStringExtra("ACCESS_TOKEN");
        String secret = data.getStringExtra("ACCESS_SECRET");
        String uid = data.getStringExtra("UID");
        return token != null && !token.equals("") && secret != null && !secret.equals("") && uid != null && !uid.equals("");
    }

    public String finishAuthentication() throws IllegalStateException {
        Intent data = AuthActivity.lastResult;
        if (data == null) {
            throw new IllegalStateException();
        }
        String token = data.getStringExtra("ACCESS_TOKEN");
        String secret = data.getStringExtra("ACCESS_SECRET");
        String uid = data.getStringExtra("UID");
        if (!(token == null || token.equals("") || secret == null || secret.equals("") || uid == null || uid.equals(""))) {
            AccessTokenPair tokens = new AccessTokenPair(token, secret);
            this.setAccessTokenPair(tokens);
            return uid;
        }
        throw new IllegalStateException();
    }

    public void unlink() {
        super.unlink();
        AuthActivity.lastResult = null;
    }
}

