/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2.android;

import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.Bundle;
import com.dropbox.client2.RESTUtility;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class AuthActivity
extends Activity {
    public static final String EXTRA_CONSUMER_KEY = "CONSUMER_KEY";
    public static final String EXTRA_ACCESS_TOKEN = "ACCESS_TOKEN";
    public static final String EXTRA_ACCESS_SECRET = "ACCESS_SECRET";
    public static final String EXTRA_UID = "UID";
    public static final String EXTRA_CONSUMER_SIG = "CONSUMER_SIG";
    public static final String EXTRA_CALLING_PACKAGE = "CALLING_PACKAGE";
    public static final String ACTION_AUTHENTICATE_V1 = "com.dropbox.android.AUTHENTICATE_V1";
    public static final int AUTH_VERSION = 1;
    static final String EXTRA_INTERNAL_CONSUMER_KEY = "EXTRA_INTERNAL_CONSUMER_KEY";
    static final String EXTRA_INTERNAL_CONSUMER_SECRET = "EXTRA_INTERNAL_CONSUMER_SECRET";
    static Intent lastResult = null;
    private String consumerKey = null;
    private String consumerSecret = null;
    private boolean hasDelegated = false;
    private boolean gotNewIntent = false;
    private static final String[] DROPBOX_APP_SIGNATURES = new String[]{"308202223082018b02044bd207bd300d06092a864886f70d01010405003058310b3009060355040613025553310b3009060355040813024341311630140603550407130d53616e204672616e636973636f3110300e060355040a130744726f70626f783112301006035504031309546f6d204d65796572301e170d3130303432333230343930315a170d3430303431353230343930315a3058310b3009060355040613025553310b3009060355040813024341311630140603550407130d53616e204672616e636973636f3110300e060355040a130744726f70626f783112301006035504031309546f6d204d6579657230819f300d06092a864886f70d010101050003818d0030818902818100ac1595d0ab278a9577f0ca5a14144f96eccde75f5616f36172c562fab0e98c48ad7d64f1091c6cc11ce084a4313d522f899378d312e112a748827545146a779defa7c31d8c00c2ed73135802f6952f59798579859e0214d4e9c0554b53b26032a4d2dfc2f62540d776df2ea70e2a6152945fb53fef5bac5344251595b729d4810203010001300d06092a864886f70d01010405000381810055c425d94d036153203dc0bbeb3516f94563b102fff39c3d4ed91278db24fc4424a244c2e59f03bbfea59404512b8bf74662f2a32e37eafa2ac904c31f99cfc21c9ff375c977c432d3b6ec22776f28767d0f292144884538c3d5669b568e4254e4ed75d9054f75229ac9d4ccd0b7c3c74a34f07b7657083b2aa76225c0c56ffc", "308201e53082014ea00302010202044e17e115300d06092a864886f70d01010505003037310b30090603550406130255533110300e060355040a1307416e64726f6964311630140603550403130d416e64726f6964204465627567301e170d3131303730393035303331375a170d3431303730313035303331375a3037310b30090603550406130255533110300e060355040a1307416e64726f6964311630140603550403130d416e64726f696420446562756730819f300d06092a864886f70d010101050003818d003081890281810096759fe5abea6a0757039b92adc68d672efa84732c3f959408e12efa264545c61f23141026a6d01eceeeaa13ec7087087e5894a3363da8bf5c69ed93657a6890738a80998e4ca22dc94848f30e2d0e1890000ae2cddf543b20c0c3828deca6c7944b5ecd21a9d18c988b2b3e54517dafbc34b48e801bb1321e0fa49e4d575d7f0203010001300d06092a864886f70d0101050500038181002b6d4b65bcfa6ec7bac97ae6d878064d47b3f9f8da654995b8ef4c385bc4fbfbb7a987f60783ef0348760c0708acd4b7e63f0235c35a4fbcd5ec41b3b4cb295feaa7d5c27fa562a02562b7e1f4776b85147be3e295714986c4a9a07183f48ea09ae4d3ea31b88d0016c65b93526b9c45f2967c3d28dee1aff5a5b29b9c2c8639"};

    protected void onCreate(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.consumerKey = savedInstanceState.getString("consumerKey");
            this.consumerSecret = savedInstanceState.getString("consumerSecret");
            this.hasDelegated = savedInstanceState.getBoolean("hasDelegated");
        }
        if (this.consumerKey == null) {
            Intent intent = this.getIntent();
            this.consumerKey = intent.getStringExtra(EXTRA_INTERNAL_CONSUMER_KEY);
            this.consumerSecret = intent.getStringExtra(EXTRA_INTERNAL_CONSUMER_SECRET);
        }
        this.setTheme(0x1030010);
        super.onCreate(savedInstanceState);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString("consumerKey", this.consumerKey);
        outState.putString("consumerSecret", this.consumerSecret);
        outState.putBoolean("hasDelegated", this.hasDelegated);
    }

    protected void onResume() {
        super.onResume();
        if (this.consumerKey == null || this.consumerSecret == null) {
            this.finish();
            return;
        }
        if (!this.hasDelegated) {
            Intent officialIntent = new Intent();
            officialIntent.setClassName("com.dropbox.android", "com.dropbox.android.activity.auth.DropboxAuth");
            officialIntent.setAction(ACTION_AUTHENTICATE_V1);
            officialIntent.putExtra(EXTRA_CONSUMER_KEY, this.consumerKey);
            officialIntent.putExtra(EXTRA_CONSUMER_SIG, this.getConsumerSig());
            officialIntent.putExtra(EXTRA_CALLING_PACKAGE, this.getPackageName());
            if (this.hasDropboxApp(officialIntent)) {
                this.startActivity(officialIntent);
            } else {
                this.startWebAuth();
            }
            this.hasDelegated = true;
        } else if (!this.gotNewIntent) {
            lastResult = new Intent();
            this.finish();
            return;
        }
    }

    protected void onNewIntent(Intent intent) {
        String token = null;
        String secret = null;
        String uid = null;
        if (intent.hasExtra(EXTRA_ACCESS_TOKEN)) {
            token = intent.getStringExtra(EXTRA_ACCESS_TOKEN);
            secret = intent.getStringExtra(EXTRA_ACCESS_SECRET);
            uid = intent.getStringExtra(EXTRA_UID);
        } else {
            String path;
            Uri uri = intent.getData();
            if (uri != null && "/connect".equals(path = uri.getPath())) {
                try {
                    token = uri.getQueryParameter("oauth_token");
                    secret = uri.getQueryParameter("oauth_token_secret");
                    uid = uri.getQueryParameter("uid");
                }
                catch (UnsupportedOperationException e) {
                    // empty catch block
                }
            }
        }
        lastResult = new Intent();
        if (!(token == null || token.equals("") || secret == null || secret.equals("") || uid == null || uid.equals(""))) {
            lastResult.putExtra(EXTRA_ACCESS_TOKEN, token);
            lastResult.putExtra(EXTRA_ACCESS_SECRET, secret);
            lastResult.putExtra(EXTRA_UID, uid);
        }
        this.gotNewIntent = true;
        this.finish();
    }

    private String getConsumerSig() {
        MessageDigest m = null;
        try {
            m = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            // empty catch block
        }
        m.update(this.consumerSecret.getBytes(), 0, this.consumerSecret.length());
        BigInteger i = new BigInteger(1, m.digest());
        String s = String.format("%1$040X", i);
        return s.substring(32);
    }

    private boolean hasDropboxApp(Intent intent) {
        PackageInfo packageInfo;
        PackageManager manager = this.getPackageManager();
        if (0 == manager.queryIntentActivities(intent, 0).size()) {
            return false;
        }
        ResolveInfo resolveInfo = manager.resolveActivity(intent, 0);
        if (resolveInfo == null) {
            return false;
        }
        try {
            packageInfo = manager.getPackageInfo(resolveInfo.activityInfo.packageName, 64);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        for (Signature signature : packageInfo.signatures) {
            for (String dbSignature : DROPBOX_APP_SIGNATURES) {
                if (!dbSignature.equals(signature.toCharsString())) continue;
                return true;
            }
        }
        return false;
    }

    private void startWebAuth() {
        String path = "/connect";
        String[] params = new String[]{"k", this.consumerKey, "s", this.getConsumerSig()};
        String url = RESTUtility.buildURL("www.dropbox.com", 1, path, params);
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        this.startActivity(intent);
    }
}

