/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.Utf8;
import com.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;

public class ClassificationBox
extends AbstractFullBox {
    public static final String TYPE = "clsf";
    private String classificationEntity;
    private int classificationTableIndex;
    private String language;
    private String classificationInfo;

    public ClassificationBox() {
        super(TYPE);
    }

    public String getLanguage() {
        return this.language;
    }

    public String getClassificationEntity() {
        return this.classificationEntity;
    }

    public int getClassificationTableIndex() {
        return this.classificationTableIndex;
    }

    public String getClassificationInfo() {
        return this.classificationInfo;
    }

    public void setClassificationEntity(String classificationEntity) {
        this.classificationEntity = classificationEntity;
    }

    public void setClassificationTableIndex(int classificationTableIndex) {
        this.classificationTableIndex = classificationTableIndex;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setClassificationInfo(String classificationInfo) {
        this.classificationInfo = classificationInfo;
    }

    @Override
    protected long getContentSize() {
        return 8 + Utf8.utf8StringLengthInBytes(this.classificationInfo) + 1;
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        byte[] cE = new byte[4];
        content.get(cE);
        this.classificationEntity = IsoFile.bytesToFourCC(cE);
        this.classificationTableIndex = IsoTypeReader.readUInt16(content);
        this.language = IsoTypeReader.readIso639(content);
        this.classificationInfo = IsoTypeReader.readString(content);
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        byteBuffer.put(IsoFile.fourCCtoBytes(this.classificationEntity));
        IsoTypeWriter.writeUInt16(byteBuffer, this.classificationTableIndex);
        IsoTypeWriter.writeIso639(byteBuffer, this.language);
        byteBuffer.put(Utf8.convert(this.classificationInfo));
        byteBuffer.put((byte)0);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("ClassificationBox[language=").append(this.getLanguage());
        buffer.append("classificationEntity=").append(this.getClassificationEntity());
        buffer.append(";classificationTableIndex=").append(this.getClassificationTableIndex());
        buffer.append(";language=").append(this.getLanguage());
        buffer.append(";classificationInfo=").append(this.getClassificationInfo());
        buffer.append("]");
        return buffer.toString();
    }
}

