/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;

public class MovieHeaderBox
extends AbstractFullBox {
    private long creationTime;
    private long modificationTime;
    private long timescale;
    private long duration;
    private double rate = 1.0;
    private float volume = 1.0f;
    private long[] matrix = new long[]{65536L, 0L, 0L, 0L, 65536L, 0L, 0L, 0L, 0x40000000L};
    private long nextTrackId;
    public static final String TYPE = "mvhd";

    public MovieHeaderBox() {
        super(TYPE);
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public long getTimescale() {
        return this.timescale;
    }

    public long getDuration() {
        return this.duration;
    }

    public double getRate() {
        return this.rate;
    }

    public float getVolume() {
        return this.volume;
    }

    public long[] getMatrix() {
        return this.matrix;
    }

    public long getNextTrackId() {
        return this.nextTrackId;
    }

    @Override
    protected long getContentSize() {
        long contentSize = 4L;
        contentSize = this.getVersion() == 1 ? (contentSize += 28L) : (contentSize += 16L);
        return contentSize += 80L;
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        int i;
        this.parseVersionAndFlags(content);
        if (this.getVersion() == 1) {
            this.creationTime = IsoTypeReader.readUInt64(content);
            this.modificationTime = IsoTypeReader.readUInt64(content);
            this.timescale = IsoTypeReader.readUInt32(content);
            this.duration = IsoTypeReader.readUInt64(content);
        } else {
            this.creationTime = IsoTypeReader.readUInt32(content);
            this.modificationTime = IsoTypeReader.readUInt32(content);
            this.timescale = IsoTypeReader.readUInt32(content);
            this.duration = IsoTypeReader.readUInt32(content);
        }
        this.rate = IsoTypeReader.readFixedPoint1616(content);
        this.volume = IsoTypeReader.readFixedPoint88(content);
        IsoTypeReader.readUInt16(content);
        IsoTypeReader.readUInt32(content);
        IsoTypeReader.readUInt32(content);
        this.matrix = new long[9];
        for (i = 0; i < 9; ++i) {
            this.matrix[i] = IsoTypeReader.readUInt32(content);
        }
        for (i = 0; i < 6; ++i) {
            IsoTypeReader.readUInt32(content);
        }
        this.nextTrackId = IsoTypeReader.readUInt32(content);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("MovieHeaderBox[");
        result.append("creationTime=").append(this.getCreationTime());
        result.append(";");
        result.append("modificationTime=").append(this.getModificationTime());
        result.append(";");
        result.append("timescale=").append(this.getTimescale());
        result.append(";");
        result.append("duration=").append(this.getDuration());
        result.append(";");
        result.append("rate=").append(this.getRate());
        result.append(";");
        result.append("volume=").append(this.getVolume());
        for (int i = 0; i < this.matrix.length; ++i) {
            result.append(";");
            result.append("matrix").append(i).append("=").append(this.matrix[i]);
        }
        result.append(";");
        result.append("nextTrackId=").append(this.getNextTrackId());
        result.append("]");
        return result.toString();
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        int i;
        this.writeVersionAndFlags(byteBuffer);
        if (this.getVersion() == 1) {
            IsoTypeWriter.writeUInt64(byteBuffer, this.creationTime);
            IsoTypeWriter.writeUInt64(byteBuffer, this.modificationTime);
            IsoTypeWriter.writeUInt32(byteBuffer, this.timescale);
            IsoTypeWriter.writeUInt64(byteBuffer, this.duration);
        } else {
            IsoTypeWriter.writeUInt32(byteBuffer, this.creationTime);
            IsoTypeWriter.writeUInt32(byteBuffer, this.modificationTime);
            IsoTypeWriter.writeUInt32(byteBuffer, this.timescale);
            IsoTypeWriter.writeUInt32(byteBuffer, this.duration);
        }
        IsoTypeWriter.writeFixedPont1616(byteBuffer, this.rate);
        IsoTypeWriter.writeFixedPont88(byteBuffer, this.volume);
        IsoTypeWriter.writeUInt16(byteBuffer, 0);
        IsoTypeWriter.writeUInt32(byteBuffer, 0L);
        IsoTypeWriter.writeUInt32(byteBuffer, 0L);
        for (i = 0; i < 9; ++i) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.matrix[i]);
        }
        for (i = 0; i < 6; ++i) {
            IsoTypeWriter.writeUInt32(byteBuffer, 0L);
        }
        IsoTypeWriter.writeUInt32(byteBuffer, this.nextTrackId);
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public void setModificationTime(long modificationTime) {
        this.modificationTime = modificationTime;
    }

    public void setTimescale(long timescale) {
        this.timescale = timescale;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setRate(double rate) {
        this.rate = rate;
    }

    public void setVolume(float volume) {
        this.volume = volume;
    }

    public void setMatrix(long[] matrix) {
        this.matrix = matrix;
    }

    public void setNextTrackId(long nextTrackId) {
        this.nextTrackId = nextTrackId;
    }
}

