/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;

public class TrackHeaderBox
extends AbstractFullBox {
    public static final String TYPE = "tkhd";
    private long creationTime;
    private long modificationTime;
    private long trackId;
    private long duration;
    private int layer;
    private int alternateGroup;
    private float volume;
    private long[] matrix = new long[]{65536L, 0L, 0L, 0L, 65536L, 0L, 0L, 0L, 0x40000000L};
    private double width;
    private double height;

    public TrackHeaderBox() {
        super(TYPE);
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public long getTrackId() {
        return this.trackId;
    }

    public long getDuration() {
        return this.duration;
    }

    public int getLayer() {
        return this.layer;
    }

    public int getAlternateGroup() {
        return this.alternateGroup;
    }

    public float getVolume() {
        return this.volume;
    }

    public long[] getMatrix() {
        return this.matrix;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    @Override
    protected long getContentSize() {
        long contentSize = 4L;
        contentSize = this.getVersion() == 1 ? (contentSize += 32L) : (contentSize += 20L);
        return contentSize += 60L;
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        if (this.getVersion() == 1) {
            this.creationTime = IsoTypeReader.readUInt64(content);
            this.modificationTime = IsoTypeReader.readUInt64(content);
            this.trackId = IsoTypeReader.readUInt32(content);
            IsoTypeReader.readUInt32(content);
            this.duration = IsoTypeReader.readUInt64(content);
        } else {
            this.creationTime = IsoTypeReader.readUInt32(content);
            this.modificationTime = IsoTypeReader.readUInt32(content);
            this.trackId = IsoTypeReader.readUInt32(content);
            IsoTypeReader.readUInt32(content);
            this.duration = IsoTypeReader.readUInt32(content);
        }
        IsoTypeReader.readUInt32(content);
        IsoTypeReader.readUInt32(content);
        this.layer = IsoTypeReader.readUInt16(content);
        this.alternateGroup = IsoTypeReader.readUInt16(content);
        this.volume = IsoTypeReader.readFixedPoint88(content);
        IsoTypeReader.readUInt16(content);
        this.matrix = new long[9];
        for (int i = 0; i < 9; ++i) {
            this.matrix[i] = IsoTypeReader.readUInt32(content);
        }
        this.width = IsoTypeReader.readFixedPoint1616(content);
        this.height = IsoTypeReader.readFixedPoint1616(content);
    }

    @Override
    public void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        if (this.getVersion() == 1) {
            IsoTypeWriter.writeUInt64(byteBuffer, this.creationTime);
            IsoTypeWriter.writeUInt64(byteBuffer, this.modificationTime);
            IsoTypeWriter.writeUInt32(byteBuffer, this.trackId);
            IsoTypeWriter.writeUInt32(byteBuffer, 0L);
            IsoTypeWriter.writeUInt64(byteBuffer, this.duration);
        } else {
            IsoTypeWriter.writeUInt32(byteBuffer, this.creationTime);
            IsoTypeWriter.writeUInt32(byteBuffer, this.modificationTime);
            IsoTypeWriter.writeUInt32(byteBuffer, this.trackId);
            IsoTypeWriter.writeUInt32(byteBuffer, 0L);
            IsoTypeWriter.writeUInt32(byteBuffer, this.duration);
        }
        IsoTypeWriter.writeUInt32(byteBuffer, 0L);
        IsoTypeWriter.writeUInt32(byteBuffer, 0L);
        IsoTypeWriter.writeUInt16(byteBuffer, this.layer);
        IsoTypeWriter.writeUInt16(byteBuffer, this.alternateGroup);
        IsoTypeWriter.writeFixedPont88(byteBuffer, this.volume);
        IsoTypeWriter.writeUInt16(byteBuffer, 0);
        for (int i = 0; i < 9; ++i) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.matrix[i]);
        }
        IsoTypeWriter.writeFixedPont1616(byteBuffer, this.width);
        IsoTypeWriter.writeFixedPont1616(byteBuffer, this.height);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("TrackHeaderBox[");
        result.append("creationTime=").append(this.getCreationTime());
        result.append(";");
        result.append("modificationTime=").append(this.getModificationTime());
        result.append(";");
        result.append("trackId=").append(this.getTrackId());
        result.append(";");
        result.append("duration=").append(this.getDuration());
        result.append(";");
        result.append("layer=").append(this.getLayer());
        result.append(";");
        result.append("alternateGroup=").append(this.getAlternateGroup());
        result.append(";");
        result.append("volume=").append(this.getVolume());
        for (int i = 0; i < this.matrix.length; ++i) {
            result.append(";");
            result.append("matrix").append(i).append("=").append(this.matrix[i]);
        }
        result.append(";");
        result.append("width=").append(this.getWidth());
        result.append(";");
        result.append("height=").append(this.getHeight());
        result.append("]");
        return result.toString();
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public void setModificationTime(long modificationTime) {
        this.modificationTime = modificationTime;
    }

    public void setTrackId(long trackId) {
        this.trackId = trackId;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setLayer(int layer) {
        this.layer = layer;
    }

    public void setAlternateGroup(int alternateGroup) {
        this.alternateGroup = alternateGroup;
    }

    public void setVolume(float volume) {
        this.volume = volume;
    }

    public void setMatrix(long[] matrix) {
        this.matrix = matrix;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public boolean isEnabled() {
        return (this.getFlags() & 1) > 0;
    }

    public boolean isInMovie() {
        return (this.getFlags() & 2) > 0;
    }

    public boolean isInPreview() {
        return (this.getFlags() & 4) > 0;
    }

    public boolean isInPoster() {
        return (this.getFlags() & 8) > 0;
    }
}

