/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.dece;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class TrickPlayBox
extends AbstractFullBox {
    public static final String TYPE = "trik";
    private List<Entry> entries = new ArrayList<Entry>();

    public TrickPlayBox() {
        super(TYPE);
    }

    public void setEntries(List<Entry> entries) {
        this.entries = entries;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    @Override
    protected long getContentSize() {
        return 4 + this.entries.size();
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        while (content.remaining() > 0) {
            this.entries.add(new Entry(IsoTypeReader.readUInt8(content)));
        }
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        for (Entry entry : this.entries) {
            IsoTypeWriter.writeUInt8(byteBuffer, entry.value);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TrickPlayBox");
        sb.append("{entries=").append(this.entries);
        sb.append('}');
        return sb.toString();
    }

    public static class Entry {
        private int value;

        public Entry() {
        }

        public Entry(int value) {
            this.value = value;
        }

        public int getPicType() {
            return this.value >> 6 & 3;
        }

        public void setPicType(int picType) {
            this.value &= 0x1F;
            this.value = (picType & 3) << 6 | this.value;
        }

        public int getDependencyLevel() {
            return this.value & 0x3F;
        }

        public void setDependencyLevel(int dependencyLevel) {
            this.value = dependencyLevel & 0x3F | this.value;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Entry");
            sb.append("{picType=").append(this.getPicType());
            sb.append(",dependencyLevel=").append(this.getDependencyLevel());
            sb.append('}');
            return sb.toString();
        }
    }
}

