/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.fragment;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.fragment.SampleFlags;
import com.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;

public class TrackFragmentHeaderBox
extends AbstractFullBox {
    public static final String TYPE = "tfhd";
    private long trackId;
    private long baseDataOffset = -1L;
    private long sampleDescriptionIndex;
    private long defaultSampleDuration = -1L;
    private long defaultSampleSize = -1L;
    private SampleFlags defaultSampleFlags;
    private boolean durationIsEmpty;

    public TrackFragmentHeaderBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        long size = 8L;
        int flags = this.getFlags();
        if ((flags & 1) == 1) {
            size += 8L;
        }
        if ((flags & 2) == 2) {
            size += 4L;
        }
        if ((flags & 8) == 8) {
            size += 4L;
        }
        if ((flags & 0x10) == 16) {
            size += 4L;
        }
        if ((flags & 0x20) == 32) {
            size += 4L;
        }
        return size;
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeUInt32(byteBuffer, this.trackId);
        if ((this.getFlags() & 1) == 1) {
            IsoTypeWriter.writeUInt64(byteBuffer, this.getBaseDataOffset());
        }
        if ((this.getFlags() & 2) == 2) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.getSampleDescriptionIndex());
        }
        if ((this.getFlags() & 8) == 8) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.getDefaultSampleDuration());
        }
        if ((this.getFlags() & 0x10) == 16) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.getDefaultSampleSize());
        }
        if ((this.getFlags() & 0x20) == 32) {
            this.defaultSampleFlags.getContent(byteBuffer);
        }
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        this.trackId = IsoTypeReader.readUInt32(content);
        if ((this.getFlags() & 1) == 1) {
            this.baseDataOffset = IsoTypeReader.readUInt64(content);
        }
        if ((this.getFlags() & 2) == 2) {
            this.sampleDescriptionIndex = IsoTypeReader.readUInt32(content);
        }
        if ((this.getFlags() & 8) == 8) {
            this.defaultSampleDuration = IsoTypeReader.readUInt32(content);
        }
        if ((this.getFlags() & 0x10) == 16) {
            this.defaultSampleSize = IsoTypeReader.readUInt32(content);
        }
        if ((this.getFlags() & 0x20) == 32) {
            this.defaultSampleFlags = new SampleFlags(content);
        }
        if ((this.getFlags() & 0x10000) == 65536) {
            this.durationIsEmpty = true;
        }
    }

    public boolean hasBaseDataOffset() {
        return (this.getFlags() & 1) != 0;
    }

    public long getTrackId() {
        return this.trackId;
    }

    public long getBaseDataOffset() {
        return this.baseDataOffset;
    }

    public long getSampleDescriptionIndex() {
        return this.sampleDescriptionIndex;
    }

    public long getDefaultSampleDuration() {
        return this.defaultSampleDuration;
    }

    public long getDefaultSampleSize() {
        return this.defaultSampleSize;
    }

    public SampleFlags getDefaultSampleFlags() {
        return this.defaultSampleFlags;
    }

    public boolean isDurationIsEmpty() {
        return this.durationIsEmpty;
    }

    public void setTrackId(long trackId) {
        this.trackId = trackId;
    }

    public void setBaseDataOffset(long baseDataOffset) {
        if (baseDataOffset == -1L) {
            this.setFlags(this.getFlags() & 0x7FFFFFFE);
        } else {
            this.setFlags(this.getFlags() | 1);
        }
        this.baseDataOffset = baseDataOffset;
    }

    public void setSampleDescriptionIndex(long sampleDescriptionIndex) {
        if (sampleDescriptionIndex == -1L) {
            this.setFlags(this.getFlags() & 0x7FFFFFFD);
        } else {
            this.setFlags(this.getFlags() | 2);
        }
        this.sampleDescriptionIndex = sampleDescriptionIndex;
    }

    public void setDefaultSampleDuration(long defaultSampleDuration) {
        this.setFlags(this.getFlags() | 8);
        this.defaultSampleDuration = defaultSampleDuration;
    }

    public void setDefaultSampleSize(long defaultSampleSize) {
        this.setFlags(this.getFlags() | 0x10);
        this.defaultSampleSize = defaultSampleSize;
    }

    public void setDefaultSampleFlags(SampleFlags defaultSampleFlags) {
        this.setFlags(this.getFlags() | 0x20);
        this.defaultSampleFlags = defaultSampleFlags;
    }

    public void setDurationIsEmpty(boolean durationIsEmpty) {
        this.setFlags(this.getFlags() | 0x10000);
        this.durationIsEmpty = durationIsEmpty;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TrackFragmentHeaderBox");
        sb.append("{trackId=").append(this.trackId);
        sb.append(", baseDataOffset=").append(this.baseDataOffset);
        sb.append(", sampleDescriptionIndex=").append(this.sampleDescriptionIndex);
        sb.append(", defaultSampleDuration=").append(this.defaultSampleDuration);
        sb.append(", defaultSampleSize=").append(this.defaultSampleSize);
        sb.append(", defaultSampleFlags=").append(this.defaultSampleFlags);
        sb.append(", durationIsEmpty=").append(this.durationIsEmpty);
        sb.append('}');
        return sb.toString();
    }
}

