/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.h264;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractBox;
import com.googlecode.mp4parser.h264.model.PictureParameterSet;
import com.googlecode.mp4parser.h264.model.SeqParameterSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AvcConfigurationBox
extends AbstractBox {
    public static final String TYPE = "avcC";
    private int configurationVersion;
    private int avcProfileIndicaation;
    private int profileCompatibility;
    private int avcLevelIndication;
    private int lengthSizeMinusOne;
    List<byte[]> sequenceParameterSets = new ArrayList<byte[]>();
    List<byte[]> pictureParameterSets = new ArrayList<byte[]>();
    boolean hasExts = true;
    private int chromaFormat = 1;
    private int bitDepthLumaMinus8 = 0;
    private int bitDepthChromaMinus8 = 0;
    List<byte[]> sequenceParameterSetExts = new ArrayList<byte[]>();

    public AvcConfigurationBox() {
        super(TYPE);
    }

    public int getConfigurationVersion() {
        return this.configurationVersion;
    }

    public int getAvcProfileIndicaation() {
        return this.avcProfileIndicaation;
    }

    public int getProfileCompatibility() {
        return this.profileCompatibility;
    }

    public int getAvcLevelIndication() {
        return this.avcLevelIndication;
    }

    public int getLengthSizeMinusOne() {
        return this.lengthSizeMinusOne;
    }

    public List<byte[]> getSequenceParameterSets() {
        return Collections.unmodifiableList(this.sequenceParameterSets);
    }

    public List<byte[]> getPictureParameterSets() {
        return Collections.unmodifiableList(this.pictureParameterSets);
    }

    public void setConfigurationVersion(int configurationVersion) {
        this.configurationVersion = configurationVersion;
    }

    public void setAvcProfileIndicaation(int avcProfileIndicaation) {
        this.avcProfileIndicaation = avcProfileIndicaation;
    }

    public void setProfileCompatibility(int profileCompatibility) {
        this.profileCompatibility = profileCompatibility;
    }

    public void setAvcLevelIndication(int avcLevelIndication) {
        this.avcLevelIndication = avcLevelIndication;
    }

    public void setLengthSizeMinusOne(int lengthSizeMinusOne) {
        this.lengthSizeMinusOne = lengthSizeMinusOne;
    }

    public void setSequenceParameterSets(List<byte[]> sequenceParameterSets) {
        this.sequenceParameterSets = sequenceParameterSets;
    }

    public void setPictureParameterSets(List<byte[]> pictureParameterSets) {
        this.pictureParameterSets = pictureParameterSets;
    }

    public int getChromaFormat() {
        return this.chromaFormat;
    }

    public void setChromaFormat(int chromaFormat) {
        this.chromaFormat = chromaFormat;
    }

    public int getBitDepthLumaMinus8() {
        return this.bitDepthLumaMinus8;
    }

    public void setBitDepthLumaMinus8(int bitDepthLumaMinus8) {
        this.bitDepthLumaMinus8 = bitDepthLumaMinus8;
    }

    public int getBitDepthChromaMinus8() {
        return this.bitDepthChromaMinus8;
    }

    public void setBitDepthChromaMinus8(int bitDepthChromaMinus8) {
        this.bitDepthChromaMinus8 = bitDepthChromaMinus8;
    }

    public List<byte[]> getSequenceParameterSetExts() {
        return this.sequenceParameterSetExts;
    }

    public void setSequenceParameterSetExts(List<byte[]> sequenceParameterSetExts) {
        this.sequenceParameterSetExts = sequenceParameterSetExts;
    }

    public boolean hasExts() {
        return this.hasExts;
    }

    public void setHasExts(boolean hasExts) {
        this.hasExts = hasExts;
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.configurationVersion = IsoTypeReader.readUInt8(content);
        this.avcProfileIndicaation = IsoTypeReader.readUInt8(content);
        this.profileCompatibility = IsoTypeReader.readUInt8(content);
        this.avcLevelIndication = IsoTypeReader.readUInt8(content);
        int temp = IsoTypeReader.readUInt8(content);
        this.lengthSizeMinusOne = temp & 3;
        long numberOfSeuqenceParameterSets = IsoTypeReader.readUInt8(content) & 0x1F;
        int i = 0;
        while ((long)i < numberOfSeuqenceParameterSets) {
            int sequenceParameterSetLength = IsoTypeReader.readUInt16(content);
            byte[] sequenceParameterSetNALUnit = new byte[sequenceParameterSetLength];
            content.get(sequenceParameterSetNALUnit);
            this.sequenceParameterSets.add(sequenceParameterSetNALUnit);
            ++i;
        }
        long numberOfPictureParameterSets = IsoTypeReader.readUInt8(content);
        int i2 = 0;
        while ((long)i2 < numberOfPictureParameterSets) {
            int pictureParameterSetLength = IsoTypeReader.readUInt16(content);
            byte[] pictureParameterSetNALUnit = new byte[pictureParameterSetLength];
            content.get(pictureParameterSetNALUnit);
            this.pictureParameterSets.add(pictureParameterSetNALUnit);
            ++i2;
        }
        if (content.remaining() < 4) {
            this.hasExts = false;
        }
        if (this.hasExts && (this.avcProfileIndicaation == 100 || this.avcProfileIndicaation == 110 || this.avcProfileIndicaation == 122 || this.avcProfileIndicaation == 144)) {
            this.chromaFormat = IsoTypeReader.readUInt8(content) & 3;
            this.bitDepthLumaMinus8 = IsoTypeReader.readUInt8(content) & 7;
            this.bitDepthChromaMinus8 = IsoTypeReader.readUInt8(content) & 7;
            long numOfSequenceParameterSetExt = IsoTypeReader.readUInt8(content);
            int i3 = 0;
            while ((long)i3 < numOfSequenceParameterSetExt) {
                int sequenceParameterSetExtLength = IsoTypeReader.readUInt16(content);
                byte[] sequenceParameterSetExtNALUnit = new byte[sequenceParameterSetExtLength];
                content.get(sequenceParameterSetExtNALUnit);
                this.sequenceParameterSetExts.add(sequenceParameterSetExtNALUnit);
                ++i3;
            }
        } else {
            this.chromaFormat = -1;
            this.bitDepthLumaMinus8 = -1;
            this.bitDepthChromaMinus8 = -1;
        }
    }

    @Override
    public long getContentSize() {
        long size = 5L;
        ++size;
        for (byte[] sequenceParameterSetNALUnit : this.sequenceParameterSets) {
            size += 2L;
            size += (long)sequenceParameterSetNALUnit.length;
        }
        ++size;
        for (byte[] pictureParameterSetNALUnit : this.pictureParameterSets) {
            size += 2L;
            size += (long)pictureParameterSetNALUnit.length;
        }
        if (this.hasExts && (this.avcProfileIndicaation == 100 || this.avcProfileIndicaation == 110 || this.avcProfileIndicaation == 122 || this.avcProfileIndicaation == 144)) {
            size += 4L;
            for (byte[] sequenceParameterSetExtNALUnit : this.sequenceParameterSetExts) {
                size += 2L;
                size += (long)sequenceParameterSetExtNALUnit.length;
            }
        }
        return size;
    }

    @Override
    public void getContent(ByteBuffer byteBuffer) {
        IsoTypeWriter.writeUInt8(byteBuffer, this.configurationVersion);
        IsoTypeWriter.writeUInt8(byteBuffer, this.avcProfileIndicaation);
        IsoTypeWriter.writeUInt8(byteBuffer, this.profileCompatibility);
        IsoTypeWriter.writeUInt8(byteBuffer, this.avcLevelIndication);
        IsoTypeWriter.writeUInt8(byteBuffer, this.lengthSizeMinusOne | 0xFC);
        IsoTypeWriter.writeUInt8(byteBuffer, this.pictureParameterSets.size() & 0x1F | 0xE0);
        for (byte[] sequenceParameterSetNALUnit : this.sequenceParameterSets) {
            IsoTypeWriter.writeUInt16(byteBuffer, sequenceParameterSetNALUnit.length);
            byteBuffer.put(sequenceParameterSetNALUnit);
        }
        IsoTypeWriter.writeUInt8(byteBuffer, this.pictureParameterSets.size());
        for (byte[] pictureParameterSetNALUnit : this.pictureParameterSets) {
            IsoTypeWriter.writeUInt16(byteBuffer, pictureParameterSetNALUnit.length);
            byteBuffer.put(pictureParameterSetNALUnit);
        }
        if (this.hasExts && (this.avcProfileIndicaation == 100 || this.avcProfileIndicaation == 110 || this.avcProfileIndicaation == 122 || this.avcProfileIndicaation == 144)) {
            IsoTypeWriter.writeUInt8(byteBuffer, this.chromaFormat | 0xFC);
            IsoTypeWriter.writeUInt8(byteBuffer, this.bitDepthLumaMinus8 | 0xF8);
            IsoTypeWriter.writeUInt8(byteBuffer, this.bitDepthChromaMinus8 | 0xF8);
            IsoTypeWriter.writeUInt8(byteBuffer, this.sequenceParameterSetExts.size());
            for (byte[] sequenceParameterSetExtNALUnit : this.sequenceParameterSetExts) {
                IsoTypeWriter.writeUInt16(byteBuffer, sequenceParameterSetExtNALUnit.length);
                byteBuffer.put(sequenceParameterSetExtNALUnit);
            }
        }
    }

    public String[] getPPS() {
        ArrayList<String> l = new ArrayList<String>();
        for (byte[] pictureParameterSet : this.pictureParameterSets) {
            String details = "not parsable";
            try {
                details = PictureParameterSet.read(pictureParameterSet).toString();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            l.add(details);
        }
        return l.toArray(new String[l.size()]);
    }

    public String[] getSPS() {
        ArrayList<String> l = new ArrayList<String>();
        for (byte[] sequenceParameterSet : this.sequenceParameterSets) {
            String detail = "not parsable";
            try {
                detail = SeqParameterSet.read(new ByteArrayInputStream(sequenceParameterSet)).toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            l.add(detail);
        }
        return l.toArray(new String[l.size()]);
    }
}

