/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.ChannelHelper;
import com.coremedia.iso.Hex;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import com.googlecode.mp4parser.annotations.DoNotParseDetail;
import com.googlecode.mp4parser.util.CastUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Logger;

public abstract class AbstractBox
implements Box {
    private static Logger LOG = Logger.getLogger(AbstractBox.class.getName());
    protected String type;
    private byte[] userType;
    private ContainerBox parent;
    private ByteBuffer content;
    private ByteBuffer deadBytes = null;

    protected AbstractBox(String type) {
        this.type = type;
    }

    protected AbstractBox(String type, byte[] userType) {
        this.type = type;
        this.userType = userType;
    }

    protected abstract long getContentSize();

    protected abstract void getContent(ByteBuffer var1);

    protected abstract void _parseDetails(ByteBuffer var1);

    @Override
    @DoNotParseDetail
    public void parse(ReadableByteChannel readableByteChannel, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        if (readableByteChannel instanceof FileChannel && contentSize > 0x100000L) {
            this.content = ((FileChannel)readableByteChannel).map(FileChannel.MapMode.READ_ONLY, ((FileChannel)readableByteChannel).position(), contentSize);
            ((FileChannel)readableByteChannel).position(((FileChannel)readableByteChannel).position() + contentSize);
        } else {
            assert (contentSize < Integer.MAX_VALUE);
            this.content = ChannelHelper.readFully(readableByteChannel, contentSize);
        }
    }

    @Override
    public void getBox(WritableByteChannel os) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(CastUtils.l2i(this.getSize()));
        this.getHeader(bb);
        if (this.content == null) {
            this.getContent(bb);
            if (this.deadBytes != null) {
                this.deadBytes.rewind();
                while (this.deadBytes.remaining() > 0) {
                    bb.put(this.deadBytes);
                }
            }
        } else {
            this.content.rewind();
            bb.put(this.content);
        }
        bb.rewind();
        os.write(bb);
    }

    final synchronized void parseDetails() {
        if (this.content != null) {
            ByteBuffer content = this.content;
            this.content = null;
            content.rewind();
            this._parseDetails(content);
            if (content.remaining() > 0) {
                this.deadBytes = content.slice();
            }
            assert (this.verify(content));
        }
    }

    protected void setDeadBytes(ByteBuffer newDeadBytes) {
        this.deadBytes = newDeadBytes;
    }

    @Override
    public long getSize() {
        long size = this.content == null ? this.getContentSize() : (long)this.content.limit();
        size += (long)(8 + (size >= 0xFFFFFFF8L ? 8 : 0) + ("uuid".equals(this.getType()) ? 16 : 0));
        return size += (long)(this.deadBytes == null ? 0 : this.deadBytes.limit());
    }

    @Override
    @DoNotParseDetail
    public String getType() {
        return this.type;
    }

    @DoNotParseDetail
    public byte[] getUserType() {
        return this.userType;
    }

    @Override
    @DoNotParseDetail
    public ContainerBox getParent() {
        return this.parent;
    }

    @Override
    @DoNotParseDetail
    public void setParent(ContainerBox parent) {
        this.parent = parent;
    }

    @DoNotParseDetail
    public IsoFile getIsoFile() {
        return this.parent.getIsoFile();
    }

    public boolean isParsed() {
        return this.content == null;
    }

    private boolean verify(ByteBuffer content) {
        ByteBuffer bb = ByteBuffer.allocate(CastUtils.l2i(this.getContentSize() + (long)(this.deadBytes != null ? this.deadBytes.limit() : 0)));
        this.getContent(bb);
        if (this.deadBytes != null) {
            this.deadBytes.rewind();
            while (this.deadBytes.remaining() > 0) {
                bb.put(this.deadBytes);
            }
        }
        content.rewind();
        bb.rewind();
        if (content.remaining() != bb.remaining()) {
            LOG.severe("remaining differs " + content.remaining() + " vs. " + bb.remaining());
            return false;
        }
        int p = content.position();
        int i = content.limit() - 1;
        int j = bb.limit() - 1;
        while (i >= p) {
            byte v2;
            byte v1 = content.get(i);
            if (v1 != (v2 = bb.get(j))) {
                LOG.severe("buffers differ at " + i + ": " + v1 + "/" + v2);
                byte[] b1 = new byte[content.remaining()];
                byte[] b2 = new byte[bb.remaining()];
                content.get(b1);
                bb.get(b2);
                System.err.println(Hex.encodeHex(b1));
                System.err.println(Hex.encodeHex(b2));
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    private boolean isSmallBox() {
        return (this.content == null ? this.getContentSize() + (long)(this.deadBytes != null ? this.deadBytes.limit() : 0) + 8L : (long)this.content.limit()) < 0x100000000L;
    }

    private void getHeader(ByteBuffer byteBuffer) {
        if (this.isSmallBox()) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.getSize());
            byteBuffer.put(IsoFile.fourCCtoBytes(this.getType()));
        } else {
            IsoTypeWriter.writeUInt32(byteBuffer, 1L);
            byteBuffer.put(IsoFile.fourCCtoBytes(this.getType()));
            IsoTypeWriter.writeUInt64(byteBuffer, this.getSize());
        }
        if ("uuid".equals(this.getType())) {
            byteBuffer.put(this.getUserType());
        }
    }
}

