/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.builder;

import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.sampleentry.AudioSampleEntry;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.builder.FragmentIntersectionFinder;
import com.googlecode.mp4parser.util.Math;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class SyncSampleIntersectFinderImpl
implements FragmentIntersectionFinder {
    private static Logger LOG = Logger.getLogger(SyncSampleIntersectFinderImpl.class.getName());

    @Override
    public long[] sampleNumbers(Track track, Movie movie) {
        if ("vide".equals(track.getHandler())) {
            if (track.getSyncSamples() != null && track.getSyncSamples().length > 0) {
                List<long[]> times = SyncSampleIntersectFinderImpl.getSyncSamplesTimestamps(movie, track);
                return SyncSampleIntersectFinderImpl.getCommonIndices(track.getSyncSamples(), SyncSampleIntersectFinderImpl.getTimes(movie, track), (long[][])times.toArray((T[])new long[times.size()][]));
            }
            throw new RuntimeException("Video Tracks need sync samples. Only tracks other than video may have no sync samples.");
        }
        if ("soun".equals(track.getHandler())) {
            Track referenceTrack = null;
            for (Track candidate : movie.getTracks()) {
                if (candidate.getSyncSamples() == null || candidate.getSyncSamples().length <= 0) continue;
                referenceTrack = candidate;
            }
            if (referenceTrack != null) {
                long[] refSyncSamples = this.sampleNumbers(referenceTrack, movie);
                int refSampleCount = referenceTrack.getSamples().size();
                long[] syncSamples = new long[refSyncSamples.length];
                long minSampleRate = 192000L;
                for (Track testTrack : movie.getTracks()) {
                    AudioSampleEntry ase;
                    if (!"soun".equals(testTrack.getHandler()) || (ase = (AudioSampleEntry)testTrack.getSampleDescriptionBox().getSampleEntry()).getSampleRate() >= minSampleRate) continue;
                    minSampleRate = ase.getSampleRate();
                    long sc = testTrack.getSamples().size();
                    double stretch = (double)sc / (double)refSampleCount;
                    for (int i = 0; i < syncSamples.length; ++i) {
                        int start = (int)java.lang.Math.ceil(stretch * (double)(refSyncSamples[i] - 1L)) + 1;
                        syncSamples[i] = start;
                    }
                }
                AudioSampleEntry ase = (AudioSampleEntry)track.getSampleDescriptionBox().getSampleEntry();
                double factor = (double)ase.getSampleRate() / (double)minSampleRate;
                if (factor != java.lang.Math.rint(factor)) {
                    throw new RuntimeException("Sample rates must be a multiple of the lowest sample rate to create a correct file!");
                }
                for (int i = 1; i < syncSamples.length; ++i) {
                    syncSamples[i] = (int)(1.0 + (double)(syncSamples[i] - 1L) * factor);
                }
                return syncSamples;
            }
            throw new RuntimeException("There was absolutely no Track with sync samples. I can't work with that!");
        }
        for (Track candidate : movie.getTracks()) {
            if (candidate.getSyncSamples() == null || candidate.getSyncSamples().length <= 0) continue;
            long[] refSyncSamples = this.sampleNumbers(candidate, movie);
            int refSampleCount = candidate.getSamples().size();
            long[] syncSamples = new long[refSyncSamples.length];
            long sc = track.getSamples().size();
            double stretch = (double)sc / (double)refSampleCount;
            for (int i = 0; i < syncSamples.length; ++i) {
                int start = (int)java.lang.Math.ceil(stretch * (double)(refSyncSamples[i] - 1L)) + 1;
                syncSamples[i] = start;
            }
            return syncSamples;
        }
        throw new RuntimeException("There was absolutely no Track with sync samples. I can't work with that!");
    }

    public static List<long[]> getSyncSamplesTimestamps(Movie movie, Track track) {
        LinkedList<long[]> times = new LinkedList<long[]>();
        for (Track currentTrack : movie.getTracks()) {
            long[] currentTrackSyncSamples;
            if (!currentTrack.getHandler().equals(track.getHandler()) || (currentTrackSyncSamples = currentTrack.getSyncSamples()) == null || currentTrackSyncSamples.length <= 0) continue;
            long[] currentTrackTimes = SyncSampleIntersectFinderImpl.getTimes(movie, currentTrack);
            times.add(currentTrackTimes);
        }
        return times;
    }

    public static long[] getCommonIndices(long[] syncSamples, long[] syncSampleTimes, long[] ... otherTracksTimes) {
        LinkedList<Long> nuSyncSamples = new LinkedList<Long>();
        for (int i = 0; i < syncSampleTimes.length; ++i) {
            boolean foundInEveryRef = true;
            for (long[] times : otherTracksTimes) {
                foundInEveryRef &= Arrays.binarySearch(times, syncSampleTimes[i]) >= 0;
            }
            if (!foundInEveryRef) continue;
            nuSyncSamples.add(syncSamples[i]);
        }
        long[] nuSyncSampleArray = new long[nuSyncSamples.size()];
        for (int i = 0; i < nuSyncSampleArray.length; ++i) {
            nuSyncSampleArray[i] = (Long)nuSyncSamples.get(i);
        }
        if ((double)nuSyncSampleArray.length < (double)syncSamples.length * 0.3) {
            LOG.warning("There are less than 25% of common sync samples in the given track.");
            throw new RuntimeException("There are less than 25% of common sync samples in the given track.");
        }
        if ((double)nuSyncSampleArray.length < (double)syncSamples.length * 0.5) {
            LOG.fine("There are less than 50% of common sync samples in the given track. This is implausible but I'm ok to continue.");
        } else if (nuSyncSampleArray.length < syncSamples.length) {
            LOG.finest("Common SyncSample positions vs. this tracks SyncSample positions: " + nuSyncSampleArray.length + " vs. " + syncSamples.length);
        }
        return nuSyncSampleArray;
    }

    private static long[] getTimes(Movie m, Track track) {
        long[] syncSamples = track.getSyncSamples();
        long[] syncSampleTimes = new long[syncSamples.length];
        LinkedList<TimeToSampleBox.Entry> timeQueue = new LinkedList<TimeToSampleBox.Entry>(track.getDecodingTimeEntries());
        int currentSample = 1;
        long currentDuration = 0L;
        long currentDelta = 0L;
        int currentSyncSampleIndex = 0;
        long left = 0L;
        long timeScale = 1L;
        for (Track track1 : m.getTracks()) {
            if (track1.getTrackMetaData().getTimescale() == track.getTrackMetaData().getTimescale()) continue;
            timeScale = Math.lcm(timeScale, track1.getTrackMetaData().getTimescale());
        }
        while ((long)currentSample <= syncSamples[syncSamples.length - 1]) {
            if ((long)currentSample++ == syncSamples[currentSyncSampleIndex]) {
                syncSampleTimes[currentSyncSampleIndex++] = currentDuration * timeScale;
            }
            if (left-- == 0L) {
                TimeToSampleBox.Entry entry = (TimeToSampleBox.Entry)timeQueue.poll();
                left = entry.getCount();
                currentDelta = entry.getDelta();
            }
            currentDuration += currentDelta;
        }
        return syncSampleTimes;
    }
}

