/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.builder.smoothstreaming;

import com.coremedia.iso.Hex;
import com.coremedia.iso.boxes.OriginalFormatBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SoundMediaHeaderBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.VideoMediaHeaderBox;
import com.coremedia.iso.boxes.h264.AvcConfigurationBox;
import com.coremedia.iso.boxes.sampleentry.AudioSampleEntry;
import com.coremedia.iso.boxes.sampleentry.SampleEntry;
import com.coremedia.iso.boxes.sampleentry.VisualSampleEntry;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.builder.FragmentIntersectionFinder;
import com.googlecode.mp4parser.authoring.builder.SyncSampleIntersectFinderImpl;
import com.googlecode.mp4parser.authoring.builder.smoothstreaming.AudioQuality;
import com.googlecode.mp4parser.authoring.builder.smoothstreaming.ManifestWriter;
import com.googlecode.mp4parser.authoring.builder.smoothstreaming.VideoQuality;
import com.googlecode.mp4parser.boxes.mp4.ESDescriptorBox;
import com.googlecode.mp4parser.util.CastUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Serializer;

public class FlatManifestWriterImpl
implements ManifestWriter {
    private FragmentIntersectionFinder intersectionFinder = new SyncSampleIntersectFinderImpl();
    private long[] audioFragmentsDurations;
    private long[] videoFragmentsDurations;

    public void setIntersectionFinder(FragmentIntersectionFinder intersectionFinder) {
        this.intersectionFinder = intersectionFinder;
    }

    protected Document customizeManifest(Document manifest) {
        return manifest;
    }

    @Override
    public String getManifest(Movie movie) throws IOException {
        int i;
        LinkedList<VideoQuality> videoQualities = new LinkedList<VideoQuality>();
        long videoTimescale = -1L;
        LinkedList<AudioQuality> audioQualities = new LinkedList<AudioQuality>();
        long audioTimescale = -1L;
        for (Track track : movie.getTracks()) {
            SampleDescriptionBox stsd;
            if (track.getMediaHeaderBox() instanceof VideoMediaHeaderBox) {
                this.videoFragmentsDurations = this.checkFragmentsAlign(this.videoFragmentsDurations, this.calculateFragmentDurations(track, movie));
                stsd = track.getSampleDescriptionBox();
                videoQualities.add(this.getVideoQuality(track, (VisualSampleEntry)stsd.getSampleEntry()));
                if (videoTimescale == -1L) {
                    videoTimescale = track.getTrackMetaData().getTimescale();
                } else assert (videoTimescale == track.getTrackMetaData().getTimescale());
            }
            if (!(track.getMediaHeaderBox() instanceof SoundMediaHeaderBox)) continue;
            this.audioFragmentsDurations = this.checkFragmentsAlign(this.audioFragmentsDurations, this.calculateFragmentDurations(track, movie));
            stsd = track.getSampleDescriptionBox();
            audioQualities.add(this.getAudioQuality(track, (AudioSampleEntry)stsd.getSampleEntry()));
            if (audioTimescale == -1L) {
                audioTimescale = track.getTrackMetaData().getTimescale();
                continue;
            }
            assert (audioTimescale == track.getTrackMetaData().getTimescale());
        }
        Element smoothStreamingMedia = new Element("SmoothStreamingMedia");
        smoothStreamingMedia.addAttribute(new Attribute("MajorVersion", "2"));
        smoothStreamingMedia.addAttribute(new Attribute("MinorVersion", "1"));
        smoothStreamingMedia.addAttribute(new Attribute("Duration", "0"));
        Element videoStreamIndex = new Element("StreamIndex");
        videoStreamIndex.addAttribute(new Attribute("Type", "video"));
        videoStreamIndex.addAttribute(new Attribute("TimeScale", Long.toString(videoTimescale)));
        videoStreamIndex.addAttribute(new Attribute("Chunks", Integer.toString(this.videoFragmentsDurations.length)));
        videoStreamIndex.addAttribute(new Attribute("Url", "video/{bitrate}/{start time}"));
        videoStreamIndex.addAttribute(new Attribute("QualityLevels", Integer.toString(videoQualities.size())));
        smoothStreamingMedia.appendChild((Node)videoStreamIndex);
        for (i = 0; i < videoQualities.size(); ++i) {
            VideoQuality vq = (VideoQuality)videoQualities.get(i);
            Element qualityLevel = new Element("QualityLevel");
            qualityLevel.addAttribute(new Attribute("Index", Integer.toString(i)));
            qualityLevel.addAttribute(new Attribute("Bitrate", Long.toString(vq.bitrate)));
            qualityLevel.addAttribute(new Attribute("FourCC", vq.fourCC));
            qualityLevel.addAttribute(new Attribute("MaxWidth", Long.toString(vq.width)));
            qualityLevel.addAttribute(new Attribute("MaxHeight", Long.toString(vq.height)));
            qualityLevel.addAttribute(new Attribute("CodecPrivateData", vq.codecPrivateData));
            qualityLevel.addAttribute(new Attribute("NALUnitLengthField", Integer.toString(vq.nalLength)));
            videoStreamIndex.appendChild((Node)qualityLevel);
        }
        for (i = 0; i < this.videoFragmentsDurations.length; ++i) {
            Element c = new Element("c");
            c.addAttribute(new Attribute("n", Integer.toString(i)));
            c.addAttribute(new Attribute("d", Long.toString(this.videoFragmentsDurations[i])));
            videoStreamIndex.appendChild((Node)c);
        }
        if (this.audioFragmentsDurations != null) {
            int i2;
            Element audioStreamIndex = new Element("StreamIndex");
            audioStreamIndex.addAttribute(new Attribute("Type", "audio"));
            audioStreamIndex.addAttribute(new Attribute("TimeScale", Long.toString(audioTimescale)));
            audioStreamIndex.addAttribute(new Attribute("Chunks", Integer.toString(this.audioFragmentsDurations.length)));
            audioStreamIndex.addAttribute(new Attribute("Url", "audio/{bitrate}/{start time}"));
            audioStreamIndex.addAttribute(new Attribute("QualityLevels", Integer.toString(audioQualities.size())));
            smoothStreamingMedia.appendChild((Node)audioStreamIndex);
            for (i2 = 0; i2 < audioQualities.size(); ++i2) {
                AudioQuality aq = (AudioQuality)audioQualities.get(i2);
                Element qualityLevel = new Element("QualityLevel");
                qualityLevel.addAttribute(new Attribute("Index", Integer.toString(i2)));
                qualityLevel.addAttribute(new Attribute("Bitrate", Long.toString(aq.bitrate)));
                qualityLevel.addAttribute(new Attribute("AudioTag", Integer.toString(aq.audioTag)));
                qualityLevel.addAttribute(new Attribute("SamplingRate", Long.toString(aq.samplingRate)));
                qualityLevel.addAttribute(new Attribute("Channels", Integer.toString(aq.channels)));
                qualityLevel.addAttribute(new Attribute("BitsPerSample", Integer.toString(aq.bitPerSample)));
                qualityLevel.addAttribute(new Attribute("PacketSize", Integer.toString(aq.packetSize)));
                qualityLevel.addAttribute(new Attribute("CodecPrivateData", aq.codecPrivateData));
                audioStreamIndex.appendChild((Node)qualityLevel);
            }
            for (i2 = 0; i2 < this.audioFragmentsDurations.length; ++i2) {
                Element c = new Element("c");
                c.addAttribute(new Attribute("n", Integer.toString(i2)));
                c.addAttribute(new Attribute("d", Long.toString(this.audioFragmentsDurations[i2])));
                audioStreamIndex.appendChild((Node)c);
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Serializer serializer = new Serializer((OutputStream)baos);
        serializer.setIndent(4);
        serializer.write(this.customizeManifest(new Document(smoothStreamingMedia)));
        return baos.toString("UTF-8");
    }

    private AudioQuality getAudioQuality(Track track, AudioSampleEntry ase) {
        if (this.getFormat(ase).equals("mp4a")) {
            AudioQuality l = new AudioQuality();
            l.bitrate = this.getBitrate(track);
            l.audioTag = 255;
            l.samplingRate = ase.getSampleRate();
            l.channels = ase.getChannelCount();
            l.bitPerSample = ase.getSampleSize();
            l.packetSize = 4;
            l.codecPrivateData = this.getAudioCodecPrivateData(ase.getBoxes(ESDescriptorBox.class).get(0));
            return l;
        }
        throw new InternalError("I don't know what to do with audio of type " + this.getFormat(ase));
    }

    @Override
    public long getBitrate(Track track) {
        long bitrate = 0L;
        for (ByteBuffer sample : track.getSamples()) {
            bitrate += (long)sample.limit();
        }
        bitrate *= 8L;
        bitrate = (long)((double)bitrate / ((double)FlatManifestWriterImpl.getDuration(track) / (double)track.getTrackMetaData().getTimescale()));
        return bitrate;
    }

    private String getAudioCodecPrivateData(ESDescriptorBox esDescriptorBox) {
        ByteBuffer configBytes = esDescriptorBox.getEsDescriptor().getDecoderConfigDescriptor().getAudioSpecificInfo().getConfigBytes();
        byte[] configByteArray = new byte[configBytes.limit()];
        configBytes.rewind();
        configBytes.get(configByteArray);
        return Hex.encodeHex(configByteArray);
    }

    private VideoQuality getVideoQuality(Track track, VisualSampleEntry vse) {
        if (!"avc1".equals(this.getFormat(vse))) {
            throw new InternalError("I don't know how to handle video of type " + this.getFormat(vse));
        }
        AvcConfigurationBox avcConfigurationBox = vse.getBoxes(AvcConfigurationBox.class).get(0);
        VideoQuality l = new VideoQuality();
        l.bitrate = this.getBitrate(track);
        l.codecPrivateData = Hex.encodeHex(this.getAvcCodecPrivateData(avcConfigurationBox));
        l.fourCC = "AVC1";
        l.width = vse.getWidth();
        l.height = vse.getHeight();
        l.nalLength = avcConfigurationBox.getLengthSizeMinusOne() + 1;
        return l;
    }

    private long[] checkFragmentsAlign(long[] referenceTimes, long[] checkTimes) throws IOException {
        if (referenceTimes == null || referenceTimes.length == 0) {
            return checkTimes;
        }
        long[] referenceTimesMinusLast = new long[referenceTimes.length - 1];
        System.arraycopy(referenceTimes, 0, referenceTimesMinusLast, 0, referenceTimes.length - 1);
        long[] checkTimesMinusLast = new long[checkTimes.length - 1];
        System.arraycopy(checkTimes, 0, checkTimesMinusLast, 0, checkTimes.length - 1);
        if (!Arrays.equals(checkTimesMinusLast, referenceTimesMinusLast)) {
            System.err.print("Reference     :  [");
            for (long l : checkTimes) {
                System.err.print(l + ",");
            }
            System.err.println("]");
            System.err.print("Current       :  [");
            for (long l : referenceTimes) {
                System.err.print(l + ",");
            }
            System.err.println("]");
            throw new IOException("Track does not have the same fragment borders as its predecessor.");
        }
        return checkTimes;
    }

    private byte[] getAvcCodecPrivateData(AvcConfigurationBox avcConfigurationBox) {
        List<byte[]> sps = avcConfigurationBox.getSequenceParameterSets();
        List<byte[]> pps = avcConfigurationBox.getPictureParameterSets();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(new byte[]{0, 0, 0, 1});
            for (byte[] sp : sps) {
                baos.write(sp);
            }
            baos.write(new byte[]{0, 0, 0, 1});
            for (byte[] pp : pps) {
                baos.write(pp);
            }
        }
        catch (IOException ex) {
            throw new InternalError("ByteArrayOutputStream do not throw IOException ?!?!?");
        }
        return baos.toByteArray();
    }

    private String getFormat(SampleEntry se) {
        String type = se.getType();
        if (type.equals("encv") || type.equals("enca") || type.equals("encv")) {
            OriginalFormatBox frma = se.getBoxes(OriginalFormatBox.class, true).get(0);
            type = frma.getDataFormat();
        }
        return type;
    }

    @Override
    public long[] calculateFragmentDurations(Track track, Movie movie) {
        long[] startSamples = this.intersectionFinder.sampleNumbers(track, movie);
        long[] durations = new long[startSamples.length];
        int currentFragment = -1;
        int currentSample = 1;
        for (TimeToSampleBox.Entry entry : track.getDecodingTimeEntries()) {
            int max = currentSample + CastUtils.l2i(entry.getCount());
            while (currentSample <= max) {
                if (currentFragment == startSamples.length - 1 || (long)currentSample == startSamples[currentFragment + 1]) {
                    // empty if block
                }
                int n = ++currentFragment;
                durations[n] = durations[n] + entry.getDelta();
                ++currentSample;
            }
        }
        return durations;
    }

    protected static long getDuration(Track track) {
        long duration = 0L;
        for (TimeToSampleBox.Entry entry : track.getDecodingTimeEntries()) {
            duration += entry.getCount() * entry.getDelta();
        }
        return duration;
    }
}

