/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.boxes.AbstractMediaHeaderBox;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SubSampleInformationBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class AppendTrack
extends AbstractTrack {
    Track[] tracks;

    public AppendTrack(Track ... tracks) throws IOException {
        this.tracks = tracks;
        byte[] referenceSampleDescriptionBox = null;
        for (Track track : tracks) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            track.getSampleDescriptionBox().getBox(Channels.newChannel(baos));
            if (referenceSampleDescriptionBox == null) {
                referenceSampleDescriptionBox = baos.toByteArray();
                continue;
            }
            if (Arrays.equals(referenceSampleDescriptionBox, baos.toByteArray())) continue;
            throw new IOException("Cannot append " + track + " to " + tracks[0] + " since their Sample Description Boxes differ");
        }
    }

    @Override
    public List<ByteBuffer> getSamples() {
        ArrayList<ByteBuffer> lists = new ArrayList<ByteBuffer>();
        for (Track track : this.tracks) {
            lists.addAll(track.getSamples());
        }
        return lists;
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.tracks[0].getSampleDescriptionBox();
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        if (this.tracks[0].getDecodingTimeEntries() != null && !this.tracks[0].getDecodingTimeEntries().isEmpty()) {
            LinkedList<long[]> lists = new LinkedList<long[]>();
            for (Track track : this.tracks) {
                lists.add(TimeToSampleBox.blowupTimeToSamples(track.getDecodingTimeEntries()));
            }
            LinkedList<TimeToSampleBox.Entry> returnDecodingEntries = new LinkedList<TimeToSampleBox.Entry>();
            Iterator iterator = lists.iterator();
            while (iterator.hasNext()) {
                long[] list;
                for (long nuDecodingTime : list = (long[])iterator.next()) {
                    TimeToSampleBox.Entry e;
                    if (returnDecodingEntries.isEmpty() || returnDecodingEntries.getLast().getDelta() != nuDecodingTime) {
                        e = new TimeToSampleBox.Entry(1L, nuDecodingTime);
                        returnDecodingEntries.add(e);
                        continue;
                    }
                    e = returnDecodingEntries.getLast();
                    e.setCount(e.getCount() + 1L);
                }
            }
            return returnDecodingEntries;
        }
        return null;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        if (this.tracks[0].getCompositionTimeEntries() != null && !this.tracks[0].getCompositionTimeEntries().isEmpty()) {
            LinkedList<int[]> lists = new LinkedList<int[]>();
            for (Track track : this.tracks) {
                lists.add(CompositionTimeToSample.blowupCompositionTimes(track.getCompositionTimeEntries()));
            }
            LinkedList<CompositionTimeToSample.Entry> compositionTimeEntries = new LinkedList<CompositionTimeToSample.Entry>();
            Iterator iterator = lists.iterator();
            while (iterator.hasNext()) {
                int[] list;
                for (int compositionTime : list = (int[])iterator.next()) {
                    CompositionTimeToSample.Entry e;
                    if (compositionTimeEntries.isEmpty() || compositionTimeEntries.getLast().getOffset() != compositionTime) {
                        e = new CompositionTimeToSample.Entry(1, compositionTime);
                        compositionTimeEntries.add(e);
                        continue;
                    }
                    e = compositionTimeEntries.getLast();
                    e.setCount(e.getCount() + 1);
                }
            }
            return compositionTimeEntries;
        }
        return null;
    }

    @Override
    public long[] getSyncSamples() {
        if (this.tracks[0].getSyncSamples() != null && this.tracks[0].getSyncSamples().length > 0) {
            int numSyncSamples = 0;
            for (Track track : this.tracks) {
                numSyncSamples += track.getSyncSamples().length;
            }
            long[] returnSyncSamples = new long[numSyncSamples];
            int pos = 0;
            long samplesBefore = 0L;
            for (Track track : this.tracks) {
                for (long l : track.getSyncSamples()) {
                    returnSyncSamples[pos++] = samplesBefore + l;
                }
                samplesBefore += (long)track.getSamples().size();
            }
            return returnSyncSamples;
        }
        return null;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        if (this.tracks[0].getSampleDependencies() != null && !this.tracks[0].getSampleDependencies().isEmpty()) {
            LinkedList<SampleDependencyTypeBox.Entry> list = new LinkedList<SampleDependencyTypeBox.Entry>();
            for (Track track : this.tracks) {
                list.addAll(track.getSampleDependencies());
            }
            return list;
        }
        return null;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.tracks[0].getTrackMetaData();
    }

    @Override
    public String getHandler() {
        return this.tracks[0].getHandler();
    }

    @Override
    public AbstractMediaHeaderBox getMediaHeaderBox() {
        return this.tracks[0].getMediaHeaderBox();
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return this.tracks[0].getSubsampleInformationBox();
    }
}

