/*
 * Decompiled with CFR 0.152.
 */
package com.todoroo.aacenc;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.speech.RecognitionListener;
import android.speech.SpeechRecognizer;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import com.todoroo.aacenc.AACEncoder;
import com.todoroo.aacenc.AACToM4A;
import com.todoroo.aacenc.R;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class Main
extends Activity
implements RecognitionListener {
    private String AAC_FILE;
    private String M4A_FILE = "/sdcard/audio.m4a";
    private AACEncoder encoder = new AACEncoder();
    private long speechStarted = 0L;
    private SpeechRecognizer sr;
    private ProgressDialog pd;
    ByteArrayOutputStream baos = new ByteArrayOutputStream();

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.main);
        File dir = this.getFilesDir();
        this.AAC_FILE = dir.toString() + "/audio.aac";
        this.findViewById(R.id.write).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Main.this.write();
            }
        });
        this.findViewById(R.id.play).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Main.this.play();
            }
        });
        this.sr = SpeechRecognizer.createSpeechRecognizer((Context)this);
    }

    private void play() {
        MediaPlayer mediaPlayer = new MediaPlayer();
        try {
            mediaPlayer.setDataSource(this.M4A_FILE);
            mediaPlayer.prepare();
            mediaPlayer.start();
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalStateException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Toast.makeText((Context)this, (CharSequence)"Playing Audio", (int)1).show();
    }

    private void write() {
        this.sr.setRecognitionListener((RecognitionListener)this);
        Intent intent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        intent.putExtra("android.speech.extra.LANGUAGE_MODEL", "free_form");
        intent.putExtra("calling_package", "com.domain.app");
        this.speechStarted = 0L;
        this.baos.reset();
        this.pd = new ProgressDialog((Context)this);
        this.pd.setMessage((CharSequence)"Speak now...");
        this.pd.setIndeterminate(true);
        this.pd.setCancelable(true);
        this.pd.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                Main.this.sr.cancel();
                Main.this.onEndOfSpeech();
            }
        });
        this.pd.show();
        this.sr.startListening(intent);
        this.speechStarted = System.currentTimeMillis();
    }

    public void onBeginningOfSpeech() {
        System.err.println("beginning");
    }

    public void onBufferReceived(byte[] buffer) {
        if (this.speechStarted > 0L) {
            try {
                this.baos.write(buffer);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void onStop() {
        super.onStop();
        this.sr.destroy();
    }

    public void onEndOfSpeech() {
        this.pd.dismiss();
        if (this.speechStarted == 0L) {
            return;
        }
        long delta = System.currentTimeMillis() - this.speechStarted;
        int sampleRate = (int)((long)(this.baos.size() * 1000) / delta);
        sampleRate = 8000;
        System.err.println("computed sample rate: " + sampleRate);
        this.encoder.init(64000, 1, sampleRate, 16, this.AAC_FILE);
        this.encoder.encode(this.baos.toByteArray());
        System.err.println("end");
        this.encoder.uninit();
        try {
            new AACToM4A().convert((Context)this, this.AAC_FILE, this.M4A_FILE);
            Toast.makeText((Context)this, (CharSequence)"File Saved!", (int)1).show();
        }
        catch (IOException e) {
            Toast.makeText((Context)this, (CharSequence)"Error :(", (int)1).show();
            Log.e((String)"ERROR", (String)"error converting", (Throwable)e);
        }
    }

    public void onError(int error) {
        Log.w((String)"Speech Error", (String)("Error code: " + error));
    }

    public void onEvent(int arg0, Bundle arg1) {
    }

    public void onPartialResults(Bundle partialResults) {
        this.onResults(partialResults);
    }

    public void onReadyForSpeech(Bundle arg0) {
    }

    public void onResults(Bundle results) {
        ArrayList strings = results.getStringArrayList("results_recognition");
        ((TextView)this.findViewById(R.id.text)).setText((CharSequence)(strings.size() == 0 ? "" : (String)strings.get(0)));
    }

    public void onRmsChanged(float arg0) {
    }
}

