/*
 * Decompiled with CFR 0.152.
 */
package org.acra.sender;

import android.net.Uri;
import android.util.Log;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.acra.ACRA;
import org.acra.ACRAConfiguration;
import org.acra.ACRAConstants;
import org.acra.ReportField;
import org.acra.collector.CrashReportData;
import org.acra.sender.ReportSender;
import org.acra.sender.ReportSenderException;
import org.acra.util.HttpRequest;
import org.acra.util.JSONReportBuilder;

public class HttpSender
implements ReportSender {
    private final Uri mFormUri;
    private final Map<ReportField, String> mMapping;
    private final Method mMethod;
    private final Type mType;

    public HttpSender(Method method, Type type, Map<ReportField, String> mapping) {
        this.mMethod = method;
        this.mFormUri = null;
        this.mMapping = mapping;
        this.mType = type;
    }

    public HttpSender(Method method, Type type, String formUri, Map<ReportField, String> mapping) {
        this.mMethod = method;
        this.mFormUri = Uri.parse((String)formUri);
        this.mMapping = mapping;
        this.mType = type;
    }

    @Override
    public void send(CrashReportData report) throws ReportSenderException {
        try {
            URL reportUrl = this.mFormUri == null ? new URL(ACRA.getConfig().formUri()) : new URL(this.mFormUri.toString());
            Log.d((String)ACRA.LOG_TAG, (String)("Connect to " + reportUrl.toString()));
            String login = ACRAConfiguration.isNull(ACRA.getConfig().formUriBasicAuthLogin()) ? null : ACRA.getConfig().formUriBasicAuthLogin();
            String password = ACRAConfiguration.isNull(ACRA.getConfig().formUriBasicAuthPassword()) ? null : ACRA.getConfig().formUriBasicAuthPassword();
            HttpRequest request = new HttpRequest();
            request.setConnectionTimeOut(ACRA.getConfig().connectionTimeout());
            request.setSocketTimeOut(ACRA.getConfig().socketTimeout());
            request.setMaxNrRetries(ACRA.getConfig().maxNumberOfRequestRetries());
            request.setLogin(login);
            request.setPassword(password);
            request.setHeaders(ACRA.getConfig().getHttpHeaders());
            String reportAsString = "";
            switch (this.mType) {
                case JSON: {
                    reportAsString = report.toJSON().toString();
                    break;
                }
                default: {
                    Map<String, String> finalReport = this.remap(report);
                    reportAsString = HttpRequest.getParamsAsFormString(finalReport);
                }
            }
            switch (this.mMethod) {
                case POST: {
                    break;
                }
                case PUT: {
                    reportUrl = new URL(reportUrl.toString() + '/' + report.getProperty(ReportField.REPORT_ID));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown method: " + this.mMethod.name());
                }
            }
            request.send(reportUrl, this.mMethod, reportAsString, this.mType);
        }
        catch (IOException e) {
            throw new ReportSenderException("Error while sending " + (Object)((Object)ACRA.getConfig().reportType()) + " report via Http " + this.mMethod.name(), e);
        }
        catch (JSONReportBuilder.JSONReportException e) {
            throw new ReportSenderException("Error while sending " + (Object)((Object)ACRA.getConfig().reportType()) + " report via Http " + this.mMethod.name(), e);
        }
    }

    private Map<String, String> remap(Map<ReportField, String> report) {
        ReportField[] fields = ACRA.getConfig().customReportContent();
        if (fields.length == 0) {
            fields = ACRAConstants.DEFAULT_REPORT_FIELDS;
        }
        HashMap<String, String> finalReport = new HashMap<String, String>(report.size());
        for (ReportField field : fields) {
            if (this.mMapping == null || this.mMapping.get((Object)field) == null) {
                finalReport.put(field.toString(), report.get((Object)field));
                continue;
            }
            finalReport.put(this.mMapping.get((Object)field), report.get((Object)field));
        }
        return finalReport;
    }

    public static enum Type {
        FORM{

            @Override
            public String getContentType() {
                return "application/x-www-form-urlencoded";
            }
        }
        ,
        JSON{

            @Override
            public String getContentType() {
                return "application/json";
            }
        };


        public abstract String getContentType();
    }

    public static enum Method {
        POST,
        PUT;

    }
}

