/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.crypto.modes.gcm;

import org.spongycastle.crypto.util.Pack;
import org.spongycastle.util.Arrays;

abstract class GCMUtil {
    GCMUtil() {
    }

    static byte[] oneAsBytes() {
        byte[] tmp = new byte[16];
        tmp[0] = -128;
        return tmp;
    }

    static int[] oneAsInts() {
        int[] tmp = new int[4];
        tmp[0] = Integer.MIN_VALUE;
        return tmp;
    }

    static int[] asInts(byte[] bs) {
        int[] us = new int[]{Pack.bigEndianToInt(bs, 0), Pack.bigEndianToInt(bs, 4), Pack.bigEndianToInt(bs, 8), Pack.bigEndianToInt(bs, 12)};
        return us;
    }

    static void multiply(byte[] block, byte[] val) {
        byte[] tmp = Arrays.clone(block);
        byte[] c = new byte[16];
        for (int i = 0; i < 16; ++i) {
            byte bits = val[i];
            for (int j = 7; j >= 0; --j) {
                if ((bits & 1 << j) != 0) {
                    GCMUtil.xor(c, tmp);
                }
                boolean lsb = (tmp[15] & 1) != 0;
                GCMUtil.shiftRight(tmp);
                if (!lsb) continue;
                tmp[0] = (byte)(tmp[0] ^ 0xFFFFFFE1);
            }
        }
        System.arraycopy(c, 0, block, 0, 16);
    }

    static void multiplyP(int[] x) {
        boolean lsb = (x[3] & 1) != 0;
        GCMUtil.shiftRight(x);
        if (lsb) {
            x[0] = x[0] ^ 0xE1000000;
        }
    }

    static void multiplyP8(int[] x) {
        int lsw = x[3];
        GCMUtil.shiftRightN(x, 8);
        for (int i = 7; i >= 0; --i) {
            if ((lsw & 1 << i) == 0) continue;
            x[0] = x[0] ^ -520093696 >>> 7 - i;
        }
    }

    static void shiftRight(byte[] block) {
        int i = 0;
        int bit = 0;
        while (true) {
            int b = block[i] & 0xFF;
            block[i] = (byte)(b >>> 1 | bit);
            if (++i == 16) break;
            bit = (b & 1) << 7;
        }
    }

    static void shiftRight(int[] block) {
        int i = 0;
        int bit = 0;
        while (true) {
            int b = block[i];
            block[i] = b >>> 1 | bit;
            if (++i == 4) break;
            bit = b << 31;
        }
    }

    static void shiftRightN(int[] block, int n) {
        int i = 0;
        int bits = 0;
        while (true) {
            int b = block[i];
            block[i] = b >>> n | bits;
            if (++i == 4) break;
            bits = b << 32 - n;
        }
    }

    static void xor(byte[] block, byte[] val) {
        for (int i = 15; i >= 0; --i) {
            int n = i;
            block[n] = (byte)(block[n] ^ val[i]);
        }
    }

    static void xor(int[] block, int[] val) {
        for (int i = 3; i >= 0; --i) {
            int n = i;
            block[n] = block[n] ^ val[i];
        }
    }
}

