/*
 * Decompiled with CFR 0.152.
 */
package com.activate.gcm;

import android.content.Context;
import com.google.android.gcm.GCMRegistrar;
import java.util.HashMap;
import org.appcelerator.kroll.KrollFunction;
import org.appcelerator.kroll.KrollModule;
import org.appcelerator.kroll.common.Log;
import org.appcelerator.titanium.TiApplication;

public class C2dmModule
extends KrollModule {
    private static final String LCAT = "C2dmModule";
    private static C2dmModule _THIS;
    private KrollFunction successCallback;
    private KrollFunction errorCallback;
    private KrollFunction messageCallback;

    public C2dmModule() {
        _THIS = this;
    }

    public void registerC2dm(HashMap options) {
        Log.d((String)LCAT, (String)"registerC2dm called");
        this.successCallback = (KrollFunction)options.get("success");
        this.errorCallback = (KrollFunction)options.get("error");
        this.messageCallback = (KrollFunction)options.get("callback");
        String registrationId = this.getRegistrationId();
        if (registrationId != null && registrationId.length() > 0) {
            this.sendSuccess(registrationId);
        } else {
            GCMRegistrar.register((Context)TiApplication.getInstance(), this.getSenderId());
        }
    }

    public void unregister() {
        Log.d((String)LCAT, (String)"unregister called");
        GCMRegistrar.unregister((Context)TiApplication.getInstance());
    }

    public String getRegistrationId() {
        Log.d((String)LCAT, (String)"get registrationId property");
        return GCMRegistrar.getRegistrationId((Context)TiApplication.getInstance());
    }

    public String getSenderId() {
        return TiApplication.getInstance().getAppProperties().getString("com.activate.gcm.sender_id", "");
    }

    public void sendSuccess(String registrationId) {
        if (this.successCallback != null) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("registrationId", registrationId);
            this.successCallback.callAsync(this.getKrollObject(), data);
        }
    }

    public void sendError(String error) {
        if (this.errorCallback != null) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("error", error);
            this.errorCallback.callAsync(this.getKrollObject(), data);
        }
    }

    public void sendMessage(HashMap messageData) {
        if (this.messageCallback != null) {
            HashMap<String, HashMap> data = new HashMap<String, HashMap>();
            data.put("data", messageData);
            this.messageCallback.call(this.getKrollObject(), data);
        }
    }

    public static C2dmModule getInstance() {
        return _THIS;
    }
}

