/*
 * Decompiled with CFR 0.152.
 */
package com.activate.gcm;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import com.activate.gcm.C2dmModule;
import com.google.android.gcm.GCMBaseIntentService;
import java.util.HashMap;
import org.appcelerator.kroll.common.Log;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.TiProperties;
import org.json.JSONObject;

public class GCMIntentService
extends GCMBaseIntentService {
    private static final String LCAT = "C2DMReceiver";
    private static final String REGISTER_EVENT = "registerC2dm";
    private static final String UNREGISTER_EVENT = "unregister";
    private static final String MESSAGE_EVENT = "message";
    private static final String ERROR_EVENT = "error";

    public GCMIntentService() {
        super(TiApplication.getInstance().getAppProperties().getString("com.activate.gcm.sender_id", ""));
    }

    @Override
    public void onRegistered(Context context, String registrationId) {
        Log.d((String)LCAT, (String)("Registered: " + registrationId));
        C2dmModule.getInstance().sendSuccess(registrationId);
    }

    @Override
    public void onUnregistered(Context context, String registrationId) {
        Log.d((String)LCAT, (String)"Unregistered");
        C2dmModule.getInstance().fireEvent(UNREGISTER_EVENT, new HashMap());
    }

    @Override
    protected void onMessage(Context context, Intent intent) {
        Log.d((String)LCAT, (String)"Message received");
        TiProperties systProp = TiApplication.getInstance().getAppProperties();
        HashMap<String, String> data = new HashMap<String, String>();
        for (String key : intent.getExtras().keySet()) {
            Log.d((String)LCAT, (String)("Message key: " + key + " value: " + intent.getExtras().getString(key)));
            String eventKey = key.startsWith("data.") ? key.substring(5) : key;
            data.put(eventKey, intent.getExtras().getString(key));
        }
        int icon = systProp.getInt("com.activate.gcm.icon", 0);
        CharSequence tickerText = (CharSequence)data.get("ticker");
        long when = System.currentTimeMillis();
        CharSequence contentTitle = (CharSequence)data.get("title");
        CharSequence contentText = (CharSequence)data.get(MESSAGE_EVENT);
        Intent notificationIntent = new Intent((Context)this, GCMIntentService.class);
        Intent launcherintent = new Intent("android.intent.action.MAIN");
        launcherintent.setFlags(0x200000);
        launcherintent.setComponent(ComponentName.unflattenFromString((String)systProp.getString("com.activate.gcm.component", "")));
        launcherintent.addCategory("android.intent.category.LAUNCHER");
        PendingIntent contentIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)launcherintent, (int)0);
        Notification notification = new Notification(icon, tickerText, when);
        notification.defaults = -1;
        notification.flags = 16;
        notification.setLatestEventInfo(context, contentTitle, contentText, contentIntent);
        String ns = "notification";
        NotificationManager mNotificationManager = (NotificationManager)this.getSystemService(ns);
        mNotificationManager.notify(1, notification);
        JSONObject json = new JSONObject(data);
        systProp.setString("com.activate.gcm.last_data", json.toString());
        if (C2dmModule.getInstance() != null) {
            C2dmModule.getInstance().sendMessage(data);
        }
    }

    @Override
    public void onError(Context context, String errorId) {
        Log.e((String)LCAT, (String)("Error: " + errorId));
        C2dmModule.getInstance().sendError(errorId);
    }

    @Override
    public boolean onRecoverableError(Context context, String errorId) {
        Log.e((String)LCAT, (String)("RecoverableError: " + errorId));
        C2dmModule.getInstance().sendError(errorId);
        return true;
    }
}

