/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.content.Context;
import android.content.Intent;
import android.view.View;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.games.OnGamesLoadedListener;
import com.google.android.gms.games.OnPlayersLoadedListener;
import com.google.android.gms.games.OnSignOutCompleteListener;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.RealTimeSocket;
import com.google.android.gms.games.achievement.OnAchievementUpdatedListener;
import com.google.android.gms.games.achievement.OnAchievementsLoadedListener;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.OnLeaderboardMetadataLoadedListener;
import com.google.android.gms.games.leaderboard.OnLeaderboardScoresLoadedListener;
import com.google.android.gms.games.leaderboard.OnScoreSubmittedListener;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.OnInvitationsLoadedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeReliableMessageSentListener;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.internal.bj;
import com.google.android.gms.internal.x;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GamesClient
implements GooglePlayServicesClient {
    public static final int NOTIFICATION_TYPE_INVITATION = 1;
    public static final int NOTIFICATION_TYPES_ALL = -1;
    public static final int NOTIFICATION_TYPES_MULTIPLAYER = 1;
    public static final String EXTRA_PLAYERS = "players";
    public static final String EXTRA_MIN_AUTOMATCH_PLAYERS = "min_automatch_players";
    public static final String EXTRA_MAX_AUTOMATCH_PLAYERS = "max_automatch_players";
    public static final String EXTRA_ROOM = "room";
    public static final String EXTRA_EXCLUSIVE_BIT_MASK = "exclusive_bit_mask";
    public static final String EXTRA_INVITATION = "invitation";
    public static final int MAX_UNRELIABLE_MESSAGE_LEN = 1168;
    public static final int MAX_RELIABLE_MESSAGE_LEN = 1400;
    public static final int STATUS_OK = 0;
    public static final int STATUS_INTERNAL_ERROR = 1;
    public static final int STATUS_CLIENT_RECONNECT_REQUIRED = 2;
    public static final int STATUS_NETWORK_ERROR_STALE_DATA = 3;
    public static final int STATUS_NETWORK_ERROR_NO_DATA = 4;
    public static final int STATUS_NETWORK_ERROR_OPERATION_DEFERRED = 5;
    public static final int STATUS_NETWORK_ERROR_OPERATION_FAILED = 6;
    public static final int STATUS_LICENSE_CHECK_FAILED = 7;
    public static final int STATUS_ACHIEVEMENT_UNLOCK_FAILURE = 3000;
    public static final int STATUS_ACHIEVEMENT_UNKNOWN = 3001;
    public static final int STATUS_ACHIEVEMENT_NOT_INCREMENTAL = 3002;
    public static final int STATUS_ACHIEVEMENT_UNLOCKED = 3003;
    public static final int STATUS_MULTIPLAYER_ERROR_CREATION_NOT_ALLOWED = 6000;
    public static final int STATUS_MULTIPLAYER_ERROR_NOT_TRUSTED_TESTER = 6001;
    public static final int STATUS_REAL_TIME_CONNECTION_FAILED = 7000;
    public static final int STATUS_REAL_TIME_MESSAGE_SEND_FAILED = 7001;
    public static final int STATUS_INVALID_REAL_TIME_ROOM_ID = 7002;
    public static final int STATUS_PARTICIPANT_NOT_CONNECTED = 7003;
    public static final int STATUS_REAL_TIME_ROOM_NOT_JOINED = 7004;
    public static final int STATUS_REAL_TIME_INACTIVE_ROOM = 7005;
    public static final int STATUS_REAL_TIME_MESSAGE_FAILED = -1;
    private final bj cs;

    private GamesClient(Context context, String gamePackageName, String accountName, GooglePlayServicesClient.ConnectionCallbacks connectedListener, GooglePlayServicesClient.OnConnectionFailedListener connectionFailedListener, String[] scopes, int gravity, View gamesContentView) {
        this.cs = new bj(context, gamePackageName, accountName, connectedListener, connectionFailedListener, scopes, gravity, gamesContentView, false);
    }

    public void setGravityForPopups(int gravity) {
        this.cs.setGravityForPopups(gravity);
    }

    public void setViewForPopups(View gamesContentView) {
        x.d(gamesContentView);
        this.cs.setViewForPopups(gamesContentView);
    }

    @Override
    public void connect() {
        this.cs.connect();
    }

    @Override
    public boolean isConnected() {
        return this.cs.isConnected();
    }

    @Override
    public boolean isConnecting() {
        return this.cs.isConnecting();
    }

    @Override
    public void registerConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.cs.registerConnectionCallbacks(listener);
    }

    @Override
    public boolean isConnectionCallbacksRegistered(GooglePlayServicesClient.ConnectionCallbacks listener) {
        return this.cs.isConnectionCallbacksRegistered(listener);
    }

    @Override
    public void unregisterConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.cs.unregisterConnectionCallbacks(listener);
    }

    @Override
    public void registerConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.cs.registerConnectionFailedListener(listener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        return this.cs.isConnectionFailedListenerRegistered(listener);
    }

    @Override
    public void unregisterConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.cs.unregisterConnectionFailedListener(listener);
    }

    @Override
    public void disconnect() {
        this.cs.disconnect();
    }

    public void reconnect() {
        this.cs.disconnect();
        this.cs.connect();
    }

    public String getCurrentAccountName() {
        return this.cs.getCurrentAccountName();
    }

    public String getCurrentPlayerId() {
        return this.cs.getCurrentPlayerId();
    }

    public Player getCurrentPlayer() {
        return this.cs.getCurrentPlayer();
    }

    public void loadPlayer(OnPlayersLoadedListener listener, String playerId) {
        this.cs.loadPlayer(listener, playerId);
    }

    public void loadInvitablePlayers(OnPlayersLoadedListener listener, int pageSize, boolean forceReload) {
        this.cs.a(listener, pageSize, false, forceReload);
    }

    public void loadMoreInvitablePlayers(OnPlayersLoadedListener listener, int pageSize) {
        this.cs.a(listener, pageSize, true, false);
    }

    public Intent getAllLeaderboardsIntent() {
        return this.cs.getAllLeaderboardsIntent();
    }

    public Intent getLeaderboardIntent(String leaderboardId) {
        return this.cs.getLeaderboardIntent(leaderboardId);
    }

    public void loadLeaderboardMetadata(OnLeaderboardMetadataLoadedListener listener) {
        this.cs.loadLeaderboardMetadata(listener);
    }

    public void loadLeaderboardMetadata(OnLeaderboardMetadataLoadedListener listener, String leaderboardId) {
        this.cs.loadLeaderboardMetadata(listener, leaderboardId);
    }

    public void loadTopScores(OnLeaderboardScoresLoadedListener listener, String leaderboardId, int span, int leaderboardCollection, int maxResults) {
        this.cs.loadTopScores(listener, leaderboardId, span, leaderboardCollection, maxResults, false);
    }

    public void loadTopScores(OnLeaderboardScoresLoadedListener listener, String leaderboardId, int span, int leaderboardCollection, int maxResults, boolean forceReload) {
        this.cs.loadTopScores(listener, leaderboardId, span, leaderboardCollection, maxResults, forceReload);
    }

    public void loadPlayerCenteredScores(OnLeaderboardScoresLoadedListener listener, String leaderboardId, int span, int leaderboardCollection, int maxResults) {
        this.cs.loadPlayerCenteredScores(listener, leaderboardId, span, leaderboardCollection, maxResults, false);
    }

    public void loadPlayerCenteredScores(OnLeaderboardScoresLoadedListener listener, String leaderboardId, int span, int leaderboardCollection, int maxResults, boolean forceReload) {
        this.cs.loadPlayerCenteredScores(listener, leaderboardId, span, leaderboardCollection, maxResults, forceReload);
    }

    public void loadMoreScores(OnLeaderboardScoresLoadedListener listener, LeaderboardScoreBuffer buffer, int maxResults, int pageDirection) {
        this.cs.loadMoreScores(listener, buffer, maxResults, pageDirection);
    }

    public void submitScore(String leaderboardId, long score) {
        this.cs.a(null, leaderboardId, score);
    }

    public void submitScoreImmediate(OnScoreSubmittedListener listener, String leaderboardId, long score) {
        this.cs.a(listener, leaderboardId, score);
    }

    public Intent getAchievementsIntent() {
        return this.cs.getAchievementsIntent();
    }

    public void loadAchievements(OnAchievementsLoadedListener listener) {
        this.cs.loadAchievements(listener);
    }

    public void revealAchievement(String id) {
        this.cs.a((OnAchievementUpdatedListener)null, id);
    }

    public void revealAchievementImmediate(OnAchievementUpdatedListener listener, String id) {
        this.cs.a(listener, id);
    }

    public void unlockAchievement(String id) {
        this.cs.b(null, id);
    }

    public void unlockAchievementImmediate(OnAchievementUpdatedListener listener, String id) {
        this.cs.b(listener, id);
    }

    public void incrementAchievement(String id, int numSteps) {
        this.cs.a((OnAchievementUpdatedListener)null, id, numSteps);
    }

    public void incrementAchievementImmediate(OnAchievementUpdatedListener listener, String id, int numSteps) {
        this.cs.a(listener, id, numSteps);
    }

    public Intent getInvitationInboxIntent() {
        return this.cs.getInvitationInboxIntent();
    }

    public void registerInvitationListener(OnInvitationReceivedListener listener) {
        this.cs.registerInvitationListener(listener);
    }

    public void unregisterInvitationListener() {
        this.cs.unregisterInvitationListener();
    }

    public Intent getSelectPlayersIntent(int minPlayers, int maxPlayers) {
        return this.cs.getSelectPlayersIntent(minPlayers, maxPlayers);
    }

    public Intent getRealTimeWaitingRoomIntent(Room room, int minParticipantsToStart) {
        return this.cs.getRealTimeWaitingRoomIntent(room, minParticipantsToStart);
    }

    public Intent getSettingsIntent() {
        return this.cs.getSettingsIntent();
    }

    public void loadGame(OnGamesLoadedListener listener) {
        this.cs.loadGame(listener);
    }

    public void signOut() {
        this.cs.signOut(null);
    }

    public void signOut(OnSignOutCompleteListener listener) {
        this.cs.signOut(listener);
    }

    public String getAppId() {
        return this.cs.getAppId();
    }

    public void createRoom(RoomConfig config) {
        this.cs.createRoom(config);
    }

    public void joinRoom(RoomConfig config) {
        this.cs.joinRoom(config);
    }

    public void leaveRoom(RoomUpdateListener listener, String roomId) {
        this.cs.leaveRoom(listener, roomId);
    }

    public int sendReliableRealTimeMessage(RealTimeReliableMessageSentListener listener, byte[] messageData, String roomId, String recipientParticipantId) {
        return this.cs.sendReliableRealTimeMessage(listener, messageData, roomId, recipientParticipantId);
    }

    public int sendUnreliableRealTimeMessage(byte[] messageData, String roomId, String recipientParticipantId) {
        return this.cs.a(messageData, roomId, new String[]{recipientParticipantId});
    }

    public int sendUnreliableRealTimeMessage(byte[] messageData, String roomId, List<String> recipientParticipantIds) {
        String[] stringArray = recipientParticipantIds.toArray(new String[recipientParticipantIds.size()]);
        return this.cs.a(messageData, roomId, stringArray);
    }

    public int sendUnreliableRealTimeMessageToAll(byte[] messageData, String roomId) {
        return this.cs.sendUnreliableRealTimeMessageToAll(messageData, roomId);
    }

    public RealTimeSocket getRealTimeSocketForParticipant(String roomId, String participantId) {
        return this.cs.getRealTimeSocketForParticipant(roomId, participantId);
    }

    public void declineRoomInvitation(String invitationId) {
        this.cs.i(invitationId, 0);
    }

    public void dismissRoomInvitation(String invitationId) {
        this.cs.h(invitationId, 0);
    }

    public void loadInvitations(OnInvitationsLoadedListener listener) {
        this.cs.loadInvitations(listener);
    }

    public void clearAllNotifications() {
        this.cs.clearNotifications(-1);
    }

    public void clearNotifications(int notificationTypes) {
        this.cs.clearNotifications(notificationTypes);
    }

    public void setUseNewPlayerNotificationsFirstParty(boolean newPlayerStyle) {
        this.cs.setUseNewPlayerNotificationsFirstParty(newPlayerStyle);
    }

    public static final class Builder {
        private final Context mContext;
        private String ct;
        private String g = "<<default account>>";
        private final GooglePlayServicesClient.ConnectionCallbacks d;
        private final GooglePlayServicesClient.OnConnectionFailedListener e;
        private String[] f = new String[]{"https://www.googleapis.com/auth/games"};
        private int cu = 49;
        private View cv;

        public Builder(Context context, GooglePlayServicesClient.ConnectionCallbacks connectedListener, GooglePlayServicesClient.OnConnectionFailedListener connectionFailedListener) {
            this.mContext = context;
            this.ct = context.getPackageName();
            this.d = connectedListener;
            this.e = connectionFailedListener;
        }

        public Builder setScopes(String ... scopes) {
            this.f = scopes;
            return this;
        }

        public Builder setAccountName(String accountName) {
            this.g = x.d(accountName);
            return this;
        }

        public Builder setGravityForPopups(int gravity) {
            this.cu = gravity;
            return this;
        }

        public Builder setViewForPopups(View gamesContentView) {
            this.cv = x.d(gamesContentView);
            return this;
        }

        public GamesClient create() {
            return new GamesClient(this.mContext, this.ct, this.g, this.d, this.e, this.f, this.cu, this.cv);
        }
    }
}

