/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import com.google.android.gms.internal.bq;
import com.google.android.gms.internal.k;
import com.google.android.gms.internal.w;
import com.google.android.gms.internal.x;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubmitScoreResult {
    private static final String[] dB = new String[]{"leaderboardId", "playerId", "timeSpan", "hasResult", "rawScore", "formattedScore", "newBest"};
    private String dC;
    private String cw;
    private int p;
    private HashMap<Integer, Result> dD;

    public SubmitScoreResult(int statusCode, String leaderboardId, String playerId, HashMap<Integer, Result> results) {
        this.p = statusCode;
        this.dC = leaderboardId;
        this.cw = playerId;
        this.dD = results;
    }

    public SubmitScoreResult(int statusCode, String leaderboardId, String playerId) {
        this(statusCode, leaderboardId, playerId, new HashMap<Integer, Result>());
    }

    public SubmitScoreResult(k dataHolder) {
        this.p = dataHolder.getStatusCode();
        this.dD = new HashMap();
        int n2 = dataHolder.getCount();
        x.c(n2 == 3);
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl2;
            int n3 = dataHolder.d(i2);
            if (i2 == 0) {
                this.dC = dataHolder.c("leaderboardId", i2, n3);
                this.cw = dataHolder.c("playerId", i2, n3);
            }
            if (!(bl2 = dataHolder.d("hasResult", i2, n3))) continue;
            Result result = new Result(dataHolder.a("rawScore", i2, n3), dataHolder.c("formattedScore", i2, n3), dataHolder.d("newBest", i2, n3));
            this.a(result, dataHolder.b("timeSpan", i2, n3));
        }
    }

    public String getLeaderboardId() {
        return this.dC;
    }

    public String getPlayerId() {
        return this.cw;
    }

    public int getStatusCode() {
        return this.p;
    }

    public Result getScoreResult(int timeSpan) {
        return this.dD.get(timeSpan);
    }

    private void a(Result result, int n2) {
        this.dD.put(n2, result);
    }

    public String toString() {
        w.a a2 = w.c(this).a("PlayerId", this.cw).a("StatusCode", this.p);
        for (int i2 = 0; i2 < 3; ++i2) {
            Result result = this.dD.get(i2);
            a2.a("TimesSpan", bq.B(i2));
            a2.a("Result", result == null ? "null" : result.toString());
        }
        return a2.toString();
    }

    public static final class Result {
        public final long rawScore;
        public final String formattedScore;
        public final boolean newBest;

        public Result(long rawScore, String formattedScore, boolean newBest) {
            this.rawScore = rawScore;
            this.formattedScore = formattedScore;
            this.newBest = newBest;
        }

        public String toString() {
            return w.c(this).a("RawScore", this.rawScore).a("FormattedScore", this.formattedScore).a("NewBest", this.newBest).toString();
        }
    }
}

