/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.internal.ax;
import com.google.android.gms.internal.w;

public final class ParticipantEntity
implements Parcelable,
Participant {
    private final PlayerEntity dM;
    private final String dm;
    private final String bm;
    private final Uri cj;
    private final Uri ck;
    private final int dN;
    private final String dO;
    private final boolean dP;
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new Parcelable.Creator<ParticipantEntity>(){

        public ParticipantEntity q(Parcel parcel) {
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            String string4 = parcel.readString();
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            int n2 = parcel.readInt();
            String string5 = parcel.readString();
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            PlayerEntity playerEntity = bl3 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(string, string2, uri, uri2, n2, string5, bl2, playerEntity);
        }

        public ParticipantEntity[] D(int n2) {
            return new ParticipantEntity[n2];
        }

        public /* synthetic */ Object[] newArray(int x0) {
            return this.D(x0);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.q(x0);
        }
    };

    public ParticipantEntity(Participant participant) {
        Player player = participant.getPlayer();
        this.dM = player == null ? null : new PlayerEntity(player);
        this.dm = participant.getParticipantId();
        this.bm = participant.getDisplayName();
        this.cj = participant.getIconImageUri();
        this.ck = participant.getHiResImageUri();
        this.dN = participant.getStatus();
        this.dO = participant.getClientAddress();
        this.dP = participant.isConnectedToRoom();
    }

    public int getStatus() {
        return this.dN;
    }

    public String getClientAddress() {
        return this.dO;
    }

    public boolean isConnectedToRoom() {
        return this.dP;
    }

    public String getDisplayName() {
        if (this.dM == null) {
            return this.bm;
        }
        return this.dM.getDisplayName();
    }

    public void getDisplayName(CharArrayBuffer dataOut) {
        if (this.dM == null) {
            ax.b(this.bm, dataOut);
            return;
        }
        this.dM.getDisplayName(dataOut);
    }

    public Uri getIconImageUri() {
        if (this.dM == null) {
            return this.cj;
        }
        return this.dM.getIconImageUri();
    }

    public Uri getHiResImageUri() {
        if (this.dM == null) {
            return this.ck;
        }
        return this.dM.getHiResImageUri();
    }

    public String getParticipantId() {
        return this.dm;
    }

    public Player getPlayer() {
        return this.dM;
    }

    public Participant freeze() {
        return this;
    }

    public int hashCode() {
        return ParticipantEntity.a(this);
    }

    public static int a(Participant participant) {
        return w.hashCode(participant.getPlayer(), participant.getStatus(), participant.getClientAddress(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri());
    }

    public boolean equals(Object obj) {
        return ParticipantEntity.a(this, obj);
    }

    public static boolean a(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return w.a(participant2.getPlayer(), participant.getPlayer()) && w.a(participant2.getStatus(), participant.getStatus()) && w.a(participant2.getClientAddress(), participant.getClientAddress()) && w.a(participant2.isConnectedToRoom(), participant.isConnectedToRoom()) && w.a(participant2.getDisplayName(), participant.getDisplayName()) && w.a(participant2.getIconImageUri(), participant.getIconImageUri()) && w.a(participant2.getHiResImageUri(), participant.getHiResImageUri());
    }

    public String toString() {
        return ParticipantEntity.b(this);
    }

    public static String b(Participant participant) {
        return w.c(participant).a("Player", participant.getPlayer()).a("Status", participant.getStatus()).a("ClientAddress", participant.getClientAddress()).a("ConnectedToRoom", participant.isConnectedToRoom()).a("DisplayName", participant.getDisplayName()).a("IconImage", participant.getIconImageUri()).a("HiResImage", participant.getHiResImageUri()).toString();
    }

    public int describeContents() {
        return 0;
    }

    private ParticipantEntity(String participantId, String displayName, Uri iconImageUri, Uri hiResImageUri, int status, String clientAddress, boolean connectedToRoom, PlayerEntity player) {
        this.dm = participantId;
        this.bm = displayName;
        this.cj = iconImageUri;
        this.ck = hiResImageUri;
        this.dN = status;
        this.dO = clientAddress;
        this.dP = connectedToRoom;
        this.dM = player;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.dm);
        dest.writeString(this.bm);
        dest.writeString(this.cj == null ? null : this.cj.toString());
        dest.writeString(this.ck == null ? null : this.ck.toString());
        dest.writeInt(this.dN);
        dest.writeString(this.dO);
        dest.writeInt(this.dP ? 1 : 0);
        dest.writeInt(this.dM == null ? 0 : 1);
        if (this.dM != null) {
            this.dM.writeToParcel(dest, flags);
        }
    }
}

