/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.os.Bundle;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.internal.x;
import java.util.ArrayList;
import java.util.Arrays;

public final class RoomConfig {
    private final RoomUpdateListener dU;
    private final RoomStatusUpdateListener dV;
    private final RealTimeMessageReceivedListener dW;
    private final String dF;
    private final int dX;
    private final String[] dY;
    private final Bundle dZ;
    private final boolean ea;

    private RoomConfig(Builder builder) {
        this.dU = builder.dU;
        this.dV = builder.dV;
        this.dW = builder.dW;
        this.dF = builder.eb;
        this.dX = builder.dX;
        this.dZ = builder.dZ;
        this.ea = builder.ea;
        int n2 = builder.ec.size();
        this.dY = builder.ec.toArray(new String[n2]);
        if (this.dW == null) {
            x.a(this.ea, "Must either enable sockets OR specify a message listener");
        }
    }

    public RoomUpdateListener getRoomUpdateListener() {
        return this.dU;
    }

    public String getInvitationId() {
        return this.dF;
    }

    public RoomStatusUpdateListener getRoomStatusUpdateListener() {
        return this.dV;
    }

    public RealTimeMessageReceivedListener getMessageReceivedListener() {
        return this.dW;
    }

    public int getVariant() {
        return this.dX;
    }

    public String[] getInvitedPlayerIds() {
        return this.dY;
    }

    public Bundle getAutoMatchCriteria() {
        return this.dZ;
    }

    public boolean isSocketEnabled() {
        return this.ea;
    }

    public static Builder builder(RoomUpdateListener listener) {
        return new Builder(listener);
    }

    public static Bundle createAutoMatchCriteria(int minAutoMatchPlayers, int maxAutoMatchPlayers, long exclusiveBitMask) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", minAutoMatchPlayers);
        bundle.putInt("max_automatch_players", maxAutoMatchPlayers);
        bundle.putLong("exclusive_bit_mask", exclusiveBitMask);
        return bundle;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder {
        final RoomUpdateListener dU;
        RoomStatusUpdateListener dV;
        RealTimeMessageReceivedListener dW;
        String eb = null;
        int dX = -1;
        ArrayList<String> ec = new ArrayList();
        Bundle dZ;
        boolean ea = false;

        private Builder(RoomUpdateListener updateListener) {
            this.dU = x.b(updateListener, (Object)"Must provide a RoomUpdateListener");
        }

        public Builder setInvitationIdToAccept(String invitationId) {
            x.d(invitationId);
            this.eb = invitationId;
            return this;
        }

        public Builder setRoomStatusUpdateListener(RoomStatusUpdateListener listener) {
            this.dV = listener;
            return this;
        }

        public Builder setMessageReceivedListener(RealTimeMessageReceivedListener listener) {
            this.dW = listener;
            return this;
        }

        public Builder addPlayersToInvite(String ... playerIds) {
            x.d(playerIds);
            this.ec.addAll(Arrays.asList(playerIds));
            return this;
        }

        public Builder addPlayersToInvite(ArrayList<String> playerIds) {
            x.d(playerIds);
            this.ec.addAll(playerIds);
            return this;
        }

        public Builder setVariant(int variant) {
            this.dX = variant;
            return this;
        }

        public Builder setSocketCommunicationEnabled(boolean enableSockets) {
            this.ea = enableSockets;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle autoMatchCriteria) {
            this.dZ = autoMatchCriteria;
            return this;
        }

        public RoomConfig build() {
            return new RoomConfig(this);
        }
    }
}

