/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.internal.ax;
import com.google.android.gms.internal.w;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RoomEntity
implements Room {
    private final String cU;
    private final String ed;
    private final long dG;
    private final int ee;
    private final String ch;
    private final int dX;
    private final Bundle dZ;
    private final ArrayList<Participant> dJ;
    public static final Parcelable.Creator<RoomEntity> CREATOR = new Parcelable.Creator<RoomEntity>(){

        public RoomEntity s(Parcel parcel) {
            String string = parcel.readString();
            String string2 = parcel.readString();
            long l2 = parcel.readLong();
            int n2 = parcel.readInt();
            String string3 = parcel.readString();
            int n3 = parcel.readInt();
            Bundle bundle = parcel.readBundle();
            int n4 = parcel.readInt();
            ArrayList<Object> arrayList = new ArrayList<Object>(n4);
            for (int i2 = 0; i2 < n4; ++i2) {
                arrayList.add(ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            return new RoomEntity(string, string2, l2, n2, string3, n3, bundle, arrayList);
        }

        public RoomEntity[] F(int n2) {
            return new RoomEntity[n2];
        }

        public /* synthetic */ Object[] newArray(int x0) {
            return this.F(x0);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.s(x0);
        }
    };

    public RoomEntity(Room room) {
        this.cU = room.getRoomId();
        this.ed = room.getCreatorId();
        this.dG = room.getCreationTimestamp();
        this.ee = room.getStatus();
        this.ch = room.getDescription();
        this.dX = room.getVariant();
        this.dZ = room.getAutoMatchCriteria();
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        this.dJ = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.dJ.add((Participant)((Participant)arrayList.get(i2)).freeze());
        }
    }

    @Override
    public String getRoomId() {
        return this.cU;
    }

    @Override
    public String getCreatorId() {
        return this.ed;
    }

    @Override
    public long getCreationTimestamp() {
        return this.dG;
    }

    @Override
    public int getStatus() {
        return this.ee;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        int n2 = this.dJ.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = this.dJ.get(i2);
            if (!participant.getParticipantId().equals(participantId)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + participantId + " is not in room " + this.getRoomId());
    }

    @Override
    public String getDescription() {
        return this.ch;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        ax.b(this.ch, dataOut);
    }

    @Override
    public int getVariant() {
        return this.dX;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.dZ;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return this.dJ;
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        int n2 = this.dJ.size();
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(this.dJ.get(i2).getParticipantId());
        }
        return arrayList;
    }

    @Override
    public String getParticipantId(String playerId) {
        String string = null;
        int n2 = this.dJ.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = this.dJ.get(i2);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(playerId)) continue;
            string = participant.getParticipantId();
            break;
        }
        return string;
    }

    @Override
    public Room freeze() {
        return this;
    }

    public int hashCode() {
        return RoomEntity.a(this);
    }

    public static int a(Room room) {
        return w.hashCode(room.getRoomId(), room.getCreatorId(), room.getCreationTimestamp(), room.getStatus(), room.getDescription(), room.getVariant(), room.getAutoMatchCriteria(), room.getParticipants());
    }

    public boolean equals(Object obj) {
        return RoomEntity.a(this, obj);
    }

    public static boolean a(Room room, Object object) {
        if (!(object instanceof Room)) {
            return false;
        }
        if (room == object) {
            return true;
        }
        Room room2 = (Room)object;
        return w.a(room2.getRoomId(), room.getRoomId()) && w.a(room2.getCreatorId(), room.getCreatorId()) && w.a(room2.getCreationTimestamp(), room.getCreationTimestamp()) && w.a(room2.getStatus(), room.getStatus()) && w.a(room2.getDescription(), room.getDescription()) && w.a(room2.getVariant(), room.getVariant()) && w.a(room2.getAutoMatchCriteria(), room.getAutoMatchCriteria()) && w.a(room2.getParticipants(), room.getParticipants());
    }

    public String toString() {
        return RoomEntity.b(this);
    }

    public static String b(Room room) {
        return w.c(room).a("RoomId", room.getRoomId()).a("CreatorId", room.getCreatorId()).a("CreationTimestamp", room.getCreationTimestamp()).a("RoomStatus", room.getStatus()).a("Description", room.getDescription()).a("Variant", room.getVariant()).a("AutoMatchCriteria", room.getAutoMatchCriteria()).a("Participants", room.getParticipants()).toString();
    }

    public int describeContents() {
        return 0;
    }

    private RoomEntity(String roomId, String creatorId, long creationTimestamp, int roomStatus, String description, int variant, Bundle autoMatchCriteria, ArrayList<Participant> participants) {
        this.cU = roomId;
        this.ed = creatorId;
        this.dG = creationTimestamp;
        this.ee = roomStatus;
        this.ch = description;
        this.dX = variant;
        this.dZ = autoMatchCriteria;
        this.dJ = participants;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.cU);
        dest.writeString(this.ed);
        dest.writeLong(this.dG);
        dest.writeInt(this.ee);
        dest.writeString(this.ch);
        dest.writeInt(this.dX);
        dest.writeBundle(this.dZ);
        int n2 = this.dJ.size();
        dest.writeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.dJ.get(i2).writeToParcel(dest, flags);
        }
    }
}

